;ENTRY.COM	10-01-2000	Program to display nth prime
;				using simplistic algorithm
;
;	1,000,000th prime is 15,485,863 = 00EC:4BA7
;
;	It can't have a factor larger than 3931 = 0F5Bh so can
;	limit table of calculated primes to this number
;
;		Copyright (c) Lawrence E. Boothby, 1999
;
				.RADIX 16
ONLY	SEGMENT
			ASSUME CS:ONLY,SS:ONLY,DS:ONLY,ES:ONLY
				ORG 100
;******************************************************************************
Parse:			OR	AX,240A		;=DB 0Dh,0A,'$'
			DB 66
			XOR	AX,AX		;EAX<--00000000
			DB 66
			XOR	CX,CX		;ECX<--00000000
NextChr:		DB 66,6Bh,0C9,0A	;IMUL EXC,ECX,0A
			DB 66
			ADD	CX,AX
			;can't start at +82 because would miss 0Dh of nul line
			;will treat 20h as leading '0' (won't handle HTAB)
			;initial BX=0000,SI=0100 giving an initial [0081]
			MOV	AL,[BX+SI-7F]
			INC	BX		;need SI=0100 later
			AAA			;(AND AL,0F) and 0Dh sets CF
			JNB	NextChr
			POP	DI		;DI<--0000, SP<--0000
			XCHG	AX,DI		;EAX<--00000000, DI,0103
			DB 67			;NOTE: not 66h
			JCXZ	Output
			INC	AX		;first prime-1
			STD
			DB 00  ;ADD [BX-0004],BH a nop to skip next instruction
				;DWORD PTR [DI] = [0103] is safe value
;*******************************************************************************
NextTry:		MOV	DI,0FFFC
			DB 66
			INC	AX
NextCheck:		DB 66
			CWD			;clear	EDX
			DB 66
			PUSH	AX
			DB 66
			DIV	WORD PTR [DI]
			;give up if quotient smaller than divisor or equal
			DB 66
			SCASW
	     ;		DB 66			;max EDX=00000F5A
			DEC	DX		;doesn't change CF!
			DB 66
			POP	AX		;get back candidate
			JS	NextTry		;not prime if has divisor
			JNB	NextCheck	;if more prime divisors
	     ;		CMP	SP,0F778	;actual required
			OR	SP,SP		;saves 2 bytes, wastes time
			JG	Skip		;to limit stack growth
			DB 66
			PUSH	AX		;add prime to table on stack
Skip:			DB 67			;LOOP (ECX)
			LOOP	NextTry		;counting down to nth prime
;**********************---------------******************************************
Output:			MOV	CL,0A		;ECX<--0000000A
			DB 66
			MOV	BX,CX
			;SI=0100 from beginning
NextDigit:		DB 66
			CWD			;must clear last remainder
			DB 66
			DIV	BX		;remainder -->DL
			ADD	DL,30
			DEC	SI		;see my HC10 and credits
			MOV	[SI],DL
			Loop	NextDigit
			MOV	DX,SI
			XCHG	AX,BP		;AH<--09
			INT	21
Exit:			INT	20
;*******************************************************************************
ONLY	ENDS
END	Parse
