/******************************************************************************
* entry.cpp v03 - example for hc12, find nth prime number
* 
* Copyright (C) 2000 by Guido Hahn(meph), ghahn@compuserve.com, mephware@web.de 
* All rights reserved.
*
* changes from v02 to v03
*           - (re)added the lost cr + lf
*
* changes from v01 to v02
*           - an input of 0 outputs 00000000 and not blank
*           - an invalid input outputs 00000000 and not blank
* 
*
*******************************************************************************/

#include <stdio.h>
#include <stdlib.h>


const int max_array = 608;
const unsigned max_prime = 0x00ffffff;
unsigned prime_array[max_array]; 

unsigned array_count;


void main(int argc, char *argv[])
{
  unsigned c, i, j, nprime;
  int bfound;

  if(argc < 2)
  {
    nprime = 0;
  }
  else
  {
    nprime = atol(argv[1]);
  }
  

  array_count = 1;
  prime_array[0] = 5;
 
  if(nprime < 4)
  {
    switch(nprime)
    {
     case 0: c = 0; break;
     case 1: c = 2; break;
     case 2: c = 3; break;
     case 3: c = 5; break;     
    }
  }
  else
  {
    c = 5;
    for(i=3;;)
    {
      //check only odd numbers
      c+=2;
      bfound = true;
      for(j=0; (prime_array[j] * prime_array[j]) <= c; j++)
      {
        //all NOT primes are divideable by primes
        if(!(c%prime_array[j]))
        {     
          bfound = false;
          break;
        }
      }
      if(bfound)
      {
        //need only to remember primes <= sqrt(max_prime)
        if(c<0x1000)
          prime_array[array_count++] = c; 
         
        //check prime count
        if(++i == nprime)
          break;
      }
      bfound = true;
      //skip multiples of 3
      c+=4;
      for(j=0; (prime_array[j] * prime_array[j]) <= c; j++)
      {
        //all NOT primes are divideable by primes
        if(!(c%prime_array[j]))
        {
          bfound = false;
          break;
        }      
      }
      if(bfound)
      {
        //need only to remember primes <= sqrt(max_prime)
        if(c<0x1000)
          prime_array[array_count++] = c; 

        //check prime count
        if(++i == nprime)
          break;
      }
    }
  }

  //printf("array_count = %u\n",  array_count);

  printf("%010u\n", c);

}