;
;
;		shows "TOUR" file path for Hugi compo #11
;			by TAD ( tad.uk@dtn.ntl.com )
; compile:
;	TASM /m9 show
;	TLINK /t show
;
; usage:
;	SHOW.COM
;
; 
;
; credits:
;	Thanks to Jibz for the idea of displaying the TOUR 'route'
;
;
;


MAZE_WIDTH	equ	100
MAZE_HEIGHT	equ	100
MAZE_SIZE	equ	10000

WALL_C		equ	00h
PATH_C		equ	01h
BEGIN_C		equ	02h
EXIT_C		equ	03h
ROUTE_C		equ	90h

	.model tiny
	.code
	org	256
go:

	;; load the "TOUR" file ;;

	lea	dx, filename
	mov	ah, 3Dh
	mov	si, ax
	int	21h
	jnc	short opened

	lea	dx, errtxt
	mov	ah, 9
	int	21h
	ret
opened:
	xchg	ax, bx
	mov	dx, si
	mov	cx, MAZE_SIZE
	mov	ah, 3Fh
	int	21h

	;; find the BEGIN location ;;

	mov	di, si
	xchg	ax, cx
	mov	ah, ROUTE_C
	mov	al, BEGIN_C
	repnz	scasb
	dec	di

	;; follow & cycle path color ;;

follow:
	mov	[di], al		; plot BEGIN/cycle color
	inc	al
	or	al, 0C0h   		; colors C0 .. FF hex

	inc	di
	cmp	ah, [di]
	jz	short follow		; (+1, 0)
	dec	di
	dec	di
	cmp	ah, [di]
	jz	short follow		; (-1, 0)
	sub	di, MAZE_WIDTH-1
	cmp	ah, [di]
	jz	short follow		; (0, -1)
	add	di, (2*MAZE_WIDTH)
	cmp	ah, [di]
	jz	short follow		; (0, +1)

	;; show maze (2x2) ;;

	mov	ax, 0013h
	int	10h
	mov	di, 0A000h
	mov	ES, di
	sub	di, di
	mov	dx, MAZE_HEIGHT
yloop:
	mov	cx, MAZE_WIDTH
xloop:
	lodsb
	mov	ah, al
	mov	ES:[di+320], ax
	stosw
	loop	xloop
	add	di, 640-(2*MAZE_WIDTH)
	dec	dx
	jnz	short yloop

	;; cycle colors & test for a key ;;

	sub	bp, bp
cycle:
	mov	dx, 3DAh
vsync:
	in	al, dx
	test	al, 8
	jz	short vsync
	mov	dl, 0C8h
	mov	al, 0C0h
	out	dx, al
	inc	dx
	mov	ax, bp
	mov	cx, 64
rgb:
	and	al, 3Fh
	out	dx, al
	out	dx, al
	out	dx, al
	dec	ax
	loop	rgb

	dec	bp

	mov	ah, 01h
	int	16h
	jz	short cycle
	mov	ah, 0
	int	16h
	mov	ax, 0003h
	int	10h
quit:
	ret

errtxt		db	13,10,7,'unable to find "TOUR" file',13,10,'$'

filename	db	'TOUR',0

	end	go
