; Hugi Size Coding Competition #11 example program. See HC11 rules for
; detailed info about this compo.
;
; This program finds the shortest path through a maze using breadth first
; search.
;
; Don't laugh at me... I tried to grow the size a bit (I thought that
; ~170 bytes example might be a bit too small...)
; Going back to killing bytes... ;-)
;
; Compilation:  tasm -m9 example.asm
;               tlink -t -x example
;
; Note! This code is real ugly and intentionally made to be a bigger
;       then "normal" code. There's not much comment to say how
;       this works but maybe Jibzs C -code might (especially the BFS version)
;       might clarify things a bit.
;       If someone really needs more explanation about breadth first search
;       (s)he should ask me (or someone else) to explain it in eGroups.
;       I (Fabled) can be contacted via "fabled@iki.fi".
;
; ASCIIs stolen from TADs rules (thanx TAD).
;
; Good luck to all for HC11 !!
;
; -Fabled
;


        Ideal
        P386
        Model Tiny
        

        CODESEG

        Org 100h


start:

        call    InitTables
        call    ReadMino
        call    Solve
        call    WriteTour

exit:   mov     ax, 04c00h
        int     21h


InitTables:

        ;
        ; Initialize tables
        ;

        mov     di, offset queue
        mov     cx, 10000*2
        mov     ax, -1
        rep     stosw
        retn

ReadMino:

        ;
        ; Read in the maze
        ;

        mov     ax, 03d00h
        mov     dx, offset inputfile
        int     21h
        mov     [handle], ax

        mov     ah, 03fh
        mov     bx, [handle]
        mov     cx, 10000
        mov     dx, offset maze
        int     21h

        mov     ah, 03eh
        mov     bx, [handle]
        int     21h
        retn

Solve:

        ;
        ; Find the BEGIN location from the maze
        ;

        mov     di, offset maze
        mov     cx, 10000
        mov     al, 2
        repne   scasb
        dec     di

        sub     di, offset maze         ; get offset from maze
        mov     si, di

        ;
        ; Do breadth first search
        ;  SI = queue head
        ;  DI = queue tail
        ;

bfs:
        lea     bp, [si-100]
        call    AddNode                 ; go up

        lea     bp, [si-1]
        call    AddNode                 ; go left

        lea     bp, [si+1]
        call    AddNode                 ; go right

        lea     bp, [si+100]
        call    AddNode                 ; go down

        add     si, si                  ; dequeue
        mov     si, [queue+si]          ; next position

        cmp     si, -1                  ; no solution?
        je      exit                    
        cmp     [maze+si], 3            ; exit location?
        jne     bfs                     ; search until exit is found

        ; At this point the shortest path has been found.
        ; Now we have to "backtrack" and mark the optimal path.

        ;
        ; Reconstruct the solution
        ;

find:
        add     si, si
        mov     si, [previous+si]       ; get previous cell
        cmp     [maze+si], 1            ; beginning of maze?
        jne     done                    ; if yes then the path is marked
        mov     [maze+si], 90h          ; otherwise mark path
        jmp     find                    ; and advance
done:   retn


WriteTour:

        ;
        ; Write out the solution
        ;

        mov     ah, 03ch
        xor     cx, cx
        mov     dx, offset outputfile
        int     21h
        mov     [handle], ax

        mov     ah, 040h
        mov     bx, [handle]
        mov     cx, 10000
        mov     dx, offset maze
        int     21h

        mov     ah, 03eh
        mov     bx, [handle]
        int     21h

        retn


AddNode:
        ; check that BP is within the maze

        cmp     bp, 10000
        jae     _ret

        ; check that [BP] is not WALL or BEGIN

        cmp     [maze+bp], 0
        je      _ret

        cmp     [maze+bp], 2
        je      _ret

        ; check that BP is not queued yet

        add     bp, bp
        cmp     [queue+bp], -1
        jne     _ret

        ; add position BP to end of queue
        ; and update travelling table

        mov     [previous+bp], si
        shr     bp, 1
        add     di, di
        mov     [queue+di], bp
        mov     di, bp

_ret:   retn





        DATASEG

inputfile       db "MINO",0
outputfile      db "TOUR",0
handle          dw ?

; The maze

maze            db 10000 dup (?)

; Queue for processing each position

queue           dw 10000 dup (?)

; Travelling information
; This contains the position where we came from
; for each position in the maze

previous        dw 10000 dup (?)



        END start
