%pagesize 255, 160
;------------------------------------------------------------------------------
; entry.asm version 1.6
; Copyright (C) 2000 by Guido Hahn, email(ghahn@compuserve.com)
;
; This file was written for the Hugi Size Coding Competition #11: 
; t h e  -  " M O N S T E R "  -  c o m p o
; on http://www.hugi.de/compo/
;
; ALIAS:    meph
; Country:  Germany
; Date:     03-13-2000               
; Compiler: TASM 4.1		          
; Linker:   TLINK	7.1.30.1        
;                               
; Compile:  TASM   entry
; Link:     TLINK  /t entry
;
; Size: 95 Bytes
;
;
; THIS SOFTWARE IS PROVIDED BY GUIDO HAHN ``AS IS AND WITHOUT
; ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
; IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
; FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
; OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
; LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
; OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
; SUCH DAMAGE.
;
;------------------------------------------------------------------------------

;<snip>
;You may assume that
;  ... the registers have these values (all in hex):
;      (xx - means an unknown value which MUST NOT be assumed)
;
;          EAX = xxxx****
;                AL = 00 if first FCB has valid drive letter,  FF if not
;                AH = 00 if second FCB has valid drive letter, FF if not
;          EBX = xxxx0000
;          ECX = xxxx00FF
;          EDX = xxxxxxxx
;  DX  = CS = DS = ES = SS = xxxx, 0080 <= DX <=9000.
;          ESI = xxxx0100
;          EDI = xxxxFFFE
;          EBP = xxxx09xx
;          ESP = xxxxFFFE
;          EIP = xxxx0100
;
;  EFLAGS (binary) = xxxxxxxx xxxxxxxx xxxx0x1x xx0x0x1x
;      i.e.
;          DF = 0
;          IF = 1
;          other flags = x
;
;          WORD [FFFE] = 0000
;          Layout of PSP: see [Memory Layout]
;<snip>

.586

deb_startup macro     ;;initialize register values				
      xor ax, ax
      xor bx, bx	
      mov cx, 0ffh
      mov dx, cs
      mov es, dx
      mov si, 100h
      mov di, 0fffeh
      mov sp, di
      mov bp, 0911h
      cld
endm


_cseg segment para public 'code' use16
assume cs:_cseg, ds:_cseg, es:_cseg, ss:_cseg
_cseg ends

_cseg segment
org 100h										
start:	                      
ifdef DEBUG
    deb_startup
endif
    
;;
;;  open mino file
;;


    mov ah, 3dh     
    call OW_Mino                        ;ax = 0
                                        ;bx = Mino handle                                       
                                        ;dx = 01xxh

    xchg ax, si                         ;ax = 0100h, si = 0

    mov cx, (- (offset flood)) + 0ffffh 

    std                                 ;doing things from the backend
    rep stosb                           ;zero everything after the maze

    dec cx                              ;dx = -1

;;
;;  load maze
;;  
;;  cx >= 10000

    mov ah, 3fh                         
    int 21h                             ;ax = 10000
    
    xchg ax, bp                         ;bp = 10000 (need that later)

;;
;;  search maze entry point
;;        

    mov ax, 3c02h                       ;prepare function ah=3ch
    repnz scasb                         ;cx != 0

    pop cx                              ;cx = 0, sp = 0 -> si = sp
 
;;
;;  create tour file
;;
;;  cx = 0
                     
    mov dl, offset low(sztour)          ;dx = 01xxh
    call IntDos                         ;bx = file handle, ax=00xxh
                                        ;(assumes file handle < 256)
                                        ;cx = 0

    inc di                              ;di -> maze entry

                                                            
flood_maze:
    mov al, 100                         ;ax=0064h
fm0:
                                        ;step = {100, -100, 1, -1}
    add di, ax
    test byte ptr[di], dh               ;dh = 1
    jz short fm_skip                    ;skip entry point and walls
     
    cmp byte ptr[bp+di], bh             ;is there allready water 
                                        ;on that field                                    
    jne short fm_skip                   ;(bh=0 is the empty marker, assumes
                                        ; that a file handle < 256)

    mov byte ptr[bp+di], al             ;remember the step we used
    push di                             ;save pointer on stack
   
fm_skip:
    sub di, ax                          ;restore old di
    neg ax                              ;generate next step 
    js fm0                              ;         "
    cmpxchg dh, dh                      ;dh = 1
                                        ;if(al == dh) {zf = 1; dh = dh; }
                                        ;   else {zf = 0; al = dh}                                  
    jnz fm0                                                                                       
    cmpsw                               ;sub si, 2 (without destroying ax,
                                        ;like lodsw)
                                        ;NOTE: first decrement, then load
                                        ;      pointer from stack
    mov di, word ptr[si]                ;(Thanks to Ruud for the Zero NOP
                                        ; test maze, so I could avoid this
                                        ; potential bug.)

    cmp byte ptr[di], al                ;At ths point byte ptr[di] can only
    jz flood_maze                       ;be 1 or 3, we are waiting for 3!
                                        ;al = 1
;;
;;  Now we are wet, but happy at home.
;;  Let's try to remember the choosen way.
;;
    push cx                             ;push 0 -> [sp] = 0
recurse:     
    movsx cx, byte ptr[bp+di]           ;retreave step we used to reach that 
    sub di, cx                          ;field
                                        ;calculate previous field
    mov cx, 4090h                       ;prepare the NOP, and function 40h
                                        ;al = 1
    cmpxchg byte ptr[di], cl            ;if(*di == al) {zf = 1; *di = cl}
                                        ;   else{zf = 0; al = *di}
                                        ;-> don't NOP the entry field
    jz recurse      

;;
;;  write tour file
;;
    xchg ax, bp                         ;ax = 10000
    xchg ax, cx                         ;ax = 4090h, cx = 10000
  
OW_Mino:
    mov dx, offset mino                 ;dx = 01xxh


IntDos:
    int 21h                             ;open MINO or open/write TOUR
    xchg ax, bx                         ;move file handle to bx
    ret
       
sztour    db 'TOUR'                     ;0 is loaded through MINO, which starts
                                        ;with 101 Zero's (border wall)

mino      db 'MINO', 0                   
          db 9995 dup (?)

flood     db 10000 dup (?)

_cseg ends

end start


