;ENTRY.COM    04-27-2000    hugi compo #11 Maze path finder (breadth first)
;
;			Copyright (c) Lawrence E. Boothby, 2000
;			Contract programming: BoothbyL@reed.edu
;
				.RADIX 16
ONLY	SEGMENT
			ASSUME CS:ONLY,SS:ONLY,DS:ONLY,ES:ONLY
				ORG 100
;******************************************************************************
Start:		MOV	AH,3Dh		;assuming AL=00, open MINO for read
		MOV	DX,OFFSET FileIn
		CALL	Read		;assuming CX=00FF initially
;**************--------------------------***************************************
		MOV	DI,DX		;=0191
		MOV	AL,02
		REPNZ	SCASB		;look for BEGIN=02
		DEC	DI		;point to 02 just found
;**************---------------**************************************************
		MOV	SI,SP			;head of queue - 2 bytes
		POP	CX			;need CX=0000, and SP-->head
		STD				;for accessing tail of queue
		MOV	BL,63	   ;inspired by Ruud's HC10 entry (Taquin game)
Wander:		NOT	BX
		TEST	[BX+DI],DH		;DH=01
		JZ	Next			;<-- if 00, 02, or visited = 90
		XOR	BYTE PTR[BX+DI],DL	;mark visited
		LEA	BP,[BX+DI]		;new BP-->neighbor node
FileOut		DB 'tO'
		PUSH	BP			;enqueue --> neighbor node
		DB 'r',00
		PUSH	SI			;enqueue -->to --> parent node
Next:		XCHG	BX,CX
		LOOP	Wander			;visit other neighbors
		LODSW				;dequeue --> node
		XCHG	DI,AX
		CMP	DL,[DI]			;check for END = 03
		LODSW				;dequeue -->to --> parent node
		JPO	Wander			;CX=0000, BX=0063 after LOOP
;**************----------------*************************************************
; --> to --> means pointer to a pointer. More exactly, 0004 must be added to
; the first pointer to locate the second pointer on the stack that points to
; the actual byte in the MINO/TOUR file. Since the second pointer = BX, the
; addition is never actually needed. The first pointer is used to make decisions
; below.
;
NotShortest:	POP	SI		;(discarded) AX-->to -->of parent node
		POP	BX
		XOR	BYTE PTR [BX],DL	;undo visited mark
		DB 3Dh	;CMP AX,XXXX to skip next two instructions
Shortest:	POP	AX			;update AX
		POP	BX		;discard, shortest route already marked
		CMP	SP,AX
		JNB	Shortest
		JS	NotShortest
;**************---------------------********************************************
		MOV	AH,3C		;create TOUR file
		MOV	DL,LOW (OFFSET FileOut)
		PUSH	CX		;need return address -->PSP:0000
Read:		INT	21		;open or create
		XCHG	BX,AX		;intialize handle
		MOV	AH,41
FileIn		DB 'MINO'		;= DEC BP, DEC CX, DEC SI, DEC DI
		DB 00,0CC ;ADD AH,CL	;(MASM 4.0 assembles 02,E1 instead)
	       ;ADD	AH,CL		;AH<--3F = read then 40 = write
		MOV	CX,2710		;size of file
		MOV	DL,91		;(DH=01 here), 91 is useful value
		INT	21		;read or write
Exit:		RET
;*******************************************************************************
ONLY	ENDS
END	Start
