;
;     gyy   ygg ggy   gyg gygxcxggy cxsyggsxc
;     $$$   $$$ $$$   $$$ $$$   $$$    $$$
;   ;:$$$scx$$$:$$$:::$$$:$$$:cxgyg::::$$$:::;
;     $$$   $$$ $$$   $$$ $$$   $$$    $$$
;     SBS   SSB BBScxsSBS BSBsxcSSB xcsBSBsxc
;
;                 Compo #11 Entry
;
;   by Joergen Ibsen / Jibz <jibz@hotmail.com>
;
;        (based on the example by Fabled)
;

; key observations:
;  - the information stored in the special layout of the queue in
;    Fabled's code can be retreived from previous.
;  - if we position the maze at offset 10000, and the previous
;    table right after it, an absolute offset to a point in the
;    maze is of the form (10000 + n). if we multiply this by 2
;    we get (20000 + 2*n), which is exactly the offset of this
;    field in previous.
;  - the handle returned by a call to open file can be assumed to be
;    below 256, and thus below the offset of the add_node function.

.model tiny
.586
.code
org 100h

start:
        ; open MINO file and read maze
        mov     ah, 03dh                ; ax = 3d00h
        mov     dx, offset inputfile
        mov     bh, 03fh
        call    openreadwrite

        ; a correct read will make ax = cx = #bytes read = 10000
        xchg    ax, bx                  ; bx -> maze, ax = handle

        ; initialize previous table
        ;  cx = 10000 from above
        ;  ax = handle < 256
        mov     di, offset previous
        rep     stosw                   ; now cx = 0, di = 40000

        mov     si, di                  ; si = di -> queue

        ; find the BEGIN location in the maze
find_begin:
        inc     bx                      ; ok, since first 100 are wall
        cmp     byte ptr [bx], 2
        jne     find_begin

        ; do breadth first search
        ;  si = queue head, di = queue tail
        ;  bx -> field to process
bfs:
        mov     dx, offset add_node     ; dx -> add_node, for calls

        mov     bp, bx                  ; bp -> current node

        lea     bx, [bp-100]
        call    dx                      ; go up

        lea     bx, [bp-1]
        call    dx                      ; go left

        lea     bx, [bp+1]
        call    dx                      ; go right

        lea     bx, [bp+100]
        call    dx                      ; go down

        lodsw                           ; dequeue
        xchg    ax, bx                  ; bx -> next position to handle

        cmp     byte ptr [bx], 3
        jne     bfs                     ; search until exit is found

        ; here bx -> end cell

        ; at this point the shortest path has been found, now we
        ; have to "backtrack" and mark it

mark_path:
        add     bx, bx                  ; bx = offset in previous
        mov     bx, [bx]                ; get offset of previous cell
        add     byte ptr [bx], 8fh      ; 01h + 8fh = 90h = even parity
        jpe     mark_path               ; 02h + 8fh = 91h = odd parity

        ; here bx -> begin cell

        mov     byte ptr [bx], 2        ; restore the begin value

        ; create TOUR file and write the solution
        mov     ah, 03ch                ; cx = 0 from above
        mov     dl, LOW(offset outputfile) ; dx -> add_node, so dh is ok
        mov     bh, 040h

openreadwrite:
        int     21h                     ; open / create file

        xchg    ax, bx                  ; bx = handle
                                        ; ah = read/write function

        mov     cx, 10000
        mov     dx, cx                  ; dx -> maze
        int     21h                     ; read / write maze

        ; now ax = cx = dx = 10000
        retn

add_node:
        test    byte ptr [bx], (not 2)  ; begin or wall?
        jz      _ret

        mov     ax, bx                  ; ax = offset in maze
        add     bx, bx                  ; bx = offset in previous

        cmp     [bx], dx                ; handle < dx < 10000
        ja      _ret                    ; already handled?

        mov     [bx], bp                ; store previous

        stosw                           ; add to queue

_ret:
        retn

inputfile       db "MINO",0
outputfile      db "TOUR",0

org 10000

; --- the maze ---

maze            db 10000 dup (?)

; --- previous ---
;  - for each field in the maze the corresponding field in
;    previous is equal to the position it was visited from
;    (>10000) or below 256 if it has not been visited.
;  - it will be at offset 20000.

previous        dw 10000 dup (?)

; ---- queue -----
;  - the queue is used to store offsets of the fields that
;    need to be processed.
;  - it will be at offset 40000.

queue           dw 10000 dup (?)

end start
