;ENTRY.COM    04-14-2000    hugi compo #11 Maze path finder (breadth first)
;
;			Copyright (c) Lawrence E. Boothby, 2000
;			Contract programming: BoothbyL@reed.edu
;
				.RADIX 16
ONLY	SEGMENT
			ASSUME CS:ONLY,SS:ONLY,DS:ONLY,ES:ONLY
				ORG 100
;******************************************************************************
Start:		MOV	AH,3Dh		;assuming AL=00, open MINO for read
		MOV	DX,OFFSET FileIn
		CALL	File		;assuming CX=00FF initially
;**************--------------------------***************************************
		MOV	DI,DX		;=0191
		MOV	AL,02
		REPNZ	SCASB		;look for BEGIN=02
		DEC	DI		;point to 02 just found
;**************---------------**************************************************
		MOV	SI,SP			;head of queue - 2 bytes
		POP	CX			;need CX=0000, and SP-->head
		STD				;for accessing tail of queue
		MOV	BL,63	   ;inspired by Ruud's HC10 entry (Taquin game)
Wander:		NOT	BX
		TEST	[BX+DI],DH		;DH=01
		JZ	Next			;<-- if 00 or 02
		XOR	BYTE PTR[BX+DI],DL	;mark visited
		LEA	BP,[BX+DI]		;new BP-->neighbor node
FileOut		DB 'tO'
		PUSH	BP			;enqueue --> neighbor node
		DB 'r',00
		PUSH	DI			;enqueue --> parent node
Next:		XCHG	BX,CX
		LOOP	Wander			;visit other neighbors
		LODSW				;dequeue --> node
		XCHG	DI,AX
		CMP	[DI],DL
		LODSW				;dequeue --> parent
		JPE	Wander			;CX=0000, BX=63 after LOOP
;**************----------------*************************************************
Continue:	POP	DI			;AX-->parent of node
		POP	BX
		CMP	AX,BX
		XCHG	DI,AX			;update AX-->new parent
		JZ	Shortest		;shortest tour item already 90
		XCHG	DI,AX			;un-update AX-->new parent
		XOR	BYTE PTR [BX],DL	;undo visited mark
Shortest:	OR	SP,SP
		JNZ	Continue
;**************------------------***********************************************
Done:		MOV	AH,3C			;create below
		MOV	DL,LOW (OFFSET FileOut)
		PUSH	CX		;need return address -->PSP:0000
File:		INT	21
		XCHG	BX,AX		;intialize handle
		MOV	AH,41
FileIn		DB 'MINO'		;= DEC BP, DEC CX, DEC SI, DEC DI
		DB 00,0CC ;ADD AH,CL	;MASM 4.0 assembles 02,E1 instead
	       ;ADD	AH,CL		;AH<--3F then 40
		MOV	CX,2710
		MOV	DL,91		;(DH=01 here), 91 is usefull value
		INT	21		;read or write
Exit:		RET
;*******************************************************************************
ONLY	ENDS
END	Start
