;*** Test suite for Hugi compo #10

; The actual core of the program is written by TAD, I only put in the code
; for testing the entry...

; Ruud
;
; TAD:
;	- added all the '-D' debug mode switch
;	- keys:
;	       	[CURSOR]	- move by 1 pixel
;		[SHIFT+CURSOR]	- move by 8 pixels
;		[SPACE]		- run until next game-loop error
;		[ESC]		- disable debug-mode & run....
;		[N]		- locate next pixel error on screen
;		[TAB]		- toggle ENTRY <--> test screen
;		[F10]		- quit to DOS (a fake [QUIT] key press)
;
;	- you can also use the Mouse (if you have one #;o)
;
; TAD:
;	- changed '9' led digit
;	- added the file-attribute check for the "KEYS" file
;
; TAD:
;     	- added MovesCounter
;	- current key
;	- key counter & file pos
;	- F1 help screen
;	- added [F10] quit function
;	- added screen description

QUIT_KEY        equ     20h


by  EQU <BYTE PTR>
wo  EQU <WORD PTR>
dwo EQU <DWORD PTR>
off EQU <OFFSET DS:>

;; My control-codes ;;
XTAB	equ	1
YTAB	equ	2
LOCATE	equ	3
CARRET	equ	4
PEN	equ	5

        .MODEL  TINY
        .386
        LOCALS

        .DATA

bEpb    dw      0
        dw      80h
wCs1    dw      ?
        dw      5ch
wCs2    dw      ?
        dw      6ch
wCs3    dw      ?
        dw      $-bEpb
wInPoint        dw      bInput
wErrCount       dw      0
bFlag   db      0
msgNoText  db 'Text screen not restored on exit',0dh,0ah,'$'
msgPreExit db 'Program exit before winning field or escape',0dh,0ah,'$'
msgErrEnc  db ' error(s) encountered.',0dh,0ah,'$'
msgWin     db 'Winning field after ',0
msgEsc     db 'You have quit after ',0
msgMoves   db ' moves',0
msgOutErr  db 'Error in final message',0dh,0ah,'$'
msgAttrErr db 'Attribute of "KEYS" file is wrong',0dh,0ah,'$'
msgKeysErr db 'Unable to find "KEYS" file',0dh,0ah,'$'


KeysFilename	db	'KEYS',0

;*** TAD's DATA

infotxt		db	PEN,15, LOCATE,0,20,'X:',PEN,14
infotxt2	db	'000  ',PEN,15,'Y:',PEN,14
infotxt3	db	'000   ',PEN,11
infotxt4	db	'0000h',0

scr1txt		db	PEN,12,LOCATE,2,0,'ENTRY.COM Screen',0
scr2txt		db	PEN,14,LOCATE,2,0,'Reference Screen',0

helptxt		db	PEN,14, LOCATE,3,0,'F1 - tog. Help'
		db	PEN,10,LOCATE,4,2,'N - ',PEN,7,'next error'
		db	PEN,10,LOCATE,2,3,'TAB - ',PEN,7,'tog. screens'
		db	PEN,10,LOCATE,0,4,'SHIFT - ',PEN,7,'fast move'
		db	PEN,10,LOCATE,0,5,'SPACE - ',PEN,7,'1 game cycle'
		db	PEN,10,LOCATE,2,6,'ESC - ',PEN,7,'run/no debug'
		db	PEN,10,LOCATE,2,7,'F10 - ',PEN,7,'quit to DOS'

		db	PEN,14,LOCATE,7,9,'Colors'
		db	PEN,7,LOCATE,2,11,'0123456789ABCDEF'
		db	LOCATE,2,12
		db	PEN,0,219 ,PEN,1,219, PEN,2,219, PEN,3,219
		db	PEN,4,219, PEN,5,219, PEN,6,219, PEN,7,219
		db	PEN,8,219 ,PEN,9,219, PEN,10,219, PEN,11,219
		db	PEN,12,219, PEN,13,219, PEN,14,219, PEN,15,219

		db	PEN,14,LOCATE,5,14,'Puzzle Info'
		db	PEN,7,LOCATE,1,16,'Valid moves: ',PEN,10
helpnum1	db	'00000'
		db	PEN,7,LOCATE,1,17,'Total moves: ',PEN,10
helpnum2	db	'00000'
		db	PEN,7,LOCATE,4,19,'Last-key: ',PEN,15
helpnum3	db	'0000h'

		db	0


wVideoMem	dw	0A000h
wEntrySeg	dw	0

wZoomX		dw	160
wZoomY		dw	100

wZoomWinScr	dw	0
wErrorScr	dw	0
wCursorMask	dw	0F00h

bDebugMode	db	0		; NZ = debug/zoom stuff
bViewMode	db	0		; 0=view entry, 1=view emul. ref

bFlashColor	db	4
bHookKeyFlag	db	1		; NZ = hook INT 16h key vector
bKeyStatus	db	0		; key status (Shift, Alt, Ctrl etc..)
bMouseFlag	db	0
bHelpMode	db	0		; NZ = F1 help mode
bHelpRedraw	db	0
bQuitFlag	db	0

wFlashTick	db	0

MovesCounter    dw      0
HolePos         dw      0
TotalKeyMoves	dw	0		; position in KEYS file
CurrKeyCode	dw	0

wTxtX		dw	0
wTxtY		dw	0
wTxtPen		dw	0F0Fh


Grid            db       0, 13, 10, 07
                db      04, 01, 14, 11
                db      08, 05, 02, 15
                db      12, 09, 06, 03


;                       UDLR
;                       ----
ValidMoves      db      0101b           ; [0]   - allow  DOWN or RIGHT moves
                db      0111b           ; [1]
                db      0111b           ; [2]
                db      0110b           ; [3]

                db      1101b           ; [4]
                db      1111b           ; [5]
                db      1111b           ; [6]
                db      1110b           ; [7]

                db      1101b           ; [8]
                db      1111b           ; [9]
                db      1111b           ; [10]
                db      1110b           ; [11]

                db      1001b           ; [12]
                db      1011b           ; [13]
                db      1011b           ; [14]
                db      1010b           ; [15]

;; 7x 1-bit flags for the LED char sections ;;
;;
;;       777777         <------ each of the 7 LED line sections
;;      6      5                are described usings bit #7 ... bit #1
;;      6      5
;;       444444                             76543210 <-- bit
;;      3      2                (eg. '9' =  11110100 binary )
;;      3      2
;;      3      2
;;       111111


;;                      7654321
LedDigits       db      11101110b       ;[0]    '0' char
                db      00100100b       ;[1]    '1' char
                db      10111010b       ;[2]    '2' char
                db      10110110b       ;[3]    '3' char
                db      01110100b       ;[4]    '4' char
                db      11010110b       ;[5]    '5' char
                db      11011110b       ;[6]    '6' char
                db      11100100b       ;[7]    '7' char
                db      11111110b       ;[8]    '8' char
                db      11110110b       ;[9]    '9' char


;; the 7 LED section lines (scrdisp, rep, step-1) ;;

LedLines        dw      1+(15*320), 6, +1       ;[0] bot edge   bit #1
                dw      7+(8*320),  7, +320     ;[1] bot-right  bit #2
                dw      0+(8*320),  7, +320     ;[2] bot-left   bit #3
                dw      1+(7*320),  6, +1       ;[3] middle     bit #4
                dw      7+(1*320),  6, +320     ;[4] top-right  bit #5
                dw      0+(1*320),  6, +320     ;[5] top-left   bit #6
                dw      1+(0*320),  6, +1       ;[6] top line   bit #7

;; List of screen-coords for the 16 tiles ;;

ScrOffs         dw       97+(37*320)            ;[0]    coords  (97,37)
                dw      129+(37*320)            ;[1]    coords (129,37)
                dw      161+(37*320)            ;[2]    coords (161,37)
                dw      193+(37*320)            ;[3]    coords (193,37)

                dw       97+(69*320)            ;[4]    coords  (97,69)
                dw      129+(69*320)            ;[5]    coords (129,69)
                dw      161+(69*320)            ;[6]    coords (161,69)
                dw      193+(69*320)            ;[7]    coords (193,69)

                dw       97+(101*320)           ;[8]    coords  (97,101)
                dw      129+(101*320)           ;[9]    coords (129,101)
                dw      161+(101*320)           ;[10]   coords (161,101)
                dw      193+(101*320)           ;[11]   coords (193,101)

                dw       97+(133*320)           ;[12]   coords  (97,133)
                dw      129+(133*320)           ;[13]   coords (129,133)
                dw      161+(133*320)           ;[14]   coords (161,133)
                dw      193+(133*320)           ;[15]   coords (193,133)


        .DATA?

bFile		db      20h dup (?)
wEmulSeg        dw      1 dup (?)
wInCount        dw      1 dup (?)
bInput  	db      200h dup (?)
        	dw      200h dup (?)
wStack  	dw      1 dup (?)

        .CODE

        ORG     100h
Start:  mov     ax,off wStack
        mov     sp,ax
        add     ax,1fh
        shr     ax,4
        mov     dx,cs
        add     dx,ax
        mov     wEmulSeg,dx
	add	dx, (64000/16)
	mov	wEntrySeg, dx
        add     ax,(64000/16)*2     ;;TAD:: Size of screen * 2 !!!
        mov     bx,ax
        mov     ah,4ah
        int     21h     ;Resize memory used
        mov     [wCs1],ax
        mov     [wCs2],ax
        mov     [wCs3],ax
        mov     es,wEmulSeg
        xor     di,di
        xor     ax,ax
        mov     cx,64000/2
        rep stosw               ;Ref screen = 0

	;; delete the "KEYS" file ;;

	mov	dx,off KeysFilename
	mov	ah,41h
	int	21h	

        ;; draw 1 pixel border ;;

        mov     di, 95+(35*320)
        mov     cx, 130
        mov     al, 7
        rep     stosb                   ; top line

        mov     di, 95+(164*320)
        mov     cx, 130
        mov     al, 7
        rep     stosb                   ; top line

        mov     di, 95+(35*320)         ; coords (95, 35)
        mov     cx, 130
sides:
        mov     ES:[di], al             ; coords (95, y)
        mov     ES:[di+129], al         ; coords (95+129, y)
        add     di, 320
        loop    sides                   ; sides

	;; detect mouse ;;

	mov	ax,3533h
	int	21h
	mov	ax, ES
	or	ax, bx
	or	al, ah
	mov	[bMouseFlag], al	; NZ = mouse INT 33h vector

        mov     ax,3516h
        int     21h
        mov     wOld16,bx
        mov     wOld16+2,es
        mov     dx,off Int16Hook
        mov     ax,2516h
        int     21h

        mov     ax,3510h
        int     21h
        mov     wOld10,bx
        mov     wOld10+2,es
        mov     dx,off Int10Hook
        mov     ax,2510h
        int     21h

        push    ds
        pop     es
        mov     si,82h-1
        mov     di,off bFile
	call	SkipSpaces
	cmp	by [si],'-'
	jnz	short @@l00		; no '-' option ?
	inc	si
	lodsb
	and	al,0DFh
	cmp	al,'D'
	jnz	short @@l03		; MUST be '-D' or '-d' !!
	inc	[bDebugMode]

@@l03:	cmp	al,'C'
	jnz	short @@l030		; MUST be '-C' or '-c' !!
	mov	bCcKey,'4'
@@l030:
	call	SkipSpaces
@@l00:  cmp     by [si],20h
        movsb
        jae     @@l00
        mov     by [di-1],0
        
        mov     di,off bInput
@@l01:  mov     dl,-1
        mov     ah,6
        int     21h
        stosb
        jnz     @@l01
        dec     di
        sub     di,off bInput
        mov     wInCount,di

        mov     dx,off bFile
        mov     bx,off bEpb
        mov     ax,4b00h
        int     21h     ;Execute entry.com

        lds     dx,dwo cs:wOld16
        mov     ax,2516h
        int     21h

        lds     dx,dwo cs:wOld10
        mov     ax,2510h
        int     21h

        mov     ax,cs
        mov     ds,ax
        mov     es,ax
        mov     ax,wErrCount
        test    bFlag,4
        mov     dx,off msgNoText
        je      @@ShowErr
        mov     dx,off msgPreExit
        test    bFlag,3
        je      @@ShowErr
        xor     bx,bx
        mov     ah,3
        int     10h
        cmp     dx,0100h
        jne     @@FinErr
        mov     ax,MovesCounter
        mov     di,off bFile
        call    Ax2Dec
        mov     al,0
        stosb
        mov     si,off msgWin
        test    bFlag,2
        jne     @@Go1
        mov     si,off msgEsc
@@Go1:  mov     di,off bInput
        call    strcpy
        mov     si,off bFile
        call    strcpy
        mov     si,off msgMoves
        call    strcpy
        mov     cx,di
        mov     si,off bInput
        sub     cx,si
        push    0b800h
        pop     es
        xor     di,di
@@Cmp0: cmpsb
        jne     @@FinErr
        inc     di
        loop    @@Cmp0
        mov     cx,4000
        sub     cx,di
        shr     cx,1
        mov     al,20h
@@Cmp1: scasb
        jne     @@FinErr
        inc     di
        loop    @@Cmp1
        jmp short @@StdErr

@@FinErr:       inc     wErrCount
        mov     dx,off msgOutErr
        mov     ah,9
        int     21h


@@StdErr:       push    ds
        pop     es

	;; check file-attr of "KEYS" file ;;

	mov	dx, off KeysFilename
	mov	ax,4300h
	int	21h
	mov	dx,off msgKeysErr
	jc	short @@AttrErr		; can't open "KEYS" file ?
	and	cl,00011111b		; check RO, HIDDEN, SYS, VOL SUB-DIR
	jz	short @@AttrOk		; = 0 !!
	mov	dx,off msgAttrErr
@@AttrErr:
	inc	wErrCount
	mov	ah,9
	int	21h

@@AttrOk:

        mov     ax,wErrCount
        mov     di,off bFile
        call    Ax2Dec
        mov     al,'$'
        stosb
        mov     dx,off bFile
        mov     ah,9
        int     21h
        mov     dx,off msgErrEnc

@@ShowErr:      mov     ah,9
        int     21H

        cmp     wErrCount,0
        je      @@NoWait
        mov     ah,0
        int     16h
@@NoWait:
        mov     ax,wErrCount
        or      al,ah
        mov     ah,4ch
        int     21h

strcp0: stosb
strcpy: lodsb
        or      al,al
        jne     strcp0
        ret
Ax2Dec: mov     cx,10
        xor     dx,dx
        div     cx
        or      ax,ax
        je      @@DecDone
        push    dx
        call    Ax2Dec
        pop     dx
@@DecDone:      or      dl,30h
        xchg    ax,dx
        stosb
        ret

IsCc:   mov     al,cs:bCcKey
        call    GetScanCode
        xor     cs:bCcKey,2
        call    TADSMOVE
        cmp     cs:MovesCounter,8000h
        jb      Ir00
        mov     cs:bCcKey,0
Ir00:   popf
        iret

bCcKey  db 0


Int16Hook:      pushf

	cmp	cs:bHookKeyFlag, 0
	jz	short Old16
	
        cmp     ah,0
        jne     Old16
        
        cmp     cs:bCcKey,ah
        jne     IsCc

        call    DrawGrid        ;Update & check
        adc     cs:wErrCount,0  ;Error + 1 if CY

	mov	ax,3920h
	cmp	cs:bQuitFlag, 0
	jnz	short @@QuitNow

        push    si
        mov     si,cs:wInPoint
        lods    by cs:[si]
        mov     cs:wInPoint,si
        dec     cs:wInCount
        pop     si
        jns     @@HaveKey
        pushf
        call    dwo cs:wOld16
@@HaveKey:
        call    GetScanCode
        test    cs:bFlag,1
        je      @@NotEscape
        inc     cs:wErrCount
@@NotEscape:    cmp     al, QUIT_KEY
        jne     @@NotEscKey
        or      cs:bFlag,1
@@NotEscKey:    call    CheckWin
        jnz     @@NoWin
        or      cs:bFlag,2
        inc     cs:wErrCount

@@NoWin:        call    TADSMOVE        ;Update the reference data
@@QuitNow:
        popf
        iret

Old16:  popf
        db      0eah
wOld16  dw      ?,?

Int10Hook:      pushf
        cmp     ax,3
        jne     Old10
        
;        call    DrawGrid        ;Update & check
;        adc     cs:wErrCount,0  ;Error + 1 if CY

        or      cs:bFlag,4
        test    cs:bFlag,1
        jne     Old10   ;Escape pressed, OK
        inc     cs:wErrCount
        call    CheckWin
        jne     Old10   ;No winning field Error
        dec     cs:wErrCount    ;Ok, exit allowed
        or      cs:bFlag,2
Old10:  popf
        db      0eah
wOld10  dw      ?,?


GetScanCode:    xor     cs:bFlag,80h
        js      @@AltCode
        mov     ah,4bh
        cmp     al,34h
        je      @@HaveSC
        mov     ah,48h
        cmp     al,38h
        je      @@HaveSC
        mov     ah,4dh
        cmp     al,36h
        je      @@HaveSC
        mov     ah,50h
        cmp     al,32h
        je      @@HaveSC
@@EndSC:        mov     ah,39h
        cmp     al,20h
        je      @@HaveSC
        mov     ah,1
@@HaveSC:       ret

@@AltCode:      cmp     al,32h
        jb      @@EndSC
        mov     ah,al
        sub     ah,2fh
        ret


SkipSpc2:
	inc	si
SkipSpaces:
	cmp	by [si],20h
	jbe	short SkipSpc2
	ret


;; Check for WIN condition ::
CheckWin:
        push    bx
        mov     bx, 15
cw_loop:
        cmp     cs:Grid[bx], bl
        jnz     short cw_nope
        dec     bx
        jns     short cw_loop
cw_nope:
        inc     bx                      ; ZF = won
        pop     bx
        ret

TADSMOVE:       pusha
        push    ds
        push    cs
        pop     ds

	mov	CurrKeyCode, ax		; Keep current scan/key code

	inc	TotalKeyMoves		; count every key (illegal & valid)


        mov     di,  4                  ; dx = 0        dy = +1
        mov     cl, 0100b               ; down
        cmp     al, '8'
        jz      short TryMove           ; [8] ?

        mov     di,  -4                 ; dx = 0        dy = -1
        mov     cl, 1000b               ; up
        cmp     al, '2'
        jz      short TryMove           ; [2] ?

        mov     di,  1                  ; dx = +1       dy = 0
        mov     cl, 0001b               ; right
        cmp     al, '4'
        jz      short TryMove           ; [4] ?

        mov     di,  -1                 ; dx = -1       dy = 0
        mov     cl, 0010b               ; left
        cmp     al, '6'
        jz      short TryMove           ; [6] ?

_Ret1:  pop     ds
        popa
        ret

;; Attempt Move ;;
TryMove:
        mov     bx, [HolePos]
        test    ValidMoves[bx],  cl
        jz      short BadMove           ; is it a bad move (ie. at border) ?

        mov     al, Grid[bx+di]
        mov     Grid[bx], al            ; Move tile
        mov     Grid[bx+di], 0          ; replace hole
        add     [HolePos],  di          ; update hole (x, y) position

        inc     [MovesCounter]          ; MovesCounter + 1
BadMove:
        jmp     _Ret1

;*** TAD's drawing engine

;; Draw entire grid ;;

DrawGrid:       pusha
        push    es
        push    ds
        push    cs
        pop     ds
        mov     es,wEmulSeg
        cld

        mov     si,  15
dg_LOOP:
        mov     al, Grid[si]            ; al = grid[x,y]

        shl     si, 1
        mov     di,  ScrOffs[si]        ; di --> screen pixel

        ;; draw the 30x30 pixel box ;;

        mov     dx,30
dg_BOX:
        mov     cx,30
        rep     stosb
        add     di,320-30
        dec     dx
        jnz     short dg_BOX

        ;; draw the LED digits ;;

        aam     10
        push    ax
        mov     al,ah                   ; 10's
        mov     di, 6+(7*320)           ; draw at (+6, +7)
        call    DrawLED

        pop     ax                      ; 1's
        mov     di, 16+(7*320)          ; draw at (+16, +7)
        call    DrawLED

        shr     si,1
        dec     si
        jns     short dg_LOOP

        push    0a000h
        pop     ds
        xor     di,di
        xor     si,si
        mov     cx,64000/2
        repe cmpsw
        je      @@Compares		; no drawing errors ?
	cmp	cs:bDebugMode,0
	jz	@@NoShow		; Debug mode off ?
	call	ShowDebug
@@NoShow:
        stc
@@Compares:     pop     ds
        pop     es
        popa
        ret

;; Draw LED char(AL) at( DI+Scroffs[si] ) ;;
DrawLED:
        add     di, ScrOffs[si]         ; [ES:DI] --> screen pixel

        mov     bx, offset LedDigits
        xlat    [bx]
        aam     1                       ; ah = bits     al = 00

        mov     bx, (6*6)
dl_LOOP:
        add     ax,ax
        jnc     short dl_NEXT           ; don't draw line section ?
        push    di
        add     di, LedLines[bx]        ; [ES:DI] --> scr pixel
        mov     cx, LedLines[bx+2]      ; CX = rep count
dl_DRAW:
        mov     ES:[di], al             ; plot pixel color(0)
        add     di, LedLines[bx+4]      ; advance DI by +1 or +320
        loop    dl_DRAW
        pop     di
dl_NEXT:
        sub     bx, 6
        jns     short dl_LOOP           ; repeat for all 7 LED sections
        ret

;* Copy screen[SI:0000] to [DI:0000] *
CopyScreen:
	push	DS
	push	ES
	mov	DS, si
	xor	si, si
	mov	ES, di
	xor	di, di
	mov	cx,(64000/2)
	rep	movsw
	pop	ES
	pop	DS
	ret

;; The main debug-mode loop ;;
ShowDebug:
	push	DS
	push	ES

	push	CS
	pop	DS			; DS --> CS

	cmp	bMouseFlag, 0
	jz	short @@norat
	mov	ax, 000Fh
	mov	cx, 4
	mov	dx, 4
	int	33h			;set mickey-2-pixel ratio
@@norat:

	mov	bHookKeyFlag, 0		; disable INT 16h key hook

	mov	bHelpRedraw,1

	mov	si, wVideoMem
	mov	di, wEntrySeg
	call	CopyScreen		; save video-mem screen

	mov	wErrorScr, 0
	call	FindNextError		; goto 1st error (if any)

	call	DrawBackground
@@again:
	call	Vsync
	call	DrawWindow		; Draw zoom/help window
	mov	ax, wCursorMask
	call	DrawCursor		; draw area cursor
	call	DebugMouse		; get mouse inputs
	mov	ah,01h
	int	16h
	jz	short @@again		; no key press ?
	sub	ax,ax
	int	16h
	cmp	al,27
	jz	short @@quit		; [ESC] turn off debug mode...
	cmp	al, 20h
	jz	short @@next		; [SPACE] run until next error...
	cmp	ah, 044h
	jz	short @@termin		; [F10] quit to dos ?
	push	ax
	mov	ah,02h
	int	16h
	mov	bKeyStatus, al		; Key shift status
	pop	ax
	call	DebugKeys		; process key(AX)
	jmp	short @@again
@@termin:
	inc	bQuitFlag
@@quit:
	mov	bDebugMode, 0		; disable debug mode
@@next:
	mov	si, wEntrySeg
	mov	di, wVideoMem
	call	CopyScreen		; restore video-mem

	pop	ES
	pop	DS
	mov	cs:bHookKeyFlag, 1
	ret


;* Wait for V-SYNC *
Vsync:
	mov	dx, 3DAh
@@1:
	in	al, dx
	test	al, 8
	jz	short @@1
	ret

;* Process key(AX) *
DebugKeys:
	mov	bx, -1
	sub	dx, dx
	cmp	ah, 4Bh
	jz	short KeyRel		; [LEFT] ?

	neg	bx
	cmp	ah, 4Dh
	jz	short KeyRel		; [RIGHT] ?

	xchg	dx, bx
	cmp	ah, 50h
	jz	short KeyRel		; [DOWN] ?

	neg	dx
	cmp	ah, 48h
	jz	short KeyRel		; [UP] ?

	cmp	al, 9
	jz	short TogScr		; [TAB] ?

	and	al, 0DFh
	cmp	al, "N"
	jz	FindNextError		; [N] ?

	cmp	ah, 03Bh
	jz	TogHelp			; [F1] ?


TogScr:
	xor	bViewMode, 1
	call	DrawBackground
	ret

TogHelp:
	xor	bHelpMode, 1
	call	DrawBackground
ShowF1Help:
	cmp	bHelpMode,0
	jz	short @@1
	inc	bHelpRedraw
@@1:
	ret
	

;* Move relative dx(bx) dy(dx) scaled by [SHIFT] *
KeyRel:
	mov	cl, 3
	test	bKeyStatus, cl
	jz	short MoveRel
	shl	bx, cl
	shl	dx, cl			; if SHIFT then dx*8, dy*8
MoveRel:
	add	bx, wZoomX
	jns	short @@1
	sub	bx, bx    	
@@1:
	cmp	bx, 319
	jle	short @@2
	mov	bx, 319
@@2:
	add	dx, wZoomY
	jns	short @@3
	sub	dx, dx
@@3:
	cmp	dx, 199
	jle	short @@4
	mov	dx, 199
@@4:

GotoXY:
	pusha
	mov	ax, 00FFh
	call	DrawCursor		; Erase cursor (restore line pixels)
	popa

	mov	wZoomX, bx
	mov	wZoomY, dx

	;; check that Zoom x,y isn't under zoom window ;;

	mov	ax, wZoomWinScr
	xor	ax, 320-128
	jz	short @@8
	cmp	bx, 142
	jbe	short @@9
	jmp	short @@6
@@8:
	cmp	bx, 175
	jb	short @@6
@@9:
	mov	wZoomWinScr, ax		; move window to avoid cursor
	call	DrawBackground
@@6:
	ret

;* Deal with the Mouse inputs *
DebugMouse:
	cmp	bMouseFlag, 0
	jz	short @@1

	mov	ax, 000Bh
	int	33h		; read mickey counters
	mov	bx, cx
	sar	bx, 1
	sar	dx, 1

	mov	ax, bx
	or	ax, dx
	jnz	short MoveRel	; has Mouse moved ?

@@1:
	ret

;* Draw the background screen (Frame + HotSpot) *
DrawBackground:
	mov	bHelpRedraw,1
	call	DrawFrame
	ret


;* Draw the window frame & clear window *
DrawFrame:
	mov	si, wEntrySeg
	mov	ax, wEmulSeg

	test	bViewMode, 1
	jz	short @@1		; viewing Entry screen ?
    	xchg	ax, si			; else view Emulated test screen
@@1:
	mov	di, wVideoMem
	call	CopyScreen

	;; now draw all the static border stuff... ;;

	push	ES
	mov	ES, wVideoMem
	mov	di, wZoomWinScr
	mov	ax, 0F0Fh
	mov	cx, (126/2)
	rep	stosw
	stosb
	add	di, 320-127
	mov	dx, 126+6
@@2:
	mov	ax, 000Fh
	stosw
	sub	ax,ax
	mov	cx,124/2
	rep	stosw
	mov	byte ptr ES:[di],0Fh
	add	di,320-126
	dec	dx
	jnz	short @@2
	mov	ax, 0F0Fh
	mov	cx, (126/2)
	rep	stosw
	stosb
	pop	ES
	ret

;* Draw the Window Hotspot(0,0) cursor *
DrawHotSpot:
	push	ES
	mov	ES, wVideoMem

	mov	ax,0F0Fh

	mov	di, wZoomWinScr
	add	di, 61+(59*320)
	stosw
	stosw
	stosb
	add	di,320-5
	mov	cx,3
@@3:
	mov	ES:[di], al
	mov	ES:[di+4], al
	add	di,320
	loop	@@3
	stosw
	stosw
	stosb

	pop	ES

	mov	si,offset scr1txt
	test	bViewMode, 1
	jz	short @@1
	mov	si,offset scr2txt
@@1:
	call	PrintMessage
	ret

;* Draw window stuff (zoom or help) *
DrawWindow:
	cmp	bHelpMode,0
	jz	short DrawZoom
	shr	bHelpRedraw,1
	jnc	short @@1

	mov	di, offset helpnum1
	mov	ax, MovesCounter
	call	outdec5

	mov	di, offset helpnum2
	mov	ax, TotalKeyMoves
	call	outdec5

	mov	di, offset helpnum3
	mov	ax, CurrKeyCode
	call	outhex4

	mov	si, offset helptxt
	call	PrintMessage
@@1:
	ret


;* Draw the zoom window & info bar status *
DrawZoom:
	call	DrawHotSpot

	lea	di, infotxt2
	mov	ax, wZoomX
	call	outdec3

	lea	di, infotxt3
	mov	ax, wZoomY
	call	outdec3

	lea	di, infotxt4
	mov	ax, 320
	mul	wZoomY
	add	ax, wZoomX
	call	outhex4


	push	DS
	push	ES
	push	FS

	mov	bx, wZoomX
	mov	bp, wZoomY

	mov	ax, 320
	mul	bp
	add	ax, bx
	sub	ax, 15+(12*320)
	xchg	ax, si 
	mov	ES, wEntrySeg		; [ES:SI] --> entry bitmap (-15,-15)
	mov	FS, wEmulSeg		; [FS:SI] --> test bitmap

	add	wFlashTick,2
	jns	short @@4
	push	ES
	push	FS
	pop	ES
	pop	FS			; swap ES, FS
@@4:

	mov	di, wZoomWinScr
	add	di, 2+(320*12)
	mov	DS, wVideoMem		; [DS:DI] --> screen pixel

	sub	bx, 15
	sub	bp, 12			; centre hotspot (x,y)

	mov	dh, 28
@@1:
	mov	dl, 31
@@2:
	mov	al, 0
	cmp	bp, 200	 		; this loop REALLY sux !!!
	jae	short @@3
	cmp	bx, 320			; but I don't care... 
	jae	short @@3
	mov	al, ES:[si]		; get clipped bitmap pixel
@@3:
	mov	ah, al
	inc	si
	mov	[di], ax
	mov	[di+2], al
	mov	[di+320], ax
	mov	[di+322], al
	mov	[di+640], ax
	mov	[di+642], al		; simple 3x3 magnify

	add	di, 4
	inc	bx
	dec	dl
	jnz	short @@2
	add	di, (4*320)-(4*31)
	add	si, (320-31)
	sub	bx, 31
	inc	bp
	dec	dh
	jnz	short @@1

	pop	FS
	pop	ES
	pop	DS

	;; display info bar ;;

	mov	si, offset infotxt
	call	PrintMessage	
	ret


;* Print message[DS:SI] in window *
PrintMessage:
	pusha
	push	ES
	mov	ES, wVideoMem
	mov	bp, wTxtPen
	jmp	pm_CALC

	;; decode & print 6x6 pixel char(AX) ;;
pm_PRINT:
	shl	bx, 3

	mov	ah,6
pm_CHRY:
	mov	al, dbugfont[bx]
	inc	bx

	add	al, al
	sbb	cl, cl
	add	al, al
	sbb	ch, ch
	add	al, al
	sbb	dl, dl
	add	al, al
	sbb	dh, dh
	and	cx, bp
	and	dx, bp
	mov	ES:[di], cx
	mov	ES:[di+2], dx		; decode bits 7..4

	add	al, al
	sbb	cl, cl
	add	al, al
	sbb	ch, ch
	and	cx, bp
	mov	ES:[di+4], cx		; decode bits 3..2

	add	di, 320
	dec	ah
	jnz	short pm_CHRY
	add	di, 6-(6*320)
	inc	byte ptr wTxtX
pm_NEXT:
	mov	bl, [si]
	inc	si
	and	bx, 00FFh
	cmp	bl, PEN
	ja	short pm_PRINT		; not a control-code ?
	add	bx, bx
	jmp	cs:pm_JUMPS[bx]

pm_JUMPS	dw	pm_QUIT
		dw	pm_XTAB
		dw	pm_YTAB
		dw	pm_LOCATE
		dw	pm_CARRET
		dw	pm_PEN


pm_CARRET:
	mov	byte ptr wTxtX, 0
	inc	byte ptr wTxtY
	jmp	SHORT pm_CALC

pm_XTAB:
	lodsb
	mov	byte ptr wTxtX, al
	jmp	short pm_CALC

pm_LOCATE:
	lodsb
	mov	byte ptr wTxtX, al
pm_YTAB:
	lodsb
	mov	byte ptr wTxtY, al

	;; calc pixel addr from text (x*6,y*6) ;;
pm_CALC:
	mov	di, wTxtY
	mov	ax, wTxtX
	imul	di, di, (6*320)
	imul	ax, ax, 6
	add	ax, 2+2+(320*5)
	add	ax, wZoomWinScr
	add	di, ax			; [ES:DI] --> scr pixel
	jmp	short pm_NEXT

pm_PEN:
	lodsb
	mov	ah,al
	xchg	ax, bp
	jmp	short pm_NEXT

pm_QUIT:
	mov	wTxtPen, bp
	pop	ES
	popa
	ret



;* Find the next pixel error *
FindNextError:
	push	DS
	push	ES

	mov	di, wErrorScr		; begin from last position
	mov	ES, wEntrySeg
	mov	DS, wEmulSeg

	mov	cx, 64000
	sub	cx, di
	jc	short @@4
	mov	si, di
	repz	cmpsb
	jnz	short @@2		; found error ?
@@4:
	sub	si, si
	sub	di, di
	mov	cx, 64000
	repz	cmpsb			; restart from 0,0
@@2:
	pop	ES
	pop	DS
	jz	short @@3		; no error ?

	mov	wErrorScr, di

	;; calc x,y from pixel error address ;;

	xchg	ax, di
	dec	ax
	sub	dx, dx
	mov	si, 320
	div	si
	mov	bx, dx
	xchg	ax, dx
	jmp	GotoXY			; Move zoom window over pixel
@@3:
	ret

;* Output(AX) into[DS:DI] as hex 4- digit *
outhex4:
	xchg	ax, dx
	mov	cx, 4
@@1:
	rol	dx, 4
	mov	ax, 300Fh
	and	al, dl
	aaa
	aad	11h
	mov	[di], al
	inc	di
	loop	@@1
	ret


outdec5:
	mov	bx, 1000
	sub	dx,dx
	div	bx
	call	outdec2
	xchg	ax,dx

;* Output(AX) into[DS:DI] as decimal 3-digit *
outdec3:
	mov	bx, 100
	sub	dx, dx
	div	bx
	or	al, '0'
	mov	[di], al
	inc	di
	xchg	ax, dx
outdec2:
	aam
	or	ax, '00'
	mov	[di], ah
	inc	di
	mov	[di], al
	inc	di
	ret

;* Draw the zoom area cursor on the background *
DrawCursor:
	xchg	ax, dx
	push	DS
	push	ES
	mov	bx, wZoomX
	mov	di, wZoomY

	mov	ES, wVideoMem		; [ES:0000] --> vid mem

	test	bViewMode, 1
	mov	ax, wEntrySeg
	jz	short @@1
    	mov	ax, wEmulSeg
@@1:
	mov	DS, ax			; [DS:0000] --> entry/test bitmap

	sub	bx, 16
	sub	di, 13
	lea	cx, [bx+32]
	call	HorzCursor

	lea	cx, [di+29]
	call	VertCursor

	push	bx
	lea	bx, [bx+32]
	call	VertCursor
	pop	bx

	add	di,29
	lea	cx, [bx+32]
	call	HorzCursor

	pop	ES
	pop	DS
	ret

;* Draw horz line(BX,DI) - (CX,DI) mask(DX) *
HorzCursor:
	pusha
	cmp	di,200
	jae	short @@1
	test	bx, bx
	jns	short @@2
    	sub	bx, bx
@@2:
	cmp	cx, 319
	jle	short @@3
    	mov	cx, 319
@@3:
	sub	cx, bx
	jc	short @@1
	inc	cx

	imul	di, di,320
	add	di, bx
@@4:
	mov	al, [di]
	and	al, dl
	or	al, dh
	stosb
	loop	@@4
@@1:
	popa
	ret

;* Draw vert line(BX,DI) - (BX,CX) mask(DX) *
VertCursor:
	pusha
	cmp	bx, 320
	jae	short @@1
	test	di, di
	jns	short @@2
	sub	di, di
@@2:
	cmp	cx, 199
	jle	short @@3
	mov	cx, 199
@@3:
	sub	cx, di
	jc	short @@1
	inc	cx

	imul	di, di, 320
	add	di, bx
@@4:
	mov	al, [di]
	and	al, dl
	or	al, dh
	stosb
	add	di, 320-1
	loop	@@4
@@1:
	popa
	ret


;; A dodgy looking 6x6 pixel font (8 bytes per char) ;;

dbugfont	label byte

;* File: "D:\FED\SYS6X6.MSK"
;*
	DW	00000h,00000h,00000h,00000h,07020h,020D8h,02020h,00000h
	DW	02020h,0D820h,02070h,00000h,01810h,018ECh,00010h,00000h
	DW	06020h,060DCh,00020h,00000h,0A870h,0A8D8h,00070h,00000h
	DW	0F0F8h,0C8E0h,00098h,00000h,0A8D8h,0A870h,000D8h,00000h
	DW	0180Ch,0E0B0h,00040h,00000h,08478h,0B4A4h,07884h,00000h
	DW	07830h,0FC78h,03000h,00000h,01810h,07010h,060F0h,00000h
	DW	080E0h,090DCh,01018h,00000h,080E0h,0E8B8h,02C38h,00000h
	DW	01414h,03414h,06474h,00000h,04040h,06040h,03070h,00000h
	DW	0C8F8h,0D8C8h,0F8D8h,00000h,02060h,07020h,07070h,00000h
	DW	00878h,0C0F8h,0F8C0h,00000h,010F0h,018F8h,0F818h,00000h
	DW	0C0C0h,0D8C0h,018F8h,00000h,080F0h,018F8h,0F818h,00000h
	DW	0C0C0h,098F8h,0F8D8h,00000h,008F8h,03038h,03030h,00000h
	DW	05070h,0D870h,0F8D8h,00000h,0D8F8h,0F8C8h,01818h,00000h
	DW	07000h,0F808h,00070h,00000h,080E0h,090DCh,01CF0h,00000h
	DW	03C1Ch,04060h,05870h,00000h,0D0E0h,00818h,02878h,00000h
	DW	02C44h,01428h,0C0ECh,00000h,0D008h,0A050h,000C0h,00000h
	DW	00000h,00000h,00000h,00000h,03030h,03030h,03000h,00000h
	DW	0D8D8h,00090h,00000h,00000h,0F850h,0F850h,00050h,00000h
	DW	0A078h,02870h,020F0h,00000h,0D0C8h,05820h,00098h,00000h
	DW	0D060h,0E860h,068D0h,00000h,03030h,00060h,00000h,00000h
	DW	06030h,06060h,00030h,00000h,03060h,03030h,00060h,00000h
	DW	03048h,03078h,00048h,00000h,02020h,020F8h,00020h,00000h
	DW	00000h,03000h,06030h,00000h,00000h,00078h,00000h,00000h
	DW	00000h,03000h,00030h,00000h,03018h,0C060h,00080h,00000h
	DW	09870h,0C8A8h,00070h,00000h,03010h,01010h,00010h,00000h
	DW	008F0h,08070h,000F8h,00000h,008F0h,00870h,000F0h,00000h
	DW	05030h,0F890h,00010h,00000h,080F0h,008F0h,000F0h,00000h
	DW	08070h,088F0h,00070h,00000h,008F8h,02010h,00020h,00000h
	DW	08870h,08870h,00070h,00000h,08870h,00878h,00070h,00000h
	DW	03030h,03000h,00030h,00000h,03030h,03000h,02010h,00000h
	DW	03018h,03060h,00018h,00000h,07800h,07800h,00000h,00000h
	DW	03060h,03018h,00060h,00000h,09870h,03030h,03000h,00000h
	DW	08870h,0B0B8h,07880h,00000h,08870h,088F8h,00088h,00000h
	DW	088F0h,088F0h,000F0h,00000h,08078h,08080h,00078h,00000h
	DW	088F0h,08888h,000F0h,00000h,080F8h,080F0h,000F8h,00000h
	DW	080F8h,080F0h,00080h,00000h,08078h,08898h,00078h,00000h
	DW	08888h,088F8h,00088h,00000h,02070h,02020h,00070h,00000h
	DW	00808h,08808h,00070h,00000h,05048h,05060h,00048h,00000h
	DW	04040h,04040h,00078h,00000h,0D888h,088A8h,00088h,00000h
	DW	0C888h,098A8h,00088h,00000h,08870h,08888h,00070h,00000h
	DW	088F0h,080F0h,00080h,00000h,08870h,08888h,01870h,00000h
	DW	088F0h,0A0F0h,00098h,00000h,08078h,00870h,000F0h,00000h
	DW	020F8h,02020h,00020h,00000h,08888h,08888h,00078h,00000h
	DW	08888h,05088h,00020h,00000h,08888h,0D8A8h,00088h,00000h
	DW	05088h,05020h,00088h,00000h,08888h,02050h,00020h,00000h
	DW	010F8h,04020h,000F8h,00000h,06078h,06060h,00078h,00000h
	DW	060C0h,01830h,00008h,00000h,01878h,01818h,00078h,00000h
	DW	07020h,000D8h,00000h,00000h,00000h,00000h,0F800h,00000h
	DW	06060h,00030h,00000h,00000h,07000h,0F808h,00078h,00000h
	DW	0F080h,08888h,000F0h,00000h,07000h,08080h,00070h,00000h
	DW	07808h,08888h,00078h,00000h,07000h,080F8h,00070h,00000h
	DW	02018h,02078h,00020h,00000h,07800h,07888h,0F008h,00000h
	DW	0B080h,088C8h,00088h,00000h,06000h,02020h,00070h,00000h
	DW	01010h,01010h,0E010h,00000h,09080h,090E0h,00088h,00000h
	DW	02060h,02020h,00070h,00000h,05000h,0A8F8h,00088h,00000h
	DW	0F000h,08888h,00088h,00000h,07000h,08888h,00070h,00000h
	DW	0F000h,08888h,080F0h,00000h,07800h,08888h,00878h,00000h
	DW	07000h,04048h,00040h,00000h,03800h,01860h,00070h,00000h
	DW	07020h,02020h,00010h,00000h,08800h,08888h,00078h,00000h
	DW	08800h,05088h,00020h,00000h,08800h,0A8A8h,000D8h,00000h
	DW	04800h,03030h,00048h,00000h,08800h,07888h,0F008h,00000h
	DW	07800h,02010h,00078h,00000h,03038h,03060h,00038h,00000h
	DW	03030h,03030h,03030h,00000h,03070h,03018h,00070h,00000h
	DW	0E840h,010B8h,00000h,00000h,02000h,0C870h,000F8h,00000h
	DW	08078h,08080h,0C078h,00000h,00050h,08888h,07888h,00000h
	DW	02010h,0F870h,07080h,00000h,05020h,00870h,078F8h,00000h
	DW	00050h,00870h,078F8h,00000h,02040h,00870h,078F8h,00000h
	DW	00020h,00870h,078F8h,00000h,07800h,08080h,0E078h,00000h
	DW	05020h,0F870h,07080h,00000h,00050h,0F870h,07080h,00000h
	DW	02040h,0F870h,07080h,00000h,00050h,02060h,07020h,00000h
	DW	05020h,02020h,07020h,00000h,02040h,02060h,07020h,00000h
	DW	00050h,08870h,088F8h,00000h,00020h,08870h,088F8h,00000h
	DW	0F820h,0F080h,0F880h,00000h,0F000h,0E038h,00078h,00000h
	DW	0A078h,0A0F8h,000B8h,00000h,05020h,08870h,07088h,00000h
	DW	00050h,08870h,07088h,00000h,02040h,08870h,07088h,00000h
	DW	05020h,08888h,07888h,00000h,02040h,08888h,07888h,00000h
	DW	00050h,07888h,0F008h,00000h,00050h,08870h,07088h,00000h
	DW	00050h,08888h,07888h,00000h,03810h,03860h,00010h,00000h
	DW	02018h,02070h,00078h,00000h,0D888h,02070h,02070h,00000h
	DW	0D8F0h,0D8F0h,0C0F0h,00000h,02018h,02078h,0C020h,00000h
	DW	02010h,00870h,078F8h,00000h,02010h,02060h,07020h,00000h
	DW	02010h,08870h,07088h,00000h,02010h,08888h,07888h,00000h
	DW	000F0h,088F0h,08888h,00000h,00078h,06848h,04858h,00000h
	DW	00870h,078F8h,0F800h,00000h,08870h,07088h,0F800h,00000h
	DW	00060h,06060h,070C8h,00000h,00000h,04078h,00040h,00000h
	DW	00000h,00878h,00008h,00000h,0C0C0h,02CD8h,03C18h,00000h
	DW	0C0C0h,014CCh,0043Ch,00000h,00030h,03030h,03030h,00000h
	DW	06C34h,06CD8h,00034h,00000h,0D8B0h,0D86Ch,000B0h,00000h
	DW	0B068h,00870h,078F8h,00000h,0B068h,08870h,07088h,00000h
	DW	04834h,06858h,0B048h,00000h,03008h,06858h,04030h,00000h
	DW	07000h,0A0B8h,00078h,00000h,0B078h,0B0B8h,00078h,00000h
	DW	02040h,08870h,088F8h,00000h,0B068h,08870h,088F8h,00000h
	DW	0B068h,08870h,07088h,00000h,00050h,00000h,00000h,00000h
	DW	02010h,00000h,00000h,00000h,07020h,02020h,00020h,00000h
	DW	0E868h,068E8h,02828h,00000h,0CC78h,0BCB4h,078C4h,00000h
	DW	08C78h,08CB4h,078A4h,00000h,05CF4h,00054h,00000h,00000h
	DW	00048h,04848h,01048h,00000h,048E8h,0E848h,03008h,00000h
	DW	0D898h,0D870h,000C8h,00000h,030F0h,03030h,000F8h,00000h
	DW	00878h,03818h,00068h,00000h,018FCh,01818h,00018h,00000h
	DW	018F0h,0D8D8h,000D8h,00000h,03070h,03030h,00030h,00000h
	DW	03078h,01818h,00018h,00000h,06CFCh,06C6Ch,0006Ch,00000h
	DW	0D8C0h,0D8D8h,000F8h,00000h,01878h,00018h,00000h,00000h
	DW	018F0h,01818h,000F0h,00000h,0F8C0h,01818h,00078h,00000h
	DW	07CD8h,06464h,0006Ch,00000h,01838h,01818h,00078h,00000h
	DW	0D8F8h,0D8D8h,00070h,00000h,06C6Ch,06C6Ch,000FCh,00000h
	DW	098F8h,018D8h,000F8h,00000h,0D8D8h,03870h,000F8h,00000h
	DW	018F8h,0D0D8h,0C0C0h,00000h,01870h,01818h,00018h,00000h
	DW	0D4D4h,0C4F4h,000FCh,00000h,05878h,05858h,000D8h,00000h
	DW	01838h,01818h,00018h,00000h,018F8h,01818h,00018h,00000h
	DW	0FC00h,06C6Ch,0007Ch,00000h,0F8F8h,0F8F8h,0F8F8h,00000h
	DW	0D8D8h,03070h,00030h,00000h,02830h,07070h,060A0h,00000h
	DW	02000h,0D870h,00088h,00000h,05800h,0B4B4h,00068h,00000h
	DW	06800h,0D0D0h,00068h,00000h,0D870h,0D8F0h,0C0F0h,00000h
	DW	06CFCh,06064h,06060h,00000h,0F800h,05050h,00050h,00000h
	DW	060F8h,06030h,0F8C0h,00000h,07038h,0D8D8h,00070h,00000h
	DW	06800h,06868h,0C07Ch,00000h,0F800h,03030h,02030h,00000h
	DW	07070h,0A8A8h,07070h,00000h,0D870h,0D8F8h,00070h,00000h
	DW	0D870h,050D8h,000D8h,00000h,06830h,0D870h,070D8h,00000h
	DW	02018h,0A870h,0C070h,00000h,07020h,0A8A8h,02070h,00000h
	DW	04038h,04078h,00038h,00000h,04830h,04848h,00048h,00000h
	DW	00078h,00078h,00078h,00000h,0F820h,00020h,000F8h,00000h
	DW	01860h,00060h,00078h,00000h,06018h,00018h,00078h,00000h
	DW	0100Ch,03030h,03030h,00000h,03030h,03030h,0C020h,00000h
	DW	00020h,000F8h,00020h,00000h,0B068h,06800h,000B0h,00000h
	DW	04830h,00030h,00000h,00000h,07830h,00030h,00000h,00000h
	DW	00000h,03030h,00000h,00000h,01C00h,0D010h,02070h,00000h
	DW	06870h,06868h,00000h,00000h,01870h,07830h,00000h,00000h
	DW	03070h,07010h,00000h,00000h,000F8h,00000h,00000h,00000h

        END     Start


