
                %TITLE "The Taquin-Puzzle"

        ; $Id: entry.asm 1.26 2000/01/23 14:46:38 JohnnyL.Fencey Exp $

        ;============================================;
        ;                                            ;
        ;             the one year before            ;
        ;              M I L L E N I U M             ;
        ;                  challenge                 ;
        ;--------------------------------------------;
        ;                                            ;
        ;       HUGI size coding competition         ;
        ;                    # 10                    ;
        ;                                            ;
        ;--------------------------------------------;
        ;             by Johnny L. Fencey            ;
        ;                                            ;
        ;         JeLlyFish.software@gmx.net         ;
        ;                                            ;
        ;============================================;


        MODEL TINY
        P586N           ;-) not that I really use such big stuff

                Ŀ
                ; compilation directives ;
                

FINAL=          1       ; if !=0 code assumes some startup values different
                        ; from that in the debugger (namely BP)
                        ; if (!=0) saving= 3

USE_KBIOS=      0       ; if !=0 then uses int16/ah=0 call for keys
                        ; else it uses DOS function 08h for that
                        ; 0 allows input file redirection

IF FINAL NE 0   ; non-debug mode
        USE_KBIOS=      1       ; use BIOS for checking pressed keys
ENDIF

                Ŀ
                ; some definitions ;
                

        ;---------------------;
        ; tile base constants ;
        ;---------------------;

X=       95     ; X-base-position of border
Y=       35     ; Y-base-position of border
S=       32     ; spacing between single tiles

W=      320     ; screen width


        ;--------------------------------;
        ; define our own video segment   ;
        ; and redefine X & Y accordingly ;
        ;--------------------------------;

VSEG=   0A000h+((Y*W+X) SHR 4)
Y=      0
X=      X AND 0Fh


        ;-----------------;
        ; color constants ;
        ;-----------------;

BACKCOLOR=      0
BORDERCOLOR=    7


        ;-------------;
        ; video modes ;
        ;-------------;

V_TEXT= 03h
V_GRAF= 13h


        ;----------------;
        ; BIOS functions ;
        ;----------------;

B_GETKEY=       00h


        ;---------------;
        ; DOS functions ;
        ;---------------;

D_GETKEY=       08h
D_PRINT_STR=    09h
D_FCREATE=      3Ch
D_FCLOSE=       3Eh
D_FWRITE=       40h


        ;------------------------------;
        ; key codes and move constants ;
        ;------------------------------;

K_ESC=  ' '

K_UP=   '2'
M_UP=   -4      ; up move of hole

K_LT=   '6'
M_LT=   -1      ; left move of hole

K_RT=   '4'
M_RT=   +1      ; right move of hole

K_DN=   '8'
M_DN=   +4      ; down move of hole


        ;--------------------------;
        ; little EQUations         ;
        ;..........................;
        ; Do you really think it's ;
        ; more readable this way?  ;
        ;--------------------------;

moves   EQU     <WORD 0FFFCh>


        ;---------------------;
        ; some useless macros ;
        ;---------------------;

MACRO _b_int
        int     16h
ENDM _b_int

MACRO _d_int
        int     21h
ENDM _d_int

MACRO _v_int
        int     10h
ENDM _v_int


        ;--------------------;
        ; some useful macros ;
        ;--------------------;

MACRO salc
        DB 0D6h
ENDM salc





                Ŀ
                ; let's dig into the real McCoy ;
                




CODESEG
        STARTUPCODE

                Ŀ
                ; initialization ;
                

IF FINAL EQ 0

        mov     bp, OFFSET game_table

ENDIF   ; FINAL=0

        mov     di, bp                  ; bp=09xx at startup
                                        ; good place for the game table ;)
@@initloop:
        stos    [BYTE es:di]
        sub     al, 3                   ; sub 3
        and     al, 0Fh                 ; mask out higher nibble
        jnz     SHORT @@initloop

        push    ax                      ; init move counter on the stack

        mov     al, V_GRAF              ; ax= 0000 at startup
        _v_int                          ; init screenmode

        xor     cx, cx
        mov     ah, D_FCREATE
        mov     dx, OFFSET keyfilename
        _d_int

        push    ax                      ; save 'keys' file handle

                Ŀ
                ; draw border ;
                

        mov     ax, (130d SHL 8)+BORDERCOLOR
        mov     di, X+Y*W
        call    drawsquare

        mov     ax, (128d SHL 8)+BACKCOLOR
        mov     di, (X+1)+(Y+1)*W
        call    drawsquare

@@gameloop:

                Ŀ
                ; draw tiles ;
                

        mov     si, 15d
@@drawtiles:
        imul    bx, si, 64d             ; *64 means:
                                        ; Bit 2/3 to BH (*256)
        shr     bl, 1                   ; Bit 0/1 shl 5 (*32=S)
        mov     al, W*S/256d
        mul     bh                      ; ax= bh*40 (=W*S = 320*32)
        mov     bh, al                  ; result to high byte of BX
        lea     di, [bx+(X+2)+(Y+2)*W]  ; offset plus base to DI

        mov     al, [bp+si]             ; color to AL

        mov     ah, 30d                 ; 30 pixel square
        call    drawsquare

                Ŀ
                ; draw LEDs ;
                

        aam     10d                     ; ah= 10's, al= 1's

        push    ax
        call    drawLED                 ; draw the 1's
        pop     ax

        sub     di, 10d                 ; the 10's are 10 bytes to the left
        mov     al, ah                  ; load 10's value to al
        call    drawLED                 ; draw the 10's

        dec     si                      ; decrement counter
        jns     SHORT @@drawtiles

                Ŀ
                ; read a key ;
                

@@zeroloop:                             ; SI is -1 at this point
        inc     si
        cmp     [bp+si], ch
        jne     SHORT @@zeroloop        ; set SI to offset of zero tile

@@readkey:
IF USE_KBIOS NE 0

        mov     ah, B_GETKEY
        _b_int                          ; read key

ELSE    ; USE_KBIOS!=0

        mov     ah, D_GETKEY
        _d_int

ENDIF   ; USE_KBIOS=0

                Ŀ
                ; write it back ;
                

        pop     bx                      ; get key file handle
        push    bx                      ; push it again
        push    ax                      ; save key

        mov     dx, sp                  ; let dx point to pushed byte
        mov     cl, 1
        mov     ah, D_FWRITE
        _d_int                          ; write the same byte

        pop     ax                      ; restore the key

        mov     dx, OFFSET msg_DropOut  ; setup for fail message

                Ŀ
                ; check the keys ;
                

        mov     bx, si                  ; get zero position in SI

        cmp     al, K_ESC
        je      SHORT @@endgame

       
       ; the following code is more or less from TAD ;
       

                                ; TAD: Thank you, I tried to achieve
                                ; something like that in less than
                                ; 24 bytes. Alas, your mail was
                                ; faster than my mind, and I
                                ; really couldn't resist :^)

        ror     al, 1
        add     al, 0-(K_UP/2)-4
        add     al, 4
        jnc     SHORT @@readkey         ; check the keys and only fall
                                        ; through if they're good ones

        setp    cl
        add     cl, cl                  ; set up the shift (either 0/2)

        add     al, al
        and     al, 2
        dec     ax                      ; set up the sign (either -1/+1)

                
                ; END of TAD's code ;
                

        jp      SHORT @@noNEG
        not     bl                      ; negate BL on positive values
                                        ; BTW, SF does not work because
                                        ; AH may contain values != 0
@@noNEG:

        shl     al, cl                  ; get the value (becomes [+|-][1|4])
        cbw                             ; make it a word
        xchg    ax, bx                  ; move it to BX (index register)

                Ŀ
                ; check for valid moves ;
                

        shr     al, cl                  ; adjust those two bits to test
        test    al, 0011b
        jz      SHORT @@readkey         ; invalid, nothing changes

        inc     [moves]                 ; increment move counter
                                        ; (actually on stack at 0FFFCh)

                Ŀ
                ; make the move ;
                

        lea     di, [si+bx]             ; load DI with tile we move zero to
        xchg    ch, [bp+di]             ; set old tile to zero and get value
        xchg    ch, [bp+si]             ; copy this value to old zero tile
                                        ; and make CH zero again

                Ŀ
                ; check winning condition ;
                

        mov     di, bp                  ; set up for winning condition check
        mov     cl, 15d                 ; check only 15 tiles
                                        ; but if 15 tiles are correct,
                                        ; the 16th one must be correct, too
@@wincheckloop:
        mov     bx, cx                  ; load index from CX
        cmp     [di+bx], bl
        loope   @@wincheckloop

        jne     SHORT @@gameloop

        mov     dl, LOW OFFSET msg_Won  ; setup for success message

@@endgame:

                Ŀ
                ; exit stuff ;
                

        pop     bx                      ; get key file handle
        mov     ah, D_FCLOSE
        _d_int                          ; close the 'keys' file

        mov     ax, V_TEXT
        _v_int                          ; back to text mode

        call    printstr                ; print first message

        mov     dl, LOW OFFSET msg_After
        _d_int

                Ŀ
                ; print out moves counter ;
                

        pop     ax                      ; get the moves counter
        mov     si, OFFSET numbuf
        mov     bl, 10d                 ; (bh must be zero here)
                                        ; last set is from a dos file handle
                                        ; that should always be < 0xFF
                                ; thanks to Lawrence E. Boothby
                                ; who explained me the JFT and so made
                                ; me sure about this point
@@writenum:
        dec     si
        xor     dx, dx
        div     bx
        add     dl, '0'
        mov     [si], dl
        test    ax, ax
        jnz     SHORT @@writenum

        mov     dx, si                  ; si= start of num string

PROC printstr
        mov     ah, D_PRINT_STR
        _d_int

        ret
ENDP printstr

                Ŀ
                ; called procedures ;
                

PROC drawsquare
        push    VSEG
        pop     es                      ; let ES point to video segment

        mov     cl, ah                  ; height to CX
@@loop:
        pusha                           ; push DI & CX
        mov     cl, ah                  ; width to CX
        rep     stos [BYTE es:di]       ; draw the line
        popa                            ; restore width & destination
        add     di, W                   ; adjust destination
        loop    @@loop
@retn:
        ret
ENDP drawsquare

PROC drawLED
        mov     bx, OFFSET LEDBit
        xlat    [LEDBit]                ; translate value to LEDBits
        aam     1                       ; clear AL and
                                        ; set AH to the segment bits
@@nextbar:
        mov     dx, [bx+LEDBarO-LEDBit] ; get offset of LED segment
        inc     bx
        inc     bx                      ; next one
        add     ah, ah
        jz      SHORT @retn             ; z -> nothing more to draw
        jnc     SHORT @@nextbar         ; bit not set -> no draw

        push    di                      ; save DI

        sar     dx, 1                   ; get length flag (=Bit 0)

        adc     cl, 6                   ; 6 or 7 length

        add     di, dx                  ; add the offset

        test    ah, 00011111b           ; check terminator position
                                        ; (lower five bits)
        jz      SHORT @@hdraw           ; z -> horizontal bars

@@vdraw:                                ; vertical bars
        stos    [BYTE es:di]            ; write pixel
        add     di, W-1                 ; adjust offset
        loop    @@vdraw
@@hdraw:
        rep     stos [BYTE es:di]       ; CX is zero after @@vdraw-loop
                                        ; so the code is effectively
                                        ; a NOP in this case
        pop     di                      ; restore DI
        jmp     SHORT @@nextbar
ENDP drawLED




                Ŀ
                ; the bad (space wasting) DATA ;
                




; DATASEG

        ;-----------------------------;
        ; the led bits                ;
        ; Bit 0 is used as end marker ;
        ;-----------------------------;

        ;  76543210
LEDBit  DB 11111011b    ; 0
        DB 01010001b    ; 1
        DB 10011111b    ; 2
        DB 01011111b    ; 3
        DB 01110101b    ; 4
        DB 01101111b    ; 5
        DB 11101111b    ; 6
        DB 01111001b    ; 7
        DB 11111111b    ; 8
        DB 01111111b    ; 9

        ;------------------------------------------;
        ; our own numbering different from the one ;
        ; described in the rules...                ;
        ;------------------------------------------;

                        ;        3
                        ;       5 4
                        ;        2
                        ;       7 6
                        ;        1

        ;-----------------------------------------------;
        ; let's define the position of the LED segments ;
        ;-----------------------------------------------;

TB=     30d*W   ; the tile base (DI after call to drawsquare)

; the LED bar's offsets
LEDBarO DW (16+15*W-TB)*2+1     ; 3
        DW (23+15*W-TB)*2+1     ; 2
        DW (16+ 8*W-TB)*2       ; 6
        DW (23+ 8*W-TB)*2       ; 5
        DW (17+ 7*W-TB)*2       ; 7
        DW (17+14*W-TB)*2       ; 4
        DW (17+22*W-TB)*2       ; 1

        ;----------------------------------;
        ; and the fucking rest of our data ;
        ;----------------------------------;

keyfilename     DB 'keys', 0

msg_Won         DB 'Winning field$'
msg_DropOut     DB 'You have quit$'
msg_After       DB ' after $'

LABEL numbuf BYTE
msg_Moves       DB ' moves', 0Dh, 0Ah, '$'





                        Ŀ
                        ; the good (zero size) DATA ;
                        ; actually it's only needed ;
                        ; in debug mode ...         ;
                        




; UDATASEG

IF FINAL EQ 0
        game_table      DB 16 DUP (?)   ; the game table
ENDIF   ; FINAL=0

END
