;     hugi-compo#10 entry
;coded by
;    shr of Molecoola

;based on TAD's example program :)
;6th of January, 2000.
;shr@thot.banki.hu
;372 bytes

.model tiny
.386
.code
org 100h

gridOfsHigh = 3Ch
gridOffset = gridOfsHigh*100h

;color 7, (95,35)-(+129,+129).
;
   drawBorder macro
;
    mov di,320*35+95
    mov al,7

    mov cl,129      ;ch=0
    rep stosb

    mov cl,129
vertLines:
    stosb
    add di,320-129-1
    stosb
    sub di,-128     ;shorter than 'add di,128'
    loop vertLines

    std
    mov cl,129
    rep stosb
    cld
endm

;
   wr_ax_dec macro
;
    lea di,pastNum
    mov cl,10       ;ch=0
makeStr:
    xor dx,dx
    div cx
    dec di
    add [di],dl
    or ax,ax
    jnz makeStr
endm

;
   drawGrid macro        ;dh=2
;
    mov bl,15       ;bh=0
    mov di,97+3*32+(37+3*32)*320 +7*320+6+32 -10
dg_LOOP:
    sub di,7*320+6+32-10

    mov al,[bx+gridOffset]

;check4win
    cmp al,bl
    jz checkReady
    mov dh,128      ;NOT winning situation
checkReady:

;draw 30x30 box
    mov cl,30       ;ch=0
dg_BOX:
    push cx
    mov cl,30
    rep stosb
    add di,320-30
    pop cx
    loop dg_BOX

;draw the LED digits
    sub di,320*(30-7)-16

    aam             ;ah=[al/10], al=al MOD 10

drawNum:
    push bx
    mov bl,al
    drawLed         ;->al=0
    pop bx
    xchg al,ah

    sub di,10
    xor dh,1
    jp drawNum

    test bl,3
    jnz diOK
;previous row
    add di,32*4-32*320
diOK:
    dec bx
    jns dg_LOOP
endm
;->ax=cx=0
;dh=2 if winning position is reached
;dh=128 if not

;
   drawLed macro
;
    mov dl,ledDigits[bx]

    mov al,0        ;color

    mov bl,2*6      ;bh=0
dlLoop:
    shl dl,1
    jnc dlNext

;draw a LED section
    push di
    add di,ledAddr[bx]
    mov cl,6
dlDraw:
    stosb
    cmp bl,2*2
    jbe diReady
    add di,319
diReady:
    loop dlDraw
;length of segment = 7 ?
    cmp bl,2*4
    jbe sectionReady
    stosb
sectionReady:
    pop     di
dlNext:
    sub bl,2
    jns dlLoop
endm

;
  hugi10entry:
;
;assumed: BL=CH=0, DX>15, DF=0 at start

    mov ax,13h
    int 10h

    push 0a000h
    pop es

gengrid:     ;0fh<=ax<8000h
    mov bh,gridOfsHigh  ;bl=0
gg:
    mov di,ax
    imul di,5
    and di,15
    mov byte ptr [di+bx],al
    dec ax
    jns gg

    mov bp,bx       ;offset grid + holepos

    drawBorder

;cx=0
    lea dx,fileName
    xchg ax,bx      ;->ah=3Ch
    int 21h
    xchg ax,bx      ;bx=handle

    xor si,si       ;si=movescounter

mainLoop:
    push bx
    drawGrid        ;->ax=cx=0
    pop bx

    or dh,dh        ;SF=0 if winning position is reached, SF=1 if not
    mov dx,offset strWin
    jns Quit

;keypress
    int 16h
    push ax
    inc cx          ;->cx=1
    mov dx,sp
    mov ah,40h      ;bx=handle
    int 21h
    pop ax

    mov ah,0

    push bx

    mov dx,bp

;cl=1
    mov bl,4        ;bh=0
    cmp al,'8'
    jz vert

    mov bl,1
    cmp al,'4'
    jz checkMoveDir

    neg bx          ;-1
    mov cl,-1
    cmp al,'6'
    jz checkMoveDir

    mov bl,-4       ;->bx=-4
    cmp al,'2'
    jnz moveReady

vert:
    shr dl,2
checkMoveDir:
    and dl,3
    add dl,cl
    cmp dl,3
    ja moveReady

    mov di,bp
    xchg [bx+di],ah ;ah=0
    mov [di],ah
    add bp,bx

    inc si

moveReady:
    pop bx

    cmp al,20h
    mov dx,offset strQuit
    jnz mainLoop


quit:
;switch back into textmode
    mov al,3h       ;ah=0
    int 10h

;close file 'keys'
    mov ah,3eh      ;bx=handle
    int 21h

;print win or quit string
    mov ah,9
    int 21h

;print ' after '
    mov dl,offset strAfter-200h
    int 21h         ;ah=9

;print movescounter value (decimal)
    xchg ax,si

    wr_ax_dec

    mov dx,di
    xchg ax,si      ;->ah=9
    int 21h

    ret


                       ;6543210
ledDigits       db      11111010b        ;'0'
                db      10100000b        ;'1'
                db      01101110b        ;'2'
                db      10101110b        ;'3'
                db      10110100b        ;'4'
                db      10011110b        ;'5'
                db      11011110b        ;'6'
                db      10110010b        ;'7'
                db      11111110b        ;'8'
                db      10111110b        ;'9'

                                         ;length
ledAddr         dw      1+(0*320)        ;  6     ;horizontal lines
                dw      1+(7*320)        ;  6
                dw      1+(15*320)       ;  6

                dw      0+(1*320)        ;  6     ;vertical lines
                dw      7+(1*320)        ;  6
                dw      0+(8*320)        ;  7
                dw      7+(8*320)        ;  7


;strings
strWin          db 'Winning field$'
strQuit         db 'You have quit$'
strAfter        db ' after $'
num             db '00000'
pastNum:
strMoves        db ' moves',0dh,0ah,'$'
fileName        db 'keys',0

end hugi10entry