%pagesize 255, 160
;------------------------------------------------------------------------------
; entry.asm version 1.6
; Copyright (C) 2000 by Guido Hahn, email(ghahn@compuserve.com)
;
; This file was written for the Hugi Size Coding Competition #10: Taquin
; on http://www.hugi.de/compo/
;
; ALIAS:    meph
; Country:  Germany
; Date:     01-16-2000               
; Compiler: TASM 4.1		          
; Linker:   TLINK	7.1.30.1        
;                               
; Compile:  TASM   entry
; Link:     TLINK  /t entry
;
; Size: 364 Bytes
;
;
; THIS SOFTWARE IS PROVIDED BY GUIDO HAHN ``AS IS'' AND WITHOUT
; ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
; IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
; FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
; OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
; LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
; OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
; SUCH DAMAGE.
;
;------------------------------------------------------------------------------

;<snip>
;You may assume that
;  ... the registers have these values (all in hex):
;      (xx - means an unknown value which MUST NOT be assumed)
;
;          EAX = xxxx****
;                AL = 00 if first FCB has valid drive letter,  FF if not
;                AH = 00 if second FCB has valid drive letter, FF if not
;          EBX = xxxx0000
;          ECX = xxxx00FF
;          EDX = xxxxxxxx
;  DX  = CS = DS = ES = SS = xxxx, 0080 <= DX <=9000.
;          ESI = xxxx0100
;          EDI = xxxxFFFE
;          EBP = xxxx09xx
;          ESP = xxxxFFFE
;          EIP = xxxx0100
;
;  EFLAGS (binary) = xxxxxxxx xxxxxxxx xxxx0x1x xx0x0x1x
;      i.e.
;          DF = 0
;          IF = 1
;          other flags = x
;
;          WORD [FFFE] = 0000
;          Layout of PSP: see [Memory Layout]
;<snip>

.586

deb_startup macro     ;;initialize register values				
      xor ax, ax
      xor bx, bx	
      mov cx, 0ffh
      mov dx, cs
      mov es, dx
      mov si, 100h
      mov di, 0fffeh
      cld
endm

MOVES   equ <si-26>
LED     equ <si-18>
HOLE    equ <si-8>
DIGITS  equ <si>
HANDLE  equ <si+6>

VidmemSegment = 0a2b2h
ZeroPosition = 897                      ;offset of hole into es:

_cseg segment para public 'code' use16
assume cs:_cseg, ds:_cseg, es:_cseg, ss:_cseg
_cseg ends

_cseg segment
org 100h										
start:	                      
ifdef DEBUG
    deb_startup
endif
    

    mov al, 13h                         ;set vid mode 13h
    int 10h

    push VidmemSegment
    pop es
    
    xor bp, bp                          ;initialize the  move counter to zero
    mov si, offset DigOffsets

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  DrawBorder
;;
;;  
    mov di, cx
    mov ax, 3c07h                     ;prepare ah for create file
                                      ;al = color 7 
    
    mov cl, 129
db1:
    mov byte ptr es:[di+129],al       ;mov byte ptr es:[di+129],al        
    stosb                                                                      
    add di, 319                       ;add di, 319
    loop db1

    mov cl, 130
db0:
    mov byte ptr es:[di-129*320], al
    stosb
    loop db0

  
;;
;;  cx = 0
;;  ah = 3ch
    mov dx, offset szFileName           ;create File with Attributes cx = 0
    int 21h
    mov word ptr[dwFileHandle], ax                  
    
                  
InitGrid:  
    xchg ax, bx                         ;ax = 0 ,bx=xxxx = filehandle
    cwd                                 ;dx = 0
dt0:
    push ax
    
    xchg ax, dx
    call Get_EdgeOffset
    xchg ax, dx
    call Draw_Single_Tile

    pop ax
    inc dx
    add al, 13                              
    and al, 0fh                         ;modulo 16
    jnz dt0                            



mainloop: 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  verify if puzzle is solved or make ah=0
;;	
    mov dx, offset szSolved
    mov ax, 15
vs0:
    call Get_EdgeOffset
    scasb                               ;test color of upper left tile edge        
    jnz short not_solved
    dec ax
   
    jnz short vs0                       ;need only to compare 15 tiles to be
                                        ;sure that all 16 tiles are at the 
                                        ;proper position -> ah = 0


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  control goes here on exit conditions                                     ;;
;;                                                                           ;;
exit:                                             

    mov ax, 03h                         ;return to text mode   
    int 10h
                         
    mov ah, 09h                         ;print first part of exit message
    int 21h
    mov dx, offset szAfter
    int 21h
   
    mov di, offset szMoves
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  Hex2Ascii 
;;
    xchg ax, bp                         ;ax = MovesCounter, bp = 09xx
    mov bl, 10                          ;bh = 0 
                                        ;(On winning condition bh was cleared
                                        ; through Draw_Single_Tile,
                                        ; On user break bh was cleared through
                                        ; mov bx, 8)

get_next_digit:
    xor dx, dx                          ;dx = 0
    dec di
    div bx                              ;dx = remainder, ax = quotient
    add dl, '0'                         ;convert to ascii                          
    mov byte ptr[di], dl                ;write to buffer
    test ax, ax
    jnz get_next_digit


    mov dx, di
    xchg ax, bp                         ;ax=09xx
    int 21h                             ;print final part of message

    ret                                 ;return to dos

;;
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;
;;  ah = 0
;;  bx = 0
;;  cx = 0, 1
;;
 
not_solved:
    int 16h                             ;get key

    push ax                
    mov bx, word ptr[HANDLE]            ;bx = dwFileHandle
                                        ;write key to file
    mov cl, 1                           ;cx = 1
    mov dx, sp                          ;         "
    mov ah, 40h                         ;         "
    int 21h                             ;         " 
    pop ax

    mov dx, offset szAborted

    mov bx, 8                           ;Can't use mov bl,8 here, because
                                        ;there is no guarantee that a File-
                                        ;handle is < 256.
    cmp al, ' '                         ;if user pressed space bar -> quit 
    jz short exit                       


    sub al, '0'    
keyloop:
    cmp al, bl
    je short Keytest
    dec bx
    dec bx
    jnz keyloop
        
    
    jmp mainloop                        ;invalid key -> ignore


 
Keytest:
    mov bx, word ptr[bx + MOVES-2]      ;mov bx, [bx+MovesOffs-2]
    mov di, word ptr[HOLE]              ;di = offset hole position    
    add bx, di            
    mov al, byte ptr es:[bx]            ;al = color of desired destination
    test al, al
    jz short mainloop                   ;if al == 0 it's a bad move

    mov word ptr[HOLE], bx              ;save new hole position
    push bx
    call Draw_Single_Tile               ;swap hole with tile to move
    xchg ax, bx                         ;mov al, 0   "
    pop di                              ;            "
    call Draw_Single_Tile               ;            "
    inc bp                              ;update moves counter

    jmp mainloop                    



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  Get_EdgeOffset:
;;
;;  get offset of upper left tile edge
;;
;;  In  al = GridIndex {0,1,2,...,15}
;;  Out di = Offset of upper left edge
;;
;;  assumes: ch = 0
;;  
;;
;;Gridoffsets - ZeroPosition =      row0   row1   row2   row3 
;;                          line0   0x0000 0x0020 0x0040 0x0060
;;                          line1   0x2800 0x2820 0x2840 0x2860
;;                          line2   0x5000 0x5020 0x5040 0x5060
;;                          line3   0x7800 0x7820 0x7840 0x7860


Get_EdgeOffset:
    push ax
    aam 4                               ;ah=line , al=row
    shl al, 5                           ;al = al*32
    xchg al, ch                         ;al = 0
    imul ax, 40                         ;ah = ah * 40
    xchg al, ch                         ;ax = hi(40*line),lo(32*row), ch=0
    add ax, ZeroPosition
    xchg ax, di                         ;di = offset of upper left edge
    pop ax
    ret


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  Draw_Single_Tile
;;  
;;  In al = color
;;     di = offset
;;
;;  assumes ch = 0
  
Draw_Single_Tile: 
    mov bx, 30   
dt1:
    
    mov cl, 30
    rep stosb
    add di, 320 - 30
    dec bx
    jnz dt1

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  Draw the LED digits
;;  assumes si = offset DigOffsets
DrawDigits:
    sub di, 320*23 - 7                  ;offset to 10's
    aam 10                              ;ah = 10's, al = 1's
    call DrawOneDigit
    xchg al, ah

    add di, 10                          ;offset to 1's


DrawOneDigit:
    pusha                               ;we are under great register pressure,
                                        ;so keep them consistent
   
    mov bl, ah
    mov ah, byte ptr[bx + LED]          ;get appropiate digit flags
    
    mov bl, 6                           ;first draw 3 horizontal segments
                                        ;I have to start with 6, because
                                        ;I use bx for indexing too.
GetColor:                   
    mov cl, 6                           ;initialize loop counter to 6                              
    xor dx, dx
    inc dx                              ;set dx to offset that must be added
                                        ;each iteration

    shl ah, 1                           ;draw with color 0 if not carry, else 
                                        ;draw with background color
    jz short dod_ret                    ;if zf all segments are drawn
    sbb al, al                          ;if carry al = 0ffh, else al = 0
                                                                                                                                 
    dec bx
    dec bx
    jns short keep_horz
    cmp bl, 0fch                        ;now bl  = {0feh, 0fch, 0fah, 0f8h}
                                        ;0feh and 0fch need a counter of 6
                                        ;0fah and 0f8h need a counter of 7

    adc cl, ch                          ;inc cl if carry
    mov dx, 320                         ;dx = 320 (vertical)

keep_horz:
dod0:
    and byte ptr es:[di], al            ;mask pixel 
    add di, dx
    loop dod0
    
ifdef DEBUG
    push si
    mov si,[bx+DIGITS]
    add di, si
    pop si
else
    add di,[bx+DIGITS]                  ;add offset to next digit segment
endif
    
    jmp GetColor

dod_ret:
    popa
    ret


szFileName      db 'keys', 0                                      ;

szSolved        db 'Winning field$'
szAfter         db ' after $'                                     ;
szAborted       db 'You have quit$'                               ;
szMoves         db ' moves',0dh,0ah,'$'                           ;

MovesOffs       dw -(32*320), 32, -32, (32*320)                   ;si-26

;;  7x 1-bit flags for the LED char sections ;;
;;  changed from example.asm 
;;  to:
;;       777777         
;;      4      3            
;;      4      3
;;       666666                       
;;      2      1                
;;      2      1
;;      2      1
;;       555555
;;                      76543210        0=segment to draw, 1=segment to ignore

LedDigits       db      01000001b       ;[0]    '0' char          ;si-18
                db      11110101b       ;[1]    '1' char
                db      00010011b       ;[2]    '2' char
                db      00010101b       ;[3]    '3' char
                db      10100101b       ;[4]    '4' char
                db      00001101b       ;[5]    '5' char
                db      00001001b       ;[6]    '6' char
                db      01100101b       ;[7]    '7' char
                db      00000001b       ;[8]    '8' char
                db      00000101b       ;[9]    '9' char

dwZeroPos       dw  ZeroPosition                      ;si-8

                dw  -(7*320-7)                        ;            bx=-6
                dw  320-7                             ;            bx=-4
                dw  -(6*320-7)                        ;            bx=-2
DigOffsets      dw  -(14*320+7)                       ;<- si       bx=0   
                dw  8*320-6                           ;            bx=2              
                dw  7*320-6                           ;            bx=4                                                
                                         
                                                                                                                                            
dwFileHandle    dw ?                                  ;si+6



_cseg ends

end start


