;Entry in Hugi Size Coding Competition #10
;Copyright 2000 GreenGhost

;2000.01.17 : 412 bytes
;2000.01.17 : 399 bytes : optimizing
;2000.01.18 : 398 bytes : optimizing
;2000.01.20 : 396 bytes : DrawRect added
;2000.01.23 : 387 bytes : segment change in redraw
;2000.01.23 : 386 bytes : key table
;2000.01.23 : 376 bytes : reordered DrawChar
;2000.01.26 : 375 bytes : keep ah=0 in kbd loop
;2000.01.27 : 374 bytes : use cbw to clear same flag
;2000.01.27 : 373 bytes : handle in bx, empty in bp
;2000.01.27 : 371 bytes : pusha in draw loop
;2000.01.27 : 369 bytes : mask key code with move bit
;2000.01.27 : 367 bytes : use bh in grid exchange
;2000.01.28 : 366 bytes : clear ah in kbd loop

%define BorderPos 35*320+95
%define GridPos 37*320+97

section .text
org 100h

Main:                           ;                              [28]
  mov di,Grid                   ;                       3
  .NextGrid:                    ;
    stosb                       ;                       1
    sub al,3                    ;                       2
    and al,15                   ;                       2
  jnz .NextGrid                 ;                       2
  xchg cx,ax                    ;fileattr=0             1
  mov al,13h                    ;graphics mode          2
  int 10h                       ;                       2
  mov dx,FileName               ;                       3
  mov ah,3Ch                    ;create file            2
  int 21h                       ;                       2
  xchg bx,ax                    ;handle in bx           1
  xchg bp,ax                    ;clear empty            1
; mov ax,0100h                  ;set counter and flag
  .Draw:                        ;                               [23]
    mov dx,0A2C1h               ;                       3
    mov es,dx                   ;                       2
    mov di,15                   ;position               3
    mov ax,130*256+7            ;color and size         3
    call DrawRect               ;draw border            3
    mov di,320+16               ;position               3
    mov ax,128*256+0            ;color and size         3
    call DrawRect               ;erase inside border    3
    mov si,Grid                 ;                       3       [63]
    .NextPiece:                 ;
      pusha                     ;save ax, bx and dx     1
      mov es,dx                 ;set segment            2
      mov di,2*320+17           ;position of square     3
      mov al,[si]               ;color                  2
      mov ah,30                 ;size                   2
      call DrawRect             ;draw square            3
      mov di,9*320+23           ;position of digit      3
      aam 10                    ;                       2
      push ax                   ;                       1
      mov al,ah                 ;get tens digit         2
      call DrawChar             ;                       3
      mov di,9*320+33           ;                       3
      pop ax                    ;get ones digit         1
      call DrawChar             ;                       3
      popa                      ;restore ax, bx and dx  1
      cmp al,[si]               ;                       2
      je .Same                  ;                       2
        cbw                     ;set flag               1
      .Same:                    ;
      inc si                    ;next grid item         1
      inc dx                    ;move segment           1
      inc dx                    ;                       1
      inc ax                    ;counter++              1
      test al,3                 ;                       2
      jnz .NoLine               ;                       2
        add dx,640-8            ;next line              4
      .NoLine:                  ;
      cmp al,16                 ;                       2
    jne .NextPiece              ;                       2
    mov dx,WinMsg               ;select win message     3
    or ah,ah                    ;test if correct        2
    jnz .Msg                    ;                       2
  .Next:                        ;                               [22]
;   mov ah,0                    ;cmd=readkey
    int 16h                     ;get key                2
    mov si,Buf                  ;                       3
    mov dx,si                   ;                       2
    mov [si],al                 ;store char             2
    mov ah,40h                  ;cmd=fwrite             2
    mov cl,1                    ;len=1                  2
    int 21h                     ;write char             2
    lodsb                       ;get key                1
    cmp al,32                   ;test if space          2
    je .Quit                    ;                       2
    lea di,[si+bp]              ;point to empty         2
    push si                     ;                       1       [40]
    mov cl,4                    ;set counter            2
    mov si,KeyTable             ;                       3
    xchg dx,ax                  ;key in dl              1
    .NextKey:                   ;
      lodsw                     ;get moves mask         1
      push cx                   ;                       1
      mov cx,bp                 ;copy empty             2
      inc cx                    ;                       1
      shl ax,cl                 ;get move bit           2
      pop cx                    ;                       1
      salc                      ;make mask              1
      and al,[si]               ;and with key code      2
      inc si                    ;                       1
      cbw                       ;clear ah               1
      cmp al,dl                 ;compare to key         2
      lodsb                     ;get offset             1
    loopne .NextKey             ;                       2
    pop si                      ;                       1
  jne .Next                     ;                       2
    cbw                         ;                       1
    add bp,ax                   ;move empty             2
    xchg [si+bp],bh             ;store empty            2
    xchg [di],bh                ;store piece            2
    inc word [Moves]            ;                       4
  jmp .Draw                     ;                       3

  .Quit:                        ;                               [29]
    mov dx,QuitMsg              ;select quit message    3
  .Msg:                         ;
    mov ax,3                    ;set text mode 3        3
    int 10h                     ;                       2
    call .Write                 ;                       3
    mov dl,AfterMsg             ;select "after"         2
    int 21h                     ;write                  2
    mov ax,[Moves]              ;get moves              3
    call WriteInt               ;write moves            3
    mov dx,MovesMsg             ;select "moves"         3
.Write:
    mov ah,9                    ;cmd=writestr           2
    int 21h                     ;write                  2
    ret                         ;quit/return            1

; Draws a filled square with size ah, color al, at es:di

DrawRect:       ;al=color, ah=size, di=pos                      [15]
  mov cl,ah                     ;                       2
  .NextLine:                    ;
    pusha                       ;save cx and di         1
    mov cl,ah                   ;                       2
    rep stosb                   ;                       2
    popa                        ;restore cx and di      1
    add di,320                  ;                       4
  loop .NextLine                ;                       2
  ret                           ;                       1

; Writes ax in decimal

WriteInt:                       ;                              [20]
  xor dx,dx                     ;clear hight word       2
  mov cl,10                     ;                       2
  div cx                        ;get digit in dl        2
  push dx                       ;save digit             1
  or ax,ax                      ;test if more           2
  jz .NoMore                    ;                       2
    call WriteInt               ;write the rest         3
  .NoMore:                      ;
  pop ax                        ;restore digit          1
  add al,'0'                    ;make character         2
  int 29h                       ;write                  2
  ret                           ;                       1

; Draws the digit in al at es:di

DrawChar:       ;al=digit       ;                               [17]
  mov bx,LedTable               ;                       3
  xlatb                         ;get bitmask            1
  xchg dx,ax                    ;                       1
  xor ax,ax                     ;                       2
  call HLine                    ;draw top segment       3
  call VLines                   ;draw 2,3,4,5           3
  add di,7-15*320               ;move to segment 6      4
VLines:                         ;                               [7]
  mov cl,6                      ;                       2
  call VLine                    ;                       3
  mov cl,7                      ;                       2
VLine:                          ;                               [16]
  mov bx,320                    ;                       3
  add di,bx                     ;                       2
  shr dl,1                      ;get mask bit           2
  .Next:                        ;
    jnc .NoDraw                 ;                       2
      mov [es:di],al            ;draw pixel             3
    .NoDraw:                    ;
    lea di,[di+bx]              ;next line              2
  loop .Next                    ;                       2
HLine:                          ;                               [11]
  shr dl,1                      ;                       2
  jnc .NoLine                   ;                       2
    push di                     ;save position          1
    inc di                      ;one pixel right        1
    stosw                       ;draw                   1
    stosw                       ;                       1
    stosw                       ;                       1
    pop di                      ;restore position       1
  .NoLine:                      ;
  ret                           ;                       1

KeyTable:                       ;                               [16]
 dw 0000111111111111b           ;valid moves mask
 db '2'                         ;key
 db -4                          ;move offset
 dw 0111011101110111b
 db '6'
 db -1
 dw 1110111011101110b
 db '4'
 db 1
 dw 1111111111110000b
 db '8'
 db 4

LedTable:                               ;       [10]
;   87654321 <-segment bits
 db 10111011b   ;0       --1--
 db 10100000b   ;1      |     |
 db 00111101b   ;2      2     6
 db 10110101b   ;3      |     |
 db 10100110b   ;4       --3-- --7--    (segments 7 and 9 are never drawn)
 db 10010111b   ;5      |     |
 db 10011111b   ;6      4     8
 db 10100011b   ;7      |     |
 db 10111111b   ;8       --5-- --9--
 db 10110111b   ;9

FileName:       db "keys"               ;4      [50]
Moves:          dw 0                    ;2
WinMsg:	        db "Winning field$"     ;14
QuitMsg:        db "You have quit$"     ;14
AfterMsg:       db " after $"           ;8
MovesMsg:       db " moves",13,10,"$"   ;9

section .bss

Handle: resw 1
Buf:    resb 1
Grid:   resb 16

