        Ideal

        P586

        Model Tiny



o       equ <offset>

l       equ <low>

h       equ <high>

s       equ <short>

b       equ <byte>

w       equ <word>



macro   salc

        db 0d6h

        endm



        ideal



LedOffset       = -30*320 + 6 + 7*320 + 1

MatrixEndOffset = 024Fh



A000Offset      = 02C1Fh - MatrixEndOffset



        CodeSeg



        Org 100h





start:

        ;

        ; Initialize grid & variables

        ;



        mov     di, o matrix

        push    di



@@init: stosb

        add     al, 00Dh

        and     al, 00Fh

        jnz     s @@init



        stosw                   ; Linear hole offset to zero



        ;

        ; Initialize 320x200x256 mode

        ;



        mov     al, 013h

        int     10h



        push    0A000h + A000Offset / 16

        pop     es



        ;

        ; Close STDAUX

        ; (so when opening file it has handle

        ; of STDAUX)

        ;



        mov     ah, 03Eh

        mov     bl, 003h

        int     21h



        ;

        ; Draw borders

        ;



        mov     ax, 03C07h



        ; DI = 0025Fh, ES adjusted so that

        ; ES:DI points to coords (95, 35)



        mov     bl, 1

        mov     dx, 320

@@side: mov     cl, 129

@@pix:  stosb

        dec     di

        add     di, bx

        loop    @@pix 

        neg     bx

        xchg    bx, dx

        dec     bp                      ; Clear moves counter

        jnz     @@side                  ; and do loop >4 times





        ;

        ; Open keys file

        ;



        mov     dx, o filename

        int     21h                     ; Open "keys"



        cwd                             ; Logical hole offset to zero (dh)

        pop     si                      ; si = o matrix



        ;

        ; Draw the bricks

        ;



mainloop:



        mov     dl, l o msgWin

        mov     bx, 15

        mov     di, 0A701h - A000Offset



@@brick:



        mov     al, [b si+bx]

        cbw



        cmp     al, bl                  ; check for winning state.

        adc     cl, ch                  ; carry is set at least for *one*

                                        ; tile if it is not in winning state.



        pusha



        mov     bp, 320



        ;

        ; Draw a solid brick

        ;



;;        mov     dx, -29

        mov     dh, -1

@@box:  mov     cl, 30

        rep     stosb

        lea     di, [di+bp-30]          ; DI+=290

        inc     dx                      ; Loop 30 times and

        jng     s @@box                 ; after loop DX=1



        ;

        ; Draw the leds for each brick

        ;



        aaa                             ; Convert hex to decimal (ax < 0x10)



@@led:

        xchg    al, ah

        mov     bl, al



@@segment:

        rol     [b si+bx+o LedDigits-o matrix], 1

        salc



        ror     [b si+o h05+2-o matrix], 1

        adc     cl, 6+1



        db      03ch

@@line: and     [es:di+((7*320) + LedOffset-1)+7], al

        add     di, bp

        loop    @@line



        neg     dx

        xchg    dx, bp



        or      dh, dh

        jnz     @@segment               ; loop for drawing rectancle

        neg     bp

        js      @@segment               ; loop for drawing two rectangles



        add     di, 10-2



        scasw                           ; ax negative?

        jns     @@led                   ; if not then draw second led



        popa



        sub     di, 32



;;        test    bl, 000000011b

        test    bl, dl

        jnz     s @@row

        sub     di, 320*32-4*32

@@row:



        dec     bx

        jns     s @@brick               ; loop for each brick



        jcxz    s quit                  ; was it a winning state?



        ; (DI=0DD41h)



        ;

        ; Read key (ah = 0, from the "cbw" before "pusha")

        ;



        int     16h



        ;

        ; Replicate to file (write to STDAUX)

        ;



        mov     ah, 004h

        mov     dl, al

        int     21h



        ;

        ; Check for quit key

        ; 



        cmp     al, 020h

        jne     s continue      ; [SPACE] ?





        mov     dl, l o msgEsc  ; DL = already 020h



quit:

        ;

        ; 80x25 text mode

        ; 



        mov     ax, 00003h

        int     10h



        ;

        ; Print termination message

        ; 



        mov     dh, 1

        call    Print



        mov     dl, l o msgAfter

        int     21h



        ;

        ; Print number of moves

        ; and end of the message

        ;



        xchg    ax, bp

        mov     cl, 10



@@asc:  xor     dx, dx

        div     cx

        or      dl, 030h

        dec     si

        mov     [b si+o msgMoves-o matrix], dl



        or      ax, ax

        jnz     s @@asc



        lea     dx, [si+o msgMoves-o matrix]

Print:  mov     ah, 9

        int     21h



        ret







; Bit  Meaning

; ---  -------

;  7   bottom-right

;  6   bottom

;  5   bottom-left

;  4   middle

;  3   upper-right

;  2   upper

;  1   upper-left

;  0   multipurpose-bit



label LedDigits

                db 00010001b

                db 01110111b

                db 10000011b

                db 00100011b

                db 01100101b

                db 00101001b

                db 00001001b

                db 01110001b

                db 00000001b

                db 00100000b



        Org $-1



msgAfter        db ' after $'                   ;  8 bytes

msgMoves        db ' moves',0dh,0ah,'$'         ;  9 bytes

msgWin          db 'Winning field$'             ; 14 bytes

msgEsc          db 'You have quit$'             ; 14 bytes





continue:



        ;

        ; Check for move key

        ;



        sub     al, 032h                ; ['2','4','6','8'] -> [0,2,4,6]

        lahf



        test    al, 11111001b           ; Check for invalid

        jnz     s badkey                ; key press



h05:    and     ax, 0502h               ;

        mov     cl, ah                  ; Calculate adder for logical

        dec     ax                      ; offset.

        shl     al, cl                  ;



        ;

        ; Check for valid move

        ; 



        add     al, dh

        test    al, 11001100b           ; Check for invalid move

        jnz     s badkey



        mov     dh, al                  ; Update logical coordinates



        ;

        ; Apply move

        ;



        aam     16

        aad     4                       ; Calculate linear offset



        xchg    ax, bx

        xchg    ch, [b si+bx]           ; Replace hole

        xchg    bl, [b si+16]           ; Get old offset & store new

        xchg    ch, [b si+bx]           ; Replace brick



filename:

        dec     bx                      ; 'K'

        inc     bp                      ; 'E' and Update moves counter

badkey: pop     cx                      ; 'Y' and Clear CX

        jnc     $+2                     ; 's\0'

        push    cx                      ; Restore SP to 0FFFEh



        jmp     mainloop





        Org (MatrixEndOffset-18)



label matrix





        End start

