;   ͸
;Ķ  Chris Dragan's entry for the Hugi Size Coding Competition #10  Ŀ    
;  ͼ     
;        
;    ͻ	  http://ams.ampr.org/cdragan/		     
;  Ķ Assumes at startup: Ŀ     
;  ͵     
;   AX  0000  SP  FFFE  [SP] 0000  [DS:0] 20CD (int 20h)	            
;Ĵ CX  00FF  BP  09??  IP	 0100 Ĵ     
;   DX  PSP_  SI  0100 Ĵ [DS:2] A000 (Win'95)	            
;   BX  0000  DI  FFFE 	      Ŀ 9FFF (DOS+HIMEM/WinNT)       
;  Ŀ  9FC0 (raw DOS)	            
;   CS = DS = ES = SS = DX = PSP segment       
;  				     
;  ڿ	    ķ	     
;ĴĴ You can build the program using Netwide Assembler: 	     
;   	    ͸ nasm -o entry.com entry.asm ͼ	     
;   		       ͼ		;	     
;								;	     
;		    ͻ	;	     
;		     Special thanks to TAD and Fabled 	;	     
;		    ͼ	;	     
								;	     
%define BORDER_COLOR 7						;	     
%define SCREEN_OFFS 0	; Win'95=0, DOS+HIMEM=16, raw DOS=1024	;	     
%define MakeXY(x,y) (((y)*320)+(x))				;	     
%define MakeWord(hi,lo) (((hi)<<8)+(lo))			;	     
								;	     
;		ķ					;	     
;Ĵ Startup Ĵ
org 100h       ;ͼ					;	     
								;	     
		; Fill the grid 				;	     
			mov	di, Grid			;	     
_fill_grid:		  stosb 				;	     
			  add	  al, 13			;	     
			  and	  al, 0Fh			;	     
			  loop	  _fill_grid			;	     
								;	     
		; Make es point video segment			;	     
			les	dx, [bx]			;	     
								;	     
		; Switch to video mode 13h (320x200x8bpp)	;	     
			mov	al, 13h 			;	     
			int	10h				;	     
								;	     
		; Create file KEYS				;	     
			mov	ah, 3Ch 			;	     
			mov	dx, Keys			;	     
			int	21h		; returns 1st free handle = 5
								;	     
;		ķ					;	     
;Ĵ Drawing Ĵ
;		ͼ					;	     
								;	     
		; Draw border					;	     
			mov	di, MakeXY(95,35) + SCREEN_OFFS ;	     
			mov	ah, BORDER_COLOR		;	     
			mov	bl, 129 			;	     
			mov	dl, 0F0h			;	     
			call	DrawRect			;	     
			; bp=0 returned 			;	     
			xor	bx, bx		; hole position = 0	     
								;	     
		; Prepare to drawing tiles			;	     
_main_loop:		mov	si, Grid			;	     
			push	si				;	     
			mov	di, MakeXY(97+4*32,37-32) + SCREEN_OFFS ;    
			cbw			; clear move/carry counter   
								;	     
		; Move pointer to next row			;	     
_next_tile:		test	ah, 30h 			;	     
			jnz	_no_next_row			;	     
			add	di, MakeXY(-4*32,32)		;	     
_no_next_row:							;	     
		; Draw tile background				;	     
			lodsb					;	     
			pusha					;	     
			mov	bl, 30				;	     
.loop:			  mov	  cl, 30			;	     
		      rep stosb 				;	     
			  add	  di, MakeXY(-30,1)		;	     
			  dec	  bx				;	     
			  jnz	  .loop 			;	     
			add	di, MakeXY(0,-30) + MakeXY(16,14) ;	     
								;	     
		; Extract decimal digits			;	     
			mov	dh, al				;	     
			aam					;	     
								;	     
		; Draw digits					;	     
_next_digit:		pusha					;	     
			mov	bx, LEDCodes			;	     
			xlatb					;	     
			xchg	ax, dx				;	     
			mov	bx, MakeWord(01010000b,7)	;	     
			call	DrawRect			;	     
			neg	si				;	     
			call	DrawRect.nosi			;	     
			popa					;	     
			add	di, byte MakeXY(-10,0)		;	     
			mov	al, ah				;	     
			dec	bx				;	     
			jp	_next_digit			;	     
								;	     
		; Next tile					;	     
			popa					;	     
			add	di, byte MakeXY(32,0)		;	     
			inc	ax				;	     
			cmp	al, [si]			;	     
			adc	ah, 16				;	     
			jnc	_next_tile			;	     
								;	     
		; Check ending condition			;	     
			pop	si				;	     
			mov	dx, WinMessage			;	     
			jnz	_get_key			;	     
								;	     
;		ķ					;	     
;Ĵ Quit Ĵ
;		ͼ					;	     
								;	     
		; Switch to mode 3				;	     
_quit:			mov	ax, 0003h			;	     
			int	10h				;	     
								;	     
		; Display beginning of message			;	     
			mov	ah, 09h 			;	     
			int	21h				;	     
			mov	dl, After-200h			;	     
			int	21h				;	     
								;	     
		; Convert moves counter to decimal		;	     
			xchg	ax, bp				;	     
			mov	cl, 10				;	     
			mov	bx, MessageEnd			;	     
.loop:			  xor	  dx, dx			;	     
			  div	  cx				;	     
			  add	  dl, '0'			;	     
			  dec	  bx				;	     
			  mov	  [bx], dl			;	     
			  or	  ax, ax			;	     
			  jnz	  .loop 			;	     
			mov	dx, bx				;	     
			mov	ah, 09h 			;	     
			int	21h				;	     
								;	     
		; Quit						;	     
			ret					;	     
								;	     
;		ķ				;	     
;Ĵ Input handling Ĵ
;		ͼ				;	     
								;	     
		; Get key					;	     
_get_key:		mov	ah, 00h 			;	     
			int	16h				;	     
								;	     
		; Write key to KEYS				;	     
			pusha					;	     
			mov	dx, -4				;	     
			mov	bl, 5				;	     
			mov	cl, 1				;	     
			mov	ah, 40h 			;	     
			int	21h				;	     
			popa					;	     
								;	     
		; Quit if Space 				;	     
			mov	dl, QuitMessage-200h		;	     
			cmp	al, ' ' 			;	     
			je	_quit				;	     
								;	     
		; Validate key					;	     
			ror	al, 1				;	     
			sub	al, ('2'>>1) + 4		;	     
			add	al, 4		; al =	0  1  2  3	     
			jnc	_get_key			;	     
								;	     
;		ķ				;	     
;Ĵ Tile movement Ĵ
;		ͼ				;	     
								;	     
		; Validate move 				;	     
			push	bx				;	     
			mov	bx, KeyCode			;	     
			xlatb			; al = F0 01 FF 10	     
			pop	bx				;	     
			add	al, cl				;	     
			test	al, 11001100b			;	     
			jnz	_get_key			;	     
								;	     
		; Do move					;	     
			mov	cl, al				;	     
			aam	16				;	     
			aad	4				;	     
			xchg	ax, bx				;	     
			xchg	ch, [bx+si]			;	     
			add	si, ax				;	     
			xchg	ch, [si]			;	     
								;	     
		; Increment moves counter			;	     
			inc	bp				;	     
								;	     
		; Go to drawing 				;	     
			jmp	_main_loop			;	     
								;	     
;		ķ			;	     
;Ĵ Rectangle drawing routine Ĵ
;		ͼ			;	     
; ah = color							;	     
; bl = rectWidth-1						;	     
; bh = add count (bits) 					;	     
; cx = 0							;	     
; dl = line switch (bits)					;	     
DrawRect:		mov	si, 320 			;	     
.nosi:			xor	bp, bp				;	     
.next_line:		  rol	  bh, 1 			;	     
			  adc	  cl, bl			;	     
			  rol	  dl, 1 			;	     
			  mov	  al, ah			;	     
.loop:			    stosb				;	     
			    jc	    .color_ok			;	     
			    salc				;	     
.color_ok:		    lea     di, [di+bp] 		;	     
			    loop    .loop			;	     
			  not	  bp				;	     
			  xchg	  si, bp			;	     
			  dec	  bp				;	     
			  jnz	  .next_line			;	     
			ret					;	     
								;	     
;͵
; "LED" digit layout (in bit numbers)					     
;		;  35673214 <- line numbers	;   1 1 1 1 1 1 	     
LEDCodes	db 10001000b ;0 		; 4		2	     
		db 10111011b ;1   0 = line on	; 4		2	     
		db 01000001b ;2   1 = line off	; 4		2	     
		db 00010001b ;3 		; 4		2	     
		db 00110010b ;4 		; 4		2	     
		db 00010100b ;5 		; 4		2	     
		db 00000100b ;6 		;   3 3 3 3 3 3 	     
		db 10111000b ;7 		; 7		5	     
		db 10000000b ;8 		; 7		5	     
		db 00010000b ;9  ͻ	; 7		5	     
;				  Ŀ	 Ŀ 	; 7		5	     
;		       Taquin ->     	; 7		5	     
;				   Ŀ  	; 7		5	     
;				     	; 7		5	     
;				 ͼ	;   6 6 6 6 6 6 	     
;Ĵ
								;	     
KeyCode 	db 0F0h, 01h, 0FFh, 10h 			;	     
								;	     
WinMessage	db 'Winning field$'				;	     
QuitMessage	db 'You have quit$'				;	     
After		db ' after $'					;	     
MessageEnd	db ' moves', 13, 10, '$'			;	     
								;	     
Keys		db 'KEYS'					;	     
		; There will come a 0 here			;	     
Grid:								;	     
;		  ķ				;	     
;Ĵ End of file 
;              ͼ