	page	59,132
;ENTRY.ASM	JAN-30-00
; by Lenny Boreal
; email: loren_blaney@idcomm.com
;
;	      ¿  ڿ		       ڿ      ¿ 
;	      ٳ      ĿĿ Ŀ    ٳ
;	                        
;	                  
;		   HUGI  SIZE  CODING  COMPETITION  #10     
;		      
;
;			   The Taquin Puzzle Game
;		          (aka: Slider or Puzzle15)
;
;	     Taquin is based on a grid of 16 square slots. On
;	     this 4x4 grid are placed 15 movable tiles and 1
;	     empty space (the hole).
;
;	     The player uses the [8] [2] [4] [6] keys to slide
;	     a tile into the hole. The old tile position becomes
;	     the new hole.
;
;	     This process of sliding tiles continues until
;	     either the player presses the [space] key or the
;	     puzzle is solved.
;
;	     Starting Configuration	          Solution
;	        Ŀ		       Ŀ
;	            13 10 07 		           01 02 03 
;	         04 01 14 11 		        04 05 06 07 
;	         08 05 02 15 		        08 09 10 11 
;	         12 09 06 03 		        12 13 14 15 
;	        		       
;
;Assemble with:
; tasm /m entry
; tlink /t entry

	.486
cseg	segment dword public use16 'code'
	assume	cs:cseg, ds:cseg, es:cseg, ss:cseg

	org	100h			;this is a COM file so skip the PSP
start:

;Registers are assumed to be initialized by the loader. If a debugger (such
; as CodeView) is used, the following must be executed:
;debug:
;	mov	ax,00000h
;	mov	bx,00000h
;	mov	cx,000ffh
;	mov	dx,ds
;	mov	si,00100h
;	mov	di,0fffeh
;	mov	bp,00955h		;varies: 09??
;end debug
;The values in the high 16 bits (the extended half) vary. Also the values in
; fs and gs vary. The direction flag (d) is assumed to be clear (incrementing).

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;Initialize grid with starting configuration

	xchg	ax,cx			;ah=0, cx=0
	mov	al,13h			;call BIOS to set graphic mode 13h
	int	10h			; 320x200 with 256 colors

;Create 'keys' output file (cx = 0 = no file attributes)
	mov	dx,offset fileName
	mov	ah,3ch			;call DOS to create output file
	int	21h			;al <- handle
;Redirect output to the auxiliary device to go to the 'keys' file instead
;assume bh = 0
	mov	bl,18h			;point to file handle table in PSP
	xlat				;al = index into system file table
	mov	[bx+3],al		;redirect auxiliary device 'handle' (3)

	xchg	ax,cx			;ax=0
	mov	di,si			;initialize grid for starting config
puz05:	stosb				;	db	 0, 13, 10, 07   es=ds
	sub	al,3			;	db	04, 01, 14, 11
	and	al,0Fh			;	db	08, 05, 02, 15
	jne	puz05			;	db	12, 09, 06, 03

	xchg	ax,bp			;initialize move counter (bp=0)

;Draw border
	push	0a000h			;point to video ram
	pop	es
	mov	ax,0B007h		;al = color (gray); ah = shift pattern
puz07:	mov	di,95+(35*320)		;upper-left corner coords (95,35)
puz09:	mov	cl,130-1		;length of side
	shl	ah,1			;set status flags
	call	line			;(status is unaffected)
	jnc	puz07			;jump after drawing second side
	jne	puz09			;loop for 4 sides
	stosb				;plug the last pixel

;  ax = 0007h
;  bx = 0018h
;  cx = hole position = 0
;  dx = 02xxh
;  si = grid pointer (0100h)
;  di = lower right corner of border +1 = CDE1h
;  bp = move counter = 0

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;Draw puzzle
mainLoop:
	pusha				;save regs: ah=0, bh=0, cx, dh=02, bp

	mov	di,193+(133*320)	;coordinate for slot 15
	mov	bl,15		 	;loop for grid slots 15 down thru 0...

;Draw the 30x30 pixel tile
puz20:	mov	al,[si+bx]		;get the tile value (= color)
	cmp	al,bl			;set bits for tiles not in winning
	rcr	bp,1			; positions (bp need not be initialized)

	mov	dx,30			;draw tile 30 lines high
puz25:	mov	cl,30			; and 30 pixels wide
	rep	stosb			;es:[di++] <- al (color)
	add	di,320-30		;move down to start of next line
	dec	dx
	jne	puz25

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;Draw two LED digits
;assume dx = 0; used to loop for two LED digits

	aam	10			;ah <- al/10; al <- remainder
led00:	pusha				;save registers ah, bx, dx, si, di

;Draw 7-segment display
;Inputs:
; al = digit
; cx = 0
; di = plotting coordinate

;seg <- tbl(digit)
	mov	bx,offset segs
	xlat
	xchg	ax,bx
	mov	bh,01100000b		;bl = segs; bh = 7/6 length

	lea	si,[di+10+6+(7*320)-(30*320)]	;upper-left corner of LED box

;for 2 boxes (top & bottom of 7-segment display)...
	cwd				;dx <- 0
led10:	mov	ah,0B0h			;ah = shift pattern
led20:	mov	di,si			;get coordinate of upper-left corner

;Plot either black (0) or background color (can't skip segs, must move di ptr)
led30:	shr	bl,1			;plot black where seg = 0
	db	0D6h			;salc; al <- if carry=0 then 00 else FFh
	and	al,es:[si]		;get background color

;assume cx = 0
	shr	bh,1			;segments 5 & 6 are one pixel longer
	adc	cl,6+1			;(first pixel is skipped)

	inc	di			;skip first point
	shl	ah,1			;affects status
	call	linex
	jnc	led20
	jne	led30			;next segment

	lea	si,[di-7]		;upper-left corner of bottom box
	dec	dx			;loop for 2 boxes (dx=0000, FFFF, FFFE)
	jp	led10

	popa				;restore registers ah, bx, dx, si, di

	mov	al,ah			;get 10's digit
	sub	di,10			;point to location for 10's digit
	dec	dx			;loop for 2 digits (dx=0000, FFFF, FFFE)
	jp	led00

	sub	di,32-10-10 + (30*320)	;move coordinate left a slot column
	test	bl,03h			;moving up a row?
	jne	led40			;jump if not
	 sub	di,(32*320)-(4*32)	;move up a row and right 4 columns
led40:
	dec	bx			;loop for 16 slots
	jns	puz20

	test	bp,bp			;check for win
	popa				;restore regs: ah=0, bh=0, cx, dh=02, bp

	mov	dl,low offset msgWin	;set up win message
	je	puz90			;go display win message if won

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;Get keystroke (ah=0)
	int	16h			;BIOS function to wait for, then get key
					;al = ASCII character; ah = scan code
	mov	dl,al			;output keystroke character to
	mov	ah,04h			; auxiliary device (which has been
	int	21h			; redirected to 'keys' file)

;assume dh=02
	mov	dl,low offset msgQuit	;set up quit message
	xor	ax,0420h		;is it the [space] key? (also clear ah)
	je	puz90			;jump if so - quit program

;Check for legal direction keys: [2] [4] [6] [8]
; al = keystroke XOR 20h
; ah = 0
; cx = hole position
	ror	al,1			;get LSB (Thanx TAD!)
	sub	al,((38h-20h)/2)+1	;[8]-> -1, [6]-> -2, [2]-> -4
	add	al,4
mov10:	jnc	mainLoop		;jump if illegal key
;al= 0, 1, 2, 3

;Determine new hole position and check for legal moves
	mov	bx,offset movTbl	;get amount to move hole from table
	xlat
	add	al,cl			;add hole position
	push	ax			;save new hole position
	xor	al,cl			;check if legal move
	imul	bx,ax,4			;only X bits or Y bits can change,
	test	al,bl			; not both (clears carry)
	pop	bx			;get new hole position (bh=0)
	jne	mov10			;jump if illegal

	xchg	ah,[bx+si]		;get tile at new hole posn & store hole
	xchg	bx,cx			;get current hole position and update it
	xchg	[bx+si],ah		;store tile (and restore ah=0)

	inc	bp			;count move
	jmp	mov10			;jump to mainLoop (carry is clear)

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;Display exit message
;assume ah=0
puz90:	mov	al,03h			;restore text mode
	int	10h

	call	out30			;print win/quit message at dx

;assume dh = 02
	mov	dl,low offset msgAftr	;display ' after ' message
	int	21h

;(Number output routine stolen from shr -- Thanx shr!)
	mov	di,offset msgMoves	;point to ' moves' message
	xchg	ax,bp			;get move count
	mov	cl,10			;set up divide by 10
out10:	xor	dx,dx			;(use cbw if moves < 32768)
	div	cx
	or	dl,30h			;convert to ASCII
	dec	di			;store into message
	mov	[di],dl
	test	ax,ax			;loop until quotient = 0
	jne	out10
	mov	dx,di			;point to number

out30:	mov	ah,09h			;display message at dx
	int	21h
;	ret				;return to DOS via int 20h in PSP

;-------------------------------------------------------------------------------
;Draw a horizontal or vertical line depending on sign flag
;
line:	stosb				;es:[di++] <- al
linex:	jns	lin10			;jump if horizontal line
	 lea	di,[di+320-1]		;move down, add di,320-1 w/o status
lin10:	loop	line
	ret


;Table to move				 key   tile   hole
movTbl	db	-4			;'2'    dn     up
	db	+1			;'4'    lt     rt
	db	-1			;'6'    rt     lt
	db	+4			;'8'    up     dn


;Table of 1-bit flags for the LED digit segments
;
;	 000000	 <----- each of the 7 LED line sections
;	2      1	 are described using bits 7..0
;	2      1
;	 444444		segment 3 is not used and it is
;	6      5	 a 'don't care' bit
;	6      5
;	6      5
;	 777777
;
;	Bit:	76543210	Digit
segs	db	00010000b	;0
	db	11010101b	;1
	db	00100100b	;2
	db	01000100b	;3
	db	11000001b	;4
	db	01000010b	;5
	db	00000010b	;6
	db	11010000b	;7
	db	00000000b	;8
	db	01000000b	;9


fileName db	'keys',0
msgWin	db	'Winning field$'
msgQuit	db	'You have quit$'
msgAftr	db	' after $'
msgMoves db	' moves', 0Dh, 0Ah, '$'	;WARNING: overwrites preceding locations


cseg	ends				;("start" is required by assembler, else
	end	start			; org 0 is assumed and .com file is 256
					; bytes larger)
