// Plasma coded 1996 by The Real Adok

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>

void back2text(void);
void char13h(unsigned int letter,unsigned char font,unsigned char col,
	     unsigned int zseg,unsigned int zoff);
void delay(int hi,int lo);
void enter13h(void);
char point13h(int x,int y);
void pset13h(int x,int y,int col);
void setpal(char col,char r,char g,char b);

void makeplasma(unsigned int x1,unsigned int y1,
		unsigned int x2,unsigned int y2);
void plasmacol(int xl,int yo,int x,int y,int xr,int yu);
void plasmapal(char j);

void back2text(void)
{
  asm {
    mov ax,3
    int 10h
  }
}

void char13h(unsigned int letter,unsigned char font,unsigned char col,
	     unsigned int zseg,unsigned int zoff)
{
  unsigned char temp,y,i;

  letter=letter*font;
  for(y=0;y<8;y++)
  {
    asm {
      mov bx,word ptr zoff
      add bx,word ptr letter
      add bl,byte ptr y
      mov ax,word ptr zseg
      mov es,ax
      mov al,byte ptr es:[bx]
      mov byte ptr temp,al
    }

    for(i=0;i<=7;i++)
    {
      if(temp==(temp|(1<<(7-i)))) pset13h(i,y,col);
    }
  }
}

void delay(int hi,int lo)
{
  asm {
    mov ax,8600h
    mov cx,word ptr hi
    mov dx,word ptr lo
    int 15h
  }
}

void enter13h(void)
{
  asm {
    mov ax,13h
    int 10h
  }
}

char point13h(int x,int y)
{
  int temp=320*y+x;

  asm {
    mov ax,0a000h
    mov es,ax
    mov bx,word ptr temp
    mov al,byte ptr es:[bx]
    xor ah,ah
  }
}

void pset13h(int x,int y,int col)
{
  int temp=320*y+x;

  asm {
    mov ax,0a000h
    mov es,ax
    mov bx,word ptr temp
    mov ax,word ptr col
    xor ah,ah
    mov es:[bx],al
  }
}

void setpal(char col,char r,char g,char b)
{
  outp(0x3c8,col);
  outp(0x3c9,r);
  outp(0x3c9,g);
  outp(0x3c9,b);
}


void makeplasma(unsigned int x1,unsigned int y1,
		unsigned int x2,unsigned int y2)
{
  int col;
  unsigned int x,y;

  if((x2-x1)>1)
  {
    x=(x1+x2)>>1;
    y=(y1+y2)>>1;
    plasmacol(x1,y1,x,y1,x2,y1);
    plasmacol(x2,y1,x2,y,x2,y2);
    plasmacol(x1,y2,x,y2,x2,y2);
    plasmacol(x1,y1,x1,y,x1,y2);

    col=(point13h(x,y1)+point13h(x2,y)+point13h(x,y2)+point13h(x1,y))>>2;
    pset13h(x,y,col);
    makeplasma(x1,y1,x,y);
    makeplasma(x,y,x2,y2);
    makeplasma(x1,y,x,y2);
    makeplasma(x,y1,x2,y);
  }
}

void plasmacol(int xl,int yo,int x,int y,int xr,int yu)
{
  int col;

  if(point13h(x,y)==0)
  {
    col=xr-xl+yu-yo;
    col=random(col*3)-col;
    col=col+point13h(xl,yo)+point13h(xr,yu)>>1;
    if(col<1) col=1;
    if(col>189) col=189;
    pset13h(x,y,col);
  }
}

void plasmapal(char j)
{
  char i;

  for(i=1;i<=63;i++)
  {
    setpal(i+j,0,i,i);
    setpal(i+63+j,i,0,53-i);
    setpal(i+126+j,43-i,i,i*2);
  }
}

void main(void)
{
  unsigned int i=0;
  unsigned char j=0;
  char direction=1;

  enter13h();

  plasmapal(j++);
  makeplasma(0,0,319,199);

  fflush(stdin);
  for(i=0;i<=1000;i++)
  {
    if(j!=0) plasmapal(j);
    j+=direction;
    if(j==0) direction*=-1;
    delay(0,10000);
  }

  getchar();
  back2text();
}

