{ $G+ }                           { 286 Anweisungen an }
{ PCX-Loader 320x200x256 (c) 1995 by Myrlochar }

Program PCX_LOADER;

Uses
  DOS;

Var
  pcxfilename: pathstr;
  file_error: boolean;
  bytes_per_line: word;
  RGB256: array[1..768] of Byte;
  scratch, abuff0, abuff1: pointer;
  repeatcount: byte;
  datalength: word;
  columncount, plane, video_index: word;

const
  buffsize = 65521;

Procedure init320x200; assembler;
asm
   mov ax,0013h
   int 10h
end;

Procedure DECODE_PCX256 (Page_Addr:Word); assembler;
asm
  mov     es, page_addr       { Video Segment }
  mov     di, video_index
  xor     cx, cx
  mov     cl, repeatcount
  mov     bx, datalength
  push    ds                  { DS sichern }
  lds     si, scratch
  add     bx, si
  cld
  cmp     cl, 0               { war es ein Zhler-Byter }
  jne     @multi_data         { ja, dann folgen Daten }
  @getbyte:                   { letztes Byte war kein Zhler }
  cmp     si, bx
  je      @exit
  lodsb
  cmp     al, 192
  jb      @one_data
  xor     al, 192             { get zhler von den unteren 6 Bits holen }
  mov     cl, al              { sichern in cl }
  cmp     si, bx
  je      @exit
  @multi_data:
  lodsb
  rep     stosb
  jmp     @getbyte
  @one_data:
  stosb
  jmp     @getbyte
  @exit:
  pop     ds                  { und BP's DS wieder herstellen }
  mov     video_index, di
  mov     repeatcount, cl
end;

procedure ZEIG_PCX(pfilename: pathstr;Page_addr:Word);
var
  x, gun, pcxcode: byte;
  pcxfile: file;
  palette_start, total_read: longint;
  palette_flag: byte;
  version: word;

procedure CLEANUP;
  begin
    close(pcxfile);
    freemem(scratch, buffsize);
  end;

begin
assign(pcxfile, pfilename);
{$I-} reset(pcxfile, 1);  {$I+}
file_error:= (IOresult <> 0);
if file_error then exit;
getmem(scratch, buffsize);                  { Speicher holen }
blockread(pcxfile, version, 2);             { erste zwei bytes holen }
file_error:= (hi(version) < 5);             { keine Palette --> Ende }
if file_error then
begin
  cleanup; exit;
end;
palette_start:= filesize(pcxfile) - 769;
seek(pcxfile, 128);
total_read:= 128;
repeatcount:= 0;
video_index:= 0;

repeat
  blockread(pcxfile, scratch^, buffsize, datalength);
  inc(total_read, datalength);
  if (total_read > palette_start) then
      dec(datalength, total_read - palette_start);
  decode_pcx256(Page_Addr);
until (eof(pcxfile)) or (total_read>= palette_start);

seek(pcxfile, palette_start);
blockread(pcxfile, palette_flag, 1);
file_error:= (palette_flag <> 12);
if file_error then
begin
  cleanup; exit;
end;
blockread(pcxfile, RGB256, 768);         { Palette holen }
asm
     xor   ax,ax               {  AX := 0                              }
     mov   cx,768              {  CX := Anzahl Eintrge                }
     mov   dx,03C8h
     mov   si,offset rgb256

     out   dx,al
     inc   dx

   @l1:

     mov   bl,[si]
     shr   bl,2
     mov   [si],bl
     outsb
     dec   cx
     jnz   @l1
end;
cleanup;
end;

BEGIN
      init320x200;
      zeig_pcx ('WASWEISICH.PCX',$A000);
      readln;
      asm
        mov ax,0003h                             { und zurck zu Textmode }
        int 10h
      end;
END.
