DOSSEG

.MODEL SMALL
.STACK 256

Page_Addr       equ 0A000h
Buff_Size       equ 5000

.DATA

File         dw (?)               ; Filehandle zum Zugriff auf Datei
Header       db 128 dup (?)       ; Buffer um Header zu lesen
RepeatCount  db (?)               ; Wiederholungszaehler
BytesRead    dw (?)               ; Lnge der gelesenen Daten in Bytes
End_Offset   dw (?)               ; Nummer des Bytes in einer Zeile
Video_Offset dw (?)               ; Offset-Addy vom ViedeoRam
DatenPuffer  db Buff_Size dup (?) ; Tab fr gelesene Bytes
Palette      db 768 dup (?)       ; Feld fr Palette
Granu        dw (0)               ; Granularitt fr Fensterverschiebung
Vesa         db 256 dup (4)       ; Vesainfo abfragen fr Granu...
FensterProc  dw (?)               ; Fr Offset
             dw (?)               ; Fr Segment


Public ShowPCX800

.CODE

SHOWPCX800 PROC FAR
  mov ax,@Data
  mov ds,ax          ; DatenSegment nach DS

  mov es,ax          ; DatenSegment nach ES
  mov ax,4F01h
  mov cx,101h        ; Beliebiger VesaVideoModus nach CX
  lea di,Vesa
  int 10h            ; VesaInfos abfragen
  mov ax,WORD PTR VESA+4
  mov bx,ax          ; Granularitt nach BX
  mov ax,64          ; MaxFenstergre (64K) nach AX
  div bl             ; AX = 64 / Granularitt
  mov granu,ax
  mov ax,WORD PTR VESA+0Ch
  mov FensterProc,ax
  mov ax,WORD PTR VESA+0Eh
  mov FensterProc+2,ax

  mov dx,3dah
  in ax,dx
  mov dx,3c0h
  xor al,al
  out dx,al

  mov ax,4f05h
  xor bx,bx
  xor dx,dx
  int 10h              ; Erstes Fenster einblenden

  push bp
  mov bp,sp
  push ds

  mov bx,[bp+6]         ;Offset von String nach BX
  mov ds,[bp+8]         ;Segment von String nag DS

  mov al,[bx]           ;Laenge von String nach AL
  xor ah,ah
  mov si,ax             ;Laenge von String nach SI
  inc bx                ;Beim echten String anfangen
  mov al,[bx+si]
  mov di,ax
  mov [bx+si],ah        ;'0' ans Ende schreiben
  mov dx,bx
  mov ax,3d00h
  int 21h               ;Datei ffnen
  mov dx,di
  mov [bx+si],dl

  pop ds

  mov File,ax           ; Datei ffnen + Handle ermitteln
  jnc OK
  jmp Ende              ; Wenn Fehler nach Ende

OK:
  mov ax,3F00h
  mov bx,File
  mov cx,128
  lea dx,Header
  int 21h               ; 128 Bytes aus PCX-File lesen (Header)
  jnc OK2
  jmp Ende              ; Wenn Fehler nach Ende

OK2:
  mov Video_Offset,0    ; AnfangsWerte setzen
  mov RepeatCount,0
  xor bp,bp             ; BP wird als 'Fensterzaehler' mibraucht
Schleife:
  mov ax,3F00h
  mov bx,File
  mov cx,Buff_Size
  lea dx,DatenPuffer
  int 21h              ; 30000b aus PCX-File lesen
  jc  Ende
  cmp ax,0
  je  MakePalette      ; Wenn keine Bytes mehr gelesen wurden -> Ende
  mov BytesRead,ax
  call Decode          ; 30000b decodieren
  jmp Schleife

MakePalette:
  mov ah,42h
  mov al,02h
  mov bx,File
  mov cx,0
  mov dx,0
  int 21h              ; Laenge des Files bestimmen

  sub ax,768           ;DWord (DX:AX) um 768 erniedrigen
  jnc NextPal
  sub dx,1

NextPal:
  mov cx,dx
  mov dx,ax
  mov ah,42h
  mov al,00h
  mov bx,File
  int 21h              ;FilePointer auf 768b vor Ende setzen

  mov ah,3Fh
  mov bx,File
  mov cx,768
  lea dx,Palette
  int 21h              ; 768b aus File lesen (in Palette)

  lea bx,Palette
  mov cx,768
decrease:
  mov ah,[bx]
  shr ah,2
  mov [bx],ah
  inc bx
  loop decrease        ;Alle Farbeintrge durch 4 teilen

  mov ax,1012h
  mov bx,0
  mov cx,256
  mov dx,Seg Palette
  mov es,dx
  lea dx,Palette
  int 10h              ;256 Farben setzen

  mov dx,3dah
  in ax,dx
  mov dx,3c0h
  mov al,20h
  out dx,al

DateiSchliessen:
  mov ah,3Eh
  mov bx,File
  int 21h              ; File schlieen

ENDE:
  pop bp
  retf 004             ; Prozedur verlassen
ShowPCX800 ENDP

Decode Proc Near
    mov ax, Page_Addr                  ; Video-Segment nach AX
    mov es, ax                         ; Video-Segment nach ES
    mov di, Video_Offset               ; Video_Offset nach DI
    mov dx, End_Offset                 ; Schon geschriebene Bytes nach DX
    xor cx, cx                         ; CX auf null
    mov cl, RepeatCount                ; Anzahl der Wiederholungen nach CL
    mov bx, BytesRead                  ; Gre des Puffers nach BX
    lea si, DatenPuffer                ; Offset von DatenPuffer nach SI
    add bx, si                         ; Offset-Ende vom Puffer
    cld                                ; Lsche DF - INC DI (bei STOSB...)

checkbyte:
    cmp si, bx                         ; Noch Daten da?
    je exit                            ; Wenn nicht : EXIT
    mov al,[si]                        ; Byte aus Puffer nach AL
    inc si                             ; Auf nchstes Byte zeigen
    cmp cl, 0                          ; Wiederholungsschleife ?
    jne WriteByte                      ; Wenn ja : WriteByte
    cmp al, 11000000b                  ; Sonst prfe BIT 7+6
    jb VorWriteByte                    ; Nicht gesetzt : One_Data
    xor al, 11000000b                  ; BIT 0-5 : Wiederholungszhler
    mov cl, al                         ; Wiederholungsanzahl nach CL
    jmp checkbyte                      ; Prfe nchste Data

VorWriteByte:
    mov cl,1

WriteByte:
    push ax
    push cx
     mov ax,di
     mov di,640
     div di
     cmp ax,102
     je Anders
     mov cx,dx
     mul di
     mov di,ax
     add di,cx
    pop cx
    pop ax
    shr cx,1
    jnc gerade
    stosb
gerade:
    mov ah,al
    rep stosw                          ; AL in VideoSpeicher, INC Offset (DI)
    jmp checkbyte                      ; Prfe nchste Data

anders:
     mov cx,dx
     mul di
     mov di,ax
     add di,cx
    pop cx
    pop ax
anders2:
    stosb

    cmp di,0
    je NextWindow

    loop anders2

    jmp checkbyte

NextWindow:
    push bx
    push dx
    xor bx,bx
    add bp,Granu
    mov dx,bp
    call DWORD PTR FensterProc         ; FAR CALL nach FensterRoutine
    mov bx,1
    mov dx,bp
    call DWORD PTR FensterProc         ; FAR CALL nach FensterRoutine
    pop dx
    pop bx
    loop writebyte
    jmp checkbyte

exit:
    mov Video_Offset, di
    mov End_Offset, dx
    mov repeatcount, cl
    ret                                 ;Werte zwischenspeichern und zurck
Decode Endp

END