unit mousetpu;

interface

uses dos,crt;

{ntige types}
type farben=array[0..999]of byte;
     vesainfo_datablock0=record
       signa:array[0..3] of byte;major_v,minor_v:byte;hersteller:pointer;l_flag:array[0..1]of word;modis:pointer;
      end;
     vesainfo_freeblock0=array[0..255]of byte;
     vesainfo_datablock1=record
       modusflag:word;
       f_win1,f_win2:byte;
       granu,winsize,segm1,segm2:word;
       far_rout:pointer;
       byte_per_line,x_points,y_points:word;
       breit_matrix,hoehe_matrix,bit_planes,bit_per_point,anz_bloecke,speichermodell,groesse_bloecke:byte;
      end;
var regs:registers;
    i,x,y:word;
    aktwin_byte,secwin_byte,granu_diff:byte;
    winstat,two_pages:word;
    aktwin_diff:longint;
    modi_nr:byte;pb:^byte;
    datenbl:^vesainfo_datablock0;
    datenbl2:vesainfo_datablock1;
    p_datenblock:vesainfo_freeblock0;
    modi_liste:array[0..40] of word;
{$f+}
procedure setgranu_faktor(granu:word);far;
procedure moveaktwin(hw:word);far;
function  getwinbyte(x,y:word):byte;far;
function getaktwinbyte:byte;far;
procedure vputpixel(x,y,f:word);far;
function  vgetpixel(x,y:word):byte;far;
procedure vputpixel_woc(x,y,f:word);far;
function  vgetpixel_woc(x,y:word):byte;far;
procedure vputpixel_virt(x,y,f,segm:word);far;
function  vgetpixel_virt(x,y,segm:word):byte;far;
procedure vputblock(start,anz,segm,offs:word);far;
procedure vgetblock(start,anz,segm,offs:word);far;
procedure vputvirtblock(x,y,anz,segm,offs:word);far;
procedure vputvirtblock_trans(tc,x,y,anz,segm,offs:word);far;
procedure vgetvirtblock(x,y,anz,segm,offs:word);far;
procedure vcopy_woc(anz_dw,seg1,ofs1,seg2,ofs2:word);far;
procedure vcopy_screen_2_mem(anz_lines,ofs1,seg2,ofs2:word);far;
procedure vcopy_mem_2_screen(anz_lines,seg1,ofs1,ofs2:word);far;
procedure vcopy_mem_2_mem(anz_lines,seg1,ofs1,seg2,ofs2:word);far;
procedure vcopy_mem(anz_bytes,seg1,ofs1,seg2,ofs2:word);far;
procedure vcopy_s_and(anz_lines,seg1,ofs1,ofs2,ofs_m:word);far;
procedure vcopy_s_bkg(anz_lines,ofs1:word;col_dw:word);far;
procedure vputmouse(x,y,mp_seg,mp_ofs,bp_seg,bp_ofs:word);far;
procedure vclearmouse(x,y,bp_seg,bp_ofs:word);far;
procedure vscroll_mem(seg,ofs,anz,rot:word);far;
procedure vputchar_cmp(x1,y1,seg,ofs,farbe:word);far;
procedure initvesamode;far;
function check4vesa:boolean;far;


type mouse_saverec=record altmx,altmy,mousex,mousey,mset:word;end;
     mouse_quadrec=record x1,y1,x2,y2:word;end;
     mouse_shapetype=array[0..143]of byte;
var mouse_visible:boolean;
    mousebut,mousex,mousey:integer;
    altmbut ,altmx ,altmy:integer;
    event_status,mouseset:byte;
    mouse_shape,backmouse:mouse_shapetype;
    mouse_moved:word;
function  mouse_installed:boolean;
function  mouse_getadress:pointer;
procedure mouse_inithandler(addy:pointer);
procedure mouse_deinithandler;
procedure mouse_resetdrv;
procedure mouse_init;
procedure mouse_deinit;
procedure mouse_checkpos;
procedure mouse_setpos(mx,my:word);
procedure mouse_getpos(var mx,my:word);
procedure mouse_setarea(x1,y1,x2,y2:word;posx,posy:integer);
procedure mouse_getarea(var x1,y1,x2,y2:word);
procedure mouse_plot;
procedure mouse_clear;
procedure mouse_move;
procedure mouse_secpos(var mouse:mouse_saverec);
procedure mouse_respos(mouse:mouse_saverec);
procedure mouse_show;
procedure mouse_hide;
procedure mouse_setshape(shape:pointer);
procedure mouse_getshape(shape:pointer);
procedure mouse_unvisible;





implementation

    {mouse-vars}

var mouse:mouse_saverec;
    mouse_range:mouse_quadrec;
    mousedx,mousedy,altdx,altdy:integer;

procedure setgranu_faktor(granu:word);external;
procedure moveaktwin(hw:word);external;
function  getwinbyte(x,y:word):byte;external;
function  getaktwinbyte:byte;external;
procedure vputpixel(x,y,f:word);external;
function  vgetpixel(x,y:word):byte;external;
procedure vputpixel_woc(x,y,f:word);external;
function  vgetpixel_woc(x,y:word):byte;external;
procedure vputpixel_virt(x,y,f,segm:word);external;
function  vgetpixel_virt(x,y,segm:word):byte;external;
procedure vputblock(start,anz,segm,offs:word);external;
procedure vgetblock(start,anz,segm,offs:word);external;
procedure vputvirtblock(x,y,anz,segm,offs:word);external;
procedure vputvirtblock_trans(tc,x,y,anz,segm,offs:word);external;
procedure vgetvirtblock(x,y,anz,segm,offs:word);external;
procedure vcopy_woc(anz_dw,seg1,ofs1,seg2,ofs2:word);external;
procedure vcopy_screen_2_mem(anz_lines,ofs1,seg2,ofs2:word);external;
procedure vcopy_mem_2_screen(anz_lines,seg1,ofs1,ofs2:word);external;
procedure vcopy_mem_2_mem(anz_lines,seg1,ofs1,seg2,ofs2:word);external;
procedure vcopy_mem(anz_bytes,seg1,ofs1,seg2,ofs2:word);external;
procedure vcopy_s_and(anz_lines,seg1,ofs1,ofs2,ofs_m:word);external;
procedure vcopy_s_bkg(anz_lines,ofs1:word;col_dw:word);external;
procedure vputchar_cmp(x1,y1,seg,ofs,farbe:word);external;
procedure vputmouse(x,y,mp_seg,mp_ofs,bp_seg,bp_ofs:word);external;
procedure vclearmouse(x,y,bp_seg,bp_ofs:word);external;
procedure vscroll_mem(seg,ofs,anz,rot:word);external;

{$l vesaview.obj}
procedure clear_key_buffer;
var taste:char;
begin
 while keypressed do taste:=readkey;
end;

procedure get_modi(po:pointer);
var count:byte;pw:^word;
begin count:=0;repeat pw:=ptr(seg(po^),ofs(po^)+count);modi_liste[count div 2]:=pw^;inc(count,2);until pw^=$ffff;
 modi_nr:=count div 2;
end;
function get_granu_faktor(granu_kb:byte):byte;
var granu:word;count:byte;
begin
 if granu_kb=64 then get_granu_faktor:=16
 else
  begin
   granu:=granu_kb*1024;count:=0;
   if granu>1 then
    begin
     repeat asm shr granu,1;inc count;end;until granu=1;get_granu_faktor:=count;
    end else get_granu_faktor:=1;
  end;
end;

procedure get_Vesa_info;
begin
 datenbl:=addr(p_datenblock);regs.ah:=$4f;regs.al:=0;regs.es:=seg(p_datenblock);regs.di:=ofs(p_datenblock);intr($10,regs);
end;
procedure get_modi_info(modus:word);
begin
 regs.ah:=$4f;regs.al:=1;regs.cx:=modus;regs.es:=seg(datenbl2);regs.di:=ofs(datenbl2);intr($10,regs);
end;

function vesa_info1:boolean;
const liste:string[4]='VESA';
begin
 get_vesa_info;
 for i:=0 to 3 do if (chr(datenbl^.signa[i]))<>liste[i+1] then begin vesa_info1:=false;exit;end;
 get_modi(datenbl^.modis);vesa_info1:=true;
end;
function check4vesa:boolean;
var du:boolean;
begin
 du:=false;
 if vesa_info1 then
  begin
   for i:=0 to modi_nr do
    if modi_liste[i]=$101 then begin get_modi_info($101);du:=true;
    if odd(datenbl2.f_win2) then two_pages:=1 else two_pages:=0;
   end;
  end;
 check4vesa:=du;
end;
procedure initvesamode;
begin
 if vesa_info1 then
  begin
   for i:=0 to modi_nr do if modi_liste[i]=$101 then get_modi_info($101);
   if odd(datenbl2.f_win2) then two_pages:=1 else two_pages:=0;
  end
 else begin writeln('Keine VESA-Karte gefunden!');halt;end;
 regs.ax:=$4f02;regs.bx:=$101;intr($10,regs);
 granu_diff:=get_granu_faktor(datenbl2.granu);
end;

procedure vbl;assembler;
asm
 mov dx,$3da
 @wait1:in al,dx;test al,$8;jnz @wait1
 @wait2:in al, dx;test al,$8;jz @wait2
end;

{mouse-routs}
{Beginn der Mausroutinen}
procedure mouse_eventhandler;assembler;
asm
 pusha
 push ds
 push ax
 mov ax, SEG MOUSEX
 mov ds,ax
 cmp event_status,2
 je @aktiv
 shl event_status,1
 mov ax,mousebut
 mov altmbut,ax
 mov mousebut,bx

 mov mousedx,si;sub si,altdx;add mousex,si;mov ax,mousedx;mov altdx,ax;
 mov mousedy,di;sub di,altdy;add mousey,di;mov ax,mousedy;mov altdy,ax;
 mov cx,mousex;mov dx,mousey;
 @x1:cmp cx,mouse_range.x1;jge @x2 ;mov ax,mouse_range.x1;mov mousex,ax;
 @x2:cmp mouse_range.x2,cx;jge @y1 ;mov ax,mouse_range.x2;mov mousex,ax;
 @y1:cmp dx,mouse_range.y1;jge @y2 ;mov ax,mouse_range.y1;mov mousey,ax;
 @y2:cmp mouse_range.y2,dx;jge @rdy;mov ax,mouse_range.y2;mov mousey,ax;
 @rdy:
 mov mouse_moved,1
 shr event_status,1
 @aktiv:

 pop ax
 pop ds
 popa
end;
{$f-}
function mouse_getadress:pointer;
begin
 mouse_getadress:=addr(mouse_eventhandler);
end;
procedure mouse_inithandler(addy:pointer);assembler;
asm
 pusha
 push es
 les dx,addy
 mov ax,$000c
 mov cx,31
 int $33
 pop es
 popa
end;
procedure mouse_deinithandler;
begin
 mouse_resetdrv;
end;
procedure mouse_checkpos;
begin
 if mousex<mouse_range.x1 then mousex:=mouse_range.x1;
 if mousex>mouse_range.x2 then mousex:=mouse_range.x2;
 if mousey<mouse_range.y1 then mousey:=mouse_range.y1;
 if mousey>mouse_range.y2 then mousey:=mouse_range.y2;
end;
procedure mouse_setpos(mx,my:word);
var m:byte;
begin
 m:=mouseset;if m>0 then mouse_clear;
 mousex:=mx;
 mousey:=my;
 mouse_checkpos;
 if m>0 then mouse_plot;
end;
procedure mouse_getpos(var mx,my:word);
begin
 mx:=mousex;
 my:=mousey;
end;
procedure mouse_setarea(x1,y1,x2,y2:word;posx,posy:integer);
begin
 mouse_range.x1:=x1;mouse_range.y1:=y1;
 mouse_range.x2:=x2;mouse_range.y2:=y2;
 if posx=-1 then begin mousex:=(x2-x1-12)div 2+x1;end else mousex:=posx;
 if posy=-1 then begin mousey:=(y2-y1-12)div 2+y1;end else mousey:=posy;
 mouse_checkpos;
end;
procedure mouse_getarea(var x1,y1,x2,y2:word);
begin
 x1:=mouse_range.x1;y1:=mouse_range.y1;
 x2:=mouse_range.x2;y2:=mouse_range.y2;
end;
procedure mouse_plot;
var x,y:word;b,m:byte;
begin
 if mouseset=1 then exit;
 mouseset:=1;
 altmx:=mousex;altmy:=mousey;
 m:=getwinbyte(altmx,altmy);
 if m=getwinbyte(altmx+11,altmy+11) then
  begin
   if getaktwinbyte<>m then moveaktwin(m);
   vputmouse(altmx,altmy,seg(mouse_shape),ofs(mouse_shape),seg(backmouse),ofs(backmouse));
  end
 else
  begin
   for y:=altmy to altmy+11 do for x:=altmx to altmx+11 do
    begin
     backmouse[(y-altmy)*12+(x-altmx)]:=vgetpixel(x,y);
     b:=mouse_shape[(y-altmy)*12+(x-altmx)];if b>0 then vputpixel(x,y,b);
    end;
  end;
end;
procedure mouse_clear;
var x,y:word;m:byte;
begin
 if mouseset=0 then exit;
 mouseset:=0;
 m:=getwinbyte(altmx,altmy);
 if m=getwinbyte(altmx+11,altmy+11) then
  begin
   if m<>getaktwinbyte then moveaktwin(m);
   vclearmouse(altmx,altmy,seg(backmouse),ofs(backmouse));
  end
 else
  for y:=altmy to altmy+11 do for x:=altmx to altmx+11 do vputpixel(x,y,backmouse[(y-altmy)*12+(x-altmx)]);
end;
procedure mouse_createshape;
var i,j:word;
begin
 for i:=0 to 11 do
  for j:=0 to 11 do
   mouse_shape[i*12+j]:=j+i;
end;

{ende der mouse-routs}

procedure mouse_move;assembler;
asm
 cmp mouse_visible,0
 je @exit
 cmp mouse_moved,0
 je @exitmovemouse
 mov mouse_moved,0
 call vbl
 call mouse_clear
 call mouse_plot
 jmp @exit
 @exitmovemouse:
 @exit:
end;

procedure mouse_resetdrv;assembler;
asm
 mov ax,0
 int $33
 mov ax,$21
 int $33
 mov mousebut,0
 mov mouseset,0
 mov mouse_moved,0
end;
function mouse_installed:boolean;
begin
 regs.ax:=0;intr($33,regs);
 if regs.ax=$ffff then mouse_installed:=true else mouse_installed:=false;
end;

procedure mouse_init;
begin
 mouse_resetdrv;
 mouse_inithandler(mouse_getadress);
end;
procedure mouse_deinit;
begin
 mouse_deinithandler;
 mouse_resetdrv;
end;

procedure mouse_secpos(var mouse:mouse_saverec);
begin
 mouse.altmx:=altmx;mouse.altmy:=altmy;mouse.mousex:=mousex;mouse.mousey:=mousey;
end;
procedure mouse_respos(mouse:mouse_saverec);
begin
 altmx:=mouse.altmx;altmy:=mouse.altmy;mousex:=mouse.mousex;mousey:=mouse.mousey;
 mouse.mset:=1;mouse_setpos(mouse.mousex,mouse.mousey);
end;
procedure mouse_show;
begin
 if mouse_visible then exit;
 mouse_visible:=true;mouse_plot;
end;
procedure mouse_hide;
begin
 if not mouse_visible then exit;
 mouse_clear;mouse_visible:=false;
end;
procedure mouse_setshape(shape:pointer);
begin
 if mouse_visible then mouse_clear;
 move(shape^,mouse_shape,sizeof(mouse_shape));
 if mouse_visible then mouse_plot;
end;
procedure mouse_getshape(shape:pointer);
begin
 move(mouse_shape,shape^,sizeof(mouse_shape));
end;
procedure mouse_unvisible;assembler;
asm
 mov ax,2;int $33;
end;


begin
 mousedx:=0;altdx:=0;mousedy:=0;altdy:=0;
 mouse_visible:=false;mouseset:=0;
end.
{$f-}