program vector_intro;

uses crt,dos;

type vertex=record
       x,y,z:longint;
       xr,yr,zr:longint;
       xs,ys:longint;
       rotated:boolean;
      end;
     face=record
       normal,middle:vertex;
       col:byte;
       visible:boolean;
       p:array[1..4]of word;
      end;


var punkte:array[0..7]of vertex;
    view:vertex;
    sinus_t:array[0..449]of integer;
    rota1,rota2,i,v:integer;
    plane:record anz:byte;s:array[1..7]of face;end;
    w1,w2,w3,w4,ps1,ps2,ps3,ps4,pc1,pc2,pc3,pc4,psc,pcs,pcc,pss:integer;
    scenepos:record x,y,z:word;end;
    taste:char;



procedure setgfxmode;
begin
 asm
  mov ax,$13
  int $10
 end;
end;
procedure settxtmode;
begin
 asm
  mov ax,$3
  int $10
 end;
end;
procedure calc_sine;
begin
 for i:=0 to 359 do
  begin
   sinus_t[i]:=trunc(sin(i*PI/180)*10000+0.5);
  end;
 move(sinus_t[0],sinus_t[360],90*sizeof(word));
end;
function sinus(a:integer):integer;
begin
 while a<0 do inc(a,360);
 while a>=360 do dec(a,360);
 sinus:=sinus_t[a];
 {sinus:=trunc(sin(a/180*PI)*10000+0.5);}
end;
function cosin(a:integer):integer;
begin
 while a<0 do inc(a,360);
 while a>=360 do dec(a,360);
 cosin:=sinus_t[a+90];
 {cosin:=trunc(cos(a/180*PI)*10000+0.5);}
end;
procedure calc_normal(var pl:face);
var d1,d2:vertex;
    p1,p2,p4,pe:vertex;
    l:longint;
begin
 p1:=punkte[pl.p[1]];p2:=punkte[pl.p[2]];p4:=punkte[pl.p[4]];
 d1.x:=p1.x-p4.x;d1.y:=p1.y-p4.y;d1.z:=p1.z-p4.z;
 d2.x:=p1.x-p2.x;d2.y:=p1.y-p2.y;d2.z:=p1.z-p2.z;
 pe.x:=d1.y*d2.z-d1.z*d2.y;
 pe.y:=d1.z*d2.x-d1.x*d2.z;
 pe.z:=d1.x*d2.y-d1.y*d2.x;
 with pe do l:=trunc(sqrt(x*x+y*y+z*z));
 pe.x:=trunc(pe.x*127/l);
 pe.y:=trunc(pe.y*127/l);
 pe.z:=trunc(pe.z*127/l);
 pl.normal:=pe;
end;
procedure calc_middle(var pl:face);
var d1,d2:vertex;
    p1,p2,p3,p4:vertex;
begin
 p1:=punkte[pl.p[1]];p2:=punkte[pl.p[2]];p3:=punkte[pl.p[3]];p4:=punkte[pl.p[4]];
 pl.middle.x:=trunc((p1.x+p2.x+p3.x+p4.x) div 4);
 pl.middle.y:=trunc((p1.y+p2.y+p3.y+p4.y) div 4);
 pl.middle.z:=trunc((p1.z+p2.z+p3.z+p4.z) div 4);
end;

procedure init_faces;
begin
 with punkte[0] do begin x:=40; y:=40; z:=-40;end;
 with punkte[1] do begin x:=-40;y:=40; z:=-40;end;
 with punkte[2] do begin x:=-40;y:=-40;z:=-40;end;
 with punkte[3] do begin x:=40; y:=-40;z:=-40;end;
 with punkte[4] do begin x:=40; y:=40; z:=40;end;
 with punkte[5] do begin x:=-40;y:=40; z:=40;end;
 with punkte[6] do begin x:=-40;y:=-40;z:=40;end;
 with punkte[7] do begin x:=40; y:=-40;z:=40;end;

 plane.anz:=6;
 with plane.s[1] do begin p[1]:=0;p[2]:=1;p[3]:=2;p[4]:=3;visible:=false;col:=15;end;
 with plane.s[2] do begin p[1]:=1;p[2]:=5;p[3]:=6;p[4]:=2;visible:=false;col:=14;end;
 with plane.s[3] do begin p[1]:=5;p[2]:=4;p[3]:=7;p[4]:=6;visible:=false;col:=1;end;
 with plane.s[4] do begin p[1]:=4;p[2]:=0;p[3]:=3;p[4]:=7;visible:=false;col:=7;end;
 with plane.s[5] do begin p[1]:=4;p[2]:=5;p[3]:=1;p[4]:=0;visible:=false;col:=10;end;
 with plane.s[6] do begin p[1]:=3;p[2]:=2;p[3]:=6;p[4]:=7;visible:=false;col:=3;end;
 for i:=1 to plane.anz do
  begin
   calc_normal(plane.s[i]);
   calc_middle(plane.s[i]);
  end;
end;
procedure putpix(x,y:word;c:byte);
begin
 mem[$a000:y*320+x]:=c;
end;
procedure hline(x1,y1,x2:integer;col:byte);
begin
 if y1>199 then exit;
 if y1<0 then exit;
 if x1<0 then x1:=0;if x1>319 then x1:=319;
 if x2<0 then x2:=0;if x2>319 then x2:=319;
 asm
  push es
  mov cx,x2
  sub cx,x1
  inc cx
  mov di,y1
  mov bx,di
  shl di,8
  shl bx,6
  add di,bx
  add di,x1
  mov ax,$a000
  mov es,ax
  mov al,col
  cld
  rep stosb
  pop es
 end;
end;

procedure fillpoly(var plane:face;clear:boolean);
const cp:array[1..4]of byte=(3,4,1,2);
var col,pmin,pright,pleft:byte;
    ymax,ymin:integer;
    psl,psr:integer;
    pymin:integer;
    y,xl,xr,xer,xel,yer,yel,xdr,xdl,cr,cl,dr,dl:longint;
 procedure get_extremes;
 var dummy:byte;
 begin
  psl:=0;psr:=0;
  ymax:=0;ymin:=480;
  for i:=1 to 4 do
   begin
    if punkte[plane.p[i]].ys<ymin then ymin:=punkte[plane.p[i]].ys;
    if punkte[plane.p[i]].ys>ymax then ymax:=punkte[plane.p[i]].ys;
   end;
  for i:=1 to 4 do
   begin
    if (punkte[plane.p[i]].ys=ymin) then
     pmin:=i;pymin:=ymin;
   end;
  if pmin=1 then begin pleft:=4;pright:=2;end;
  if pmin=2 then begin pleft:=1;pright:=3;end;
  if pmin=3 then begin pleft:=2;pright:=4;end;
  if pmin=4 then begin pleft:=3;pright:=1;end;
  xl:=punkte[plane.p[pmin]].xs;xr:=xl;

  xer:=punkte[plane.p[pright]].xs;yer:=punkte[plane.p[pright]].ys;
  xel:=punkte[plane.p[pleft]].xs; yel:=punkte[plane.p[pleft]].ys;

  cr:=0;cl:=0;xdr:=0;xdl:=0;
  if xr<=xer then begin dr:=0;if (yer-pymin+1)<>0 then xdr:=100000*(xer-xr+1) div (yer-pymin+1) else xdr:=0;end
             else begin dr:=1;if (yer-pymin+1)<>0 then xdr:=100000*(xr-xer+1) div (yer-pymin+1) else xdr:=0;end;
  if xl<=xel then begin dl:=0;if (yel-pymin+1)<>0 then xdl:=100000*(xel-xl+1) div (yel-pymin+1) else xdl:=0;end
             else begin dl:=1;if (yel-pymin+1)<>0 then xdl:=100000*(xl-xel+1) div (yel-pymin+1) else xdl:=0;end;

  if pymin=yer then
   begin xdr:=0;xr:=xer;end;
  if pymin=yel then
   begin xdl:=0;xl:=xel;end;
 end;
 procedure switch(var p1,p2:word);
 var d:word;
 begin
  d:=p1;p1:=p2;p2:=d;
 end;
 procedure switch_l(var p1,p2:longint);
 var d:longint;
 begin
  d:=p1;p1:=p2;p2:=d;
 end;

begin
 get_extremes;
 if clear then col:=0 else if plane.visible then col:=plane.col else exit;{col:=1;}
 y:=pymin;
 for y:=ymin to ymax do
  begin
   inc(cr,xdr);while cr>100000 do begin if dr=0 then inc(xr) else dec(xr);dec(cr,100000);end;
   inc(cl,xdl);while cl>100000 do begin if dl=0 then inc(xl) else dec(xl);dec(cl,100000);end;
   if xl>xr then begin switch_l(xl,xr);hline(xl,y,xr,col);switch_l(xl,xr); end else hline(xl,y,xr,col);
   if (y=yer)and(pleft<>pright) then
      begin
       xr:=punkte[plane.p[pright]].xs;
       inc(pright);if pright=5 then pright:=1;
       cr:=0;xdr:=0;xer:=punkte[plane.p[pright]].xs;yer:=punkte[plane.p[pright]].ys;
       if xr<=xer then begin dr:=0;if (yer-y+1)<>0 then xdr:=100000*(xer-xr+1) div (yer-y+1) else xdr:=0;end
                  else begin dr:=1;if (yer-y+1)<>0 then xdr:=100000*(xr-xer+1) div (yer-y+1) else xdr:=0;end;
       if y=yer then begin xdr:=0;xr:=xer;end;
      end;
   if (y=yel)and(pleft<>pright) then
      begin
       xl:=punkte[plane.p[pleft]].xs;
       dec(pleft);if pleft=0 then pleft:=4;
       cl:=0;xdl:=0;xel:=punkte[plane.p[pleft]].xs;yel:=punkte[plane.p[pleft]].ys;
       if xl<=xel then begin dl:=0;if (yel-y+1)<>0 then xdl:=100000*(xel-xl+1) div (yel-y+1) else xdl:=0;end
                  else begin dl:=1;if (yel-y+1)<>0 then xdl:=100000*(xl-xel+1) div (yel-y+1) else xdl:=0;end;
       if y=yel then begin xdl:=0;xl:=xel;end;
      end;
  end;
 if xl>xr then begin switch_l(xl,xr);hline(xl,y,xr,col);switch_l(xl,xr); end else hline(xl,y,xr,col);
end;

procedure init_rot;
begin
 w1:=rota1;w2:=rota2;w3:=w1+w2;w4:=w1-w2;
 ps1:=sinus(w1);ps2:=sinus(w2);ps3:=sinus(w3);ps4:=sinus(w4);
 pc1:=cosin(w1);pc2:=cosin(w2);pc3:=cosin(w3);pc4:=cosin(w4);
 psc:=(ps3+ps4) div 2;
 pcs:=(ps3-ps4) div 2;
 pcc:=(pc4+pc3) div 2;
 pss:=(pc4-pc3) div 2;
end;
procedure rot_point(var p:vertex;n:boolean);
const distance=128; {256}
var v1,v2:integer;
begin
 p.xr:=(-p.x*ps1+p.y*pc1) div 10000;
 p.yr:=(-p.x*pcs-p.y*pss+p.z*pc2) div 10000;
 p.zr:=(-p.x*pcc-p.y*psc-p.z*ps2) div 10000;

 if not n then inc(p.zr,scenepos.z); {+distance}
 v1:=(p.zr);
 if v1=0 then
  begin p.xs:=0;p.ys:=0;end
 else
  begin
   p.xs:=1*((p.xr*distance div v1))+scenepos.x;
   p.ys:=1*((p.yr*distance div v1))+scenepos.y;
  end;
end;
procedure vbl;
begin
 repeat until (port[$3da]and 8)=8;
 {repeat until (port[$3da]and 8)=0;}

end;
procedure chk_col(var pl:face);
var p:word;
begin
 if pl.normal.zr>=0 then exit;
 p:=(0-pl.normal.zr) shr 3;
 pl.col:=p+16;
end;

procedure chk_vis(var pl:face);
var skal:longint;
begin
 {if pl.normal.zr<=0 then pl.visible:=true else pl.visible:=false;}
 skal:=pl.normal.xr*pl.middle.xr+pl.normal.yr*pl.middle.yr+pl.normal.zr*pl.middle.zr;
 if skal<=0 then pl.visible:=true else pl.visible:=false;
end;
procedure draw_world(clearflag:boolean);
var sort:array[1..8]of byte;dsort:byte;
    za:array[1..8]of integer;dz:integer;
    i,j,anz:byte;
begin
 j:=1;anz:=0;for i:=1 to plane.anz do if plane.s[i].visible then begin sort[j]:=i;inc(j);inc(anz);end;
 for i:=1 to anz do
  begin
   za[i]:=(punkte[plane.s[sort[i]].p[1]].z+punkte[plane.s[sort[i]].p[2]].z+punkte[plane.s[sort[i]].p[3]].z
          +punkte[plane.s[sort[i]].p[4]].z) div 4;
  end;
 if anz=0 then exit;
 if anz>1 then
  for i:=1 to anz-1 do
   for j:=i+1 to anz do
    if za[i]<za[j] then
     begin
      dsort:=sort[i];sort[i]:=sort[j];sort[j]:=dsort;
      dz:=za[i];za[i]:=za[j];za[j]:=dz;
     end;
 for i:=1 to anz do fillpoly(plane.s[sort[i]],clearflag);
end;

procedure rotate_world;
begin
 draw_world(true);
 inc(rota1,1);inc(rota2,2);
 if rota1>=360 then dec(rota1,360);
 if rota2>=360 then dec(rota2,360);
 init_rot;
 for i:=0 to 7 do rot_point(punkte[i],false);
 for i:=1 to plane.anz do
  begin rot_point(plane.s[i].normal,true);rot_point(plane.s[i].middle,false);chk_vis(plane.s[i]);chk_col(plane.s[i]);end;
 draw_world(false);
 vbl;
end;

procedure setpal;
var fa:array[0..47]of byte;regs:registers;
begin
 for i:=16 to 31 do
  begin
   fillchar(fa[(i-16)*3],3,(i-15)*4-1);
  end;
 regs.ax:=$1012;
 regs.bx:=16;regs.cx:=16;regs.es:=seg(fa);regs.dx:=ofs(fa);intr($10,regs);
end;

begin
 v:=14;
 scenepos.x:=160;scenepos.y:=100;scenepos.z:=200;
 calc_sine;init_faces;setgfxmode;rota1:=45;rota2:=45;

 init_rot;
 setpal;
 for i:=0 to 7 do rot_point(punkte[i],false);
 for i:=1 to plane.anz do
  begin rot_point(plane.s[i].normal,true);rot_point(plane.s[i].middle,false);chk_vis(plane.s[i]);chk_col(plane.s[i]);end;
 draw_world(false);
 repeat
  rotate_world;
  while keypressed do
   begin
    taste:=readkey;
    if taste='+' then inc(scenepos.z,1);
    if taste='-' then dec(scenepos.z,1);
    if taste='x' then inc(scenepos.x,1);
    if taste='X' then dec(scenepos.x,1);
    if taste='y' then inc(scenepos.y,1);
    if taste='Y' then dec(scenepos.y,1);
    if taste in ['x','X','y','Y','+','-'] then taste:=#0;
   end;
 until taste>#0;
 settxtmode;
end.