Unit GFX;

INTERFACE

USES crt;
CONST VGA = $A000;

TYPE Virtual = Array [1..64000] of byte;  { The size of our Virtual Screen }
     VirtPtr = ^Virtual;                  { Pointer to the virtual screen }

VAR Virscr : VirtPtr;                     { Our first Virtual screen }
    Vaddr  : word;                        { The segment of our virtual screen}

type TPCXHeader = record               { Header der PCX-Datei }
                    Manuf,Version,Encode,BitsPerPixel : byte;
                    X1,Y1,X2,Y2,Xres,Yres : integer;
                    Palette          : array[0..47] of byte;
                    VideoMode,Planes : byte;
                    BytesPerLine     : integer;
                    Reserved         : array[0..59] of byte;
                  end;
     PPCXPic = ^TPCXPic;
     TPCXPic = record
                 Header  : TPCXHeader;            { Der Header }
                 Palette : array[0..767] of byte; { Die Palette }
                 Pixels  : pointer;               { Das Bild }
               end;

var PCX_  : TPCXPic;
    I     : integer;
    PCX   : string;

procedure LoadPCX(sk: integer;FileName:string;var PCX:TPCXPic; ScrPtr : pointer);
   { Ldt eine 200x320 PCX-Datei in Virtuellen Screen}
procedure setwhite;
   { palettenfading mit dem ziel wei }
procedure setblack;
   { palettenfading mit dem ziel schwarz }
Procedure SetMCGA;
   { This procedure gets you into 320x200x256 mode. }
Procedure SetText;
   { This procedure returns you to text mode.  }
Procedure Cls (Where:word;Col : Byte);
   { This clears the screen to the specified color }
Procedure SetUpVirtual;
   { This sets up the memory needed for the virtual screen }
Procedure ShutDown;
   { This frees the memory used by the virtual screen }
procedure flip(source,dest:Word);
   { This copies the entire screen at "source" to destination }
procedure copyflip(source1,source2,dest:Word);
   { source1 + source2 = dest }
Procedure Pal(Col,R,G,B : Byte);
   { This sets the Red, Green and Blue values of a certain color }
Procedure GetPal(Col : Byte; Var R,G,B : Byte);
  { This gets the Red, Green and Blue values of a certain color }
procedure WaitRetrace;
   {  This waits for a vertical retrace to reduce snow on the screen }
Procedure Putpixel (X,Y : Integer; Col : Byte; where:word);
   { This puts a pixel on the screen by writing directly to memory. }
Function Getpixel (X,Y : Integer; where:word) :Byte;
   { This gets the pixel on the screen by reading directly to memory. }


IMPLEMENTATION

{}
Procedure SetMCGA;  { This procedure gets you into 320x200x256 mode. }
BEGIN
  asm
     mov        ax,0013h
     int        10h
  end;
END;

{}
Procedure SetText;  { This procedure returns you to text mode.  }
BEGIN
  asm
     mov        ax,0003h
     int        10h
  end;
END;

{}
Procedure Cls (Where:word;Col : Byte); assembler;
   { This clears the screen to the specified color }
asm
   push    es
   mov     cx, 32000;
   mov     es,[where]
   xor     di,di
   mov     al,[col]
   mov     ah,al
   rep     stosw
   pop     es
End;

{}
Procedure SetUpVirtual;
   { This sets up the memory needed for the virtual screen }
BEGIN
  GetMem (VirScr,64000);
  vaddr := seg (virscr^);
END;

{}
Procedure ShutDown;
   { This frees the memory used by the virtual screen }
BEGIN
  FreeMem (VirScr,64000);
END;

{}
procedure flip(source,dest:Word); assembler;
  { This copies the entire screen at "source" to destination }
asm
  push    ds
  mov     ax, [Dest]
  mov     es, ax
  mov     ax, [Source]
  mov     ds, ax
  xor     si, si
  xor     di, di
  mov     cx, 32000
  rep     movsw
  pop     ds
end;

{}
procedure copyflip(source1,source2,dest:Word);
  { farbe 0 wird ignoriert }
var i   : longint;
    col : byte;
begin
  for i:=0 to 63999 do
   begin
    if mem[source1:i]=0 then mem[source1:i]:=mem[source2:i];
   end;
   flip(source1,vga);
end;

{}
Procedure Pal(Col,R,G,B : Byte); assembler;
  { This sets the Red, Green and Blue values of a certain color }
asm
   mov    dx,3c8h
   mov    al,[col]
   out    dx,al
   inc    dx
   mov    al,[r]
   out    dx,al
   mov    al,[g]
   out    dx,al
   mov    al,[b]
   out    dx,al
end;

{}
Procedure GetPal(Col : Byte; Var R,G,B : Byte);
  { This gets the Red, Green and Blue values of a certain color }
Var
   rr,gg,bb : Byte;
Begin
   asm
      mov    dx,3c7h
      mov    al,col
      out    dx,al

      add    dx,2

      in     al,dx
      mov    [rr],al
      in     al,dx
      mov    [gg],al
      in     al,dx
      mov    [bb],al
   end;
   r := rr;
   g := gg;
   b := bb;
end;

{}
procedure WaitRetrace; assembler;
  {  This waits for a vertical retrace to reduce snow on the screen }
label
  l1, l2;
asm
    mov dx,3DAh
l1:
    in al,dx
    and al,08h
    jnz l1
l2:
    in al,dx
    and al,08h
    jz  l2
end;

{}
Procedure Putpixel (X,Y : Integer; Col : Byte; where:word); assembler;
  { This puts a pixel on the screen by writing directly to memory. }
Asm
  mov     ax,[where]
  mov     es,ax
  mov     bx,[X]
  mov     dx,[Y]
  mov     di,bx
  mov     bx, dx                  {; bx = dx}
  shl     dx, 8
  shl     bx, 6
  add     dx, bx                  {; dx = dx + bx (ie y*320)}
  add     di, dx                  {; finalise location}
  mov     al, [Col]
  stosb
End;

{}
Function Getpixel (X,Y : Integer; where:word):byte; assembler;
  { This puts a pixel on the screen by writing directly to memory. }
Asm
  mov     ax,[where]
  mov     es,ax
  mov     bx,[X]
  mov     dx,[Y]
  mov     di,bx
  mov     bx, dx                  {; bx = dx}
  shl     dx, 8
  shl     bx, 6
  add     dx, bx                  {; dx = dx + bx (ie y*320)}
  add     di, dx                  {; finalise location}
  mov     al, es:[di]
End;

{}
procedure setwhite;
var col, wert, r, b, g : byte;
const    bed : boolean = true;
begin
  repeat
    for i:=0 to 255 do begin
      getpal(i,r,g,b);
      if r<62 then inc(R);
      if g<62 then inc(G);
      if b<62 then inc(B);
      pal(i,r,g,b);
      if (r<62) or (g<62) or (b<62) then bed:=false else bed:=true;
   end;
 until bed=true;
end;

{}
procedure setblack;
var col, wert, r, b, g : byte;
const    bed : boolean = true;
begin
  repeat
    for i:=0 to 255 do begin
      getpal(i,r,g,b);
      if r>0 then dec(R);
      if g>0 then dec(G);
      if b>0 then dec(B);
      pal(i,r,g,b);
      if (r>0) or (g>0) or (b>0) then bed:=false else bed:=true;
   end;
 until bed=true;
end;

{}
procedure LoadPCX(sk: integer;FileName:string;var PCX:TPCXPic; ScrPtr : pointer);
  { Ldt PCX-Datei }

var F               : file;
    Buf             : array[0..1024] of byte;
    BufPtr,Off,Size : word;
    Code,Count      : byte;

begin
  assign(F,FileName);
  reset(F,1);
  seek(F,sk);
  blockread(F,PCX.Header,sizeof(PCX.Header)); { Header einlesen }
  Size:=64000;
  BufPtr := sizeof(Buf);
  Off := 0;                            { Offset in der PCX-Datei }
  while Off < Size do begin
    if BufPtr >= sizeof(Buf) then begin
      blockread(F,Buf,sizeof(Buf));    { Daten lesen }
      BufPtr := 0;
    end;
    Code := Buf[BufPtr];
    inc(BufPtr);
    if Code shr 6 = 3 then begin       { Dekomprimierung }
      Count := Code and 63;
      if BufPtr >= sizeof(Buf) then begin
        blockread(F,Buf,sizeof(Buf));
        BufPtr := 0;
      end;
      Code := Buf[BufPtr];
      inc(BufPtr);
      fillchar(mem[seg (ScrPtr^): ofs (ScrPtr^) +Off],Count,Code);
      inc(Off,Count);
    end
    else begin
      mem[seg (ScrPtr^): ofs (ScrPtr^) +Off] := Code;
      inc(Off);
    end;
  end;
  if BufPtr >= sizeof(Buf) then begin
    blockread(F,Buf,sizeof(Buf));
    BufPtr := 0;
  end;
  Code := Buf[BufPtr];
  inc(BufPtr);
  if Code = 12 then begin
    for Off := 0 to 767 do begin
      if BufPtr >= sizeof(Buf) then begin
        blockread(F,Buf,767-Off);
        BufPtr := 0;
      end;
      PCX.Palette[Off] := Buf[BufPtr];
      inc(BufPtr);
    end;
  end;
  close(F);
  port[$3C8] := 0;                     { Palette setzen }
  for I := 0 to 767 do begin
    PCX_.Palette[I] := PCX_.Palette[I] shr 2;
    Port[$3C9] := PCX_.Palette[I];
  end;
end;

BEGIN
END.