type red_book=record leer,min,sec,fra:byte;end;
type trackinfo=record audio:boolean;start,zeit,ende:red_book;end;
type cd_data_struc=record
          {treiber-infos}
       available:boolean;
       device:file of byte;
       subunit:byte;
       drivename:string[8];
       dev_handle:word;
       drive_num:byte;
       errormsg:string[60];
       Oldint:pointer;
       User_oldint:pointer;
       oldseg:worD;
       handler_aktiv:byte;
       cd_fkt_aktiv:byte;
       timer_request:boolean;
       timer_loop:byte;
       timer_loop_val:byte;
          {drive-infos}
       audio_avail:boolean;
       door_closed:boolean;
       door_locked:boolean;
       door_was_open:boolean;
       vol_set_avail:boolean;
       cd_in_drive:boolean;
       playstatus:word;
       mscdstatus:word;
          {cd-infos}
       tracks_avail:boolean;
       firsttrack:byte;
       lasttrack:byte;
       cd_length:red_book;
       upc_code:array[0..12]of byte;
       tracks:array[1..99]of trackinfo;
       playlist:record mode:byte;anz:byte;track:array[1..99]of byte;end;
       shufflelist:record index,anz:byte;track:array[1..99]of byte;end;
       volume:byte;
          {akt. titel}
       introscan_on:boolean;
       introscan_art:byte;
       shuffle_on:boolean;
       program_on:boolean;
       repeat_mode:byte;
       akt_track:byte;
       akt_title_time:red_book;
       akt_cd_time:red_book;
       channels:record
        channel1,vol1,
        channel2,vol2,
        channel3,vol3,
        channel4,vol4:byte;end;
          {myown infos}
       cmd_ok:boolean;
       player:record
         modus,action,index:byte;usertask:boolean;end;
       pausestatus:boolean;
       title_changed,cd_changed:boolean;
       user_timer1,user_timer2:longint;
       user_timer1_click,user_timer1_on,user_timer2_click,user_timer2_on:boolean;
       play_finished:red_book;
      end;

const cmd_exit_w_play   =0;
      cmd_exit          =1;
      cmd_play          =2;
      cmd_stop          =3;
      cmd_next          =4;
      cmd_prev          =5;
      cmd_introscan     =6;
      cmd_progplay      =7;
      cmd_shuffleplay   =8;
      cmd_reset         =9;
      cmd_vol_up        =10;
      cmd_vol_down      =11;
      cmd_drive_open    =12;
      cmd_drive_close   =13;
      cmd_drive_lock    =14;
      cmd_drive_unlock  =15;
      cmd_drive_reset   =16;
      cmd_pause         =17;
      cmd_resume        =18;
      cmd_repeatchange  =19;
      cmd_introchange   =20;

      mode_exit          =0;
      mode_exit_w_play   =1;
      mode_nothing       =2;
      mode_n             =2;
      mode_play          =3;
      mode_nexttitle     =5;
      mode_prevtitle     =6;
      mode_progplay      =7;
      mode_shuffleplay   =8;



      act_nothing        =0;
      act_n              =0;
      act_play           =2;
      act_next           =3;
      act_prev           =4;
      act_vol_up         =5;
      act_vol_do         =6;
      act_drive_open     =7;
      act_drive_close    =8;
      act_drive_lock     =9;
      act_drive_unlock   =10;
      act_pause          =11;
      act_resume         =12;
      act_exit           =13;
      act_exit_w_play    =14;
      act_reset          =15;
      act_stop           =16;



var cd_rom:cd_data_struc;


function  cd_init:boolean;                         forward;
procedure cd_openhandle;                           forward;
procedure cd_closehandle;                          forward;
function  cd_getdrivename:boolean;                 forward;
procedure cd_drivestatus;                          forward;
procedure cd_audio_info;                           forward;
procedure cd_track_infos;                          forward;
procedure cd_upc_code;                             forward;
procedure cd_play_info;                            forward;
procedure cd_play_status;                          forward;
function  cd_is_playing:boolean;                   forward;
procedure cd_change_control;                       forward;
procedure cd_opendrive;                            forward;
procedure cd_closedrive;                           forward;
procedure cd_lockdrive;                            forward;
procedure cd_unlockdrive;                          forward;
procedure cd_getchanneldat;                        forward;
procedure cd_setchanneldat;                        forward;
function  cd_getvolume:word;                       forward;
procedure cd_setvolume(vol:word);                  forward;
function  cd_get_header_pos:longint;               forward;
procedure cd_set_header_pos(r:red_book);           forward;
procedure cd_resetdrive;                           forward;
procedure cd_control_player;                       forward;
procedure cd_control_player_imm;                   forward;
procedure cd_playtitle(track:byte);                forward;
procedure cd_playtitle_intro(track:byte);          forward;
procedure cd_stoptitle;                            forward;
procedure cd_searchfirsttrack;                     forward;
function  cd_play(mode:byte):boolean;              forward;
procedure command_kernel(cmd:byte);                forward;
procedure player_kernel_user;                      forward;
procedure player_kernel_timer;                     forward;
procedure cd_function_begin;                               forward;
procedure cd_function_end;                                 forward;
procedure cd_start_user_timer(timer:byte;ticks:word);      forward;
procedure cd_stop_user_timer(timer:byte);                  forward;
function  cd_get_user_timer(timer:byte):boolean;           forward;
procedure cd_init_timer_kernel;                            forward;
procedure cd_deinit_timer_kernel;                          forward;
procedure cd_init_player_functions;                        forward;
procedure cd_create_playlist_shuffle;                      forward;
procedure cd_create_playlist_play;                         forward;
procedure cd_create_playlist_program;                      forward;
procedure cd_create_playlist_program_add(track:byte);      forward;
function  cd_create_playlist_program_chk(idx:byte):byte;   forward;
procedure cd_create_playlist_program_clr(idx:byte);        forward;
function  cd_count_tracks:byte;                            forward;
function  cd_count_tracks_time:longint;                    forward;
procedure cd_set_cdrom_adress;                             forward;
procedure cd_set_old_adress;                               forward;
procedure all_init_timer_kernel(proc:pointer);             forward;
procedure all_deinit_timer_kernel;                         forward;
procedure timer_int;                                       forward;



var d:boolean;
var ioblk:array[0..20]of byte;
    ctlblk,secblk:array[0..129]of byte;
    old_exit_proc:pointer;
    taste:char;

procedure cd_function_begin;
begin
 inc(cd_rom.cd_fkt_aktiv);
end;
procedure cd_function_end;
begin
 if cd_rom.cd_fkt_aktiv>0 then dec(cd_rom.cd_fkt_aktiv);
end;

function cd_init:boolean;
begin
 cd_function_begin;
 regs.ax:=$1500;
 regs.bx:=0;
 regs.cx:=0;
 intr($2f,regs);
 if regs.bx>0 then
  begin
   cd_rom.available:=true;
   cd_rom.drive_num:=regs.cl;
  end
 else
  begin
   cd_rom.available:=false;
  end;
 cd_init:=cd_rom.available;
 cd_function_end;
end;

procedure cd_closehandle;
begin
 cd_function_begin;
 {$i-}close(cd_rom.device);
 {$i+}
 cd_function_end;
end;
procedure new_exit_proc;
begin
 cd_closehandle;
end;
procedure cd_openhandle;
var f:text;
begin
 assign(cd_rom.device,cd_rom.drivename);
 {$i-}reset(cd_rom.device);{$i+}
 if ioresult=0 then
  begin
   cd_rom.dev_handle:=filerec(cd_rom.device).handle;
  end
 else cd_rom.dev_handle:=$ffff;
end;

function cd_getdrivename:boolean;
type tstrc=record leer:array[0..9]of byte;name:array[0..7]of char;end;
var count:char;buffer:array[0..25]of record code:byte;pt:pointer;end;
    strc:^tstrc;
begin
 regs.ax:=$1501;
 regs.es:=seg(buffer);
 regs.bx:=ofs(buffer);
 intr($2f,regs);
 cd_rom.subunit:=buffer[0].code;
 strc:=buffer[0].pt;
 cd_rom.drivename[0]:=chr(8);move(strc^.name,cd_rom.drivename[1],8);
 cd_openhandle;cd_closehandle;
 if cd_rom.dev_handle=$ffff then cd_getdrivename:=false else cd_getdrivename:=true;
end;
procedure cd_mscdex_use;
var w:word;
begin
 cd_function_begin;
 regs.ax:=$1510;
 regs.cx:=cd_rom.drive_num;
 regs.es:=seg(ctlblk);
 regs.bx:=ofs(ctlblk);
 intr($2f,regs);
 cd_function_end;
end;
procedure cd_ioctl_read;
begin
 cd_function_begin;
 regs.ax:=$4402;
 regs.bx:=cd_rom.dev_handle;
 regs.cx:=129;
 regs.ds:=seg(ctlblk);
 regs.dx:=ofs(ctlblk);
 intr($21,regs);
 cd_rom.playstatus:=regs.ax;
 cd_function_end;
end;
procedure cd_ioctl_write;
begin
 cd_function_begin;
 regs.ax:=$4403;
 regs.bx:=cd_rom.dev_handle;
 regs.cx:=129;
 regs.ds:=seg(ctlblk);
 regs.dx:=ofs(ctlblk);
 intr($21,regs);
 cd_rom.playstatus:=regs.ax;
 cd_function_end;
end;

procedure cd_drivestatus;
var w:word;l:longint;
begin
 cd_function_begin;
 fillchar(ctlblk,130,0);
 ctlblk[0]:=$06;cd_ioctl_read;
 move(ctlblk[1],l,4);
 w:=word(l and $ffff);
 if (w and 16)=16 then cd_rom.audio_avail:=true else cd_rom.audio_avail:=false;
 if (w and 1)=0 then cd_rom.door_closed:=true else cd_rom.door_closed:=false;
 if (w and 2)=0 then cd_rom.door_locked:=true else cd_rom.door_locked:=false;
 if (w and 256)=256 then cd_rom.vol_set_avail:=true else cd_rom.vol_set_avail:=false;
 if (w and 2048)=0 then cd_rom.cd_in_drive:=true else cd_rom.cd_in_drive:=false;
 cd_function_end;
end;

procedure cd_audio_info;
begin
 cd_function_begin;
 fillchar(ctlblk,130,0);
 ctlblk[0]:=$0a;cd_ioctl_read;
 cd_rom.firsttrack:=ctlblk[1];
 cd_rom.lasttrack:=ctlblk[2];
 if cd_rom.lasttrack>99 then cd_rom.lasttrack:=99;
 cd_rom.cd_length.fra:=ctlblk[3];
 cd_rom.cd_length.sec:=ctlblk[4];
 cd_rom.cd_length.min:=ctlblk[5];
 cd_rom.cd_length.leer:=ctlblk[6];
 cd_function_end;
end;
function red2hsg(v:red_book):longint;
begin
 red2hsg:=longint(v.min)*4500+longint(v.sec)*75+longint(v.fra)-150;
end;
function hsg2red(l:longint):longint;
var l2,l3:longint;
begin
 l2:=l+150;
 l3:=l2 div 4500*65536;l2:=l2 mod 4500;
 l3:=l3+((l2 div 75)*256);l2:=l2 mod 75;
 l3:=l3+l2;
 hsg2red:=l3;
end;
function bcd2byte(b:byte):byte;
begin
 bcd2byte:=(b shr 4)*10+(b and $0f);
end;
procedure cd_upc_code;
var i,w:byte;
begin
 cd_function_begin;
 fillchar(ctlblk,30,0);
 ctlblk[0]:=14;cd_ioctl_read;
 if ctlblk[1]=0 then {no code}
  begin
   for i:=0 to 12 do cd_rom.upc_code[i]:=0;
  end
 else
  begin
   w:=bcd2byte(ctlblk[2]);cd_rom.upc_code[0]:=w div  10;cd_rom.upc_code[1]:=w mod 10;
   w:=bcd2byte(ctlblk[3]);cd_rom.upc_code[2]:=w div  10;cd_rom.upc_code[3]:=w mod 10;
   w:=bcd2byte(ctlblk[4]);cd_rom.upc_code[4]:=w div  10;cd_rom.upc_code[5]:=w mod 10;
   w:=bcd2byte(ctlblk[5]);cd_rom.upc_code[6]:=w div  10;cd_rom.upc_code[7]:=w mod 10;
   w:=bcd2byte(ctlblk[6]);cd_rom.upc_code[8]:=w div  10;cd_rom.upc_code[9]:=w mod 10;
   w:=bcd2byte(ctlblk[7]);cd_rom.upc_code[10]:=w div 10;cd_rom.upc_code[11]:=w mod 10;
   w:=bcd2byte(ctlblk[8]);cd_rom.upc_code[12]:=w div 10;
  end;
 cd_function_end;
end;

procedure cd_calculate_playtime(po:pointer;t2,t1:red_book);
var ze:^red_book;over:byte;
begin
 cd_function_begin;
 ze:=po;
 if t2.fra<t1.fra then
  begin ze^.fra:=t2.fra+75-t1.fra;over:=1;end else begin ze^.fra:=t2.fra-t1.fra;over:=0;end;
 if t2.sec<t1.sec+over then
  begin ze^.sec:=t2.sec+60-(t1.sec+over);over:=1;end else begin ze^.sec:=t2.sec-(t1.sec+over);over:=0;end;
 ze^.min:=t2.min-(t1.min+over);
 ze^.leer:=0;
 cd_function_end;
end;
procedure roundup(n:byte);
begin
 cd_rom.tracks[n].start.fra:=0;
 if cd_rom.tracks[n].start.sec=59 then cd_rom.tracks[n].start.sec:=0 else inc(cd_rom.tracks[n].start.sec);
 if cd_rom.tracks[n].start.sec=0 then inc(cd_rom.tracks[n].start.sec);
 {cd_rom.tracks[n].ende.fra:=0;
 if cd_rom.tracks[n].ende.sec=59 then cd_rom.tracks[n].ende.sec:=0 else inc(cd_rom.tracks[n].ende.sec);
 if cd_rom.tracks[n].ende.sec=0 then inc(cd_rom.tracks[n].ende.sec);}
end;
function cd_count_tracks:byte;
var co:byte;
begin
 co:=0;
 if cd_rom.shuffle_on then
  begin
   if cd_rom.shufflelist.anz>0 then
    for i:=1 to cd_rom.shufflelist.anz do
     if cd_rom.tracks[cd_rom.shufflelist.track[i]].audio then inc(co);
  end
 else
  begin
   if cd_rom.playlist.anz>0 then
    for i:=1 to cd_rom.playlist.anz do
     if cd_rom.tracks[cd_rom.playlist.track[i]].audio then inc(co);
  end;
 cd_count_tracks:=co;
end;
function cd_count_tracks_time:longint;
var co:longint;
begin
 co:=0;
 if cd_rom.shuffle_on then
  begin
   if cd_rom.shufflelist.anz>0 then
    for i:=1 to cd_rom.shufflelist.anz do
     if cd_rom.tracks[cd_rom.shufflelist.track[i]].audio then inc(co,red2hsg(cd_rom.tracks[cd_rom.shufflelist.track[i]].zeit));
  end
 else
  begin
   if cd_rom.playlist.anz>0 then
    for i:=1 to cd_rom.playlist.anz do
     if cd_rom.tracks[cd_rom.playlist.track[i]].audio then inc(co,red2hsg(cd_rom.tracks[cd_rom.playlist.track[i]].zeit));
  end;
 cd_count_tracks_time:=co;
end;


procedure cd_track_infos;
begin
 cd_function_begin;
 for i:=1 to 99 do cd_rom.tracks[i].audio:=false;
 for i:=cd_rom.firsttrack to cd_rom.lasttrack do
  begin
   fillchar(ctlblk,100,0);ctlblk[0]:=$0b;ctlblk[1]:=i;cd_ioctl_read;
   cd_rom.tracks[i].start.fra:=ctlblk[2];
   cd_rom.tracks[i].start.sec:=ctlblk[3];
   cd_rom.tracks[i].start.min:=ctlblk[4];
   cd_rom.tracks[i].start.leer:=ctlblk[5];
   cd_rom.tracks[i].audio:=(((ctlblk[6] shr 4)and 4)=0);
  end;
 for i:=cd_rom.firsttrack to cd_rom.lasttrack-1 do
  begin
   cd_rom.tracks[i].ende.fra:=cd_rom.tracks[i+1].start.fra;
   cd_rom.tracks[i].ende.sec:=cd_rom.tracks[i+1].start.sec;
   cd_rom.tracks[i].ende.min:=cd_rom.tracks[i+1].start.min;
   cd_calculate_playtime(addr(cd_rom.tracks[i].zeit),cd_rom.tracks[i+1].start,cd_rom.tracks[i].start);
  end;
  cd_calculate_playtime(addr(cd_rom.tracks[cd_rom.lasttrack].zeit),cd_rom.cd_length,cd_rom.tracks[cd_rom.lasttrack].start);
  for i:=1 to 99 do if cd_rom.tracks[i].audio then begin cd_rom.tracks_avail:=true;i:=99;end else cd_rom.tracks_avail:=false;
  cd_create_playlist_play;
 cd_function_end;
end;

procedure cd_play_info;
begin
 cd_function_begin;
 fillchar(ctlblk,30,0);
 ctlblk[0]:=$0c;cd_ioctl_read;
 cd_rom.akt_title_time.min:=ctlblk[4];
 cd_rom.akt_title_time.sec:=ctlblk[5];
 cd_rom.akt_title_time.fra:=ctlblk[6];
 cd_rom.akt_cd_time.min:=ctlblk[8];
 cd_rom.akt_cd_time.sec:=ctlblk[9];
 cd_rom.akt_cd_time.fra:=ctlblk[10];
 cd_function_end;
end;
procedure cd_play_status;
var l:longint;
begin
 cd_function_begin;
 fillchar(ctlblk,30,0);
 ctlblk[0]:=22;ctlblk[2]:=$e;
 l:=0;move(l,ctlblk[$0e],4);l:=0;move(l,ctlblk[$12],4);
 cd_mscdex_use;
 cd_rom.playstatus:=(ctlblk[4] shl 8) or ctlblk[3];
 cd_function_end;
end;

function cd_is_playing:boolean;
const playing:word=1 shl 9;
begin
 cd_function_begin;
 cd_play_status;
 cd_is_playing:=(cd_rom.playstatus and playing)=playing;
 cd_function_end;
end;
procedure cd_change_control;
begin
 cd_function_begin;
 fillchar(ctlblk,130,0);
 ctlblk[0]:=$09;cd_ioctl_read;
 if ctlblk[1]<>1 then begin cd_audio_info;cd_track_infos;cd_searchfirsttrack;
  cd_create_playlist_play;end;
 cd_function_end;
end;
procedure cd_opendrive;
begin
 cd_function_begin;
 fillchar(ctlblk,30,0);ctlblk[0]:=0;cd_ioctl_write;
 cd_function_end;
end;
procedure cd_closedrive;
begin
 cd_function_begin;
 fillchar(ctlblk,30,0);ctlblk[0]:=5;cd_ioctl_write;
 cd_function_end;
end;
procedure cd_lockdrive;
begin
 cd_function_begin;
 fillchar(ctlblk,30,0);ctlblk[0]:=1;ctlblk[1]:=1;cd_ioctl_write;
 cd_function_end;
end;
procedure cd_unlockdrive;
begin
 cd_function_begin;
 fillchar(ctlblk,30,0);ctlblk[0]:=1;ctlblk[1]:=0;cd_ioctl_write;
 cd_function_end;
end;
procedure cd_getchanneldat;
begin
 cd_function_begin;
 fillchar(ctlblk,130,0);ctlblk[0]:=4;cd_ioctl_read;
 move(ctlblk[1],cd_rom.channels,8);
 cd_function_end;
end;
procedure cd_setchanneldat;
begin
 cd_function_begin;
 fillchar(ctlblk,130,0);ctlblk[0]:=3;
 move(cd_rom.channels,ctlblk[1],8);
 cd_ioctl_write;
 cd_function_end;
end;
function cd_getvolume:word;
begin
 cd_function_begin;
 cd_getchanneldat;
 cd_getvolume:=word(cd_rom.channels.vol1);
 cd_function_end;
end;
procedure cd_setvolume(vol:word);
label raushier;
begin
 cd_function_begin;
 if vol>$ff then goto raushier;
 cd_rom.channels.vol1:=byte(vol);
 cd_rom.channels.vol2:=byte(vol);
 cd_rom.channels.vol3:=byte(vol);
 cd_rom.channels.vol4:=byte(vol);
 cd_setchanneldat;
 cd_rom.volume:=vol;
 raushier:
 cd_function_end;
end;
procedure cd_resetdrive;
begin
 cd_function_begin;
 fillchar(ctlblk,10,0);
 ctlblk[0]:=2;cd_ioctl_write;
 cd_function_end;
end;
procedure cd_control_player;
label raushier;
begin
 cd_function_begin;
 cd_drivestatus;
 if (cd_rom.door_closed) then
  begin
   if (cd_rom.cd_in_drive) then
    begin
     if cd_rom.door_was_open then
      begin
       cd_change_control;cd_rom.door_was_open:=false;cd_rom.player.modus:=mode_nothing;
       cd_lockdrive;
       cd_create_playlist_play;
       cd_rom.program_on:=false;cd_rom.shuffle_on:=false;
       cd_rom.cd_changed:=true;
      end;goto raushier;
    end else begin cd_rom.door_was_open:=true;end;
  end else begin cd_rom.door_was_open:=true;end;
 raushier:
 cd_function_end;
end;
procedure cd_control_player_imm;
begin
 cd_function_begin;
 repeat cd_drivestatus;until cd_rom.door_closed ;
 cd_lockdrive;
 if cd_rom.cd_in_drive then
  begin
   cd_change_control;
   cd_rom.door_was_open:=false;cd_rom.player.modus:=mode_nothing;
   cd_create_playlist_play;
   cd_rom.program_on:=false;cd_rom.shuffle_on:=false;cd_rom.cd_changed:=true;
  end;
 cd_function_end;
end;
function cd_get_header_pos:longint;
var r:longint;
begin
 cd_function_begin;
 fillchar(ctlblk,10,0);
 ctlblk[0]:=1;cd_ioctl_read;
 if ctlblk[1]=1 then
  begin
   move(ctlblk[2],r,4);cd_get_header_pos:=r;
  end
 else
  begin
   move(ctlblk[2],r,4);cd_get_header_pos:=hsg2red(r);
  end;
 cd_function_end;
end;
procedure cd_set_header_pos(r:red_book);
var l:longint;
begin
 cd_function_begin;
 fillchar(ctlblk,30,0);
 ctlblk[0]:=23;
 ctlblk[1]:=0;
 ctlblk[2]:=$83;
 ctlblk[13]:=0;
 l:=red2hsg(r);move(l,ctlblk[20],4);
 cd_mscdex_use;
 cd_function_end;
end;
procedure cd_settitle(t:byte);
label raushier;
begin
 cd_function_begin;
 if cd_rom.tracks[t].audio=false then goto raushier;
 cd_set_header_pos(cd_rom.tracks[t].start);
 cd_rom.akt_track:=t;
 raushier:
 cd_function_end;
end;

procedure cd_playtitle(track:byte);
var l:longint;
begin
 cd_function_begin;
 fillchar(ctlblk,30,0);
 ctlblk[0]:=22;
 ctlblk[1]:=0;       {subunit}
 ctlblk[2]:=$84;
 ctlblk[$0d]:=0;
 l:=red2hsg(cd_rom.tracks[track].start);move(l,ctlblk[$0e],4);
 l:=red2hsg(cd_rom.tracks[track].zeit); move(l,ctlblk[$12],4);
 cd_rom.play_finished:=cd_rom.tracks[track].zeit;
 cd_mscdex_use;
 cd_function_end;
end;
procedure cd_playtitle_intro(track:byte);
var l:longint;
begin
 cd_function_begin;
 fillchar(ctlblk,30,0);
 ctlblk[0]:=22;
 ctlblk[1]:=0;       {subunit}
 ctlblk[2]:=$84;
 ctlblk[$0d]:=0;
 if red2hsg(cd_rom.tracks[track].zeit)>525 then
  begin
   l:=red2hsg(cd_rom.tracks[track].start);move(l,ctlblk[$0e],4);
   l:=525;move(l,ctlblk[$12],4);
   cd_rom.play_finished.min:=0;
   cd_rom.play_finished.sec:=6;
  end
 else
  begin
   l:=red2hsg(cd_rom.tracks[track].start);move(l,ctlblk[$0e],4);
   l:=red2hsg(cd_rom.tracks[track].zeit);move(l,ctlblk[$12],4);
   cd_rom.play_finished:=cd_rom.tracks[track].zeit;
  end;
 cd_mscdex_use;
 cd_function_end;
end;
procedure cd_playtitle_midtro(track:byte);
var l:longint;rb:red_book;
begin
 cd_function_begin;
 fillchar(ctlblk,30,0);
 ctlblk[0]:=22;
 ctlblk[1]:=0;       {subunit}
 ctlblk[2]:=$84;
 ctlblk[$0d]:=0;
 if red2hsg(cd_rom.tracks[track].zeit)>1050 then
  begin
   l:=red2hsg(cd_rom.tracks[track].start)+(red2hsg(cd_rom.tracks[track].zeit)div 2);move(l,ctlblk[$0e],4);
   l:=525;move(l,ctlblk[$12],4);
   l:=red2hsg(cd_rom.tracks[track].zeit)div 2;
   inc(l,500);
   cd_rom.play_finished.min:=(l div 4500);
   cd_rom.play_finished.sec:=((l mod 4500) div 75);
  end
 else
  begin
   l:=red2hsg(cd_rom.tracks[track].start);move(l,ctlblk[$0e],4);
   l:=red2hsg(cd_rom.tracks[track].zeit);move(l,ctlblk[$12],4);
   cd_rom.play_finished:=cd_rom.tracks[track].zeit;
  end;
 cd_mscdex_use;
 {if cd_is_playing then cd_rom.akt_track:=track;}
 cd_function_end;
end;

procedure cd_stoptitle;
begin
 cd_function_begin;
 fillchar(ctlblk,30,0);
 ctlblk[0]:=25;
 ctlblk[1]:=0;       {subunit}
 ctlblk[2]:=$85;
 cd_mscdex_use;
 cd_rom.mscdstatus:=(ctlblk[4] shl 8)or(ctlblk[3]);
 cd_function_end;
end;

procedure cd_resumeplay;
begin
 cd_function_begin;
 fillchar(ctlblk,10,0);
 ctlblk[0]:=10;
 ctlblk[1]:=0;       {subunit}
 ctlblk[2]:=$88;
 cd_mscdex_use;
 cd_rom.mscdstatus:=(ctlblk[4] shl 8)or(ctlblk[3]);
 cd_function_end;
end;

procedure cd_searchfirsttrack;
begin
 cd_function_begin;
 cd_rom.akt_track:=$ff;
 for i:=cd_rom.firsttrack to cd_rom.lasttrack do
  begin
   if cd_rom.tracks[i].audio then
    begin cd_rom.akt_track:=i;cd_set_header_pos(cd_rom.tracks[i].start);
     if cd_rom.shuffle_on=false then cd_rom.player.index:=i;
     i:=cd_rom.lasttrack;
    end;
  end;
 cd_function_end;
end;
procedure cd_create_playlist_shuffle;
var dumtitles:array[1..99]of byte;i,i2,d,r,dumindex:byte;
begin
 if cd_is_playing then
  begin cd_stoptitle;cd_rom.player.action:=act_stop;cd_rom.player.modus:=mode_n;end;
 cd_rom.shufflelist.index:=1;
 randomize;for dumindex:=1 to 99 do dumtitles[dumindex]:=0;dumindex:=cd_rom.playlist.anz;
 for i:=1 to dumindex do if not(cd_rom.tracks[cd_rom.playlist.track[i]].audio) then begin dumtitles[i]:=1;dec(dumindex);end;
 cd_rom.shufflelist.anz:=dumindex;
 for i:=1 to cd_rom.shufflelist.anz do
  begin
   r:=random(dumindex)+1;
   d:=0;i2:=0;
   dec(dumindex);
   repeat inc(i2);while dumtitles[i2]=1 do inc(i2);inc(d);until d=r;
   cd_rom.shufflelist.track[i]:=cd_rom.playlist.track[i2];
   dumtitles[i2]:=1;end;
 cd_rom.akt_track:=cd_rom.shufflelist.track[cd_rom.shufflelist.index];
end;

procedure cd_create_playlist_play;
var i,i2:byte;
begin
 if cd_is_playing then
  begin cd_stoptitle;cd_rom.player.action:=act_stop;cd_rom.player.modus:=mode_n;end;
 cd_rom.playlist.mode:=mode_play;
 cd_rom.program_on:=false;
 cd_rom.player.index:=1;
 i:=cd_rom.firsttrack;i2:=1;
 repeat
  cd_rom.playlist.track[i2]:=i;if cd_rom.tracks[i].audio then inc(i2);inc(i);
 until i=cd_rom.lasttrack+1;
 cd_rom.playlist.anz:=i2-1;
 cd_rom.akt_track:=cd_rom.playlist.track[cd_rom.player.index];
 if cd_rom.shuffle_on then cd_create_playlist_shuffle;
end;
procedure cd_create_playlist_program_add(track:byte);
begin
 if cd_rom.playlist.anz<99 then
  if cd_rom.tracks[track].audio then
   begin
    cd_rom.playlist.track[cd_rom.playlist.anz+1]:=track;
    inc(cd_rom.playlist.anz);
   end;
end;
function cd_create_playlist_program_chk(idx:byte):byte;
begin
 if idx<=cd_rom.playlist.anz then
  if idx>0 then
   cd_create_playlist_program_chk:=cd_rom.playlist.track[idx];
end;
procedure cd_create_playlist_program_clr(idx:byte);
begin
 if idx<=cd_rom.playlist.anz then
  if idx>0 then
   begin
    if idx=cd_rom.playlist.anz then dec(cd_rom.playlist.anz)
    else
     begin
      for i:=idx+1 to cd_rom.playlist.anz do
       cd_rom.playlist.track[i-1]:=cd_rom.playlist.track[i];
      dec(cd_rom.playlist.anz);
     end;
   end;
end;

procedure cd_create_playlist_program;
begin
 if cd_is_playing then
  begin cd_stoptitle;cd_rom.player.action:=act_stop;cd_rom.player.modus:=mode_n;end;
 cd_rom.playlist.mode:=mode_play;
 cd_rom.program_on:=true;
 cd_rom.player.index:=1;
 cd_rom.playlist.anz:=0;
 {cd_rom.akt_track:=cd_rom.playlist.track[cd_rom.player.index];}
end;

procedure cd_goto_nextlisttitle;
begin
 if cd_rom.shuffle_on then
  begin
   if cd_rom.shufflelist.index+1>cd_rom.shufflelist.anz then
    begin cd_create_playlist_shuffle;cd_settitle(cd_rom.shufflelist.track[cd_rom.shufflelist.index]);end
   else
    begin cd_settitle(cd_rom.shufflelist.track[cd_rom.shufflelist.index+1]);inc(cd_rom.shufflelist.index);end;
  end
 else
  begin
   if cd_rom.player.index+1>cd_rom.playlist.anz then exit;
   cd_settitle(cd_rom.playlist.track[cd_rom.player.index+1]);
   inc(cd_rom.player.index);
  end;
end;
procedure cd_goto_prevlisttitle;
begin
 if cd_rom.shuffle_on then
  begin
   if cd_rom.shufflelist.index+1>cd_rom.shufflelist.anz then
    begin cd_create_playlist_shuffle;cd_settitle(cd_rom.shufflelist.track[cd_rom.shufflelist.index]);end
   else
    begin cd_settitle(cd_rom.shufflelist.track[cd_rom.shufflelist.index+1]);inc(cd_rom.shufflelist.index);end;
  end
 else
  begin
   if cd_rom.player.index-1<1 then exit;
   cd_settitle(cd_rom.playlist.track[cd_rom.player.index+1]);
   dec(cd_rom.player.index);
  end;
end;

function cd_play(mode:byte):boolean;
var i:byte;index,anz,track:byte;audio:boolean;
begin
 if cd_rom.tracks_avail=false then begin cd_rom.player.modus:=mode_nothing;cd_play:=false;exit;end;
 if cd_rom.shuffle_on then begin index:=cd_rom.shufflelist.index;anz:=cd_rom.shufflelist.anz;end
                      else begin index:=cd_rom.player.index;anz:=cd_rom.playlist.anz;end;
 if cd_rom.shuffle_on then begin if mode=act_prev then mode:=act_next;end;

 if cd_rom.repeat_mode=2 then begin if mode=act_prev then mode:=act_play;if mode=act_next then mode:=act_play;end;
 if mode=act_play then begin i:=index;end;
 if mode=act_next then
  begin i:=index+1;if i>anz then if cd_rom.repeat_mode=1 then i:=1 else begin cd_play:=true;exit;end;
   if (i=1)and(cd_rom.shuffle_on) then cd_create_playlist_shuffle;end;
 if mode=act_prev then begin i:=index-1;if i<1 then if cd_rom.repeat_mode=1 then i:=anz else begin cd_play:=true;exit;end;end;
 cd_stoptitle;

  if cd_rom.shuffle_on then track:=cd_rom.shufflelist.track[i]else track:=cd_rom.playlist.track[i];
  audio:=cd_rom.tracks[track].audio;
  if audio then
   begin
    if cd_rom.introscan_on then
     begin if cd_rom.introscan_art=0 then cd_playtitle_intro(track) else cd_playtitle_midtro(track);end
    else cd_playtitle(track);
    repeat until (cd_is_playing){or(time_out=1000)};
   end;

 if not(cd_is_playing) then
  begin
   cd_rom.player.modus:=mode_nothing;cd_play:=false;cd_rom.title_changed:=true;
  end
 else
  begin
   cd_rom.player.modus:=mode_play;cd_play:=true;cd_rom.akt_track:=track;
   if cd_rom.shuffle_on=false then cd_rom.player.index:=i else cd_rom.shufflelist.index:=i;
  end;
end;

{$f+}
procedure player_kernel_timer;
label raushier;
begin
 if (cd_rom.player.usertask=false)and(not(cd_is_playing))and(cd_rom.pausestatus=false)then
  begin
   cd_drivestatus;
   with cd_rom do
    begin if (not(door_closed))or(door_was_open) then
     begin cd_control_player;if (door_was_open)then goto raushier;end;end;
   if cd_rom.player.modus=mode_nothing then goto raushier;
   if cd_rom.player.modus=mode_play        then d:=cd_play(act_next);
   cd_rom.player.action:=act_nothing;
   cd_rom.title_changed:=true;
   if (d=false)or(cd_is_playing=false) then begin cd_rom.player.modus:=mode_nothing;cd_rom.cmd_ok:=false;end
   else cd_rom.cmd_ok:=true;
  end;
 raushier:
 cd_rom.timer_request:=false;
end;

procedure cd_set_cdrom_adress;assembler;
asm
 push ax
 push ds
 mov ax,seg(ctlblk)
 mov ds,ax
 pop ax
 mov cd_rom.oldseg,ax
 pop ax
end;
procedure cd_set_old_adress;assembler;
asm
 push ax
 mov ax,cd_rom.oldseg
 mov ds,ax
 pop ax
end;
procedure cd_start_user_timer(timer:byte;ticks:word);
begin
 if timer=1 then
  begin
   cd_rom.user_timer1:=ticks;
   cd_rom.user_timer1_click:=false;
   cd_rom.user_timer1_on:=true;
  end
 else
  begin
   cd_rom.user_timer2:=ticks;
   cd_rom.user_timer2_click:=false;
   cd_rom.user_timer2_on:=true;
  end;
end;
procedure cd_stop_user_timer(timer:byte);
begin
 if timer=1 then
  begin
   cd_rom.user_timer1:=0;
   cd_rom.user_timer1_click:=false;
   cd_rom.user_timer1_on:=false;
  end
 else
  begin
   cd_rom.user_timer2:=0;
   cd_rom.user_timer2_click:=false;
   cd_rom.user_timer2_on:=false;
  end;
end;
function cd_get_user_timer(timer:byte):boolean;
begin
 if timer=1 then
  begin cd_get_user_timer:=cd_rom.user_timer1_click;end
 else
  begin cd_get_user_timer:=cd_rom.user_timer2_click;end;
end;
procedure timer_int;
begin
 asm pop ax;end;
 asm cli;end;
 asm
  pushf
  call cd_rom.oldint
 end;
 cd_set_cdrom_adress;
 if cd_rom.user_timer1_on then begin if cd_rom.user_timer1>0 then dec(cd_rom.user_timer1) else
   begin cd_rom.user_timer1_click:=true;cd_rom.user_timer1_on:=false;end;end;
 if cd_rom.user_timer2_on then begin if cd_rom.user_timer2>0 then dec(cd_rom.user_timer2) else
   begin cd_rom.user_timer2_click:=true;cd_rom.user_timer2_on:=false;end;end;
 if cd_rom.timer_loop>0 then dec(cd_rom.timer_loop)
 else
 begin
  cd_rom.timer_loop:=cd_rom.timer_loop_val;
  if (cd_rom.handler_aktiv=1)or(cd_rom.cd_fkt_aktiv>0) then
   begin
    cd_rom.timer_request:=true;
   end
  else
   begin
    cd_rom.handler_aktiv:=1;
    cd_rom.timer_request:=false;
    player_kernel_timer;
    cd_rom.handler_aktiv:=0;
   end;
 end;
 cd_set_old_adress;
 port[$20]:=$20;
 asm sti;end;
end;

{$f-}
procedure player_kernel_user;
label raushier;
var d:boolean;
begin
 cd_function_begin;
 if cd_rom.player.usertask=false             then goto raushier;
 if cd_rom.player.action=act_exit            then begin cd_rom.player.modus:=mode_exit;cd_rom.player.action:=act_n;end;
 if cd_rom.player.action=act_exit_w_play     then begin cd_rom.player.modus:=mode_exit_w_play;cd_rom.player.action:=act_n;end;
 if cd_rom.player.action=act_vol_up          then begin cd_setvolume(cd_getvolume+2);cd_rom.player.action:=act_nothing;end;
 if cd_rom.player.action=act_vol_do          then begin cd_setvolume(cd_getvolume-2);cd_rom.player.action:=act_nothing;end;
 if cd_rom.player.action=act_drive_lock      then begin cd_lockdrive;cd_rom.player.action:=act_nothing;end;
 if cd_rom.player.action=act_drive_unlock    then begin cd_unlockdrive;cd_rom.player.action:=act_nothing;end;
 if cd_rom.player.action=act_drive_open      then begin cd_opendrive;cd_rom.player.action:=act_nothing;end;
 if cd_rom.player.action=act_drive_close     then begin cd_closedrive;cd_rom.player.action:=act_nothing;
                                                        cd_rom.door_was_open:=true;end;
 if cd_rom.player.action=act_resume          then begin cd_resumeplay;cd_rom.player.action:=act_nothing;end;
 if cd_rom.player.action=act_pause           then begin cd_stoptitle;cd_rom.player.action:=act_nothing;end;
 if cd_rom.player.action=act_reset           then begin cd_resetdrive;cd_rom.player.action:=act_nothing;end;
 if cd_rom.player.action=act_stop            then begin cd_stoptitle;cd_rom.player.action:=act_nothing;end;
 if cd_rom.player.modus=mode_nothing then
  begin
   if cd_rom.player.action=act_next          then begin cd_goto_nextlisttitle;cd_rom.player.action:=act_nothing;end;
   if cd_rom.player.action=act_prev          then begin cd_goto_prevlisttitle;cd_rom.player.action:=act_nothing;end;
  end;
 if cd_rom.player.action=act_nothing         then goto raushier;
 if cd_rom.player.modus=mode_play            then begin d:=cd_play(cd_rom.player.action);end;

 if d=false then begin cd_rom.player.modus:=mode_nothing;cd_rom.cmd_ok:=false;end else cd_rom.cmd_ok:=true;
 raushier:
 cd_rom.player.usertask:=false;cd_rom.player.action:=act_nothing;
 cd_function_end;
end;
procedure usertask;
begin
 cd_rom.player.usertask:=true;
end;

procedure command_kernel(cmd:byte);
begin
 cd_function_begin;
 cd_rom.player.usertask:=false;
 {if (cd_rom.cd_in_drive=false) or (cd_rom.door_closed=false) then exit;}
 case cmd of
  cmd_exit_w_play:begin usertask;cd_rom.player.action:=act_exit_w_play;end;
  cmd_exit       :begin usertask;cd_rom.player.action:=act_exit;end;
  cmd_drive_reset:begin usertask;cd_rom.player.action:=act_reset;end;
  cmd_stop       :begin usertask;cd_rom.player.action:=act_stop;cd_rom.player.modus:=mode_n;end;
  cmd_pause      :begin usertask;cd_rom.player.action:=act_pause;cd_rom.pausestatus:=true;end;
  cmd_resume     :begin usertask;cd_rom.player.action:=act_resume;cd_rom.pausestatus:=false;end;
  cmd_next       :begin usertask;cd_rom.player.action:=act_next;end;
  cmd_prev       :begin usertask;cd_rom.player.action:=act_prev;end;
  cmd_vol_up     :begin usertask;cd_rom.player.action:=act_vol_up;end;
  cmd_vol_down   :begin usertask;cd_rom.player.action:=act_vol_do;end;
  cmd_drive_lock   :begin usertask;cd_rom.player.action:=act_drive_lock;end;
  cmd_drive_unlock :begin usertask;cd_rom.player.action:=act_drive_unlock;end;
  cmd_drive_open   :begin usertask;cd_rom.player.action:=act_drive_open;cd_rom.player.modus:=mode_n;end;
  cmd_drive_close  :begin usertask;cd_rom.player.action:=act_drive_close;cd_rom.player.modus:=mode_n;end;

  cmd_play        :begin usertask;cd_rom.player.modus:=cd_rom.playlist.mode;cd_rom.player.action:=act_play;end;
  cmd_repeatchange:begin inc(cd_rom.repeat_mode);if cd_rom.repeat_mode=3 then cd_rom.repeat_mode:=0;end;
  cmd_progplay    :begin if cd_rom.program_on then cd_create_playlist_play else cd_create_playlist_program;end;
  cmd_introscan   :begin if cd_rom.introscan_on then cd_rom.introscan_on:=false else cd_rom.introscan_on:=true;end;
  cmd_introchange :begin if cd_rom.introscan_art=0 then cd_rom.introscan_art:=1 else cd_rom.introscan_art:=0;end;
  cmd_shuffleplay :begin if cd_rom.shuffle_on then cd_rom.shuffle_on:=false else
                        begin cd_rom.shuffle_on:=true;cd_create_playlist_shuffle;end;end;
 end;
 if cd_rom.player.usertask then player_kernel_user;
 cd_function_end;
end;
procedure cd_init_player_functions;
begin
 cd_create_playlist_play;
 cd_settitle(cd_rom.playlist.track[cd_rom.player.index]);
 cd_rom.player.modus:=mode_play;
end;

procedure cd_init_timer_kernel;
const freq=25;
var count:word;proc:pointer;
begin
 asm cli;end;
 count:=1193180 div freq;
 port[$43]:=$36;
 port[$40]:=lo(count);
 port[$40]:=hi(count);
 getintvec($08,cd_rom.oldint);
 cd_rom.handler_aktiv:=0;
 cd_rom.timer_request:=false;
 proc:=@timer_int;setintvec($08,proc);
 asm sti;end;
end;
procedure all_init_timer_kernel(proc:pointer);
begin
 asm cli;end;
 getintvec($08,cd_rom.user_oldint);
 setintvec($08,proc);
 asm sti;end;
end;
procedure all_deinit_timer_kernel;
begin
 asm cli;end;
 setintvec($08,cd_rom.user_oldint);
 asm sti;end;
end;

procedure cd_deinit_timer_kernel;
var count:word;
begin
 asm cli;end;
 setintvec($08,cd_rom.oldint);
 asm sti;end;
end;

procedure cd_unit5_init;
begin
 cd_rom.cd_fkt_aktiv:=0;
 cd_rom.door_locked:=false;
 cd_rom.door_was_open:=false;
 cd_rom.pausestatus:=false;
 cd_rom.introscan_on:=false;
 cd_rom.introscan_art:=0;
 cd_rom.shuffle_on:=false;
 cd_rom.program_on:=false;
 cd_rom.repeat_mode:=0;
 cd_rom.timer_request:=false;
 cd_rom.timer_loop_val:=18;
 cd_rom.timer_loop:=cd_rom.timer_loop_val;
 cd_rom.user_timer1:=0;
 cd_rom.user_timer1_click:=false;
 cd_rom.user_timer1_on:=false;
 cd_rom.user_timer2:=0;
 cd_rom.user_timer2_click:=false;
 cd_rom.user_timer2_on:=false;
 cd_rom.title_changed:=false;
 cd_rom.player.modus:=mode_nothing;
 cd_rom.cd_changed:=false;
 cd_rom.cmd_ok:=true;
 for i:=1 to 99 do cd_rom.tracks[i].audio:=false;
end;
