{******************************************}
{*** Demonstrationsprogramm fr WMANAGE ***}
{*** By EL NEBULOSO in January 1996     ***}
{******************************************}
program windemo;

{$L WMANAGE.OBJ}

uses crt,dos;

label start,stop;

var kommand : integer;          {An WMANAGE bergebenes Kommando}
    win : integer;              {Anzahl der gespeicherten Screens}
    winout : string;            {Ausgabestring fr Nr. geffnetes Fenster}
    xs,ys : byte;               {Koordinaten linke obere Ecke BOX}
    xe,ye : byte;               {Koordinaten rechte untere Ecke BOX}
    cf,cb : byte;               {Farbe der Ausgabe Box}
    art : byte;                 {Marker, ob Box einfach oder doppelt}
    i : integer;                {Schleifenzhler}
    cpu : registers;            {Prozessorregister fr Cursorunterdrckung}
    ch : char;
    

{----------------------------------------------------------------------------}
{Bildschirminhalt in Datensegment speichern}
function WMANAGE (kommand,win:integer):integer; external;

{----------------------------------------------------------------------------}
{Cursor an- und ausschalten}
procedure cursoff (befehl : boolean);
{bergebene Variable:}
{           befehl   > wenn true wird Cursor deaktiviert,}
{                    > wenn false wird Cursor reaktiviert}

begin;
  if befehl then begin
    cpu.ah:=$01;
    cpu.ch:=$01;
    cpu.cl:=$00;
    intr ($10,cpu);
  end
  else begin
    cpu.ah:=$01;
    cpu.ch:=13;
    cpu.cl:=14;
    intr ($10,cpu);
  end;
end;

{----------------------------------------------------------------------------}
{Box zeichnen}
procedure box (xs,ys,xe,ye,tc,tb,art : byte;text : string);
{bergebene Variablen:}
{           xs,ys   > Koordinaten linke,obere Ecke der Box}
{           xe,ye   > Koordinaten rechte,untere Ecke der Box}
{           tc,tb   > Vordergrundfarbe,Hintergrundfarbe}
{           art     > 1 = einfach, 2 = doppelt}
{           text    > berschrift der Box}

var i,j : byte;

begin;
  textcolor (tc);
  textbackground (tb);

  for i:=ys+1 to ye-1 do begin;
    gotoxy (xs,i);
    if art = 1 then writeln ('');
    if art = 2 then writeln ('');
    for j:=xs+1 to xe-1 do begin;
      gotoxy (j,i);
      writeln (' ');
    end;
    gotoxy (xe,i);
    if art = 1 then writeln ('');
    if art = 2 then writeln ('');
  end;

  for i:=xs+1 to xe-1 do begin;
    gotoxy (i,ys);
    if art = 1 then writeln ('');
    if art = 2 then writeln ('');
    gotoxy (i,ye);
    if art = 1 then writeln ('');
    if art = 2 then writeln ('');
  end;

  gotoxy (xs,ys);
  if art = 1 then writeln ('');
  if art = 2 then writeln ('');
  gotoxy (xs,ye);
  if art = 1 then writeln ('');
  if art = 2 then writeln ('');
  gotoxy (xe,ys);
  if art = 1 then writeln ('');
  if art = 2 then writeln ('');
  gotoxy (xe,ye);
  if art = 1 then writeln ('');
  if art = 2 then writeln ('');

  gotoxy (xs+1+((xe-xs-length (text)) div 2),ys);
  writeln (text);
end;

{----------------------------------------------------------------------------}
{main}
begin;
cursoff (true); {Cursor deaktivieren}
   start:

    clrscr;
    win:=0; {Fensteranzahl initialisieren}

      {Position, Farbe und Art Box ermitteln und ausgeben, Screen retten}
      for i:=1 to 10 do begin;
      xs:=random (55) + 1;
      ys:=random (18) + 1;
      xe:=xs+24;
      ye:=ys+6;
      cf:=random (14)+1;
      cb:=0;
      art:=random (2) + 1;
      str (win,winout);
      box (xs,ys,xe,ye,cf,cb,art,'Fenster:'+winout);
      cursoff (true); {Cursor deaktivieren, da von WMANAGE wieder aktiviert}
       delay (1500);
      win:=wmanage (0,win);
    end;

    {gerettet Screens ausgeben -> Fenster schlieen}
    for i:=1 to 10 do begin;
      win:=wmanage (1,win);
      cursoff (true); {Cursor deaktivieren, da von WMANAGE wieder aktiviert}
      delay (1500);
    end;
    ch:='*';
    if keypressed then ch:=readkey;
    if ch <> '*' then goto stop;
  goto start;

stop:
cursoff (false); {Cursor reaktivieren}
end.
