function pcxlesen (s:string) : byte;
{
   Liest ein Standard-PCX-File ein und stellt es auf dem Bildschirm dar.
   PCX-File MUSS 320*200 Pixel Auflsung haben! Mgliche Fehlercodes:
   $FF (255) : File nicht vorhanden.
   $FE (254) : PCX-Format nicht valid.
}

type kopf = record
     dummy1:longint;
     xstart,ystart,xende,yende:word;
     dummies0 : array[0..12] of longint;
     dummy2, bpl, dummy3:word;
     dummies1 : array[0..15] of longint; end;
var
  f:file; header : kopf;
  adder,gfxoffset:word; data,steuerlp,hilf,i,r,g,b : byte;
begin
assign(f,s);
{$i-}
reset(f,1); if (ioresult<>0) then  begin
pcxlesen:=$FF; close(f); exit; end; {$i+}

seek(f,0);                          { Header einlesen }
blockread(f,header,sizeof(header));

if (header.xstart<>0) or (header.xende<>319) or { nur 320*200 zulassen }
(header.ystart<>0) or (header.yende<>199) or
((header.dummy1 shl 24 shr 24)<>$a)             { Formatkennung }
then begin pcxlesen:=$FE; exit; end;

seek(f,filesize(f)-3*256); { Farben einlesen }
for i:=0 to 255 do
begin
blockread (f,r,1);blockread (f,g,1);blockread (f,b,1);
Port[$3c8]:=i; Port[$3c9]:=r shr 2; Port[$3c9]:=g shr 2;
Port[$3c9]:=b shr 2;
end;

seek(f,128); gfxoffset := 0; { Planes einlesen }
for i := 0 to 199 do
begin
adder:=0;
while (adder<header.bpl) do begin
blockread(f,hilf,1);
 if (hilf and 192) = 192 then begin { gepackt? }
 data:=hilf and 63; inc(adder,data); { maskieren }
 blockread(f,hilf,1);
 for steuerlp:=1 to data do begin
 mem[$a000:gfxoffset]:=hilf;
 inc(gfxoffset);
 end;
 end
 else begin
 mem[$a000:gfxoffset]:=hilf;
 inc(gfxoffset); inc(adder);
end;end;
end;
pcxlesen:=0;
close (f);
end;
