;********************************************************
;*** Speichern des Bildschirminhalts im Datensgement  ***
;*** und Auslesen des Bildschirminhalts aus Datenseg- ***
;*** ment und Ausgabe auf Bildschirm                  ***
;********************************************************

;*******************************************************************
;* von TP-Programm bernomme Werte:                                *
;* KOMMAND -> 0 = Schreiben, 1 = Lesen                             *
;* WINDOW -> Anzahl der vor Aufruf der Prozedur geffneten Fenster *
;*           wird um 1 erhht bzw. vermindert und als Funktions    *
;*           ergebnis an TP Programm zurckgegeben                 *
;*******************************************************************



.MODEL TPASCAL

.DATA
                VEKTOR DW ?     ;*** Tabellenzeiger
                SCREEN DB 40000 DUP (?)  ;*** Daten der ausgelesenen Screens
.CODE

KOMMAND         EQU [BP]+8      ;*** von TP Progr. bergebenes Kommando
WINDOW          EQU [BP]+6      ;*** Anzahl der gespeicherten Screens

WMANAGE         PROC NEAR
                PUBLIC WMANAGE
                PUSH BP
                MOV BP,SP
                PUSH DS
                PUSH SS
                MOV CH,01h      ;*** Cursor lschen
                MOV CL,00h
                MOV AH,01h
                INT 10h
                XOR AX,AX       ;*** AX-Register lschen
                MOV AX,KOMMAND  ;*** Kommando in AX Register laden

                ;*** Programmteile entsprechend Kommando ansteuern ***
                CMP AX,0000
                JE SCHREIBEN    ;*** Kommando Schreiben gegeben
                JMP LESEN       ;*** Kommando Lesen gegeben

                ;*** Screen in Feld schreiben ***
SCHREIBEN:      MOV AX,WINDOW   ;*** Anzahl der bereits geffneten Fenster auslesen
                CMP AX,0010       
                JNE M1_4        ;*** Sprung, wenn maximale Anzahl Fenster geffnet
                JMP ENDE
M1_4:           MOV AH,03h      ;*** Cursorposition ermitteln
                MOV BH,00h
                INT 10h
                PUSH DX         ;*** Position Cursor retten
                MOV AX,WINDOW   ;*** Anzahl der bereits abgelegten Screens auslesen
                CMP AX,0000     ;*** Prfe ob bereits Daten in Tabelle vorhanden
                JNE M1_1        ;*** Beginne Abtastung, wenn Vektor bereits init.
                MOV VEKTOR,0000 ;*** Vektor initialsieren
M1_1:           MOV DH,00       ;*** Y-Startposition Abtastcursor     
M1_2:           MOV DL,00       ;*** X-Startposition Abtastcursor
M1_3:           MOV AH,02h      ;*** Cursor positionieren
                MOV BH,00h
                INT 10h
                MOV AH,08h      ;*** Zeichen auslesen
                MOV BH,00h
                INT 10h
                MOV BX,VEKTOR   ;*** Ausgelesenes Zeichen in Tabelle ablegen
                MOV SCREEN[BX],AL
                MOV SCREEN[BX+1],AH
                ADD VEKTOR,02   ;*** Vektor auf nchsten zu beschr. Platz der Tabelle richten
                INC DL          ;*** X-Position Abtastcursor + 1
                CMP DL,80
                JNE M1_3        ;*** Sprung, wenn Abtastc. rechten Rand Scrn nicht erreicht
                INC DH          ;*** Y-Position Abtastcursor + 1
                CMP DH,25
                JNE M1_2        ;*** Sprung, wenn Abtastc. unteren Rand Scrn nicht erreicht
                POP DX          ;*** Cursorposition wiederholen
                MOV AH,02h      ;*** Cursor auf alte Position
                MOV BH,00h
                INT 10h
                MOV AX,WINDOW   ;*** Anzahl der vorher abgelegten Screens auslesen
                INC AX          ;*** Anzahl abgelegte Screens um 1 erhhen zwecks bergabe an TP Programm 
                JMP ENDE
                              

                ;*** Screen aus Feld auslesen und ausgeben ***
LESEN:          MOV AX,WINDOW                
                CMP AX,0000
                JE ENDE         ;*** Sprung, wenn keine Daten in Tabelle abgelegt
                DEC VEKTOR      ;*** Vektor auf Ende des zuletzt abgelegten Screens positioniern
                MOV DH,24       ;*** Y-Startposition Abtastcursor
M2_1:           MOV DL,79       ;*** X-Startposition Abtastcursor
M2_2:           MOV AH,02h      ;*** Cursor positionieren
                MOV BH,00h
                INT 10h
                MOV BX,VEKTOR   ;*** Zeichen auslesen
                MOV AH,SCREEN[BX]
                MOV BX,VEKTOR
                MOV AL,SCREEN[BX-1]
                MOV BL,AH
                SUB VEKTOR,2    ;*** Vektor auf Position des nchsten Zeichens in Tabelle
                MOV AH,09h      ;*** Zeichen ausgeben
                MOV BH,00h
                MOV CX,0001
                INT 10h
                DEC DL          ;*** X-Position Abtastcursor - 1
                CMP DL,255
                JNE M2_2        ;*** Sprung, wenn Abtastc. linken Rand Scrn. erreicht
                DEC DH          ;*** Y-Position Abtastcursor - 1
                CMP DH,255
                JNE M2_1        ;*** Sprung, wenn Abtastc. oberen Rand Scrn. erreicht
                MOV AX,WINDOW   ;*** Anzahl der vorher abgelegten Screens auslesen
                DEC AX          ;*** Anzahl abgelegte Screens um 1 vermindern zwecks bergabe an TP-Progr.
                INC VEKTOR      ;*** Vektor auf nchsten freien Speicherplatz in Tabelle positionieren

           
ENDE:           PUSH AX         ;*** Anzahl geffnete Fenster retten
                MOV CH,13       ;*** Cursor wiederherstellen
                MOV CL,14
                MOV AH,01h
                INT 10h
                POP AX          ;*** Anzahl geffnete Fenster wiederholen
                POP SS
                POP DS
                POP BP
                RET 6
WMANAGE         ENDP
                END

