//ਬ   䥪: C2H5OH Part II
//   । 

#include <mem.h>
#include <stdio.h>
#include <conio.h>
#include <math.h>

char screen[64000];
char bump[64000];
char pics[64000];
char sintable[256];
char pal[1024];

long time=0;
const double PI = 3.1415926545897932385;

void setgrmode(char x);
void setrgbpalette(char color, char r, char g, char b);
void setcolortable();
void readbmp();
void draw();
void copyvirtualscreen();
void init_mouse();
void init_sintable();
void draw_waves();

void main()
{
        init_sintable();
        readbmp();
        setgrmode(0x13);
        setcolortable();
        init_mouse();
        while(!kbhit())
        {
                draw_waves();
                draw();
                copyvirtualscreen();
                time-=16;
        }
        getch();
        setgrmode(0x3);
}

void readbmp()
{
        char c;
        FILE *in;
        in=fopen("water.bmp","rb");
        fseek(in,54,SEEK_SET);
        for(short x=0;x<256;x++)
        {
                c=fgetc(in);
                pal[(x<<2)]=c>>2;
                c=fgetc(in);
                pal[(x<<2)+1]=c>>2;
                c=fgetc(in);
                pal[(x<<2)+2]=c>>2;
                c=fgetc(in);
        }
        for(short y=199;y>=0;y--)
                for(short x=0;x<320;x++)
                {
                        c=fgetc(in);
                        pics[x+320*y]=c;
                }
        fclose(in);
}

void setgrmode(char x)
{
        _asm
        {
                xor ax,ax
                mov al,x
                int 10h
        }
}

void setrgbpalette(char color, char r, char g, char b)
{
        _asm
        {
                mov dx,0x3C8
                mov al,color
                out dx,al
                inc dx
                mov al,r
                out dx,al
                mov al,g
                out dx,al
                mov al,b
                out dx,al
        }
}

void setcolortable()
{
        for(short k=0;k<256;k++)
                setrgbpalette(k,pal[(k<<2)+2],pal[(k<<2)+1],pal[(k<<2)]);
}

void draw()
{
        long scr=321;
        long dx,dy;
        for(long y=1;y<199;y++)
        {
                for(long x=1;x<319;x++)
                {
                        dx=((bump[scr+1]-bump[scr-1]))+x;
                        dy=((bump[scr+320]-bump[scr-320]))+y;
                        if(dx<0) dx=0;
                        if(dx>319) dx=319;
                        if(dy<0) dy=0;
                        if(dy>199) dy=199;
                        screen[scr]=pics[dx+(dy<<6)+(dy<<8)];
                        scr++;
                }
                scr+=2;
        }
}

void init_mouse()
{
        _asm
        {
                mov eax,0x7
                mov ecx,0x0
                mov edx,0x13F
                int 33h
                mov eax,0x8
                mov ecx,0x0
                mov edx,0xC7
                int 33h
                mov eax,0x4
                mov ecx,0xA0
                mov edx,0x64
                int 33h
        }
}

void init_sintable()
{
        for(long k=0;k<256;k++)
                sintable[k]=sin(2*PI*k/256)*127+128;
}

void draw_waves()
{
        long x,y;
        long mx,my;
        long dr,r;
        long scr=0;
        _asm
        {
                xor ecx,ecx
                xor edx,edx
                mov eax,0x3
                int 0x33
                mov mx,ecx
                mov my,edx
        }
        for(y=0;y<200;y++)
        {
                r=(y-my)*(y-my)+mx*mx;
                dr=-mx<<1;
                for(x=0;x<320;x++)
                {
                        bump[scr++]=sintable[(time+(r>>5))&0xFF]>>2;
                        dr+=2;
                        r+=dr;
                }
        }
}

void copyvirtualscreen()
{
        _asm
        {
                mov dx,3DAh
        a:in al,dx
                test al,8
                jnz a
                mov dx,3DAh
        b:in al,dx
                test al,8
                jz b
        }
        memcpy((char*)0xA0000,screen,64000);
}