//ਬ   ": BLOWS"

#include <conio.h>
#include <math.h>

unsigned char screen[64000];
unsigned char blow[65536];

void setgrmode(char x);
void setrgbpalette(char color, char r, char g, char b);
void copyvirtualscreen();
void clearvirtualscreen();
void initblow();
void drawblow(long x,long y);
void setcolortable();

void main()
{
  long x,y;
  float time=0;
  initblow();
  setgrmode(0x13);
  setcolortable();
  while(!kbhit())
  {
    clearvirtualscreen();
    x=32+92*sin(time*0.5+1.0);
    y=-28+58*cos(time*1.5+2.0);
    drawblow(x,y);
    x=32+92*sin(time*1.0+1.5);
    y=-28+58*cos(time*2.0+2.5);
    drawblow(x,y);
    x=32+92*sin(time*1.5+2.0);
    y=-28+58*cos(time*2.5+3.0);
    drawblow(x,y);
    x=32+92*sin(time*2.0+2.5);
    y=-28+58*cos(time*3.0+0.5);
    drawblow(x,y);
    x=32+92*sin(time*2.5+3.0);
    y=-28+58*cos(time*0.5+1.0);
    drawblow(x,y);
    x=32+92*sin(time*3.0+0.5);
    y=-28+58*cos(time*1.0+1.5);
    drawblow(x,y);
    time+=0.02;
    copyvirtualscreen();
  }
  getch();
  setgrmode(0x3);
}

void setgrmode(char x)
{
  _asm
  {
    xor ax,ax
    mov al,x
    int 10h
  }
}

void setrgbpalette(char color, char r, char g, char b)
{
  _asm
  {
    mov dx,0x3C8
    mov al,color
    out dx,al
    inc dx
    mov al,r
    out dx,al
    mov al,g
    out dx,al
    mov al,b
    out dx,al
  }
}

void setcolortable()
{
  for(long k=0;k<64;k++)
    setrgbpalette(k,0,k,0);
}

void copyvirtualscreen()
{
  _asm
  {
    mov dx,3DAh
  a:in al,dx
    test al,8
    jnz a
    mov dx,3DAh
  b:in al,dx
    test al,8
    jz b
    cld
    mov edi,0xA0000
    mov esi,offset screen
    mov ecx,16000
    rep movsd
  }
}

void clearvirtualscreen()
{
  _asm
  {
    cld
    mov ecx,16000
    mov edi,offset screen
    mov eax,0x00000000
    rep stosd
  }
}

void initblow()
{
  long c;
  for(long y=0;y<256;y++)
    for(long x=0;x<256;x++)
    {
      c=(16384/((x-128)*(x-128)+(y-128)*(y-128)+256));
      if(c>63) c=63;
      blow[x+(y<<8)]=c;
    }
}

void drawblow(long dx,long dy)
{
  long c,s;
  long minx=0;
  if(dx<0) minx=-dx;
  long miny=0;
  if(dy<0) miny=-dy;
  long maxx=320-dx;
  if(maxx>255) maxx=255;
  long maxy=200-dy;
  if(maxy>255) maxy=255;
  for(long y=miny;y<maxy;y++)
    for(long x=minx;x<maxx;x++)
    {
      s=(x+dx)+((y+dy)<<6)+((y+dy)<<8);
      c=screen[s]+blow[x+(y<<8)];
      if(c>63) c=63;
      screen[s]=c;
    }
}