{$A+,B-,D-,E-,F-,G+,I-,L-,N-,O-,P-,Q-,R-,S-,T-,V-,X-}
{$M 1024,0,0}
{ Texts' corrector for articles given to any mag. }
{ Author: Astra / Absence. This is freeware! Spread it! }

uses Dos;

var
   f1, f2: Text;
   n1, n2: string;
   st,mth: string;
       cn: Byte;
      dir: SearchRec;


function IsMark(ch: char): Boolean;
begin
   if (ch<>'!') and (ch<>';') and (ch<>'?') and (ch<>',') and (ch<>'.') and
      (ch<>':') then IsMark := True
   else IsMark := False;
end;


procedure CorrectChars;
begin
     while Pos(#9, st)<>0 do
     begin
           for cn := 0 to (7-(Pos(#9, st)-1) mod 8) do
               Insert(' ', st, Pos(#9, st)+1);
           Delete(st, Pos(#9, st), 1);
     end;
     while Pos(#255, st)<>0 do
           st[Pos(#255, st)]:=' ';
end;


procedure CorrectBrackets(b1, b2: Char);
begin
     cn := 1;
     repeat
           if st[cn] = b1 then
              if (cn <> Length(st)) then
                 while (st[cn + 1]=' ') do
                       Delete(st, cn + 1, 1);
           if st[cn]=b2 then
              if (cn <> 1) then
                 while (st[cn-1]=' ') do
                 begin
                      Delete(st, cn - 1, 1);
                      Dec(cn);
                 end;
           Inc(cn);
     until (cn > Length(st));
end;


procedure CorrectMarks;
var
   mark: Boolean;
begin
     mark := False;
     cn := 1;
     repeat
           if st[cn]='"' then
              case mark of
                   False:
                        if (cn <> Length(st)) then
                           while (st[cn + 1]=' ') do
                                Delete(st, cn + 1, 1);
                   True:
                        if (cn <> 1) then
                           while (st[cn-1]=' ') do
                           begin
                                Delete(st, cn - 1, 1);
                                Dec(cn);
                           end;
              end;
           Mark := not Mark;
           Inc(cn);
     until (cn > Length(st));
end;


procedure CorrectSpaces;
begin
     cn := 1;
     repeat
           while (st[cn]<>' ') and (cn< Length(st)) do
                 Inc(cn);
           while (st[cn + 1]=' ') and (cn< Length(st)) do
                 Delete(st, cn + 1, 1);

           Inc(cn);
     until (cn >= Length(st));
end;


procedure CorrectCommas;
begin
     cn := 1;
     repeat
           case st[cn] of
           '!',';','?',',','.',':':
                               begin
                                    while (st[cn - 1]=' ') do
                                    begin
                                         Delete(st, cn - 1, 1);
                                         Dec(cn);
                                    end;
                                    if (st[cn + 1] <> ' ') and (cn <> Length(st))
                                       and not IsMark(st[cn + 1]) then
                                       Insert(' ', st, cn + 1);
                               end;
           end;
           Inc(cn);
     until (cn > Length(st));
end;


procedure CorrectMinus;
begin
     cn := 1;
     repeat
           while (st[cn]<>'-') and (cn <= Length(st)) do
                 Inc(cn);
           if (cn <> 1) and (cn <= Length(st)) and (st[cn - 1] <> ' ') then
              Insert(' ', st, cn - 1);
           if (cn < Length(st)) and (st[cn +1] <> ' ') then
              Insert(' ', st, cn + 1);
           Inc(cn);
     until (cn > Length(st));
end;


procedure ProcessLine;
begin
     ReadLn(f1, st);
   {  CorrectSpaces;              }     {zbedna ilosc spacji}
   {  CorrectBrackets('(',')');   }     {przyklejenie ()}
   {  CorrectBrackets('[',']');   }     {przyklejenie []}
   {  CorrectBrackets('<','>');   }     {przyklejenie <>}
   {  CorrectCommas;              }     {koreksja znakow przest.}
   {  CorrectMarks;               }     {korekta cudzyslowow ""}
   {  CorrectMinus;               }     {dodanie spacji przy minusie}
     CorrectChars;                     {zlikwidowanie TAB i #255}
     WriteLn(f2, st);
end;


procedure ProcessFile;
begin
     n2:=n1;
     Delete(n2,Pos('.',n2),4);
     n2 := n2 + '.naw';
     Assign(f1, n1);
     Assign(f2, n2);
     Reset(f1);
     Rewrite(f2);
     Writeln(n1);
     while (not Eof(f1)) do
           ProcessLine;
     Close(f2);
     Close(f1);
end;


begin
     if (ParamCount <> 1) then Halt;
     if (Pos('*',ParamStr(1))<>0) then
     begin
          mth := ParamStr(1);
          FindFirst(mth, AnyFile, dir);
          if (DosError <> 0) then Halt;
          while (DosError = 0) do
          with dir do
          begin
               if (Attr and Directory = 0) and (Attr and VolumeID = 0) then
               begin
                    n1 := Name;
                    ProcessFile;
               end;
               FindNext(dir);
          end;
     end
     else
     begin
         n1 := ParamStr(1);
         ProcessFile;
     end;
end.
