Function UpString(s: String): String;
Var
  i: Integer;
  tmp: String;
  c: Char;
Begin
  tmp:='';
  For i:=1 to Length(s) do
  Begin
    c:=UpCase(s[i]);
    tmp:=tmp+c;
  End;
  UpString:=tmp;
End;


Procedure PrepPal(Farbe: String);
Var
  i: Integer;
Begin
  Farbe:=UpString(Farbe);
  If Farbe = 'GELB' then
  Begin
    For i:=16 to 172 do
    If i > 133 then
       ChangePal(i, 63, (i-70), 0)
    Else
    If i < 70 then
      ChangePal(i, 0, 0, 0)
    Else
      ChangePal(i, i-70, (i-70), 0);
  End
  Else If Farbe='GRUEN' then
  Begin
    For i:=16 to 172 do
    If i > 133 then
       ChangePal(i, 0, 63, 0)
    Else
    If i < 70 then
      ChangePal(i, 0, 1, 0)
    Else
      ChangePal(i, 0, (i-70), 0);
  End
  Else If Farbe='ROT' then
  Begin
    For i:=16 to 172 do
    If i > 133 then
       ChangePal(i, 63, 0, 0)
    Else
    If i < 70 then
      ChangePal(i, 1, 0, 0)
    Else
      ChangePal(i, i-70, 0, 0);
  End
  Else If Farbe='BLAU' then
  Begin
    For i:=16 to 172 do
    If i > 133 then
       ChangePal(i, 0, 0, 63)
    Else
    If i < 70 then
      ChangePal(i, 0, 0, 1)
    Else
      ChangePal(i, 0, 0, i-70);
  End
  Else If Farbe='VIOLETT' then
  Begin
    For i:=16 to 172 do
    If i > 133 then
       ChangePal(i, (i-70) shr 1, 0, 63)
    Else
    If i < 70 then
      ChangePal(i, 0, 0, 1)
    Else
      ChangePal(i, (i-70) shr 1, 0, i-70);
  End
  Else If Farbe='WEISS' then
  Begin
    For i:=16 to 172 do
    If i > 133 then
       ChangePal(i, 63, 63, 63)
    Else
    If i < 70 then
      ChangePal(i, 1, 1, 1)
    Else
      ChangePal(i, i-70, i-70, i-70);
  End
  Else LoadGif(Farbe, 0, 32000);
End;




Const
  maxPoints = 80;
  maxLines  = 160;
  maxFaces  = 80;

Type
  TVektor = Array[1..3] of Longint;
  PFeld = Array[1..maxPoints] of Integer;
  LFeld = Array[1..maxLines,1..2]  of Integer;
  FFeld = Array[1..maxFaces,1..4]  of Integer;
  eFeld = Array[1..maxPoints] of Integer;
  nFeld = Array[1..maxFaces] of Longint;
  sFeld = Array[1..maxFaces] of Integer;   {Sortierfeld}
  PFigur = ^tFigur;
  tFigur = Object
             nop, nol, nof: Word;     {Anzahl Punkte, Kanten, Flchen}
             Vierecke: Byte;          {0: Dreiecke; 1: Vierecke}
             uxko, uyko, uzko: PFeld; {Urbildkoordinaten}
             bxko, byko, bzko: PFeld; {Transf. Koordinaten}
             xb, yb: PFeld;           {Bildkoordinaten}
             zSum, RF: sFeld;         {Summe der zkos der Flchen}
             Normalen: nFeld;         {zKoords der Normalenvektoren}
             Kanten: LFeld;
             Flaechen: FFeld;
             Farben: sFeld;
             Eckfarben, EckfarbenCount: eFeld;
             l: TVektor;              {Licht}
             li: Longint;             {Betrag des Lichtvektors}
             xscal, yscal, zscal: Integer;
             model, texname: String;
             Procedure Init(Filename, ObjName: String);
             Procedure Abbilden;
             Procedure Darstellen(Farbe: Byte);
             Procedure Quicksort(Lo, Hi: Integer);
             Procedure DarstFlaechen(alle: Boolean);
             Procedure DarstShade(alle: Boolean);
             Procedure DarstGouraud(alle: Boolean);
             Procedure DarstTextures(alle: Boolean);
             Procedure DrehenX(Winkel: Integer);
             Procedure DrehenY(Winkel: Integer);
             Procedure DrehenZ(Winkel: Integer);
           End;


Procedure KreuzProd(a1, a2, a3, b1, b2, b3: Integer; Var v: TVektor); Assembler;
asm
  les di, v
  {n1:=a2*b3-a3*b2}
  mov ax, a2
  imul b3
  db $66, $0f, $ac, $d3, $10  {shrd ebx, edx, $10}
  mov bx, ax
  db $66
  mov ax, a3
  imul b2
  db $66, $0f, $ac, $d1, $10  {shrd ecx, edx, $10}
  mov cx, ax
  db $66
  sub bx, cx
  db $66
  mov es:[di], bx
  {n2:=a3*b1-a1*b3}
  mov ax, a3
  imul b1
  db $66, $0f, $ac, $d3, $10  {shrd ebx, edx, $10}
  mov bx, ax
  db $66
  mov ax, a1
  imul b3
  db $66, $0f, $ac, $d1, $10  {shrd ecx, edx, $10}
  mov cx, ax
  db $66
  sub bx, cx
  db $66
  mov es:[di+4], bx
  {n3:=a1*b2-a2*b1}
  mov ax, a1
  imul b2
  db $66, $0f, $ac, $d3, $10  {shrd ebx, edx, $10}
  mov bx, ax
  db $66
  mov ax, a2
  imul b1
  db $66, $0f, $ac, $d1, $10  {shrd ecx, edx, $10}
  mov cx, ax
  db $66
  sub bx, cx
  db $66
  mov es:[di+8], bx
End;


Function SkalProd(a1, a2, a3, b1, b2, b3: Integer): Longint; Assembler;
{Skalarprodukt zweier Vektoren, Ergebnis in DX:AX}
asm
  mov ax, a1
  imul b1
  db $66, $0f, $ac, $d3, $10  {shrd ebx, edx, $10}
  mov bx, ax
  mov ax, a2
  imul b2
  db $66, $0f, $ac, $d1, $10  {shrd ecx, edx, $10}
  mov cx, ax
  mov ax, a3
  imul b3
  db $66, $0f, $ac, $d6, $10  {shrd esi, edx, $10}
  mov si, ax
  db $66
  add bx, cx
  db $66
  add bx, si
  mov ax, bx
  db $66, $0f, $a4, $da, $10  {shld edx, ebx, $10}
End;


Function Heron(a: Longint): Integer; Assembler;
{Heronverfahren fr Wurzel}
asm
  db $66             {xn1:=a div 2+1;}
  mov bx, Word Ptr a
  db $66
  or bx, bx          {a=0: das war's}
  jz @Ende
  db $66
  mov si, bx
  db $66
  shr bx, 1
  db $66
  inc bx
 @Schleife:
  db $66
  mov bx, ax         {xn:=xn1;}
  db $66
  mov ax, si         {xn1:=(xn+a div xn) div 2;}
  db $66
  xor dx, dx
  db $66
  div bx
  db $66
  add ax, bx
  db $66
  shr ax, 1
  db $66
  sub bx, ax         {|xn-xn1|>1 -> Rcksprung}
  db $66
  shr bx, 1
  jnz @Schleife
 @Ende:
End;


Function Betrag(Var v: TVektor): Integer;
Var
  l: Longint;
Begin
  l:=SkalProd(v[1], v[2], v[3], v[1], v[2], v[3]);
  Betrag:=Heron(l);
End;
 

  Procedure tFigur.Init(Filename, ObjName: String);

  Var
    i, tmp: Integer;
    f: Text;
    s: String;
  Begin
    xscal:=100; yscal:=100; zscal:=100;
    l[1]:=4; l[2]:=8; l[3]:=256;
    li:=Betrag(l);
    ObjName:=UpString(ObjName);
    If Pos('.', Filename)=0 then
      Filename:=Filename+'.koo';
    Assign(f, Filename);
    Reset(f); s:='';
    While s<>ObjName do
    Begin
      readln(f, s);
      While Pos(' ',s)<>0 do
        Delete(s, Pos(' ',s), 1);
      s:=UpString(s);
    End;
    While not (EOF(f) or (s='OBJEND')) do
    Begin
      Readln(f, s);
      While Pos(' ',s)<>0 do
        Delete(s, Pos(' ',s), 1);
      s:=UpString(s);
      If s='KOORDS' then
      Begin
        readln(f, nop);
        For i:=1 to nop do
          readln(f, uxko[i], uyko[i], uzko[i]);
      End;
      If s='LINES' then
      Begin
        readln(f, nol);
        For i:=1 to nol do
          readln(f, Kanten[i,1], Kanten[i,2]);
      End;
      If s='FACES' then
      Begin
        readln(f, nof);
        For i:=1 to nof do
          readln(f, Flaechen[i,1], Flaechen[i,2],
                    Flaechen[i,3], Flaechen[i,4]);
      End;
      If s='SCAL' then
      Begin
        readln(f, xscal);
        readln(f, yscal);
        readln(f, zscal);
      End;
      If s='MODEL' then
      Begin
        readln(f, model);
        readln(f, s);
        model:=UpString(model);
        If model='DRAHT' then
          readln(f, Farben[1]);
        If (model='FLAECHEN') or (model='TEXTURE') then
          For i:=1 to nof do
            readln(f, Farben[i]);
      End;
    End;
    Close(f);
    Movsw(uxko, bxko, nop);
    Movsw(uyko, byko, nop);
    Movsw(uzko, bzko, nop);
  End;


  Procedure tFigur.Abbilden;
  {zko=256 wird hier ausgeschlossen!}

    Procedure Zentral(x, y, z: Integer; Var xs, ys); Assembler;
    asm
      mov cx, 256      {Nenner:=256-bzko[i];}
      sub cx, z
      or cx, cx
      jz @vergisses
      mov ax, x      {xb[i]:=(bxko[i] shl 8-bzko[i] shl 2) div Nenner+159;}
      sal ax, 8
      mov bx, z
      sal bx, 2
      sub ax, bx
      cwd
      idiv cx
      add ax, 159
      les di, xs
      mov es:[di], ax
      mov ax, y      {yb[i]:=100-(byko[i] shl 8-bzko[i] shl 3) div Nenner;}
      sal ax, 8
      sal bx, 1
      sub ax, bx
      cwd
      idiv cx
      neg ax
      add ax, 100
      les di, ys
      mov es:[di], ax
     @vergisses:
    End;

  Var
    i: Integer;
  Begin
    For i:=1 to nop do
      Zentral(bxko[i], byko[i], bzko[i], xb[i], yb[i]);
  End;


  Procedure tFigur.Darstellen(Farbe: Byte);
  Var
    i: Integer;
  Begin
    For i:=1 to nol do
      BLine(xb[Kanten[i,1]], yb[Kanten[i,1]],
            xb[Kanten[i,2]], yb[Kanten[i,2]], Farbe);
  End;


  Procedure tFigur.Quicksort(Lo,Hi: integer);

    Procedure Swap(Var a, b); Assembler;
    {schneller als ber Hilfsvariable}
    asm
      les si, a
      les di, b
      mov ax, es:[di]
      xchg ax, es:[si]
      mov es:[di], ax
    End;

    Procedure Sort(l,r: integer);
    Var
      i, j, x: Integer;
    Begin
      i:=l; j:=r; x:=zsum[(l+r) shr 1];
      Repeat
        While zsum[i]<x do inc(i);
        While x<zsum[j] do dec(j);
        If i<=j then
        Begin
          Swap(zsum[i], zsum[j]);
          Swap(RF[i], RF[j]);
          asm
            inc i
            dec j
          End;
        End;
      Until i>j;
      If l<j then Sort(l,j);
      If i<r then Sort(i,r);
    End;

  Begin
    sort(Lo,Hi);
  End;


  Procedure tFigur.DarstFlaechen(alle: Boolean);
  Var
    i, k, a1, a2, a3,
    b1, b2, b3, c1, c2, c3: Integer;
    v: TVektor;
  Begin
    For i:=1 to nof do
    Begin
      zsum[i]:=bzko[Flaechen[i,1]]+bzko[Flaechen[i,2]]
              +bzko[Flaechen[i,3]]+bzko[Flaechen[i,4]];
      RF[i]:=i;
      c1:=bxko[Flaechen[i,2]];
      c2:=byko[Flaechen[i,2]];
      c3:=bzko[Flaechen[i,2]];
      a1:=bxko[Flaechen[i,1]]-c1;
      a2:=byko[Flaechen[i,1]]-c2;
      a3:=bzko[Flaechen[i,1]]-c3;
      b1:=bxko[Flaechen[i,3]]-c1;
      b2:=byko[Flaechen[i,3]]-c2;
      b3:=bzko[Flaechen[i,3]]-c3;
      KreuzProd(a1, a2, a3, b1, b2, b3, v);
      Normalen[i]:=v[3];
    End;
    Quicksort(1, nof);
    For i:=1 to nof do  {nur die Hlfte der Flchen darstellen}
    Begin
      k:=RF[i];
      If alle or (Normalen[k]>=0) then
      Begin
        KillRand;
        col:=Farben[k];
        Markieren(xb[Flaechen[k,1]], yb[Flaechen[k,1]],
                  xb[Flaechen[k,2]], yb[Flaechen[k,2]]);
        Markieren(xb[Flaechen[k,2]], yb[Flaechen[k,2]],
                  xb[Flaechen[k,3]], yb[Flaechen[k,3]]);
        Markieren(xb[Flaechen[k,3]], yb[Flaechen[k,3]],
                  xb[Flaechen[k,4]], yb[Flaechen[k,4]]);
        If (xb[Flaechen[k,4]]<>xb[Flaechen[k,1]]) or
           (yb[Flaechen[k,4]]<>yb[Flaechen[k,1]]) then
          Markieren(xb[Flaechen[k,4]], yb[Flaechen[k,4]],
                    xb[Flaechen[k,1]], yb[Flaechen[k,1]]);
        FillRand;
      End;
    End;
  End;


  Procedure tFigur.DarstShade(alle: Boolean);
  Var
    i, k, a1, a2, a3,
    b1, b2, b3, c1, c2, c3: Integer;
    v: TVektor;
    tmp: Longint;
  Begin
    For i:=1 to nof do
    Begin
      zsum[i]:=bzko[Flaechen[i,1]]+bzko[Flaechen[i,2]]
              +bzko[Flaechen[i,3]]+bzko[Flaechen[i,4]];
      RF[i]:=i;
      {Farben[i]:=85+zsum[i] div 6;}
      c1:=bxko[Flaechen[i,2]];
      c2:=byko[Flaechen[i,2]];
      c3:=bzko[Flaechen[i,2]];
      a1:=bxko[Flaechen[i,1]]-c1;
      a2:=byko[Flaechen[i,1]]-c2;
      a3:=bzko[Flaechen[i,1]]-c3;
      b1:=bxko[Flaechen[i,3]]-c1;
      b2:=byko[Flaechen[i,3]]-c2;
      b3:=bzko[Flaechen[i,3]]-c3;
      KreuzProd(a1, a2, a3, b1, b2, b3, v);
      tmp:=SkalProd(v[1], v[2], v[3], l[1], l[2], l[3]);
      Normalen[i]:=tmp;
      tmp:=abs(tmp shl 6 div (li*Betrag(v)));
      {Flche mu im Uhrzeigersinn orientiert sein!}
      If v[3]<0 then
        Farben[i]:=65-Byte(tmp)
      Else
        Farben[i]:=65+Byte(tmp);
    End;
    Quicksort(1, nof);
    For i:=1 to nof do
    Begin
      k:=RF[i];
      If alle or (Normalen[k]>=0) then
      Begin
        KillRand;
        col:=Farben[k];
        Markieren(xb[Flaechen[k,1]], yb[Flaechen[k,1]],
                  xb[Flaechen[k,2]], yb[Flaechen[k,2]]);
        Markieren(xb[Flaechen[k,2]], yb[Flaechen[k,2]],
                  xb[Flaechen[k,3]], yb[Flaechen[k,3]]);
        Markieren(xb[Flaechen[k,3]], yb[Flaechen[k,3]],
                  xb[Flaechen[k,4]], yb[Flaechen[k,4]]);
        If (xb[Flaechen[k,4]]<>xb[Flaechen[k,1]]) or
           (yb[Flaechen[k,4]]<>yb[Flaechen[k,1]]) then
        Markieren(xb[Flaechen[k,4]], yb[Flaechen[k,4]],
                  xb[Flaechen[k,1]], yb[Flaechen[k,1]]);
        FillRand;
      End;
    End;
  End;


  Procedure tFigur.DarstTextures(alle: Boolean);
  {nur fr Vierecke brauchbar}
  Var
    i, k, f1, f2, f3,
    g1, g2, g3, h1, h2, h3: Integer;
    v: TVektor;
  Begin
    For i:=1 to nof do
    Begin
      zsum[i]:=bzko[Flaechen[i,1]]+bzko[Flaechen[i,2]]
              +bzko[Flaechen[i,3]]+bzko[Flaechen[i,4]];
      RF[i]:=i;
      h1:=bxko[Flaechen[i,2]];
      h2:=byko[Flaechen[i,2]];
      f1:=bxko[Flaechen[i,1]]-h1;
      f2:=byko[Flaechen[i,1]]-h2;
      g1:=bxko[Flaechen[i,3]]-h1;
      g2:=byko[Flaechen[i,3]]-h2;
      Normalen[i]:=f1*g2-g1*f2;
    End;
    Quicksort(1, nof);
    For i:=1 to nof do  {nur die Hlfte der Flchen darstellen}
    Begin
      k:=RF[i];
      If alle or (Normalen[k]>=0) then
      TexturePoly(xb[Flaechen[k,1]], yb[Flaechen[k,1]],
                  xb[Flaechen[k,2]], yb[Flaechen[k,2]],
                  xb[Flaechen[k,3]], yb[Flaechen[k,3]],
                  xb[Flaechen[k,4]], yb[Flaechen[k,4]], Farben[k]);
    End;
  End;


  Procedure tFigur.DarstGouraud(alle: Boolean);
  Var
    i, k, a1, a2, a3, 
    b1, b2, b3, c1, c2, c3: Integer;
    v: TVektor;
    tmp1: Longint; tmp2: Integer;
    col1, col2, col3, col4: Integer;
  Begin
    For i:=1 to nof do
    Begin
      zsum[i]:=bzko[Flaechen[i,1]]+bzko[Flaechen[i,2]]
              +bzko[Flaechen[i,3]]+bzko[Flaechen[i,4]];
      RF[i]:=i;
      {Farben[i]:=85+zsum[i] div 6;}
      c1:=bxko[Flaechen[i,2]];
      c2:=byko[Flaechen[i,2]];
      c3:=bzko[Flaechen[i,2]];
      a1:=bxko[Flaechen[i,1]]-c1;
      a2:=byko[Flaechen[i,1]]-c2;
      a3:=bzko[Flaechen[i,1]]-c3;
      b1:=bxko[Flaechen[i,3]]-c1;
      b2:=byko[Flaechen[i,3]]-c2;
      b3:=bzko[Flaechen[i,3]]-c3;
      KreuzProd(a1, a2, a3, b1, b2, b3, v);
      tmp1:=SkalProd(v[1], v[2], v[3], l[1], l[2], l[3]);
      tmp2:=Integer(abs(tmp1 shl 6 div (li*Betrag(v))));
      Normalen[i]:=tmp1;
      If v[3]<0 then Farben[i]:=70-tmp2 Else
        Farben[i]:=70+tmp2;
    End;
    FillWord(Eckfarben, nop, 0);
    FillWord(EckfarbenCount, nop, 0);
    For i:=1 to nof do
      For k:=1 to 4 do
      Begin
        Inc(Eckfarben[Flaechen[i,k]], Farben[i]);
        Inc(EckfarbenCount[Flaechen[i,k]]);
      End;
    For i:=1 to nop do
    Begin
      Eckfarben[i]:=Eckfarben[i] div EckfarbenCount[i];
      If Eckfarben[i]>145 then Eckfarben[i]:=145;
    End;
    Quicksort(1, nof);
    For i:=1 to nof do
    Begin
      k:=RF[i];
      If alle or (Normalen[k]>=0) then
      Begin
        KillRand;
        col1:=Eckfarben[Flaechen[k,1]];
        col2:=Eckfarben[Flaechen[k,2]];
        col3:=Eckfarben[Flaechen[k,3]];
        col4:=Eckfarben[Flaechen[k,4]];
        InterpolRand(xb[Flaechen[k,1]], yb[Flaechen[k,1]],
                  xb[Flaechen[k,2]], yb[Flaechen[k,2]], col1, col2);
        InterpolRand(xb[Flaechen[k,2]], yb[Flaechen[k,2]],
                  xb[Flaechen[k,3]], yb[Flaechen[k,3]], col2, col3);
        InterpolRand(xb[Flaechen[k,3]], yb[Flaechen[k,3]],
                  xb[Flaechen[k,4]], yb[Flaechen[k,4]], col3, col4);
        If (xb[Flaechen[k,4]]<>xb[Flaechen[k,1]]) or
           (yb[Flaechen[k,4]]<>yb[Flaechen[k,1]]) then
        InterpolRand(xb[Flaechen[k,4]], yb[Flaechen[k,4]],
                  xb[Flaechen[k,1]], yb[Flaechen[k,1]], col4, col1);
        GouraudFill;
      End;
    End;
  End;


  Procedure tFigur.DrehenX(Winkel: Integer);
  Var
    i, y, y0, z0, z: Integer;
  Begin
    For i:=1 to nop do
    Begin
      y0:=byko[i]; z0:=bzko[i];
      asm
        {y:=(y0*cosin[Winkel]-z0*sinus[Winkel]) div 128;}
        mov di, Winkel
        shl di, 1
        mov bx, Offset cosin
        mov si, [bx+di]
        mov ax, y0
        imul si
        mov cx, ax
        mov bx, Offset sinus
        add bx, di
        mov ax, [bx]
        imul z0
        sub cx, ax
        sar cx, 7
        mov y, cx
        {z:=(y0*sinus[Winkel]+z0*cosin[Winkel]) div 128;}
        mov ax, [bx]
        imul y0
        mov cx, ax
        mov ax, z0
        imul si
        add cx, ax
        sar cx, 7
        mov z, cx
      End;
      byko[i]:=y;
      bzko[i]:=z;
    End;
  End;


  Procedure tFigur.DrehenY(Winkel: Integer);
  Var
    i, y, y0, z0, z: Integer;
  Begin
    For i:=1 to nop do
    Begin
      y0:=bxko[i]; z0:=bzko[i];
      asm
        {y:=(y0*cosin[Winkel]-z0*sinus[Winkel]) div 128;}
        mov di, Winkel
        shl di, 1
        mov bx, Offset cosin
        mov si, [bx+di]
        mov ax, y0
        imul si
        mov cx, ax
        mov bx, Offset sinus
        add bx, di
        mov ax, [bx]
        imul z0
        sub cx, ax
        sar cx, 7
        mov y, cx
        {z:=(y0*sinus[Winkel]+z0*cosin[Winkel]) div 128;}
        mov ax, [bx]
        imul y0
        mov cx, ax
        mov ax, z0
        imul si
        add cx, ax
        sar cx, 7
        mov z, cx
      End;
      bxko[i]:=y;
      bzko[i]:=z;
    End;
  End;


  Procedure tFigur.DrehenZ(Winkel: Integer);
  Var
    i, y, y0, z0, z: Integer;
  Begin
    For i:=1 to nop do
    Begin
      y0:=bxko[i]; z0:=byko[i];
      asm
        {y:=(y0*cosin[Winkel]-z0*sinus[Winkel]) div 128;}
        mov di, Winkel
        shl di, 1
        mov bx, Offset cosin
        mov si, [bx+di]
        mov ax, y0
        imul si
        mov cx, ax
        mov bx, Offset sinus
        add bx, di
        mov ax, [bx]
        imul z0
        sub cx, ax
        sar cx, 7
        mov y, cx
        {z:=(y0*sinus[Winkel]+z0*cosin[Winkel]) div 128;}
        mov ax, [bx]
        imul y0
        mov cx, ax
        mov ax, z0
        imul si
        add cx, ax
        sar cx, 7
        mov z, cx
      End;
      bxko[i]:=y;
      byko[i]:=z;
    End;
  End;
