
Const
  maxTextures = 6;

Type
  pTexture = ^tTexture;
  tTexture = Array[0..4095] of Byte;

Var
  Texturen: Array[1..maxTextures] of pTexture;


Procedure GetTexture(page: Byte; x1, y1: Integer; Var t: tTexture);
Var
  i, k: Integer;
Begin
  For i:=0 to 63 do
    For k:=0 to 63 do
      t[(63-i)+k*64]:=Get_Point(i+x1, k+y1, page);
End;


Procedure PrepTextures(Bildname: String; fpos: Longint);
Var
  i, x, y: Integer;
Begin
  pakt:=0; vp:=0;
  KillScreen;
  Switch(pakt);
  LoadGif(Bildname, fpos, 32000);
  x:=0; y:=0; i:=0;
  Repeat
    inc(i);
    GetMem(Texturen[i], SizeOf(tTexture));
    GetTexture(2, x, y, Texturen[i]^);
    x:=x+64;
    If x=320 then
    Begin
      x:=0;
      y:=y+64;
    End;
  Until i=maxTextures;
End;


Procedure CloseTextures;
Var
  i: Integer;
Begin
  For i:=1 to maxTextures do
    If Texturen[i]<>nil then
      FreeMem(Texturen[i], SizeOf(tTexture));
End;


Procedure TexturePoly(x1, y1, x2, y2, x3, y3, x4, y4: Integer; nr: Integer);

  Procedure Affin(x1, y1, x2, y2, x3, y3: Integer; phase: Byte);
  Var
    a1, a2, b1, b2, det,
    tx1, ty1, tx2, ty2, addx, addy: Longint;
    i, xmax, yoffset, n, m: Integer;
    tSeg, tOffset: Word;
  Begin
    KillRand;
    tOffset:=Ofs(Texturen[nr]^);
    tSeg:=Seg(Texturen[nr]^);
    markieren(x1,y1,x2,y2);                  { dreieck markieren }
    markieren(x2,y2,x3,y3);
    markieren(x3,y3,x1,y1);
    a1:=Longint(x1-x2);                          { basisvektor 1 }
    a2:=Longint(y1-y2);
    b1:=Longint(x3-x2);                          { basisvektor 2 }
    b2:=Longint(y3-y2);
    asm
      mov si, $A000    {Bildschirmsegment}
      mov es, si
      mov ax, tseg     {Texturesegment}
      db $8e, $e8      {mov gs, ax}
      db $66
      mov ax, Word Ptr b1       {det:=a1*b2-b1*a2;}
      db $66
      imul Word Ptr a2
      db $66
      mov si, ax
      db $66
      mov ax, Word Ptr a1
      db $66
      imul Word Ptr b2
      db $66
      sub ax, si
      db $66
      or ax, ax
      jz @Das_wars         {det=0: Scheie war's!}
      db $66
      mov Word Ptr det, ax
      mov ax, x1        {xmin:=x1;}
      cmp x2, ax        {if x2<xmin then xmin:=x2;}
      jge @l1
      mov ax, x2
     @l1:
      cmp x3, ax        {if x3<xmin then xmin:=x3;}
      jge @l2
      mov ax, x3
     @l2:
      mov i, ax
      mov bx, x1        {xmax:=x1;}
      cmp x2, bx        {if x2>xmax then xmax:=x2;}
      jle @l3
      mov bx, x2
     @l3:
      cmp x3, bx        {if x3>xmax then xmax:=x3;}
      jle @l4
      mov bx, x3
     @l4:
      mov xmax, bx
     @Outer_Loop:
        {m:=rand0[i];}
        mov si, ax
        mov di, si
        shl si, 1
        mov bx, Word Ptr rand0[si]
        mov m, bx
        {n:=rand1[i];}
        mov bx, Word Ptr rand1[si]
        mov n, bx
        sub di, Word Ptr x2             {c1:=i-x2;}
        db $66            {Vorzeichen anpassen}
        shl di, 16
        db $66
        sar di, 16
        {c2:=m-y2;}
        db $66, $0f, $bf, $8e, $ca, $ff      {movsx ecx, Word Ptr m}
        db $66, $0f, $bf, $86, $0c, $00      {movsx, eax, Word Ptr y2}
        db $66
        sub cx, ax
        {tx1:=(c1*b2-b1*c2) shl 14 div det;}
        db $66
        mov ax, Word Ptr b1
        db $66
        imul cx
        db $66
        mov si, ax
        db $66
        mov ax, Word Ptr b2
        db $66
        imul di
        db $66
        sub ax, si
        db $66
        sal ax, 14
        db $66
        cwd
        db $66
        idiv Word Ptr det
        db $66
        mov Word Ptr tx1, ax
        {ty1:=(a1*c2-c1*a2) shl 14 div det;}
        db $66
        mov ax, Word Ptr a2
        db $66
        imul di
        db $66
        mov si, ax
        db $66
        mov ax, Word Ptr a1
        db $66
        imul cx
        db $66
        sub ax, si
        db $66
        sal ax, 14
        db $66
        cwd
        db $66
        idiv Word Ptr det
        db $66
        mov Word Ptr ty1, ax
        {c2:=m-y2;}
        db $66, $0f, $bf, $4e, $cc           {movsx ecx, Word Ptr n}
        db $66, $0f, $bf, $86, $0c, $00      {movsx eax, Word Ptr y2}
        db $66
        sub cx, ax
        db $66
        {tx2:=(c1*b2-b1*c2) shl 14 div det;}
        db $66
        mov ax, Word Ptr b1
        db $66
        imul cx
        db $66
        mov si, ax
        db $66
        mov ax, Word Ptr b2
        db $66
        imul di
        db $66
        sub ax, si
        db $66
        sal ax, 14
        db $66
        cwd
        db $66
        idiv Word Ptr det
        db $66
        mov Word Ptr tx2, ax
        {ty2:=(a1*c2-c1*a2) shl 14 div det;}
        db $66
        mov ax, Word Ptr a2
        db $66
        imul di
        db $66
        mov si, ax
        db $66
        mov ax, Word Ptr a1
        db $66
        imul cx
        db $66
        sub ax, si
        db $66
        sal ax, 14
        db $66
        cwd
        db $66
        idiv Word Ptr det
        db $66
        mov Word Ptr ty2, ax
        {addx:=(tx2-tx1) div (rand1[i]-rand0[i]);}
        mov bx, n
        sub bx, m
        or bx, bx
        je @kein_div
        db $66
        mov ax, Word Ptr tx2
        db $66
        sub ax, Word Ptr tx1
        db $66
        cwd
        db $66
        idiv bx
        db $66
        mov Word Ptr addx, ax
        {addy:=(ty2-ty1) div (rand1[i]-rand0[i]);}
        db $66
        mov ax, Word Ptr ty2
        db $66
        sub ax, Word Ptr ty1
        db $66
        cwd
        db $66
        idiv bx
        db $66
        mov Word Ptr addy, ax
       @kein_div:
        mov cx, i            {Plane der x-Ko in AH bestimmen}
        mov di, cx
        and cx, 3
        mov ax, 100000010b
        shl ah, cl
        mov dx, $3c4           {Plane einschalten}
        out dx, ax
        mov ax, 80           {yoffset:=m*80+i shr 2;}
        mul m
        shr di, 2
        add di, ax
        add di, vp
        mov si, tOffset         {Textureoffset auf tx1}
        db $66
        shl si, 8
        db $66
        mov cx, Word Ptr tx1
        db $66
        add cx, si
        db $66
        mov dx, Word Ptr ty1
        cmp phase, 1        {if phase=1 then}
        jne @Inner_Loop
        sub cx, 64*256            {tx:=63-tx;}
        neg cx
        sub dx, 64*256          {ty:=63-ty;}
        neg dx
        neg Word Ptr addx
        neg Word Ptr addy
       @Inner_Loop:
          mov al, ch          {tx:=tx1 shr 8;}
          mov si, dx          {ty:=ty1 shr 8;}
          shr si, 2
          add cx, Word Ptr addx        {tx1:=tx1+addx;}
          add dx, Word Ptr addy        {ty1:=ty1+addy;}
          and si, 63*64        {Rand bereinigen}
          and ax, 63
          add si, ax
          db $65, $8a, $04    {mov al, gs:[si]}
          mov es:[di], al
          add di, 80
          dec bx
        jns @Inner_Loop
        inc i
        mov ax, i
        cmp ax, xmax
      jle @Outer_Loop
     @Das_wars:
    End;
  End;


Begin
  Affin(x1, y1, x2, y2, x3, y3, 0);
  Affin(x3, y3, x4, y4, x1, y1, 1);
End;
