Unit Font;

Interface

  type Tschrift=array[0..255,0..7] of Byte;
       Tschrift8x16=array[0..255,0..15] of Byte;
       Tmodes = (G8x8,G8x14,G8x16);
       TLoaded=record
         bpz:Byte;
         data:Pointer;
       end;

  Procedure Load_Fontfile(dateiname:string;var tabelle:pointer);
  Procedure SchriftLaden(bpz,block:Byte;zeichen,erstes:Word;var tabelle);
  Procedure StandardSchrift(mode:Tmodes;block:Byte);
  Procedure WaehleSchrift(block:Byte);

  const schrift: Tschrift= (
                           (  0,  0,  0,  0,  0,  0,  0,  0),
                           (126,129,165,129,189,153,129,126),
                           (126,255,219,255,195,231,255,126),
                           ( 68,238,254,254,124, 56, 16,  0),
                           ( 16, 56,124,254,124, 56, 16,  0),
                           ( 24, 60,219,255,219, 24, 60,  0),
                           ( 24, 60,126,255,126, 24, 60,  0),
                           (  0,  0, 60, 60, 60, 60,  0,  0),
                           (255,255,195,195,195,195,255,255),
                           (  0,126, 66, 66, 66, 66,126,  0),
                           (255,129,189,189,189,189,129,255),
                           ( 15,  7,  7,125,204,204,204,120),
                           (120,204,204,204,120, 48,252, 48),
                           ( 31, 51, 63, 48, 48,112,240,224),
                           ( 63, 99,127, 99, 99,103,230,192),
                           (219,219, 60,231,231, 60,219,219),
                           (192,240,248,254,248,240,192,  0),
                           (  6, 30, 62,254, 62, 30,  6,  0),
                           ( 48,120,252, 48, 48,252,120, 48),
                           (108,108,108,108,108,  0,108,  0),
                           (127,219,219,219,123, 27, 27,  0),
                           ( 60, 96, 60,102,102, 60,  6, 60),
                           (  0,  0,  0,  0,254,254,254,  0),
                           ( 24, 60,126, 24,126, 60, 24,126),
                           ( 48,120,252, 48, 48, 48, 48,  0),
                           ( 48, 48, 48, 48,252,120, 48,  0),
                           (  0,  8, 12,254, 12,  8,  0,  0),
                           (  0, 32, 96,254, 96, 32,  0,  0),
                           (  0,  0,192,192,254,  0,  0,  0),
                           (  0, 36, 66,255, 66, 36,  0,  0),
                           (  0, 16, 56,124,254,254,  0,  0),
                           (  0,254,254,124, 56, 16,  0,  0),
                           (  0,  0,  0,  0,  0,  0,  0,  0),
                           ( 24, 24, 24, 24, 24,  0, 24,  0),
                           (204,204,204,  0,  0,  0,  0,  0),
                           ( 54,108,254,108,254,108,216,  0),
                           ( 24,126,192,124,  6,252, 48,  0),
                           (194,198, 12, 24, 48,102,198,  0),
                           ( 56,108, 56,112,222,204,118,  0),
                           ( 48, 48, 96,  0,  0,  0,  0,  0),
                           ( 12, 24, 48, 48, 48, 24, 12,  0),
                           ( 48, 24, 12, 12, 12, 24, 48,  0),
                           (  0,108, 56,254, 56,108,  0,  0),
                           (  0, 24, 24,126, 24, 24,  0,  0),
                           (  0,  0,  0,  0,  0, 24, 24, 48),
                           (  0,  0,  0,126,  0,  0,  0,  0),
                           (  0,  0,  0,  0,  0, 24, 24,  0),
                           (  2,  6, 12, 24, 48, 96,192,  0),
                           (124,198,198,198,198,198,124,  0),
                           ( 24, 56, 24, 24, 24, 24,126,  0),
                           (124,198,  6, 28,112,198,254,  0),
                           (124,198,  6, 28,  6,198,124,  0),
                           ( 28, 60,108,204,254, 12, 12,  0),
                           (254,192,252,  6,  6,198,124,  0),
                           ( 60, 96,192,252,198,198,124,  0),
                           (254,198, 12, 24, 48, 48, 48,  0),
                           (124,198,198,124,198,198,124,  0),
                           (124,198,198,126,  6, 12,120,  0),
                           (  0, 24, 24,  0,  0, 24, 24,  0),
                           (  0, 24, 24,  0,  0, 24, 24, 48),
                           ( 12, 24, 48, 96, 48, 24, 12,  0),
                           (  0,  0,126,  0,  0,126,  0,  0),
                           ( 48, 24, 12,  6, 12, 24, 48,  0),
                           ( 60,102,  6, 12, 24,  0, 24,  0),
                           (124,198,222,222,222,192,124,  0),
                           ( 56,108,198,198,254,198,198,  0),
                           (252,198,198,252,198,198,252,  0),
                           (124,198,198,192,192,198,124,  0),
                           (248,204,198,198,198,204,248,  0),
                           (254,192,192,252,192,192,254,  0),
                           (254,192,192,252,192,192,192,  0),
                           (124,198,192,206,198,198,126,  0),
                           (198,198,198,254,198,198,198,  0),
                           (120, 48, 48, 48, 48, 48,120,  0),
                           ( 30,  6,  6,  6,198,198,124,  0),
                           (198,204,216,240,216,204,198,  0),
                           (192,192,192,192,192,192,254,  0),
                           (198,238,254,214,198,198,198,  0),
                           (198,230,246,222,206,198,198,  0),
                           (124,198,198,198,198,198,124,  0),
                           (252,198,198,252,192,192,192,  0),
                           (124,198,198,198,198,198,124,  6),
                           (252,198,198,252,198,198,198,  0),
                           (120,204, 96, 48, 24,204,120,  0),
                           (252, 48, 48, 48, 48, 48, 48,  0),
                           (198,198,198,198,198,198,124,  0),
                           (198,198,198,198,198,108, 56,  0),
                           (198,198,198,214,254,238,198,  0),
                           (198,198,108, 56,108,198,198,  0),
                           (195,195,102, 60, 24, 24, 24,  0),
                           (254, 12, 24, 48, 96,192,254,  0),
                           ( 60, 48, 48, 48, 48, 48, 60,  0),
                           (192, 96, 48, 24, 12,  6,  3,  0),
                           ( 60, 12, 12, 12, 12, 12, 60,  0),
                           (  0, 56,108,198,  0,  0,  0,  0),
                           (  0,  0,  0,  0,  0,  0,  0,255),
                           ( 48, 48, 24,  0,  0,  0,  0,  0),
                           (  0,  0,124,  6,126,198,126,  0),
                           (192,192,252,198,198,230,220,  0),
                           (  0,  0,124,198,192,192,126,  0),
                           (  6,  6,126,198,198,206,118,  0),
                           (  0,  0,124,198,254,192,126,  0),
                           ( 30, 48,124, 48, 48, 48, 48,  0),
                           (  0,  0,126,198,206,118,  6,124),
                           (192,192,252,198,198,198,198,  0),
                           ( 24,  0, 56, 24, 24, 24, 60,  0),
                           ( 24,  0, 56, 24, 24, 24, 24,240),
                           (192,192,204,216,240,216,204,  0),
                           ( 56, 24, 24, 24, 24, 24, 60,  0),
                           (  0,  0,204,254,214,198,198,  0),
                           (  0,  0,252,198,198,198,198,  0),
                           (  0,  0,124,198,198,198,124,  0),
                           (  0,  0,252,198,198,230,220,192),
                           (  0,  0,126,198,198,206,118,  6),
                           (  0,  0,110,112, 96, 96, 96,  0),
                           (  0,  0,124,192,124,  6,252,  0),
                           ( 48, 48,124, 48, 48, 48, 28,  0),
                           (  0,  0,198,198,198,198,126,  0),
                           (  0,  0,198,198,198,108, 56,  0),
                           (  0,  0,198,198,214,254,108,  0),
                           (  0,  0,198,108, 56,108,198,  0),
                           (  0,  0,198,198,206,118,  6,124),
                           (  0,  0,252, 24, 48, 96,252,  0),
                           ( 14, 24, 24,112, 24, 24, 14,  0),
                           ( 48, 48, 48,  0, 48, 48, 48,  0),
                           (112, 24, 24, 14, 24, 24,112,  0),
                           (  0,118,220,  0,  0,  0,  0,  0),
                           ( 16, 56,108,198,198,198,254,  0),
                           (120,204,192,204,120, 24, 12,120),
                           (  0,204,  0,204,204,204,126,  0),
                           ( 28,  0,120,204,252,192,120,  0),
                           (126,195, 60,  6, 62,102, 63,  0),
                           (204,  0,120, 12,124,204,126,  0),
                           (224,  0,120, 12,124,204,126,  0),
                           ( 48, 48,120, 12,124,204,126,  0),
                           (  0,  0,120,192,192,120, 12, 56),
                           (126,195, 60,102,126, 96, 60,  0),
                           (204,  0,120,204,252,192,120,  0),
                           (224,  0,120,204,252,192,120,  0),
                           (204,  0,112, 48, 48, 48,120,  0),
                           (124,198, 56, 24, 24, 24, 60,  0),
                           (224,  0,112, 48, 48, 48,120,  0),
                           (198, 56,108,198,254,198,198,  0),
                           ( 48, 48,  0,120,204,252,204,  0),
                           ( 28,  0,252, 96,120, 96,252,  0),
                           (  0,  0,127, 12,127,204,127,  0),
                           ( 62,108,204,254,204,204,206,  0),
                           (120,204,  0,120,204,204,120,  0),
                           (  0,204,  0,120,204,204,120,  0),
                           (  0,224,  0,120,204,204,120,  0),
                           (120,204,  0,204,204,204,126,  0),
                           (  0,224,  0,204,204,204,126,  0),
                           (  0,204,  0,204,204,124, 12,248),
                           (195, 24, 60,102,102, 60, 24,  0),
                           (204,  0,204,204,204,204,120,  0),
                           ( 24, 24,126,192,192,126, 24, 24),
                           ( 56,108,100,240, 96,230,252,  0),
                           (204,204,120,252, 48,252, 48, 48),
                           (248,204,204,250,198,207,198,199),
                           ( 14, 27, 24, 60, 24, 24,216,112),
                           ( 28,  0,120, 12,124,204,126,  0),
                           ( 56,  0,112, 48, 48, 48,120,  0),
                           (  0, 28,  0,120,204,204,120,  0),
                           (  0, 28,  0,204,204,204,126,  0),
                           (  0,248,  0,248,204,204,204,  0),
                           (252,  0,204,236,252,220,204,  0),
                           ( 60,108,108, 62,  0,126,  0,  0),
                           ( 56,108,108, 56,  0,124,  0,  0),
                           ( 48,  0, 48, 96,192,204,120,  0),
                           (  0,  0,  0,252,192,192,  0,  0),
                           (  0,  0,  0,252, 12, 12,  0,  0),
                           (195,198,204,222, 51,102,204, 15),
                           (195,198,204,219, 55,111,207,  3),
                           ( 24, 24,  0, 24, 24, 24, 24,  0),
                           (  0, 51,102,204,102, 51,  0,  0),
                           (  0,204,102, 51,102,204,  0,  0),
                           ( 34,136, 34,136, 34,136, 34,136),
                           ( 85,170, 85,170, 85,170, 85,170),
                           (219,119,219,238,219,119,219,238),
                           ( 24, 24, 24, 24, 24, 24, 24, 24),
                           ( 24, 24, 24, 24,248, 24, 24, 24),
                           ( 24, 24,248, 24,248, 24, 24, 24),
                           ( 54, 54, 54, 54,246, 54, 54, 54),
                           (  0,  0,  0,  0,254, 54, 54, 54),
                           (  0,  0,248, 24,248, 24, 24, 24),
                           ( 54, 54,246,  6,246, 54, 54, 54),
                           ( 54, 54, 54, 54, 54, 54, 54, 54),
                           (  0,  0,254,  6,246, 54, 54, 54),
                           ( 54, 54,246,  6,254,  0,  0,  0),
                           ( 54, 54, 54, 54,254,  0,  0,  0),
                           ( 24, 24,248, 24,248,  0,  0,  0),
                           (  0,  0,  0,  0,248, 24, 24, 24),
                           ( 24, 24, 24, 24, 31,  0,  0,  0),
                           ( 24, 24, 24, 24,255,  0,  0,  0),
                           (  0,  0,  0,  0,255, 24, 24, 24),
                           ( 24, 24, 24, 24, 31, 24, 24, 24),
                           (  0,  0,  0,  0,255,  0,  0,  0),
                           ( 24, 24, 24, 24,255, 24, 24, 24),
                           ( 24, 24, 31, 24, 31, 24, 24, 24),
                           ( 54, 54, 54, 54, 55, 54, 54, 54),
                           ( 54, 54, 55, 48, 63,  0,  0,  0),
                           (  0,  0, 63, 48, 55, 54, 54, 54),
                           ( 54, 54,247,  0,255,  0,  0,  0),
                           (  0,  0,255,  0,247, 54, 54, 54),
                           ( 54, 54, 55, 48, 55, 54, 54, 54),
                           (  0,  0,255,  0,255,  0,  0,  0),
                           ( 54, 54,247,  0,247, 54, 54, 54),
                           ( 24, 24,255,  0,255,  0,  0,  0),
                           ( 54, 54, 54, 54,255,  0,  0,  0),
                           (  0,  0,255,  0,255, 24, 24, 24),
                           (  0,  0,  0,  0,255, 54, 54, 54),
                           ( 54, 54, 54, 54, 63,  0,  0,  0),
                           ( 24, 24, 31, 24, 31,  0,  0,  0),
                           (  0,  0, 31, 24, 31, 24, 24, 24),
                           (  0,  0,  0,  0, 63, 54, 54, 54),
                           ( 54, 54, 54, 54,255, 54, 54, 54),
                           ( 24, 24,255, 24,255, 24, 24, 24),
                           ( 24, 24, 24, 24,248,  0,  0,  0),
                           (  0,  0,  0,  0, 31, 24, 24, 24),
                           (255,255,255,255,255,255,255,255),
                           (  0,  0,  0,  0,255,255,255,255),
                           (240,240,240,240,240,240,240,240),
                           ( 15, 15, 15, 15, 15, 15, 15, 15),
                           (255,255,255,255,  0,  0,  0,  0),
                           (  0,  0,118,220,200,220,118,  0),
                           (  0,120,204,248,204,248,192,192),
                           (  0,252,204,192,192,192,192,  0),
                           (  0,254,108,108,108,108,108,  0),
                           (252,204, 96, 48, 96,204,252,  0),
                           (  0,  0,126,216,216,216,112,  0),
                           (  0,102,102,102,102,124, 96,192),
                           (  0,118,220, 24, 24, 24, 24,  0),
                           (252, 48,120,204,204,120, 48,252),
                           ( 56,108,198,254,198,108, 56,  0),
                           ( 56,108,198,198,108,108,238,  0),
                           ( 28, 48, 24,124,204,204,120,  0),
                           (  0,  0,126,219,219,126,  0,  0),
                           (  6, 12,126,219,219,126, 96,192),
                           ( 56, 96,192,248,192, 96, 56,  0),
                           (120,204,204,204,204,204,204,  0),
                           (  0,252,  0,252,  0,252,  0,  0),
                           ( 48, 48,252, 48, 48,  0,252,  0),
                           ( 96, 48, 24, 48, 96,  0,252,  0),
                           ( 24, 48, 96, 48, 24,  0,252,  0),
                           ( 14, 27, 27, 24, 24, 24, 24, 24),
                           ( 24, 24, 24, 24, 24,216,216,112),
                           ( 48, 48,  0,252,  0, 48, 48,  0),
                           (  0,118,220,  0,118,220,  0,  0),
                           ( 56,108,108, 56,  0,  0,  0,  0),
                           (  0,  0,  0, 24, 24,  0,  0,  0),
                           (  0,  0,  0,  0, 24,  0,  0,  0),
                           ( 15, 12, 12, 12,236,108, 60, 28),
                           (120,108,108,108,108,  0,  0,  0),
                           (112, 24, 48, 96,120,  0,  0,  0),
                           (  0,  0, 60, 60, 60, 60,  0,  0),
                           (  0,  0,  0,  0,  0,  0,  0,  0));

Implementation

uses Dos;

Procedure SchriftLaden(bpz,block:Byte;zeichen,erstes:Word;var tabelle);
var r:registers;
begin
  with r do begin
    ah:=$11;
    al:=0;
    bh:=bpz; { bytes pro zeichen }
    bl:=block;
    cx:=zeichen;
    dx:=erstes;
    es:=seg(tabelle);
    bp:=ofs(tabelle);
  end;
  intr($10,r);
end;

Procedure StandardSchrift(mode:Tmodes;Block:Byte);
var r:registers;
begin
  with r do begin
    ah:=$11;
    case mode of
      G8x8:al:=2;
      G8x14:al:=1;
      G8x16:al:=4;
    end;
    bl:=block;
  end;
  intr($10,r);
end;

Procedure WaehleSchrift(block:Byte);
var r:registers;
    bit01,bit2:Byte;
begin
  bit01:=block and $3;
  bit2:=(block shr 2) and 1;
  with r do begin
    ah:=$11;
    bl:=(bit01) or (bit01 shl 2) or (bit2 shl 4) or (bit2 shl 5);
  end;
  intr($10,r);
end;

Procedure Load_Fontfile(dateiname:string;var tabelle:pointer);
var datei:file;
begin
  assign(datei,dateiname);
  {$I-}
  reset(datei,1);
  if IOResult<>0 then exit;
  {$I+}
    getmem(tabelle,filesize(datei)+1);
    Tloaded(tabelle^).bpz:=filesize(datei) div 256;
    Blockread(datei,Tloaded(tabelle^).data,filesize(datei));
  close(datei);
end;

end.
