;Rhddsmuc.blk
;Hdd driver for smuc ide controller.
;(c) Oleg Grigoriev AKA Ruiner AKA #0R
;Version: 1.2
;Creating date: 02-Jan-1999
;Last edit: 22-June-1999
;************************************************************;

                ORG     #8000

                DEFW    INST
                DEFW    READ
                DEFW    WRIT
                DEFW    INIT
                DEFB    #E0
                DEFB    #04
                DEFW    #0000
                DEFW    #0101
                DEFW    #0000

                DEFW    #DEAD           ;SIGNAT         ; +10
CONST           DEFB    #00             ;CQHEAD         ; +12 +00+
                DEFB    #00             ;CQSEC          ; +13 +01+
QHDSC           DEFW    #0000           ;CQHEAD * CQSEC ; +14 +02+
MGMR            DEFB    #08             ;MQHEAD         ; +16 +04
                DEFB    #27             ;MQSEC          ; +17 +05
                DEFW    #0138           ;MQHEAD * MQSEC ; +18 +06
SGMR            DEFB    #0F             ;SQHEAD         ; +1A +08
                DEFB    #16             ;SQSEC          ; +1B +09
                DEFW    #014A           ;SQHEAD * SQSEC ; +1C +0A

CDEV            DEFW    #0000           ;CYLL           ; +1E +0C
                DEFB    #00             ;HEAD           ; +20 +0E+
                DEFB    #00             ;SEC            ; +21 +0F+
                DEFB    #00             ;DRV            ; +22 +10+

DEVS            DEFB    #01,#02,#06,#15,#A0             ; +23 +11
                DEFB    #6A,#02,#06,#1D,#A0             ; +28 +16
                DEFB    #00,#00,#01,#04,#B0             ; +2D +1B
                DEFB    #63,#00,#05,#0E,#B0             ; +32 +20
                DEFB    #00,#00,#00,#01,#B0             ; +37 +25
                DEFB    #00,#00,#00,#01,#B0             ; +3C +2A
                DEFB    #00,#00,#00,#01,#B0             ; +41 +2F
                DEFB    #00,#00,#00,#01,#B0             ; +46 +34

                DEFB    #00             ;INT            ; +4B +39+

;------------------------------------------------------------;
CQHEAD          EQU     +#00
CQSEC           EQU     +#01
HEAD            EQU     +#0E
SEC             EQU     +#0F
DRV             EQU     +#10
INT             EQU     +#39

BLKSZ           EQU     #08

;**************************************************************;
;
INST    
INIT            CP      #08             ;   8 ன.
                RET     NC

                LD      C,A             ; 㥬 ࠬ
                ADD     A,A             ; ᮮ⢥饣
                ADD     A,A             ; ன⢠  
                ADD     A,C             ; ࠬ஢ ⥪饣
                LD      C,A             ; ன⢠.
                LD      B,#00
                LD      HL,DEVS
                ADD     HL,BC
                LD      DE,CDEV
                LD      C,#05
                LDIR

                DEC     HL              ; 㥬 ࠬ
                BIT     4,(HL)          ; ᮮ⢥饣
                LD      HL,MGMR         ; ᪠.
                JR      Z,$+#05
                LD      HL,SGMR
                LD      DE,CONST
                LD      C,#04
                LDIR

                RET

;************************************************************;
;
;   ⥪   hl, bc!
;
SETDI           LD      HL,SETEI        ; 室 १ .
                EX      (SP),HL
                LD      (ERROR+#01),SP  ;
                PUSH    HL
                LD      HL,SETDI0       ;  맮.
                PUSH    HL
                LD      IX,CONST
                XOR     A               ; ஢ઠ ०
                LD      (IX+INT),A      ; 뢠.
                LD      A,R
                RET     PE
                LD      A,R
                RET     PE
                INC     (IX+INT)
                RET

SETDI0          DI
                LD      A,#04           ; 뢠  .
                LD      BC,#1FFD
                OUT     (C),A
WBSY            LD      BC,#FFBE        ; ⥭ ॣ -
                IN      A,(C)           ; ﭨ.
                RLCA                    ;   BSY.
                JR      C,$-#03
                RET

SETEI           PUSH    AF
                XOR     A               ; 뢠  .
                LD      BC,#1FFD
                OUT     (C),A
                POP     AF
                BIT     0,(IX+INT)      ; ⠭ -
                RET     NZ              ;  뢠.
                EI
                RET

;************************************************************;
;
READ            LD      C,#7C           ; ⥭.
                DEFB    #3A
WRIT            LD      C,#7D           ; .

                PUSH    BC
                LD      C,#09           ; ஢ઠ 
                RST     #10             ; - .
                POP     BC
                JR      Z,L000
                CP      #16             ;  break?
                JR      NZ,L000
                LD      C,#07           ; ࠥ  
                RST     #10             ; .
                LD      A,#14           ; break.
                SCF
                RET

L000
                PUSH    DE              ;  .
                EXX
                POP     DE
                CALL    SETDI
                SRL     D               ; DE -  ᥪ.
                RR      E               ; A' -  -
                EX      AF,AF'          ; .
                LD      BC,(QHDSC)      ; BC - - ᥪ஢
                                        ;  樫.

                LD      HL,#0000        ;  DE  BC 
                LD      A,#10           ; ᥭ ⭮
DIV             RL      E               ;  BC,  ⪠  HL.
                RL      D
                ADC     HL,HL
                SBC     HL,BC
                JR      NC,$+#03
                ADD     HL,BC
                DEC     A
                JR      NZ,DIV
                LD      A,E
                RLA
                CPL
                LD      C,A
                LD      A,D
                RLA                     ; BC - ᬥ饭  -
                CPL                     ; .
                LD      B,A             ; HL - ⮪.

                LD      E,(IX+CQSEC)    ; E - - ᥪ஢
                XOR     A               ;  ஦.
                LD      D,A             ;  HL  DE.
                DEC     A
                SBC     HL,DE
                INC     A
                JR      NC,$-#03        ; D - ᬥ饭 
                ADD     HL,DE           ; .
                LD      D,A             ; L - ⮪.

                INC     E               ; ⢮ ᥪ஢
                                        ;  ஦ + 1.
                LD      A,L             ; ᬥ饭  ᥪ.
                ADD     A,(IX+SEC)      ; +  砫쭮.
                CP      E               ;  ᨬ쭮
                                        ; ?
                JR      C,$+#05         ; .
                DEC     E               ; 塞  -
                SUB     E               ;   ᫥饩
                                        ; .
                INC     D               ; ᫥. .
                LD      E,A             ;  ᥪ  E.

                LD      A,D             ; ᬥ饭  .
                ADD     A,(IX+HEAD)     ; +  砫쭮.
                CP      (IX+CQHEAD)     ;  ᨬ쭮?
                JR      C,$+#06         ; .
                SUB     (IX+CQHEAD)     ; ४㥬 
                INC     BC              ;   樫.

                OR      (IX+DRV)        ; +  ᪠.
                LD      HL,(CDEV)       ; 砫 樫.
                ADD     HL,BC           ; + ᬥ饭.
                CALL    PCOORD          ;  न 
                                        ; ॣ 䥩.

;---------------------------------------
;
                EXX                     ; hl - .
                EX      AF,AF'          ; b - ᫮ .
                                        ;  - ⨯ 樨.
                                        ; cf - ᬥ饭  ࢮ
                                        ;      ᥪ.
                LD      D,B
                JR      NC,$+#03        ; ᫨  ।, 
                DEC     D               ; 㬥蠥 ⢮
                                        ; .
                RLA                     ;  ᬥ饭.

                SRL     D               ; ⢮ ᥪ஢.
                RLA                     ;  ⮪ 
                LD      E,A             ;    e.

                BIT     1,E             ; ᫨  ।, 
                JR      Z,$+#03         ; 㢥稢 ⢮
                INC     D               ; ᥪ஢.

                SCF                     ;  㥬
                RR      C               ; c  砥  
                                        ;  .
                JR      C,HDDW          ;  cf - ⨯ 樨.

;***************************************
;
HDDR            EX      AF,AF'
                LD      A,#20           ; Read Sector(s).
                EX      AF,AF'
                AND     #01             ;  墮.
                ADD     A,D
                CALL    WKSEC0          ; 뤠 .

                BIT     1,E             ;  ?
                JR      Z,HDDR01        ; .
                CALL    SKIP            ; ய 1- 
                                        ; ᥪ.
                LD      A,#10           ; ⥭ .

HDDR00          CALL    RDHALF+#02      ;   .
                DEC     D
HDDR01          INC     D               ;  楫 ᥪ?
                DEC     D
                JR      Z,HDDR02        ; .
                CALL    WAIT            ;  ⮢.
                LD      A,#20           ; ⠥ 楫 ᥪ.
                JR      HDDR00

HDDR02          BIT     0,E             ;  墮?
                RET     Z               ; .
                CALL    WAIT            ;  ⮢.
                CALL    RDHALF          ; ⠥ 墮.

;***************************************
;skipping half of sector with speed 6.875 tact's per byte
;
SKIP            LD      A,#10
                LD      B,#F8
SKIP0           DEFB    #ED,#70       ;IN F,(C)
                DEFB    #ED,#70
                DEFB    #ED,#70
                DEFB    #ED,#70
                DEFB    #ED,#70
                DEFB    #ED,#70
                DEFB    #ED,#70
                DEFB    #ED,#70
                DEC     A
                JP      NZ,SKIP0
                OR      A
                RET

;***************************************
;
HDDW            INC     D               ;   , 
                DEC     D               ; ⥫?
                JR      Z,HDDW21        ; .

                BIT     1,E             ;  ?
                JR      Z,HDDWFF        ; .
                CALL    WKSECR          ; ⥭ ᥪ.
                CALL    RDHLFH          ; ⥭ 1- 
                                        ;  ७ .
                CALL    SKIP            ; ய 2- .

HDDWFF          LD      A,#30           ;  ᥪ.
                EX      AF,AF'          ;
                LD      A,D             ; ⢮ 楫 -
                                        ; ஢.
                CALL    WKSEC0          ;  .

                BIT     1,E             ;  ?
                JR      Z,HDDW00        ; .
                PUSH    HL              ;
                CALL    WRHLFH          ; 襬  .
                POP     HL              ;
                LD      A,#10           ; 襬 .
LOOP            CALL    WRHALF+#02      ; 襬.
                CALL    WBSY            ;  믮.
                DEC     D               ; 㬥 ᫮ -
                                        ;  ᥪ஢.

HDDW00          INC     D               ;  ⥫?
                DEC     D
                JR      Z,LOOP1         ; .
HDDW10          CALL    WBSY            ;  ⮢.
                CALL    WDRQ            ;  DRQ.
                LD      A,#20           ; 襬 楫 ᥪ.
                JR      LOOP

LOOP1           BIT     0,E             ;  墮?
                RET     Z               ; .
                LD      A,#20
                EX      AF,AF'
                LD      A,#02
                CALL    WKSEC0
                LD      A,#20
                CALL    SKIP+#02
                CALL    WAIT
                JR      HDDW22

;                PUSH    HL              ;   .
;                LD      B,#FE           ; ਢ/.
;                IN      D,(C)
;                DEC     B               ; 樫 訩.
;                IN      H,(C)
;                DEC     B               ; 樫 訩.
;                IN      L,(C)
;                DEC     B               ; ᥪ.
;                IN      E,(C)
;                LD      A,E
;                INC     E               ; ᫥. ᥪ.
;                CP      (IX+CQSEC)      ;  ᨬ쭮?
;                LD      A,D             ; ਢ/.
;                JR      C,Z1            ; .
;                LD      E,#01           ; ᥪ = 1.
;                AND     #0F             ; 室  ᫥饩
;                INC     A               ; .
;                CP      (IX+CQHEAD)     ;  ᨬ쭮?
;                JR      C,Z0            ; .
;                XOR     A               ;  = 0.
;                INC     HL              ; ᫥騩 樫.
;Z0              OR      (IX+DRV)        ; + ਢ.
;Z1              CALL    PCOORD          ; 襬 न.
;                POP     HL              ;   .

HDDW21          CALL    WKSECR          ; ⥭ ᥪ.
HDDW22          CALL    SKIP            ; ய .
                CALL    RDHLFH          ;   .

                LD      A,#30           ;  ᥪ.
                CALL    WKSEC
                CALL    WRHALF          ; 襬 墮.
                CALL    WRHLFH          ; 襬  .
                CALL    WBSY            ;  믮.
                XOR     A
                RET


;***************************************
;  न  ॣ 䥩.
;in:  A= ਢ/
;    HL= 樫.
;     E= ᥪ.
;
PCOORD          LD      BC,#FEBE        ; ਢ/.
                OUT     (C),A           ;
                DEC     B               ; 樫 訩.
                OUT     (C),H
                DEC     B               ; 樫 訩.
                OUT     (C),L
                DEC     B               ; ᥪ.
                OUT     (C),E
                RET

;***************************************
;
RDHLFH          PUSH    HL              ; ⠥  ᥪ
                LD      HL,TMBUF        ;  ७ .
                CALL    RDHALF
                POP     HL
                RET

WKSECR          LD      A,#20           ; 窠 室 ⥭
                                        ;  ᥪ.

WKSEC           EX      AF,AF'          ; 窠 室 ࠡ 
                LD      A,#01           ;  ᥪ஬.

WKSEC0          LD      B,#FA           ; 窠 室 ࠡ 
                OUT     (C),A           ; ᪮쪨 ᥪࠬ.

                LD      B,#FF           ; ⥭ ॣ -
                IN      A,(C)           ; ﭨ.
                BIT     6,A             ;  ⠭ DRDY.
                JR      Z,$-#04


                EX      AF,AF'          ;   .
                OUT     (C),A

WAIT            CALL    WBSY            ;   BSY.
                RRCA                    ; ஢ઠ 訡.
                RET     NC              ; 室, ᫨ ERR=0.

                LD      A,#07           ; 訡 ⥭/
ERROR           LD      SP,#0000        ; ᥪ.
                RET

WDRQ            IN      A,(C)           ;  ⠭ DRQ.
                BIT     3,A             ;
                JR      Z,$-#04         ;
                RET

;***********************************************
;writing bytes with speed 21.875 tact's per byte
;
WRHLFH          LD      HL,TMBUF

WRHALF          LD      A,#10
                PUSH    DE
                LD      DE,#D8F8
                LD      (WRHLF1+#01),SP
                LD      SP,HL

WRHLF0          POP     HL
                LD      B,D
                OUT     (C),H
                LD      B,E
                OUT     (C),L
                POP     HL
                LD      B,D
                OUT     (C),H
                LD      B,E
                OUT     (C),L
                POP     HL
                LD      B,D
                OUT     (C),H
                LD      B,E
                OUT     (C),L
                POP     HL
                LD      B,D
                OUT     (C),H
                LD      B,E
                OUT     (C),L
                POP     HL
                LD      B,D
                OUT     (C),H
                LD      B,E
                OUT     (C),L
                POP     HL
                LD      B,D
                OUT     (C),H
                LD      B,E
                OUT     (C),L
                POP     HL
                LD      B,D
                OUT     (C),H
                LD      B,E
                OUT     (C),L
                POP     HL
                LD      B,D
                OUT     (C),H
                LD      B,E
                OUT     (C),L
                DEC     A
                JP      NZ,WRHLF0

                LD      H,A
                LD      L,A
                ADD     HL,SP
WRHLF1          LD      SP,#0000
                POP     DE
                OR      A
                RET

;***************************************
;reading bytes with speed 20.875 tact's per byte.
;
RDHALF          LD      A,#10
                PUSH    DE
                LD      DE,#D8F8

RDHLF0          LD      B,E
                INI
                LD      B,D
                INI
                LD      B,E
                INI
                LD      B,D
                INI
                LD      B,E
                INI
                LD      B,D
                INI
                LD      B,E
                INI
                LD      B,D
                INI
                LD      B,E
                INI
                LD      B,D
                INI
                LD      B,E
                INI
                LD      B,D
                INI
                LD      B,E
                INI
                LD      B,D
                INI
                LD      B,E
                INI
                LD      B,D
                INI
                DEC     A
                JP      NZ,RDHLF0

                POP     DE
                OR      A
                RET

;***************************************
TMBUF           DEFS    #0100

