;Rhddsmuc.blk
;Hdd driver for smuc ide controller.
;(c) Oleg Grigoriev AKA Ruiner AKA #0R
;Version: 1.2
;Creating date: 02-Jan-1999
;Last edit: 22-June-1999
;************************************************************;

                ORG     #8000

                DEFW    INST
                DEFW    READ
                DEFW    WRIT
                DEFW    INIT
                DEFB    #E0
                DEFB    #04
                DEFW    #0000
                DEFW    #0101
                DEFW    #0000

                DEFW    #DEAD           ;SIGNAT         ; +10
CONST           DEFB    #00             ;CQHEAD         ; +12 +00+
                DEFB    #00             ;CQSEC          ; +13 +01+
QHDSC           DEFB    #00             ;CQHDSC         ; +14 +02+
                DEFB    #00             ;CQHDSC         ; +15 +03+
MGMR            DEFB    #08             ;MQHEAD         ; +16 +04
                DEFB    #27             ;MQSEC          ; +17 +05
                DEFB    #38             ;MQHDSC         ; +18 +06
                DEFB    #01             ;MQHDSC         ; +19 +07
SGMR            DEFB    #00             ;SQHEAD         ; +1A +08
                DEFB    #00             ;SQSEC          ; +1B +09
                DEFB    #00             ;SQHDSC         ; +1C +0A
                DEFB    #00             ;SQHDSC         ; +1D +0B

CDEV            DEFB    #00             ;CYLL           ; +1E +0C
                DEFB    #00             ;CYLL           ; +1F +0D
                DEFB    #00             ;HEAD           ; +20 +0E+
                DEFB    #01             ;SEC            ; +21 +0F+
                DEFB    #A0             ;DRV            ; +22 +10+

DEVS            DEFB    #2F,#01,#06,#05,#A0             ; +23 +11
                DEFB    #98,#01,#06,#0D,#A0             ; +28 +16
                DEFB    #00,#00,#00,#01,#A0             ; +2D +1B
                DEFB    #00,#00,#00,#01,#A0             ; +32 +20
                DEFB    #00,#00,#00,#01,#A0             ; +37 +25
                DEFB    #29,#00,#01,#18,#A0             ; +3C +2A
                DEFB    #5D,#00,#05,#1C,#A0             ; +41 +2F
                DEFB    #C6,#00,#05,#24,#A0             ; +46 +34

                DEFB    #00             ;INT            ; +4B +39+

;------------------------------------------------------------;
CQHEAD          EQU     +#00
CQSEC           EQU     +#01
HEAD            EQU     +#0E
SEC             EQU     +#0F
DRV             EQU     +#10
INT             EQU     +#39

BLKSZ           EQU     #08

;************************************************************;
;
INST            CP      #08
                RET     NC

                LD      C,A
                ADD     A,A
                ADD     A,A
                ADD     A,C
                LD      C,A
                LD      B,#00
                LD      HL,DEVS
                ADD     HL,BC
                LD      DE,CDEV
                LD      C,#05
                LDIR

                DEC     HL
                BIT     4,(HL)
                LD      HL,MGMR
                JR      Z,$+#05
                LD      HL,SGMR

                LD      DE,CONST
                LD      C,#04
                LDIR

INIT            CALL    SETDI
                LD      A,(IX+DRV)
                OUT     (C),A

                LD      A,#EF
                EX      AF,AF'
                LD      A,#AA
                LD      B,#F9
                CALL    WKSEC1

                LD      A,#C6
                EX      AF,AF'
                LD      A,BLKSZ
                JP      WKSEC0

;************************************************************;
;
SETDI           LD      HL,SETEI
                EX      (SP),HL
                LD      (ERROR+#01),SP
                PUSH    HL
                LD      HL,SETDI0
                PUSH    HL
                LD      IX,CONST
                XOR     A
                LD      (IX+INT),A
                LD      A,R
                RET     PE
                LD      A,R
                RET     PE
                INC     (IX+INT)
                RET

SETDI0          DI
                LD      A,#04
                LD      BC,#1FFD
                OUT     (C),A
                LD      C,#BE
                CALL    WAIT
                DEC     B
                RET

SETEI           PUSH    AF
                XOR     A
                LD      BC,#1FFD
                OUT     (C),A
                POP     AF
                BIT     0,(IX+INT)
                RET     NZ
                EI
                RET

;************************************************************;
;
READ            LD      C,#00
                DEFB    #3A
WRIT            LD      C,#01

                PUSH    BC
                LD      C,#09
                RST     #10
                POP     BC
                JR      Z,L000
                CP      #16
                JR      NZ,L000
                LD      C,#07
                RST     #10
                LD      A,#14
                SCF
                RET

L000            XOR     A
                PUSH    DE
                EXX
                POP     DE
                CALL    SETDI
                PUSH    BC

                LD      HL,(QHDSC)
                EX      DE,HL
                SRL     H
                RR      L
                EX      AF,AF'

                LD      BC,#FFFF
                OR      A
                SBC     HL,DE
                INC     BC
                JR      NC,$-#03
                ADD     HL,DE

                LD      E,(IX+CQSEC)
                XOR     A
                LD      D,A
                DEC     A
                SBC     HL,DE
                INC     A
                JR      NC,$-#03
                ADD     HL,DE
                LD      D,A

                INC     E
                LD      A,L
                ADD     A,(IX+SEC)
                CP      E
                JR      C,$+#05
                INC     D
                DEC     E
                SUB     E
                LD      E,A

                LD      A,D
                ADD     A,(IX+HEAD)
                CP      (IX+CQHEAD)
                JR      C,$+#06
                SUB     (IX+CQHEAD)
                INC     BC

                OR      (IX+DRV)

                LD      HL,(CDEV)
                ADD     HL,BC

                POP     BC
                OUT     (C),A
                DEC     B
                OUT     (C),H
                DEC     B
                OUT     (C),L
                DEC     B
                OUT     (C),E

;---------------------------------------
;
                EXX
                EX      AF,AF'
                LD      D,B
                JR      NC,$+#03
                DEC     D
                RLA

                SRL     D
                RLA
                LD      E,A

                BIT     1,E
                JR      Z,$+#03
                INC     D

                SRL     C
                LD      C,#BE
                JR      C,HDDW

;***************************************
;
HDDR            EX      AF,AF'
                LD      A,#C4
                EX      AF,AF'
                AND     #01
                ADD     A,D
                CALL    WKSEC0

                BIT     1,E
                JR      NZ,HDDR00
                LD      A,BLKSZ
                INC     D
                JR      HDDR01

HDDR00          CALL    SKIP
                CALL    RDHALF
                LD      A,BLKSZ-#01
HDDR01          DEC     D
                JR      Z,HDDR20

HDDR10          CP      D
                JR      C,$+#03
                LD      A,D
                PUSH    AF
                ADD     A,A
                ADD     A,A
                ADD     A,A
                ADD     A,A
                ADD     A,A
                CALL    RDHALF+#02
                CALL    WAIT
                LD      A,D
                EXX
                POP     BC
                SUB     B
                EXX
                LD      D,A
                LD      A,BLKSZ
                JR      NZ,HDDR10

HDDR20          BIT     0,E
                RET     Z
                CALL    RDHALF

;***************************************
;skipping half of sector with speed 6.875 tact's per byte
;
SKIP            LD      A,#10
                LD      B,#F8
SKIP0           DEFB    #ED,#70       ;IN F,(C)
                DEFB    #ED,#70
                DEFB    #ED,#70
                DEFB    #ED,#70
                DEFB    #ED,#70
                DEFB    #ED,#70
                DEFB    #ED,#70
                DEFB    #ED,#70
                DEC     A
                JP      NZ,SKIP0
                OR      A
                RET

;***************************************
;
HDDW            INC     D
                DEC     D
                JR      Z,HDDW21

                BIT     1,E
                JR      Z,HDDW00

                CALL    RDSEC
                CALL    RDHLFH

HDDW00          LD      A,#C5
                EX      AF,AF'
                LD      A,D
                CALL    WKSEC0
                BIT     1,E
                JR      Z,HDDW10

                PUSH    HL
                CALL    WRHLFH
                POP     HL
                CALL    WRHALF
                LD      A,BLKSZ-#01
                DEC     D
                JR      Z,HDDW20
                JR      HDDW11

HDDW10          LD      A,BLKSZ
HDDW11          CP      D
                JR      C,$+#03
                LD      A,D
                PUSH    AF
                ADD     A,A
                ADD     A,A
                ADD     A,A
                ADD     A,A
                ADD     A,A
                CALL    WRHALF+#02
                CALL    WAIT
                LD      A,D
                EXX
                POP     BC
                SUB     B
                EXX
                LD      D,A
                JR      NZ,HDDW10

HDDW20          BIT     0,E
                RET     Z
                CALL    WAIT
                LD      A,#C4
                EX      AF,AF'
                LD      A,#02
                CALL    WKSEC0
                LD      A,#30
                JR      HDDW22

HDDW21          CALL    RDSEC
                LD      A,#10
HDDW22          CALL    SKIP+#02
                CALL    RDHLFH

                LD      A,#30
                CALL    WKSEC
                CALL    WRHALF
                CALL    WRHLFH
                JR      WAIT

;***************************************
;
RDHLFH          PUSH    HL
                LD      HL,TMBUF
                CALL    RDHALF
                POP     HL
                RET

RDSEC           LD      A,#20
WKSEC           EX      AF,AF'
                LD      A,#01
WKSEC0          LD      B,#FA
WKSEC1          OUT     (C),A

                LD      B,#FF
                IN      A,(C)
                BIT     7,A
                JR      NZ,$-#04
                IN      A,(C)
                JR      Z,ERROR-#03
                BIT     6,A
                JR      Z,$-#06

                EX      AF,AF'
                OUT     (C),A

WAIT            LD      B,#FF
                IN      A,(C)
                BIT     7,A
                JR      NZ,$-#04
                RRCA
                RET     NC

                SCF
                LD      A,#07
ERROR           LD      SP,#0000
                RET

;***********************************************
;writing bytes with speed 21.875 tact's per byte
;
WRHLFH          LD      HL,TMBUF

WRHALF          LD      A,#10
                PUSH    DE
                LD      DE,#D8F8
                LD      (WRHLF1+#01),SP
                LD      SP,HL

WRHLF0          POP     HL
                LD      B,D
                OUT     (C),H
                LD      B,E
                OUT     (C),L
                POP     HL
                LD      B,D
                OUT     (C),H
                LD      B,E
                OUT     (C),L
                POP     HL
                LD      B,D
                OUT     (C),H
                LD      B,E
                OUT     (C),L
                POP     HL
                LD      B,D
                OUT     (C),H
                LD      B,E
                OUT     (C),L
                POP     HL
                LD      B,D
                OUT     (C),H
                LD      B,E
                OUT     (C),L
                POP     HL
                LD      B,D
                OUT     (C),H
                LD      B,E
                OUT     (C),L
                POP     HL
                LD      B,D
                OUT     (C),H
                LD      B,E
                OUT     (C),L
                POP     HL
                LD      B,D
                OUT     (C),H
                LD      B,E
                OUT     (C),L
                DEC     A
                JP      NZ,WRHLF0

                LD      H,A
                LD      L,A
                ADD     HL,SP
WRHLF1          LD      SP,#0000
                POP     DE
                OR      A
                RET

;***************************************
;reading bytes with speed 20.875 tact's per byte.
;
RDHALF          LD      A,#10
                PUSH    DE
                LD      DE,#D8F8

RDHLF0          LD      B,E
                INI
                LD      B,D
                INI
                LD      B,E
                INI
                LD      B,D
                INI
                LD      B,E
                INI
                LD      B,D
                INI
                LD      B,E
                INI
                LD      B,D
                INI
                LD      B,E
                INI
                LD      B,D
                INI
                LD      B,E
                INI
                LD      B,D
                INI
                LD      B,E
                INI
                LD      B,D
                INI
                LD      B,E
                INI
                LD      B,D
                INI
                DEC     A
                JP      NZ,RDHLF0

                POP     DE
                OR      A
                RET

;***************************************
TMBUF           DEFS    #0100

