;Rhddsmuc.blk
;Hdd driver for smuc. Based on original version by Jason.
;(c) Oleg Grigoriev AKA Ruiner AKA #0R
;Version: 1.2
;Complete: 100%
;Creating date: 02-01-1999
;Last edit: 04-01-1999
;Last edit: 01-04-1999
;************************************************************;

	ORG	#8000

	DEFW	INST
	DEFW	READ
	DEFW	WRIT
	DEFW	INIT
	DEFB	#E0
	DEFB	#04
	DEFW	#0000
	DEFW	#0101
	DEFW	#DEAD         ;SIGNATURE
;---------------------------------------
CCGMR	;GEOMETRY OF CURRENT DRV
	DEFB	#00           ;HEAD
	DEFB	#00           ;SECTOR
CCYLL	DEFW	#0000         ;HEAD*SECTOR
CMGMR	DEFB	#00           ;GEOMETRY OF MASTER DRV
	DEFB	#00
	DEFW	#0000
CSGMR	DEFB	#00           ;GEOMETRY OF SLAVE DRV
	DEFB	#00
	DEFW	#0000
;---------------------------------------
CCDEV	DEFW	#0000         ;CYLINDER
	DEFB	#00,#01       ;HEAD,SECTOR
	DEFB	#A0           ;MASK OF DRV

DEVS	DEFW	#0000
	DEFB	#00,#01
	DEFB	#A0
	DEFW	#0000
	DEFB	#00,#01
	DEFB	#A0
	DEFW	#0000
	DEFB	#00,#01
	DEFB	#A0
	DEFW	#0000
	DEFB	#00,#01
	DEFB	#A0
	DEFW	#0000
	DEFB	#00,#01
	DEFB	#A0
	DEFW	#0000
	DEFB	#00,#01
	DEFB	#A0
	DEFW	#0000
	DEFB	#00,#01
	DEFB	#A0
	DEFW	#0000
	DEFB	#00,#01
	DEFB	#A0

;************************************************************;
INST	CP	#08
	RET	NC
	LD	C,A
	ADD	A,A
	ADD	A,A
	ADD	A,C
	LD	C,A
	LD	B,#00
	LD	HL,DEVS
	ADD	HL,BC
	LD	DE,CCDEV
	LD	C,#05
	LDIR
	DEC	DE
	LD	A,(DE)

	LD	HL,CMGMR
	BIT	4,A
	JR	Z,$+#05
	LD	HL,CSGMR
	LD	DE,CCGMR
	PUSH	DE
	LD	C,#04
	LDIR
	POP	HL
	LD	A,(HL)
	LD	(_HEA),A
	INC	HL
	LD	A,(HL)
	INC	A
	LD	(_SEC),A

	CALL	SETDI
	LD	A,(CCDEV+#04)
	OUT	(C),A

	LD	DE,#AAEF
	LD	B,#F9
	OUT	(C),D
	LD	B,#FF
	OUT	(C),E
	IN	A,(C)
	ADD	A,A
	JR	C,$-#03

	CALL	SETEI

INIT	XOR	A
	RET

;***************************************

READ	LD	C,#00
	JR	$+#04
WRIT	LD	C,#01

	LD	A,#7F
	IN	A,(#FE)
	RRA
	JR	C,L000
	LD	A,#FE
	IN	A,(#FE)
	RRA
	CCF
	LD	A,#14
	RET	C

L000	LD	(EXIT+#01),SP
	LD	IX,CCGMR
	PUSH	DE
	XOR	A
;---------------------------------------
	EXX
	POP	DE
	LD	HL,(CCYLL)
	EX	DE,HL
	SRL	H
	RR	L
	EX	AF,AF'

	XOR	A
	LD	C,A
	LD	B,A
	SBC	HL,DE
	INC	BC
	JR	NC,$-#03
	ADD	HL,DE
	DEC	BC            ;[BC] = CYL

	LD	E,(IX+#01)
	XOR	A
	LD	D,A
	SBC	HL,DE
	INC	A
	JR	NC,$-#03
	ADD	HL,DE
	DEC	A

;[A] - HEAD; [L] - SEC; [BC] - CYLL

	LD	D,A
	LD	E,L

	LD	A,L
	ADD	A,(IX+#0F)
	CP	#00
_SEC	EQU	$-#01
	JR	C,$+#06
	INC	D
	SUB	(IX+#01)
	LD	E,A

	LD	A,D
	ADD	A,(IX+#0E)
	CP	#00
_HEA	EQU	$-#01
	JR	C,$+#06
	INC	BC
	SUB	(IX+#00)
	OR	(IX+#10)
	LD	D,A

	LD	HL,(CCDEV)
	ADD	HL,BC

;[HL] - CYLL; [D] - DRV & HEAD; [E] - SEC

	CALL	SETDI
	OUT	(C),D         ;DRV & HEAD
	DEC	B
	OUT	(C),H         ;CYLL HIGH
	DEC	B
	OUT	(C),L         ;CYLL LOW
	DEC	B
	OUT	(C),E         ;SEC
	EXX
	EX	AF,AF'
;---------------------------------------
;[HL] - ADDR; [B] - QUAN; [C] - TYPE;

	LD	E,#00

	RL	E
	BIT	0,E
	JR	Z,$+#03
	DEC	B

	SRL	B
	JR	NC,$+#04
	SET	1,E
	LD	D,B

;[D] - QUAN OF FIZ.SEC; [E] - %LF

	LD	A,E
	SRL	A

	BIT	0,C
	LD	C,#BE
	JP	NZ,WRITE

	ADC	A,D
	LD	D,A
	LD	B,#FA
	OUT	(C),D
	CALL	COM
	BIT	0,E
	JR	Z,READ1

	CALL	SKIP
	LD	A,#08
	JR	READ12
;---------------------------------------
READ1	LD	B,#FA
	IN	A,(C)
	JR	Z,READ2

READ11	LD	A,#10
READ12	CALL	RDHALF+#02

READ13	CALL	WAIT
	JR	NZ,READ1
;---------------------------------------
	OR	A
EXIT	LD	SP,#0000
	PUSH	AF
	CALL	SETEI
	POP	AF
	RET

;---------------------------------------
READ2	BIT	1,E
	JR	Z,READ11
	CALL	RDHALF
	CALL	SKIP
	JR	READ13

;***************************************
WRITE	LD	B,#FA
	LD	A,#00
	ADC	A,D
	LD	D,A
	BIT	0,E
	JR	Z,WRIT1

	LD	A,#01
	OUT	(C),A
	CALL	COM
	PUSH	HL
	LD	HL,BUFFER
	PUSH	HL
	CALL	RDHALF
	CALL	SKIP
	CALL	WAIT

	LD	B,#FA
	OUT	(C),D
	SCF
	CALL	COM+#01
	POP	HL
	CALL	WRHALF
	POP	HL
WRIT01	LD	A,#08
	JR	WRIT12

WRIT1	DEC	D
	INC	D
	JR	Z,WRIT20
	OUT	(C),D
	SCF
	CALL	COM+#01

WRIT11	LD	A,#10
WRIT12	CALL	WRHALF+#02
WRIT13	CALL	WAIT
	JR	NZ,WRIT11

WRIT20	BIT	1,E
	JR	Z,EXIT-#01
	DEC	D
	INC	D
	JR	Z,WRIT21

	LD	A,#02
	LD	B,#FA
	OUT	(C),A
	CALL	COM
	LD	A,#10
	CALL	SKIP+#02
	CALL	WAIT
	JR	WRIT22

WRIT21	LD	A,#01
	LD	B,#FA
	OUT	(C),A
	CALL	COM
WRIT22	PUSH	HL
	CALL	SKIP
	LD	HL,BUFFER
	CALL	RDHALF
	CALL	WAIT
	RES	1,E
	LD	A,#01
	LD	B,#FA
	OUT	(C),A
	SCF
	CALL	COM+#01
	POP	HL
	CALL	WRHALF
	LD	HL,BUFFER
	JR	WRIT01

;***************************************
SETDI	LD	A,R
	JP	PE,SETDI0
	LD	A,R
SETDI0	LD	A,#00
	JP	PE,SETDI1
	INC	A
SETDI1	LD	(SETEI1+#01),A
	DI
	LD	A,#04
;        LD      BC,#1FFD
;        OUT     (C),A
	OUT	(#FD),A
	LD	BC,#FEBE
	RET

;***************************************
SETEI	XOR	A
;        LD      BC,#1FFD
;        OUT     (C),A
	OUT	(#FD),A
SETEI1	LD	A,#00
	OR	A
	RET	NZ
	EI
	RET

;***************************************
COM	OR	A
	LD	B,#FF
	IN	A,(C)
	BIT	6,A
	JR	Z,$-#04

	LD	A,#20
	JR	NC,$+#04
	OR	#10
COM0	OUT	(C),A

WAIT	LD	B,#FF
	IN	A,(C)
	BIT	7,A
	JR	NZ,$-#04
	BIT	3,A
	RET	NZ
	RRCA
	RET	NC

	LD	A,#07
	JP	EXIT

;***************************************
;skipping half of sector with speed 6.4375 tact's per byte

SKIP	LD	A,#08
	LD	B,#F8
SKIP1	DEFB	#ED,#70       ;IN F,(C)
	DEFB	#ED,#70
	DEFB	#ED,#70
	DEFB	#ED,#70
	DEFB	#ED,#70
	DEFB	#ED,#70
	DEFB	#ED,#70
	DEFB	#ED,#70
	DEFB	#ED,#70
	DEFB	#ED,#70
	DEFB	#ED,#70
	DEFB	#ED,#70
	DEFB	#ED,#70
	DEFB	#ED,#70
	DEFB	#ED,#70
	DEFB	#ED,#70
	DEC	A
	JP	NZ,SKIP1
	RET

;***************************************
;reading bytes with speed 20.4375 tact's per byte
RDHALF	LD	A,#08
	PUSH	DE
	LD	DE,#D8F8
RDHLF0	DEFB	#43,#ED,#A2,#42,#ED,#A2     ;LD B,E:INI:LD B,D:INI
	DEFB	#43,#ED,#A2,#42,#ED,#A2
	DEFB	#43,#ED,#A2,#42,#ED,#A2
	DEFB	#43,#ED,#A2,#42,#ED,#A2
	DEFB	#43,#ED,#A2,#42,#ED,#A2
	DEFB	#43,#ED,#A2,#42,#ED,#A2
	DEFB	#43,#ED,#A2,#42,#ED,#A2
	DEFB	#43,#ED,#A2,#42,#ED,#A2
	DEFB	#43,#ED,#A2,#42,#ED,#A2
	DEFB	#43,#ED,#A2,#42,#ED,#A2
	DEFB	#43,#ED,#A2,#42,#ED,#A2
	DEFB	#43,#ED,#A2,#42,#ED,#A2
	DEFB	#43,#ED,#A2,#42,#ED,#A2
	DEFB	#43,#ED,#A2,#42,#ED,#A2
	DEFB	#43,#ED,#A2,#42,#ED,#A2
	DEFB	#43,#ED,#A2,#42,#ED,#A2
	DEC	A
	JP	NZ,RDHLF0
	POP	DE
	RET

;***************************************
;writing bytes with speed 21.4375 tact's per byte
WRHALF	LD	A,#08
	PUSH	DE
	LD	DE,#D8F8
	LD	(WRHLF1+#01),SP
	LD	SP,HL

WRHLF0	DEFB	#E1,#42,#ED,#61,#43,#ED,#69     ;POP HL:LD B,D:OUT (C),H:LD B,E:OUT (C),L
	DEFB	#E1,#42,#ED,#61,#43,#ED,#69
	DEFB	#E1,#42,#ED,#61,#43,#ED,#69
	DEFB	#E1,#42,#ED,#61,#43,#ED,#69
	DEFB	#E1,#42,#ED,#61,#43,#ED,#69
	DEFB	#E1,#42,#ED,#61,#43,#ED,#69
	DEFB	#E1,#42,#ED,#61,#43,#ED,#69
	DEFB	#E1,#42,#ED,#61,#43,#ED,#69
	DEFB	#E1,#42,#ED,#61,#43,#ED,#69
	DEFB	#E1,#42,#ED,#61,#43,#ED,#69
	DEFB	#E1,#42,#ED,#61,#43,#ED,#69
	DEFB	#E1,#42,#ED,#61,#43,#ED,#69
	DEFB	#E1,#42,#ED,#61,#43,#ED,#69
	DEFB	#E1,#42,#ED,#61,#43,#ED,#69
	DEFB	#E1,#42,#ED,#61,#43,#ED,#69
	DEFB	#E1,#42,#ED,#61,#43,#ED,#69
	DEC	A
	JP	NZ,WRHLF0

	LD	H,A
	LD	L,A
	ADD	HL,SP
WRHLF1	LD	SP,#0000
	POP	DE
	RET

;***************************************
BUFFER	DEFS	#0100
