@ARM

	b start

	@dcd	$0,$0,$0,$0,$0
	@dcd	$0,$0,$0,$0,$0
	@dcd	$0,$0,$0,$0,$0
	@dcd	$0,$0,$0,$0,$0
	@dcd	$0,$0,$0,$0,$0
	@dcd	$0,$0,$0,$0,$0
	@dcd	$0,$0,$0,$0,$0
	@dcd	$0,$0,$0,$0	 	;nintendo logo (sonst macht original rger)
	@dcb	"FireCube    "		;spiel name (12 byte)
	@dcb	"fire"			;game code
	@dcb	"gs"			;marer code :)
	@dcb	$96			;must be $96
	@dcb	0			;main unit code
	@dcb	0			;device type
	@dcb	0,0,0,0,0,0,0		;resv. area
	@dcb	0			;software version
	@dcb	0			;complement check (wird mit gbarm gesetzt), sonst gehts nicht auf original gba
	@dcb	0,0			;reserved area	


	vsync 	@DCD 0x04000006			; VSYNC Zhler
	video 	@DCD 0x04000000			; Video-Register
	iRAM	@DCD 0x03000000
	eRAM	@DCD 0x02000000
	mode	@DCW 0x0404			; Modus 4, BG 2 enable, Videoram 0x06000000
	palette 	@DCD 0x05000000			; Enthlt 256 16 Bit Paletteneintrge
	gfxram	@DCD 0x0600A000			; ACHTUNG: MUSS AUF 0x0600A000 sein, wenn umschalten verwendet wird !!!!
	DMA3src	@DCD 0x040000D4			; Register, in das SRC ADDR kommt
	DMA3des @DCD 0x040000D8			; Register, in das DEST ADDR kommt
	DMA3con @DCD 0x040000DE			; Register fr Controll-Bits
	DMA3cou @DCD 0x040000DC			; Wieviele Words sollen geschrieben werden
	DMAMode @DCW 0x08500			; DMA Transfermodus nach GBASpecs
	bgcolor 	@DCD 0x0			; Farbe zum lschen des Buffers
	linearray	@DCD 0x03000200			; fngt im Speicher hinter Vecarray an - muss je nach groesse angepasst werden
	divtabadr	@DCD 0x03000C04

;----------------- unser iRAM-Aufbau -------------
;
;0x03000000 	Framebuffer-Var
;0x03000004	Vektoren-Array nach Rotation
;0x030000FF	Linebuffer-Array fr Shading
;0x03000380	DIV-Tab
;-----------------------------------------------------------
	
@textarea #0x03000000				; Adresse vom RAM - alles innerhalb wird  
 	Frame 	@DCD 0x0			; entsprechend referenziert
	Vecarray  @DCD 0x0			; hier fangen VECS an

@endarea

	pal	@DCD firepal
	sinus	@DCD sin
	cosinus	@DCD cos
	vectable	@DCD Vecarray
	buffer	@DCD Frame
	fillsrc	@DCD bgcolor


;------------------------------------------------------------------------------------------------------------------------------------------
; Schaltet zwischen den Frames um, lscht den hidden frame via DMA
; -----------------------------------------------------------------------------------------------------------------------------------------

umschalten					; Hier schalten wir zwischen den Buffern um
		stmfd r13!,{r0-r4}			; Register auf den Stack
		ldr r2,[video]			; Lade Inhalt des Videoregisters
		ldr r3,[r2]
		ldr r1,[iRAM]			; Im RAM - erstes WORD = Backbuffer-ADR
		ldr r4,[r1]
		tst r3,#16				; Bit 4 gesetzt ?
		addne r4,r4,#0xA000			; Ja - also ist BB 0x06000000
		subeq r4,r4,#0xA000			; Nein - also ist BB 0x06000A000 aktiv
		str r4,[r1]				; Speicher neuen BB
		ldr r4,[vsync]
waitsync		ldr r1,[r4]				; Inhalt des VSync
		cmp r1,160			; Scanline der LCD-Hardware
		blt waitsync			; Wenn kleiner, malt LCD-H gerade .. wait
		eor r3,r3,#16			; Invertiere Bit 4, wenn r1>=160 - schaltet um
		str r3,[r2]

		b umschaltenend			; fuer Feuer wird Loeschung nicht bentigt !!!			

		ldr r0,[DMA3src]
		ldr r1,[fillsrc]			; Ldt in r1 die Adresse von bgcolor !!!
		str r1,[r0]	
		ldr r0,[DMA3des]
		ldr r1,[iRAM]
		ldr r2,[r1]				; Lade in r2 die aktuelle Backbuffer-ADR
		str r2,[r0]
		ldr r0,[DMA3cou]
		mov r1,#9600			; Bildschirm hat 240x160 = 38400 Bytes / 4 = 9600 DCD
		strh r1,[r0]
		ldr r0,[DMA3con]
		ldr r1,[DMAMode]
		strh r1,[r0]				; Wupp - DMA Transfer beginnt sofort

umschaltenend	ldmfd r13!,{r0-r4}
		mov r15,r14			; r15 ist Programm-Counter, r14 hat
						; bei BL den Wert r15 + #4 angenommen
						; daher Rcksprung


;------------------------------------------------------------------------------------------------------------------------------------------
; Ldt die Palette in den Paletten-Speicher
; -----------------------------------------------------------------------------------------------------------------------------------------

loadpalette					; bergabewert r0 - Palettensource
		stmfd r13!,{r0-r12}

		ldr r1,[palette]			; Adresse, wo die Pal hin muss
		mov r2,#256			; Schleifenzhler
palloop		ldrh r3,[r0],#-2			; Post-Index			
		strh r3,[r1],#2
		sub r2,r2,#1
		cmp r2,#0
		bne palloop

		ldmfd r13!,{r0-r12}
		mov r15,r14


;------------------------------------------------------------------------------------------------------------------------------------------
; initialisiert den Bildschirm, setzt Backbuffervariable
; -----------------------------------------------------------------------------------------------------------------------------------------

initGBA
		ldr r0,[video]
		ldrh r1,[mode]
		strh r1,[r0]				; Setze den Videomodus

		ldr r0,[iRAM]
		ldr r1,[gfxRAM]
		str r1,[r0]				; Unsere BackBuffer-Variable				
		mov r15,r14

;------------------------------------------------------------------------------------------------------------------------------------------
; kreiere DIV-Tab 1/1 .. 1/1024 im Speicher fr Interploation etc.
; -----------------------------------------------------------------------------------------------------------------------------------------

divtab
		stmfd r13!,{r0-r12}

		ldr r9,[divtabadr]			; Adresse der DIV-Tab
		mov r10,#1			; Schleifenzhler
		mov r0,#0
		str r0,[r9],#4			; wir definieren 1/0 = 0

divloop		mov r0,#0x0100000			; 2^20/			(wir speicher wg. Nachkomma 1/x * 2^20)
		mov r1,r10				; r1
		swi 0x60000			; Divisions-Interrupt r0 = r0 / r1 ; r1 = r0 MOD r1; r3 = abs( r0 / r1 )
		str r0,[r9],#4			; @DCD Tabelle
		add r10,r10,#1
		cmp r10,#1024
		ble divloop

		ldmfd r13!,{r0-r12}
		mov r15,r14
		

;------------------------------------------------------------------------------------------------------------------------------------------
; Macht ein Feuerchen aus dem Bildschirm !
; -----------------------------------------------------------------------------------------------------------------------------------------

firescreen
		stmfd r13!,{r0-r5}

		mov r0,0x03000000
		ldr r0,[r0]				; wir laden die aktuelle Frame-Buffer-Adr
		mov r1,#120			; wir starten in Zeile 120 - gehen bis 0
		mov r2,#200			; xmax 200 bis xmin 100 [ Feuerfenster wg. Speed ]
		mov r3,#240
		mla r3,r3,r1,r0
		add r3,r3,r2			; Genau Adresse im Videospeicher

weiterfeuern	ldrb r4,[r3]				; Mittelpunkt
		ldrb r5,[r3,#-240]			; Punkt darber
		add r4,r4,r5
		ldrb r5,[r3,#-1]
		add r4,r4,r5
		ldrb r5,[r3,#1]
		add r4,r4,r5
		mov r4,r4,lsr#2			; Durchschnitt /2
		cmp r4,#8
		movlt r4,#0

		tst r3,#1				; Bit 1 set ? dann nicht durch 2 teilbar !
		subne r3,r3,#1			; Bitset .. dann mach durch 2
		ldrh r9,[r3,#-240]			; lade das word
		andne r9,r9,#0xFF			; Lsche Hi-Bit
		andeq r9,r9,#0xFF00			; sonst das Low-Bit
		addne r9,r9,r4,lsl#8
		addeq r9,r9,r4
		strh r9,[r3,#-240]			; Punkt auf y*240 + x
		addne r3,r3,#1

		sub r3,r3,#1
		sub r2,r2,#1
		cmp r2,#80
		suble r1,r1,#1
		suble r3,r3,#120
		movle r2,#200
		cmp r1,#1
		bgt weiterfeuern
		
		ldmfd r13!,{r0-r5}
		mov r15,r14	

;------------------------------------------------------------------------------------------------------------------------------------------
; Zeichne Viereck entsprechend Linebuffer ! Beachte: Algo macht Clipping ! r9 ist Eck-Farb-Inkrement
; -----------------------------------------------------------------------------------------------------------------------------------------

draw4eck
		stmfd r13!,{r0-r12}

		ldr r0,[linearray]
		ldr r1,[divtabadr]
		mov r12,0x03000000
		ldr r12,[r12]			; Video-RAM
		mov r2,#0				; Schleifenzhler fr Linebuffer

readnext		ldmia r0!,{r3,r4,r5,r6}			; wir holen uns xstart,xende,farbestart,farbeend
		cmp r3,#4096			; ist xtart = xinit
		beq pruefer2			; hier ist nichts zu zeichnen, naechste Zeile ..
		cmp r3,r4				; xstart = xende ?
		beq nurpunktmalen		
	
		cmp r4,#0				; liegt xende aufm Bildschirm ?
		blt pruefer2
		cmp r3,#239			; liegt xstart aufm Bildschirm ?
		bgt pruefer2

		sub r8,r4,r3			; Linienlaenge (deltax)
		sub r6,r6,r5			; delta-Farbe
		ldr r10,[r1,r8,lsl#2]			; r10 = [r1+r8*4] wg. 1/deltax
		mul r6,r6,r10			; r6 = deltafarbe * 1/deltax * 2^20 = Farbeinkrement

		mov r5,r5,lsl#20			; Startfarbe * 2^20

paintpoints	cmp r3,#0
		blt keinpunkt
		cmp r3,#239			; x ist raus ausm Bildschirm ...
		bgt pruefer2

		ldrb r9,[r12,r3]
		cmp r9,#130
		bgt keinpunkt

		mov r8,r5,lsr#20			; r5 / 2^20

		tst r3,#1				; Bit 1 set ? dann nicht durch 2 teilbar !
		subne r3,r3,#1			; Bitset .. dann mach durch 2
		ldrh r9,[r12,r3]			; lade das word
		andne r9,r9,#0xFF			; Lsche Hi-Bit
		andeq r9,r9,#0xFF00			; sonst das Low-Bit
		addne r9,r9,r8,lsl#8
		addeq r9,r9,r8
		strh r9,[r12,r3]			; Punkt auf y*240 + x
		addne r3,r3,#1

keinpunkt		add r5,r5,r6
		add r3,r3,#1
		cmp r3,r4
		ble paintpoints

pruefer2		add r12,r12,#240			; Eine Zeile im Video-Ram tiefer
		add r2,r2,#1			; Schleifenzaehler erhoehen
		cmp r2,#160
		blt readnext

		ldmfd r13!,{r0-r12}
		mov r15,r14			; RET

nurpunktmalen	cmp r3,#0
		blt pruefer2			; Punkt ausserhalb Screen
		cmp r3,#239
		bgt pruefer2			; - " -
		add r7,r12,r3			; Videoadresse = Zeile + x
		strb r5,[r7]				; male Punkt
		b pruefer2

;------------------------------------------------------------------------------------------------------------------------------------------
; Initialisiere Linebuffer mit Ausgangswerten
; -----------------------------------------------------------------------------------------------------------------------------------------

clearlinebuffer
		stmfd r13!,{r0-r5}

		ldr r0,[linearray]
		mov r1,#160			; Linebuffer geht von 0..159, je Zeile - xstart, xende, farbstart,farbende, DCD
		mov r2,#4096			; xstart = 4096
		mvn r3,r2
		add r3,r3,#1			; xende = -4096
		mov r4,#0				; farbestart, farbeende = 0
		mov r5,#0		

vollmachen	stmia r0!,{r2,r3,r4,r5}			; Schreibe mit Post-Increment die Register r2,r3,r4,r5 nach r0, r0 aktualisieren (!)
		sub r1,r1,#1
		cmp r1,#0
		bgt vollmachen

		ldmfd r13!,{r0-r5}
		mov r15,r14

;------------------------------------------------------------------------------------------------------------------------------------------
; Nimmt fr ein 4-Eck die Rnder in den Linenpuffer und interpoliert die Farben zwischen den Punkten
; Linearrayaufbau: [0..159] (Zeilen) - of Startwert, Endwert, Farbestart, Farbeende
; bergeben wird eine Adresse r12 auf 4 Vektoren nach dem Aufbau: 4 * x,y,z,farbe, da wir einen Wrfel haben
; folgt dann Vektor der Normalen : x,y,dummy [ das sind nach Rotation die bereits neuberechneten und zentrierten Koordinaten , daher ohne z ! ]
; -----------------------------------------------------------------------------------------------------------------------------------------

linebuffer						; Linienalgorithmus 
		stmfd r13!,{r0-r12,r14}		; Register rauf aufn Stack - r14 auch sichern wegen RET
		
		bl clearlinebuffer			; Lsche den Linebuffer	

		; --- wir holen Linienkoordinaten ---

		mov r0,#4				; Vier Linien fr Viereck !

komplett		ldr r1,[r12]				; Lade x
		ldr r2,[r12,#4]			; y		
		ldr r5,[r12,#12]			; Farbestart
		cmp r0,#1				; sind wir in letzter Linie ?
		subeq r12,r12,#64			; wieder auf Anfang setzen, da einmal rum !
		ldr r3,[r12,#16]			; x1
		ldr r4,[r12,#20]			; y1
		ldr r10,[r12,#28]			; Farbeende
		add r12,r12,#16
		sub r10,r10,r5			; delta-Farbe

		; --- wir laufen die Linie ab ---

		mov r7,#1				; xinc = #1
		mov r11,#1			; yinc2 fr "echtes" y
		cmp r1,r3				; X>x1 ? 
		sublt r6,r3,r1			; Deltax = r3 - r1
		subge r6,r1,r3			; sonst Deltax = r1 - r3
		mvngt r7,r7
		addgt r7,r7,#1			; xinc = -1
		beq nurpunkttest
	
		cmp r2,r4				; y>y1 ?
neinirrtum		sublt r8,r4,r2			; deltay = r4 - r2
		subge r8,r2,r4			; deltay = r2 - r4
		mvngt r11,r11
		addgt r11,r11,#1

		cmp r8,r6				; deltay > deltax ?
		bgt ueberyachse			; ja, dann ber y-Achse

		ldr r9,[divtabadr]			; Berechnung des Interpolations-Inkrements fr Farbinterpolation 
		add r9,r9,r6,lsl#2			; Adresse in der Div-Tab -> Interpolation delta-Farbe/Linienlaenge = Anzahl der Punkte = deltax !
		ldr r9,[r9]				; deltax * 4 da jeder 1/x 4 Byte einnimt [ Achtung: deltax darf nicht groesser als 1024 sein ! ]
		mul r10,r10,r9			; r10 = delta-Farbe * 1/Linienlaenge * 2^20 -> r10 wird Increment
		mov r5,r5,lsl#20			; r5 * 2^20 fr Interpolation

		bl modifylinebuffer			; Koennen wir xwert speichern ??

		mov r9,#0
		
nachsterpunkt					; wir gehen auf der X-Achse via xinc / Im r2 = r2 + yinc bewegen
		add r1,r1,r7			; r1:=r1+xinc
		add r9,r9,r8			; Anstieg = Anstieg + deltay
		cmp r9,r6				; Anstieg grer deltax ?
		subge r9,r9,r6
		addge r2,r2,r11			; dann veraendere auch y

		add r5,r5,r10			; Farbwert-Interpolation
		bl modifylinebuffer			; Und wir aktualisieren eventuell Linebuffer

		cmp r1,r3				; x = x1 ?
		bne nachsterpunkt			; ne, weitermachen			

		b lineend

nurpunkttest	cmp r2,r4
		bne neinirrtum

		b lineend

ueberyachse	
		
		ldr r9,[divtabadr]			; Berechnung des Interpolations-Inkrements fr Farbinterpolation 
		add r9,r9,r8,lsl#2			; Adresse in der Div-Tab -> Interpolation delta-Farbe/Linienlaenge = Anzahl der Punkte = deltay !
		ldr r9,[r9]				; deltay * 4 da jeder 1/x 4 Byte einnimt [ Achtung: deltay darf nicht groesser als 1024 sein ! ]
		mul r10,r10,r9			; r10 = delta-Farbe * 1/Linienlaenge * 2^20 -> r10 wird Increment
		mov r5,r5,lsl#20			; r5 * 2^20 fr Interpolation

		bl modifylinebuffer

		mov r9,#0
		
nachsterpunkt2					; wir gehen auf der Y-Achse via Yinc
		add r2,r2,r11			; r2:=r2+yinc
		add r9,r9,r6			; Anstieg = Anstieg + deltax
		cmp r9,r8				; Anstieg grer deltay ?
		subge r9,r9,r8
		addge r1,r1,r7			; dann verndere auch x

		add r5,r5,r10
		bl modifylinebuffer

		cmp r2,r4				; x = x1 ?
		bne nachsterpunkt2			; ne, weitermachen			

		b lineend

modifylinebuffer
		; --- wir speichern nun unter bestimmtem Bedingungen x Wert in Tabelle  ---- r1 = akt - x, r2 = akt - y

		stmfd r13!,{r0,r5,r8}			; sichere Register fr Intermezzo

		cmp r2,#0				; r2 auerhalbBildschirm-Prfung
		blt nichtsberechnen
		cmp r2,#239
		bgt nichtsberechnen
 
		ldr r0,[linearray]
		add r0,r0,r2,lsl#4			; Adresse im Linearray
		mov r5,r5,lsr#20			; Stelle Farbwert her

		ldr r8,[r0]				; Lade Startwert
		cmp r8,r1				; Startwert in Linebuffer vergleichen mit aktuellem x
		strgt r1,[r0]			; r8 grer ? dann neuer Startwert r1
		strgt r5,[r0,#8]			; Schreibe Farbe in Startx		

		ldr r8,[r0,#4]			; Lade Endwert
		cmp r8,r1				; Endwert kleiner als aktuelles x ?
		strlt r1,[r0,#4]			; Endwert kleiner, dann schreibe aktuelles x
		strlt r5,[r0,#12]			; Endfarbwert eintragen
		
nichtsberechnen	ldmfd r13!,{r0,r5,r8}
		mov r15,r14			; RET

lineend		sub r0,r0,#1			; Schleifenzaehler
		cmp r0,#0
		bgt komplett

		ldmfd r13!,{r0-r12,r14}		; Restauriere Register
		mov r15,r14			; RET




;------------------------------------------------------------------------------------------------------------------------------------------
; Rotiere Vektorenarray r0 - source, r1 - winkel [ Aufbau: 1. Wert - Anzahl der Vektoren, x,y,z,farbe
;			Dest ist immer 0x03000004	[nach Frame-ADR]
; Rotation um z: 	xneu=xalt * cos - yalt * sin
;		yneu=yalt * cos + xalt * sin
;		zneu=zalt
; Rotation um y:	yneu=xalt * cos - zalt * sin
;		zneu=zalt * cos + xalt * sin
;		yneu=yalt
; Rotation um x:	zneu=zalt * cos - yalt * sin
;		yneu=yalt * cos + zalt * sin
;		xalt=xneu
; -----------------------------------------------------------------------------------------------------------------------------------------

rotatez
		stmfd r13!,{r0-r12}

		ldr r2,[r0],#4			; Anzahl der Vektoren, die zu rotieren sind
		ldr r3,[vectable]			; Zieladresse
		str r2,[r3],#4			; Anzahl der Vektoren speichern		

		ldr r12,[sinus]			; Adresse der Sin-Table
		and r1,r1,#0xFF			; Habe nur 256 Winkel, sichergehen
		add r12,r12,r1,lsl#2			; Winkel * 4 wg. DCD
		ldr r11,[r12]			; Lade den Sinus
		ldr r12,[cosinus]			; Adresse der COS-Table
		add r12,r12,r1,lsl#2
		ldr r10,[r12]			; Lade den Cosinus

allerotierenz	ldr r8,[r0],#4			; wir holen x vektor
		ldr r9,[r0],#4			; wir holen y vektor
		ldr r12,[r0],#4			; wir holen z vektor
		ldr r7,[r0],#4			; wir holen farbe vektor

; rotate by z

		mul r4,r8,r10			;x*cos
		mul r5,r9,r11			;y*sin
		sub r4,r4,r5
		mov r4,r4,asr#10			; r4 ist xneu

		mul r6,r9,r10			;y*cos
		mla r5,r8,r11,r6		
		mov r5,r5,asr#10			; r5 ist yneu

; rotate by x
		mul r8,r12,r11			; z* sin
		mla r9,r5,r10,r8			; yneu * cos + r8
		mov r9,r9,asr#10			; yganzneu

		mul r8,r12,r10			; z*cos
		mul r12,r5,r11			; y*sin
		sub r5,r8,r12
		mov r5,r5,asr#10			; zneu
		
	
		add r4,r4,#120			; auf Bildschirm zentrieren
		add r9,r9,#80
		str r4,[r3],#4			; jetzt speichern wir die Resultate in iRAM
		str r9,[r3],#4
		str r5,[r3],#4			
		str r7,[r3],#4			

		sub r2,r2,#1			; ein Vektor erledigt
		cmp r2,#0				; alle ?
		bgt allerotierenz

rotatezende	ldmfd r13!,{r0-r12}
		mov r15,r14

;------------------------------------------------------------------------------------------------------------------------------------------
; Male objekt .....
; -----------------------------------------------------------------------------------------------------------------------------------------

drawobject
		stmfd r13!,{r0,r1,r9,r12,r14}

		ldr r12,[vectable]				; Adresse 
		ldr r0,[r12],#4				; Anzahl der Vektoren
		sub r0,r0,#6				; die Normalen abziehen

		mov r0,r0,lsr#2				; durch 4 teilen, da wir Flchen zeichnen
		
restlicheflaechen	ldr r1,[r12,#72]				; hole den Z-Wert der Normalen
		cmp r1,#0
		blt nichtzeichnen

		bl linebuffer				
		bl draw4eck 

nichtzeichnen	add r12,r12,#80
		sub r0,r0,#1
		cmp r0,#0

		bgt restlicheflaechen

		ldmfd r13!,{r0,r1,r9,r12,r14}
		mov r15,r14		

;------------------------------------------------------------------------------------------------------------------------------------------
; Lade Bild
; -----------------------------------------------------------------------------------------------------------------------------------------

loadpic
		stmfd r13!,{r0-r12}
		mov r0,0x02000000				; im eRAM sind die Bildpunkte
		ldrh r1,[r0]	,#2				; Anzahl der Bildpunkt
		mov r2,0x03000000
		ldr r2,[r2]
		add r2,r2,#0x4B00

picloop	
		ldrh r3,[r0],#2
		ldrh r5,[r2]
		and r6,r3,0xFF				; Low-Byte in r6
		cmp r6,#0
		movne r6,#2
		andne r5,r5,0xFF00				; loesche Low-Byte
		addne r5,r5,r6
		and r3,r3,0xFF00
		cmp r3,#0
		movne r3,#2
		andne r5,r5,#0xFF
		add r5,r5,r3,lsl#8
		strh r5,[r2],#2
		sub r1,r1,#2
		cmp r1,#0
		bgt picloop

		ldmfd r13!, { r0-r12}
		mov r15,r14
;------------------------------------------------------------------------------------------------------------------------------------------
; unpack RLE
; -----------------------------------------------------------------------------------------------------------------------------------------

unpackRLE	stmfd r13!,{r0-r12}

		ldr r0,[yakuzaadr]				; pointer RLE Daten
		mov r1,0x02000000				; Desti im eRAM
		ldrh r2,[r0],#2
		strh r2,[r1],#2				; Anzahl der Bildpunkte 
		ldrh r2,[r0],#2				; r2 - Anzahl der Bytes

unpackLOOP	mov r6,#8					; 8 Bits to check
		ldrb r3,[r0],#1				; read flag
		sub r2,r2,#1
nextdatabyte	ldrb r4,[r0],#1				; erstes Datenbyte
		tst r3,#1					; bit set ?
		beq onlyonebyte				; wenn 0, dann nur ein Byte

		ldrb r5,[r0],#1				; r4 - Anzahl, r5 - Byte
weiterdekompri	strb r5,[r1],#1
		sub r4,r4,#1
		cmp r4,#0
		bgt weiterdekompri
		sub r2,r2,#2
		b nextcount

onlyonebyte	strb r4,[r1],#1
		sub r2,r2,#1

nextcount		mov r3,r3,lsr#1				; next bit to check
		cmp r2,#0
		beq unpackRLEend
		sub r6,r6,#1
		cmp r6,#0
		bgt nextdatabyte

		b unpackLOOP

unpackRLEend	ldmfd r13!,{r0-r12}
		mov r15,r14	


;------------------------------------------------------------------------------------------------------------------------------------------
; Hauptprogramm
; -----------------------------------------------------------------------------------------------------------------------------------------

start		bl initGBA
		ldr r0,[pal]
		bl loadpalette
		bl divtab

		;mov r0,#0x06000000
		;mov r1,#2			; es wird immer Lowbyte, HiByte gespeichert
		;mov r1,r1,lsl#8		; er scheibt nur an durch 2 teilbare Adressen !
		;mov r2,#130
		;add r2,r2,r1
		;strh r2,[r0]			; strb schreibt nur lowbyte 2 mal !
		
		

		;ldrb r2,[r0],#1		; kann jedoch die Bytes punkt fr Punkt laden !!
		;ldrb r2,[r0]

		;ldrh r2,[r0]			; er liest Punktgenau !

		;b ende


		bl unpackRLE

		mov r1,#0
		ldr r0,[modelladr]
		
roten		bl rotatez

		bl firescreen		

		bl drawobject
		bl loadpic
		bl umschalten

		add r1,r1,#5
		and r1,r1,#0xff
		b roten

ende		b ende				; endlos-Schleife

	modelladr @DCD modell
	yakuzaadr @DCD cuberle

modell	@DCD	30

	@DCD	20,20,20,200
	@DCD	20,20,-20,105
	@DCD	20,-20,-20,190
	@DCD	20,-20,20,106
	@DCD	20,0,0,0				; die Normale durch die Flche

	@DCD	-20,20,20,90
	@DCD	20,20,20,200
	@DCD	20,-20,20,106
	@DCD	-20,-20,20,120
	@DCD	0,0,20,0				; die Normale durch die Flche


	@DCD	-20,20,20,90
	@DCD	-20,20,-20,160
	@DCD	-20,-20,-20,100
	@DCD	-20,-20,20,120
	@DCD	-20,0,0,0				; die Normale durch die Flche


	@DCD	-20,20,-20,160
	@DCD	20,20,-20,105
	@DCD	20,-20,-20,190
	@DCD	-20,-20,-20,100
	@DCD	0,0,-20,0				; die Normale durch die Flche

	@DCD	-20,20,20,90
	@DCD	-20,20,-20,160
	@DCD	20,20,-20,105
	@DCD	20,20,20,200
	@DCD	0,20,0,0				; die Normale durch die Flche

	@DCD	-20,-20,20,120
	@DCD	-20,-20,-20,100
	@DCD	20,-20,-20,190
	@DCD	20,-20,20,106
	@DCD	0,-20,0,0				; die Normale durch die Flche


@DCW #0x4422,#0x4443,#0x4864,#0x4885
      @DCW #0x4CA6,#0x4CC7,#0x50E8,#0x5109
      @DCW #0x512A,#0x554B,#0x556C,#0x598D
      @DCW #0x59AE,#0x5DCF,#0x5DF0,#0x6211
      @DCW #0x6232,#0x6653,#0x6674,#0x6A95
      @DCW #0x6AB6,#0x6ED7,#0x6EF8,#0x7319
      @DCW #0x733A,#0x775A,#0x777C,#0x7B9D
      @DCW #0x7BDE,#0x7FFF,#0x7BFF,#0x7BFF,#0x7BFF,#0x77FF
      @DCW #0x77FF,#0x77FF,#0x73FF,#0x73FF
      @DCW #0x73FF,#0x6FFF,#0x6FFF,#0x6FFF
      @DCW #0x6BFF,#0x6BFF,#0x6BFF,#0x6BFF
      @DCW #0x67FF,#0x67FF,#0x67FF,#0x63FF
      @DCW #0x63FF,#0x63FF,#0x5FFF,#0x5FFF
      @DCW #0x5FFF,#0x5BFF,#0x5BFF,#0x5BFF
      @DCW #0x5BFF,#0x57FF,#0x57FF,#0x57FF
      @DCW #0x53FF,#0x53FF,#0x53FF,#0x4FFF
      @DCW #0x4FFF,#0x4FFF,#0x4BFF,#0x4BFF
      @DCW #0x4BFF,#0x47FF,#0x47FF,#0x47FF
      @DCW #0x47FF,#0x43FF,#0x43FF,#0x43FF
      @DCW #0x3FFF,#0x3FFF,#0x3FFF,#0x3BFF
      @DCW #0x3BFF,#0x3BFF,#0x37FF,#0x37FF
      @DCW #0x37FF,#0x37FF,#0x33FF,#0x33FF
      @DCW #0x33FF,#0x2FFF,#0x2FFF,#0x2FFF
      @DCW #0x2BFF,#0x2BFF,#0x2BFF,#0x27FF
      @DCW #0x27FF,#0x27FF,#0x23FF,#0x23FF
      @DCW #0x23FF,#0x23FF,#0x1FFF,#0x1FFF
      @DCW #0x1FFF,#0x1BFF,#0x1BFF,#0x1BFF
      @DCW #0x17FF,#0x17FF,#0x17FF,#0x13FF
      @DCW #0x13FF,#0x13FF,#0x13FF,#0x0FFF
      @DCW #0x0FFF,#0x0FFF,#0x0BFF,#0x0BFF
      @DCW #0x0BFF,#0x07FF,#0x07FF,#0x07FF
      @DCW #0x03FF,#0x03FF,#0x03FF,#0x03FF
      @DCW #0x03BF,#0x037F,#0x035F,#0x031F
      @DCW #0x02FF,#0x02BF,#0x029F,#0x025F
      @DCW #0x023F,#0x01FF,#0x01BF,#0x019F
      @DCW #0x015F,#0x013F,#0x00FF,#0x00DF
      @DCW #0x009F,#0x007F,#0x003F,#0x001F
      @DCW #0x041B,#0x0C19,#0x1016,#0x1813
      @DCW #0x2010,#0x240D,#0x2C0A,#0x3407
      @DCW #0x3804,#0x4001,#0x3400,#0x2400,#0x1800,#0x0C00
      @DCW #0x0000,#0x0000,#0x0000,#0x0000,#0x0000
      @DCW #0x0000,#0x0000,#0x0000,#0x0000
      @DCW #0x0000,#0x0000,#0x0000,#0x0000
      @DCW #0x0000,#0x0000,#0x0000,#0x0000
      @DCW #0x0000,#0x0000,#0x0000,#0x0000
      @DCW #0x0000,#0x0000,#0x0000,#0x0000
      @DCW #0x0000,#0x0000,#0x0000,#0x0000
      @DCW #0x0000,#0x0000,#0x0000,#0x0000
      @DCW #0x0000,#0x0000,#0x0000,#0x0000
      @DCW #0x0000,#0x0000,#0x0000,#0x0000
      @DCW #0x0000,#0x0000,#0x0000,#0x0000
      @DCW #0x0000,#0x0000,#0x0000,#0x0000
      @DCW #0x0000,#0x0000,#0x0000,#0x0000
      @DCW #0x0000,#0x0000,#0x0000,#0x0000
      @DCW #0x0000,#0x0000,#0x0000,#0x0000
      @DCW #0x0000,#0x0000,#0x0000,#0x0000
      @DCW #0x0000,#0x0000,#0x0000,#0x0000
      @DCW #0x0000,#0x0000,#0x0000,#0x0000
      @DCW #0x0000,#0x0000,#0x0000,#0x0000
      @DCW #0x0000,#0x0000,#0x0000,#0x0000
      @DCW #0x0000,#0x0000,#0x0000,#0x0000
      @DCW #0x0000,#0x0000,#0x0000,#0x0000
      @DCW #0x0000,#0x2118
firepal @DCW #0x0000

sin   @DCD #0x00000000
      @DCD #0x00000019,#0x00000032,#0x0000004B,#0x00000064
      @DCD #0x0000007D,#0x00000096,#0x000000AF,#0x000000C7
      @DCD #0x000000E0,#0x000000F8,#0x00000111,#0x00000129
      @DCD #0x00000141,#0x00000158,#0x00000170,#0x00000187
      @DCD #0x0000019E,#0x000001B5,#0x000001CC,#0x000001E2
      @DCD #0x000001F8,#0x0000020E,#0x00000223,#0x00000238
      @DCD #0x0000024D,#0x00000261,#0x00000275,#0x00000289
      @DCD #0x0000029C,#0x000002AF,#0x000002C2,#0x000002D4
      @DCD #0x000002E5,#0x000002F6,#0x00000307,#0x00000317
      @DCD #0x00000327,#0x00000336,#0x00000345,#0x00000353
      @DCD #0x00000361,#0x0000036E,#0x0000037A,#0x00000387
      @DCD #0x00000392,#0x0000039D,#0x000003A8,#0x000003B2
      @DCD #0x000003BB,#0x000003C4,#0x000003CC,#0x000003D3
      @DCD #0x000003DA,#0x000003E1,#0x000003E7,#0x000003EC
      @DCD #0x000003F0,#0x000003F4,#0x000003F8,#0x000003FB
      @DCD #0x000003FD,#0x000003FE,#0x000003FF,#0x000003FF
      @DCD #0x000003FF,#0x000003FE,#0x000003FD,#0x000003FB
      @DCD #0x000003F8,#0x000003F4,#0x000003F0,#0x000003EC
      @DCD #0x000003E7,#0x000003E1,#0x000003DA,#0x000003D3
      @DCD #0x000003CC,#0x000003C4,#0x000003BB,#0x000003B2
      @DCD #0x000003A8,#0x0000039D,#0x00000392,#0x00000387
      @DCD #0x0000037A,#0x0000036E,#0x00000361,#0x00000353
      @DCD #0x00000345,#0x00000336,#0x00000327,#0x00000317
      @DCD #0x00000307,#0x000002F6,#0x000002E5,#0x000002D4
      @DCD #0x000002C2,#0x000002AF,#0x0000029C,#0x00000289
      @DCD #0x00000275,#0x00000261,#0x0000024D,#0x00000238
      @DCD #0x00000223,#0x0000020E,#0x000001F8,#0x000001E2
      @DCD #0x000001CC,#0x000001B5,#0x0000019E,#0x00000187
      @DCD #0x00000170,#0x00000158,#0x00000141,#0x00000129
      @DCD #0x00000111,#0x000000F8,#0x000000E0,#0x000000C7
      @DCD #0x000000AF,#0x00000096,#0x0000007D,#0x00000064
      @DCD #0x0000004B,#0x00000032,#0x00000019,#0x00000000
      @DCD #0xFFFFFFE7,#0xFFFFFFCE,#0xFFFFFFB5,#0xFFFFFF9C
      @DCD #0xFFFFFF83,#0xFFFFFF6A,#0xFFFFFF51,#0xFFFFFF39
      @DCD #0xFFFFFF20,#0xFFFFFF08,#0xFFFFFEEF,#0xFFFFFED7
      @DCD #0xFFFFFEBF,#0xFFFFFEA8,#0xFFFFFE90,#0xFFFFFE79
      @DCD #0xFFFFFE62,#0xFFFFFE4B,#0xFFFFFE34,#0xFFFFFE1E
      @DCD #0xFFFFFE08,#0xFFFFFDF2,#0xFFFFFDDD,#0xFFFFFDC8
      @DCD #0xFFFFFDB3,#0xFFFFFD9F,#0xFFFFFD8B,#0xFFFFFD77
      @DCD #0xFFFFFD64,#0xFFFFFD51,#0xFFFFFD3E,#0xFFFFFD2C
      @DCD #0xFFFFFD1B,#0xFFFFFD0A,#0xFFFFFCF9,#0xFFFFFCE9
      @DCD #0xFFFFFCD9,#0xFFFFFCCA,#0xFFFFFCBB,#0xFFFFFCAD
      @DCD #0xFFFFFC9F,#0xFFFFFC92,#0xFFFFFC86,#0xFFFFFC79
      @DCD #0xFFFFFC6E,#0xFFFFFC63,#0xFFFFFC58,#0xFFFFFC4E
      @DCD #0xFFFFFC45,#0xFFFFFC3C,#0xFFFFFC34,#0xFFFFFC2D
      @DCD #0xFFFFFC26,#0xFFFFFC1F,#0xFFFFFC19,#0xFFFFFC14
      @DCD #0xFFFFFC10,#0xFFFFFC0C,#0xFFFFFC08,#0xFFFFFC05
      @DCD #0xFFFFFC03,#0xFFFFFC02,#0xFFFFFC01,#0xFFFFFC01
      @DCD #0xFFFFFC01,#0xFFFFFC02,#0xFFFFFC03,#0xFFFFFC05
      @DCD #0xFFFFFC08,#0xFFFFFC0C,#0xFFFFFC10,#0xFFFFFC14
      @DCD #0xFFFFFC19,#0xFFFFFC1F,#0xFFFFFC26,#0xFFFFFC2D
      @DCD #0xFFFFFC34,#0xFFFFFC3C,#0xFFFFFC45,#0xFFFFFC4E
      @DCD #0xFFFFFC58,#0xFFFFFC63,#0xFFFFFC6E,#0xFFFFFC79
      @DCD #0xFFFFFC86,#0xFFFFFC92,#0xFFFFFC9F,#0xFFFFFCAD
      @DCD #0xFFFFFCBB,#0xFFFFFCCA,#0xFFFFFCD9,#0xFFFFFCE9
      @DCD #0xFFFFFCF9,#0xFFFFFD0A,#0xFFFFFD1B,#0xFFFFFD2C
      @DCD #0xFFFFFD3E,#0xFFFFFD51,#0xFFFFFD64,#0xFFFFFD77
      @DCD #0xFFFFFD8B,#0xFFFFFD9F,#0xFFFFFDB3,#0xFFFFFDC8
      @DCD #0xFFFFFDDD,#0xFFFFFDF2,#0xFFFFFE08,#0xFFFFFE1E
      @DCD #0xFFFFFE34,#0xFFFFFE4B,#0xFFFFFE62,#0xFFFFFE79
      @DCD #0xFFFFFE90,#0xFFFFFEA8,#0xFFFFFEBF,#0xFFFFFED7
      @DCD #0xFFFFFEEF,#0xFFFFFF08,#0xFFFFFF20,#0xFFFFFF39
      @DCD #0xFFFFFF51,#0xFFFFFF6A,#0xFFFFFF83,#0xFFFFFF9C
      @DCD #0xFFFFFFB5,#0xFFFFFFCE,#0xFFFFFFE7,#0x00000000

cos   @DCD #0x000003FF
      @DCD #0x000003FF,#0x000003FE,#0x000003FD,#0x000003FB
      @DCD #0x000003F8,#0x000003F4,#0x000003F0,#0x000003EC
      @DCD #0x000003E7,#0x000003E1,#0x000003DA,#0x000003D3
      @DCD #0x000003CC,#0x000003C4,#0x000003BB,#0x000003B2
      @DCD #0x000003A8,#0x0000039D,#0x00000392,#0x00000387
      @DCD #0x0000037A,#0x0000036E,#0x00000361,#0x00000353
      @DCD #0x00000345,#0x00000336,#0x00000327,#0x00000317
      @DCD #0x00000307,#0x000002F6,#0x000002E5,#0x000002D4
      @DCD #0x000002C2,#0x000002AF,#0x0000029C,#0x00000289
      @DCD #0x00000275,#0x00000261,#0x0000024D,#0x00000238
      @DCD #0x00000223,#0x0000020E,#0x000001F8,#0x000001E2
      @DCD #0x000001CC,#0x000001B5,#0x0000019E,#0x00000187
      @DCD #0x00000170,#0x00000158,#0x00000141,#0x00000129
      @DCD #0x00000111,#0x000000F8,#0x000000E0,#0x000000C7
      @DCD #0x000000AF,#0x00000096,#0x0000007D,#0x00000064
      @DCD #0x0000004B,#0x00000032,#0x00000019,#0x00000000
      @DCD #0xFFFFFFE7,#0xFFFFFFCE,#0xFFFFFFB5,#0xFFFFFF9C
      @DCD #0xFFFFFF83,#0xFFFFFF6A,#0xFFFFFF51,#0xFFFFFF39
      @DCD #0xFFFFFF20,#0xFFFFFF08,#0xFFFFFEEF,#0xFFFFFED7
      @DCD #0xFFFFFEBF,#0xFFFFFEA8,#0xFFFFFE90,#0xFFFFFE79
      @DCD #0xFFFFFE62,#0xFFFFFE4B,#0xFFFFFE34,#0xFFFFFE1E
      @DCD #0xFFFFFE08,#0xFFFFFDF2,#0xFFFFFDDD,#0xFFFFFDC8
      @DCD #0xFFFFFDB3,#0xFFFFFD9F,#0xFFFFFD8B,#0xFFFFFD77
      @DCD #0xFFFFFD64,#0xFFFFFD51,#0xFFFFFD3E,#0xFFFFFD2C
      @DCD #0xFFFFFD1B,#0xFFFFFD0A,#0xFFFFFCF9,#0xFFFFFCE9
      @DCD #0xFFFFFCD9,#0xFFFFFCCA,#0xFFFFFCBB,#0xFFFFFCAD
      @DCD #0xFFFFFC9F,#0xFFFFFC92,#0xFFFFFC86,#0xFFFFFC79
      @DCD #0xFFFFFC6E,#0xFFFFFC63,#0xFFFFFC58,#0xFFFFFC4E
      @DCD #0xFFFFFC45,#0xFFFFFC3C,#0xFFFFFC34,#0xFFFFFC2D
      @DCD #0xFFFFFC26,#0xFFFFFC1F,#0xFFFFFC19,#0xFFFFFC14
      @DCD #0xFFFFFC10,#0xFFFFFC0C,#0xFFFFFC08,#0xFFFFFC05
      @DCD #0xFFFFFC03,#0xFFFFFC02,#0xFFFFFC01,#0xFFFFFC01
      @DCD #0xFFFFFC01,#0xFFFFFC02,#0xFFFFFC03,#0xFFFFFC05
      @DCD #0xFFFFFC08,#0xFFFFFC0C,#0xFFFFFC10,#0xFFFFFC14
      @DCD #0xFFFFFC19,#0xFFFFFC1F,#0xFFFFFC26,#0xFFFFFC2D
      @DCD #0xFFFFFC34,#0xFFFFFC3C,#0xFFFFFC45,#0xFFFFFC4E
      @DCD #0xFFFFFC58,#0xFFFFFC63,#0xFFFFFC6E,#0xFFFFFC79
      @DCD #0xFFFFFC86,#0xFFFFFC92,#0xFFFFFC9F,#0xFFFFFCAD
      @DCD #0xFFFFFCBB,#0xFFFFFCCA,#0xFFFFFCD9,#0xFFFFFCE9
      @DCD #0xFFFFFCF9,#0xFFFFFD0A,#0xFFFFFD1B,#0xFFFFFD2C
      @DCD #0xFFFFFD3E,#0xFFFFFD51,#0xFFFFFD64,#0xFFFFFD77
      @DCD #0xFFFFFD8B,#0xFFFFFD9F,#0xFFFFFDB3,#0xFFFFFDC8
      @DCD #0xFFFFFDDD,#0xFFFFFDF2,#0xFFFFFE08,#0xFFFFFE1E
      @DCD #0xFFFFFE34,#0xFFFFFE4B,#0xFFFFFE62,#0xFFFFFE79
      @DCD #0xFFFFFE90,#0xFFFFFEA8,#0xFFFFFEBF,#0xFFFFFED7
      @DCD #0xFFFFFEEF,#0xFFFFFF08,#0xFFFFFF20,#0xFFFFFF39
      @DCD #0xFFFFFF51,#0xFFFFFF6A,#0xFFFFFF83,#0xFFFFFF9C
      @DCD #0xFFFFFFB5,#0xFFFFFFCE,#0xFFFFFFE7,#0x00000000
      @DCD #0x00000019,#0x00000032,#0x0000004B,#0x00000064
      @DCD #0x0000007D,#0x00000096,#0x000000AF,#0x000000C7
      @DCD #0x000000E0,#0x000000F8,#0x00000111,#0x00000129
      @DCD #0x00000141,#0x00000158,#0x00000170,#0x00000187
      @DCD #0x0000019E,#0x000001B5,#0x000001CC,#0x000001E2
      @DCD #0x000001F8,#0x0000020E,#0x00000223,#0x00000238
      @DCD #0x0000024D,#0x00000261,#0x00000275,#0x00000289
      @DCD #0x0000029C,#0x000002AF,#0x000002C2,#0x000002D4
      @DCD #0x000002E5,#0x000002F6,#0x00000307,#0x00000317
      @DCD #0x00000327,#0x00000336,#0x00000345,#0x00000353
      @DCD #0x00000361,#0x0000036E,#0x0000037A,#0x00000387
      @DCD #0x00000392,#0x0000039D,#0x000003A8,#0x000003B2
      @DCD #0x000003BB,#0x000003C4,#0x000003CC,#0x000003D3
      @DCD #0x000003DA,#0x000003E1,#0x000003E7,#0x000003EC
      @DCD #0x000003F0,#0x000003F4,#0x000003F8,#0x000003FB
      @DCD #0x000003FD,#0x000003FE,#0x000003FF,#0x000003FF


cuberle @DCW 0x31B0,0xCA5

@DCB 0xFF,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xF5,0x00,0x05,
@DCB 0xFF,0x10,0x00,0x02,0xFF,0x06,0x00,0xFF,0x03,0xFF,
@DCB 0x26,0x00,0x02,0xFF,0xA4,0x00,0x08,0xFF,0x08,0x00,
@DCB 0x03,0xFF,0x05,0x00,0xFF,0x03,0xFF,0x05,0x00,0x05,
@DCB 0xFF,0x0B,0x00,0x05,0xFF,0x0C,0x00,0x03,0xFF,0x04,
@DCB 0x00,0xFB,0x04,0xFF,0x07,0x00,0xFF,0x07,0x00,0x02,
@DCB 0xFF,0x07,0x00,0x02,0xFF,0x0C,0x00,0xDF,0x05,0xFF,
@DCB 0x76,0x00,0x08,0xFF,0x09,0x00,0x03,0xFF,0x00,0x02,
@DCB 0xFF,0x03,0x00,0xFF,0x04,0xFF,0x03,0x00,0x08,0xFF,
@DCB 0x06,0x00,0x09,0xFF,0x0B,0x00,0x05,0xFF,0x03,0x00,
@DCB 0xFF,0x03,0xFF,0x07,0x00,0x03,0xFF,0x05,0x00,0x03,
@DCB 0xFF,0x06,0x00,0x04,0xFF,0x07,0x00,0xF7,0x09,0xFF,
@DCB 0x74,0x00,0x06,0xFF,0x00,0x02,0xFF,0x08,0x00,0x03,
@DCB 0xFF,0x03,0x00,0xDF,0x03,0xFF,0x02,0x00,0x03,0xFF,
@DCB 0x03,0x00,0x05,0xFF,0x00,0x03,0xFF,0x04,0x00,0xFF,
@DCB 0x02,0xFF,0x12,0x00,0x07,0xFF,0x03,0x00,0x03,0xFF,
@DCB 0x06,0x00,0x04,0xFF,0x04,0x00,0xFF,0x04,0xFF,0x04,
@DCB 0x00,0x07,0xFF,0x04,0x00,0x02,0xFF,0x24,0x00,0x04,
@DCB 0xFF,0x53,0x00,0xFB,0x06,0xFF,0x03,0x00,0xFF,0x07,
@DCB 0x00,0x03,0xFF,0x05,0x00,0x03,0xFF,0x03,0x00,0xBF,
@DCB 0x02,0xFF,0x03,0x00,0x04,0xFF,0x02,0x00,0x03,0xFF,
@DCB 0x04,0x00,0xFF,0x12,0x00,0xED,0x02,0xFF,0x00,0x04,
@DCB 0xFF,0x05,0x00,0xFF,0x07,0x00,0x04,0xFF,0x04,0x00,
@DCB 0xB7,0x04,0xFF,0x04,0x00,0x03,0xFF,0x00,0x03,0xFF,
@DCB 0x04,0x00,0xFF,0x22,0x00,0xFF,0x07,0xFF,0x53,0x00,
@DCB 0x05,0xFF,0x03,0x00,0x02,0xFF,0x06,0x00,0x05,0xFF,
@DCB 0x03,0x00,0xFF,0x04,0xFF,0x03,0x00,0x02,0xFF,0x02,
@DCB 0x00,0x03,0xFF,0x03,0x00,0x04,0xFF,0x03,0x00,0xFF,
@DCB 0x0A,0xFF,0x08,0x00,0x03,0xFF,0x02,0x00,0x03,0xFF,
@DCB 0x05,0x00,0x02,0xFF,0x06,0x00,0xFF,0x05,0xFF,0x05,
@DCB 0x00,0x02,0xFF,0x04,0x00,0x02,0xFF,0x03,0x00,0x03,
@DCB 0xFF,0x03,0x00,0xFB,0x0A,0xFF,0x1A,0x00,0xFF,0x03,
@DCB 0x00,0x03,0xFF,0x53,0x00,0x03,0xFF,0x05,0x00,0xFF,
@DCB 0x02,0xFF,0x06,0x00,0x03,0xFF,0x05,0x00,0x04,0xFF,
@DCB 0x02,0x00,0x02,0xFF,0x02,0x00,0xFF,0x03,0xFF,0x04,
@DCB 0x00,0x03,0xFF,0x04,0x00,0x0A,0xFF,0x07,0x00,0x03,
@DCB 0xFF,0x03,0x00,0xFF,0x02,0xFF,0x06,0x00,0x02,0xFF,
@DCB 0x05,0x00,0x06,0xFF,0x05,0x00,0x02,0xFF,0x03,0x00,
@DCB 0xFF,0x02,0xFF,0x03,0x00,0x04,0xFF,0x03,0x00,0x0A,
@DCB 0xFF,0x0B,0x00,0x03,0xFF,0x03,0x00,0xFE,0xFF,0x0B,
@DCB 0x00,0x04,0xFF,0x53,0x00,0x02,0xFF,0x04,0x00,0x0A,
@DCB 0xFF,0x08,0x00,0xF7,0x03,0xFF,0x03,0x00,0x02,0xFF,
@DCB 0x00,0x03,0xFF,0x04,0x00,0x03,0xFF,0x05,0x00,0x7F,
@DCB 0x08,0xFF,0x08,0x00,0x03,0xFF,0x0B,0x00,0x02,0xFF,
@DCB 0x05,0x00,0x03,0xFF,0x00,0xFF,0x02,0xFF,0x06,0x00,
@DCB 0x02,0xFF,0x02,0x00,0x02,0xFF,0x03,0x00,0x04,0xFF,
@DCB 0x04,0x00,0xFF,0x08,0xFF,0x0C,0x00,0x04,0xFF,0x02,
@DCB 0x00,0x03,0xFF,0x09,0x00,0x05,0xFF,0x59,0x00,0xFF,
@DCB 0x07,0xFF,0x0A,0x00,0x04,0xFF,0x03,0x00,0x05,0xFF,
@DCB 0x03,0x00,0x04,0xFF,0x06,0x00,0x7F,0x06,0xFF,0x09,
@DCB 0x00,0x04,0xFF,0x0B,0x00,0x02,0xFF,0x04,0x00,0x04,
@DCB 0xFF,0x00,0x77,0x02,0xFF,0x06,0x00,0x02,0xFF,0x00,
@DCB 0x02,0xFF,0x03,0x00,0x02,0xFF,0x00,0xFE,0xFF,0x05,
@DCB 0x00,0x06,0xFF,0x0F,0x00,0x03,0xFF,0x02,0x00,0x03,
@DCB 0xFF,0x09,0x00,0xF7,0x04,0xFF,0x5A,0x00,0x04,0xFF,
@DCB 0x00,0x02,0xFF,0x0A,0x00,0x04,0xFF,0x02,0x00,0xF5,
@DCB 0x02,0xFF,0x00,0x02,0xFF,0x00,0x05,0xFF,0x08,0x00,
@DCB 0x04,0xFF,0x0B,0x00,0xDF,0x03,0xFF,0x0B,0x00,0x03,
@DCB 0xFF,0x03,0x00,0x04,0xFF,0x00,0x03,0xFF,0x05,0x00,
@DCB 0xFB,0x02,0xFF,0x02,0x00,0xFF,0x03,0x00,0x07,0xFF,
@DCB 0x03,0x00,0x04,0xFF,0x11,0x00,0xFF,0x03,0xFF,0x02,
@DCB 0x00,0x03,0xFF,0x08,0x00,0x04,0xFF,0x5B,0x00,0x02,
@DCB 0xFF,0x03,0x00,0xDF,0x02,0xFF,0x09,0x00,0x04,0xFF,
@DCB 0x03,0x00,0x05,0xFF,0x00,0x05,0xFF,0x07,0x00,0xFB,
@DCB 0x04,0xFF,0x08,0x00,0xFF,0x02,0x00,0x04,0xFF,0x0B,
@DCB 0x00,0x03,0xFF,0x02,0x00,0x5F,0x04,0xFF,0x02,0x00,
@DCB 0x03,0xFF,0x05,0x00,0x02,0xFF,0x00,0x02,0xFF,0x00,
@DCB 0xED,0x0A,0xFF,0x00,0x04,0xFF,0x08,0x00,0xFF,0x09,
@DCB 0x00,0x03,0xFF,0x02,0x00,0xFF,0x03,0xFF,0x07,0x00,
@DCB 0x04,0xFF,0x5C,0x00,0x02,0xFF,0x02,0x00,0x03,0xFF,
@DCB 0x09,0x00,0xFF,0x04,0xFF,0x03,0x00,0x04,0xFF,0x03,
@DCB 0x00,0x05,0xFF,0x06,0x00,0x03,0xFF,0x07,0x00,0xFF,
@DCB 0x03,0xFF,0x02,0x00,0x03,0xFF,0x08,0x00,0x02,0xFF,
@DCB 0x02,0x00,0x02,0xFF,0x02,0x00,0x6F,0x04,0xFF,0x03,
@DCB 0x00,0x03,0xFF,0x02,0x00,0xFF,0x02,0x00,0x02,0xFF,
@DCB 0x00,0xF6,0xFF,0x03,0x00,0x09,0xFF,0x00,0x03,0xFF,
@DCB 0x07,0x00,0x03,0xFF,0x09,0x00,0xFF,0x03,0xFF,0x02,
@DCB 0x00,0x03,0xFF,0x07,0x00,0x03,0xFF,0x5D,0x00,0x02,
@DCB 0xFF,0x02,0x00,0xFF,0x03,0xFF,0x08,0x00,0x04,0xFF,
@DCB 0x04,0x00,0x03,0xFF,0x05,0x00,0x05,0xFF,0x02,0x00,
@DCB 0xFE,0xFF,0x02,0x00,0x03,0xFF,0x04,0x00,0x05,0xFF,
@DCB 0x03,0x00,0x03,0xFF,0x06,0x00,0x77,0x03,0xFF,0x02,
@DCB 0x00,0x03,0xFF,0x00,0x05,0xFF,0x03,0x00,0x03,0xFF,
@DCB 0x00,0xDE,0xFF,0x03,0x00,0x03,0xFF,0x09,0x00,0x04,
@DCB 0xFF,0x00,0x03,0xFF,0x04,0x00,0xFF,0x05,0xFF,0x0A,
@DCB 0x00,0x03,0xFF,0x02,0x00,0x02,0xFF,0x07,0x00,0x03,
@DCB 0xFF,0x5E,0x00,0xFF,0x02,0xFF,0x02,0x00,0x03,0xFF,
@DCB 0x07,0x00,0x04,0xFF,0x04,0x00,0x03,0xFF,0x07,0x00,
@DCB 0xFF,0x07,0xFF,0x02,0x00,0x0B,0xFF,0x04,0x00,0x03,
@DCB 0xFF,0x04,0x00,0x05,0xFF,0x02,0x00,0x7F,0x07,0xFF,
@DCB 0x05,0x00,0x05,0xFF,0x03,0x00,0x02,0xFF,0x0A,0x00,
@DCB 0x04,0xFF,0x00,0x77,0x0B,0xFF,0x0B,0x00,0x03,0xFF,
@DCB 0x00,0x03,0xFF,0x02,0x00,0x03,0xFF,0x00,0xFB,0x0B,
@DCB 0xFF,0x57,0x00,0xFF,0x02,0x00,0x04,0xFF,0x06,0x00,
@DCB 0x04,0xFF,0x05,0x00,0xFF,0x03,0xFF,0x08,0x00,0x06,
@DCB 0xFF,0x03,0x00,0x08,0xFF,0x07,0x00,0x0B,0xFF,0x02,
@DCB 0x00,0xBF,0x06,0xFF,0x06,0x00,0x05,0xFF,0x02,0x00,
@DCB 0x03,0xFF,0x02,0x00,0xFF,0x04,0x00,0xDF,0x06,0xFF,
@DCB 0x03,0x00,0x08,0xFF,0x0E,0x00,0x02,0xFF,0x00,0x02,
@DCB 0xFF,0x03,0x00,0xFD,0x03,0xFF,0x00,0x0B,0xFF,0x56,
@DCB 0x00,0x02,0xFF,0x02,0x00,0x03,0xFF,0x08,0x00,0xFF,
@DCB 0x02,0xFF,0x06,0x00,0x02,0xFF,0x0A,0x00,0x05,0xFF,
@DCB 0x04,0x00,0x05,0xFF,0x0A,0x00,0xFF,0x08,0xFF,0x05,
@DCB 0x00,0x04,0xFF,0x07,0x00,0x05,0xFF,0x02,0x00,0x02,
@DCB 0xFF,0x03,0x00,0xFF,0x0A,0xFF,0x05,0x00,0x05,0xFF,
@DCB 0x11,0x00,0x04,0xFF,0x03,0x00,0x02,0xFF,0x02,0x00,
@DCB 0xB7,0x0A,0xFF,0x57,0x00,0x02,0xFF,0x00,0x04,0xFF,
@DCB 0x11,0x00,0xFF,0x0C,0x00,0xFF,0x02,0xFF,0x15,0x00,
@DCB 0x05,0xFF,0x08,0x00,0x02,0xFF,0x08,0x00,0x04,0xFF,
@DCB 0x03,0x00,0xDF,0x02,0xFF,0x03,0x00,0x09,0xFF,0x88,
@DCB 0x00,0x02,0xFF,0x00,0x03,0xFF,0x4D,0x00,0xFF,0x03,
@DCB 0xFF,0x0A,0x00,0x05,0xFF,0x8B,0x00,0x06,0xFF,0xEA,
@DCB 0x00,0x05,0xFF,0xED,0x00,0xFF,0x02,0xFF,0xFF,0x00,
@DCB 0x02,0x00,0x02,0xFF,0x91,0x00,0x02,0xFF,0x5A,0x00,
@DCB 0x02,0xFF,0xFF,0x0E,0x00,0x05,0xFF,0x25,0x00,0x05,
@DCB 0xFF,0x27,0x00,0x05,0xFF,0x28,0x00,0x02,0xFF,0xBF,
@DCB 0x21,0x00,0x06,0xFF,0x03,0x00,0x06,0xFF,0x02,0x00,
@DCB 0x03,0xFF,0x00,0x04,0xFF,0xFB,0x02,0x00,0x03,0xFF,
@DCB 0x00,0x04,0xFF,0x04,0x00,0x06,0xFF,0x03,0x00,0x06,
@DCB 0xFF,0xFE,0x00,0x08,0xFF,0x02,0x00,0x06,0xFF,0x08,
@DCB 0x00,0x04,0xFF,0x05,0x00,0x02,0xFF,0xFA,0x00,0x05,
@DCB 0xFF,0x00,0x06,0xFF,0x04,0x00,0x06,0xFF,0x08,0x00,
@DCB 0x04,0xFF,0xFF,0x03,0x00,0x06,0xFF,0x06,0x00,0x02,
@DCB 0xFF,0x09,0x00,0x07,0xFF,0x07,0x00,0x04,0xFF,0xFB,
@DCB 0x02,0x00,0x03,0xFF,0x00,0x04,0xFF,0x04,0x00,0x06,
@DCB 0xFF,0x02,0x00,0x05,0xFF,0xEB,0x03,0x00,0x05,0xFF,
@DCB 0x00,0x03,0xFF,0x00,0x02,0xFF,0x02,0x00,0x05,0xFF,
@DCB 0xF3,0x04,0x00,0x04,0xFF,0x00,0xFF,0x0B,0x00,0x02,
@DCB 0xFF,0x07,0x00,0x02,0xFF,0xFF,0x03,0x00,0x03,0xFF,
@DCB 0x02,0x00,0x03,0xFF,0x02,0x00,0x02,0xFF,0x03,0x00,
@DCB 0x03,0xFF,0xFF,0x02,0x00,0x02,0xFF,0x03,0x00,0x02,
@DCB 0xFF,0x03,0x00,0x02,0xFF,0x02,0x00,0x02,0xFF,0xFF,
@DCB 0x08,0x00,0x03,0xFF,0x04,0x00,0x02,0xFF,0x03,0x00,
@DCB 0x02,0xFF,0x05,0x00,0x03,0xFF,0xFF,0x03,0x00,0x02,
@DCB 0xFF,0x04,0x00,0x03,0xFF,0x03,0x00,0x04,0xFF,0x03,
@DCB 0x00,0x03,0xFF,0xFF,0x02,0x00,0x02,0xFF,0x03,0x00,
@DCB 0x03,0xFF,0x04,0x00,0x03,0xFF,0x03,0x00,0x02,0xFF,
@DCB 0xFE,0x00,0x02,0xFF,0x03,0x00,0x02,0xFF,0x06,0x00,
@DCB 0x02,0xFF,0x08,0x00,0x03,0xFF,0xFF,0x03,0x00,0x02,
@DCB 0xFF,0x04,0x00,0x03,0xFF,0x03,0x00,0x02,0xFF,0x02,
@DCB 0x00,0x03,0xFF,0xBF,0x02,0x00,0x02,0xFF,0x03,0x00,
@DCB 0x02,0xFF,0x03,0x00,0x02,0xFF,0x00,0x02,0xFF,0xBB,
@DCB 0x03,0x00,0x02,0xFF,0x00,0x02,0xFF,0x03,0x00,0x02,
@DCB 0xFF,0x00,0x02,0xFF,0xFE,0x00,0x04,0xFF,0x03,0x00,
@DCB 0x03,0xFF,0x02,0x00,0x02,0xFF,0x02,0x00,0x02,0xFF,
@DCB 0xFF,0x0B,0x00,0x02,0xFF,0x07,0x00,0x02,0xFF,0x05,
@DCB 0x00,0x02,0xFF,0x02,0x00,0x02,0xFF,0xFF,0x03,0x00,
@DCB 0x02,0xFF,0x03,0x00,0x02,0xFF,0x03,0x00,0x02,0xFF,
@DCB 0x02,0x00,0x02,0xFF,0xFF,0x03,0x00,0x02,0xFF,0x02,
@DCB 0x00,0x02,0xFF,0x09,0x00,0x02,0xFF,0x04,0x00,0x02,
@DCB 0xFF,0xFF,0x03,0x00,0x02,0xFF,0x05,0x00,0x02,0xFF,
@DCB 0x05,0x00,0x02,0xFF,0x04,0x00,0x03,0xFF,0xEF,0x03,
@DCB 0x00,0x03,0xFF,0x05,0x00,0x02,0xFF,0x00,0x02,0xFF,
@DCB 0x05,0x00,0x02,0xFF,0xFF,0x03,0x00,0x02,0xFF,0x05,
@DCB 0x00,0x04,0xFF,0x03,0x00,0x02,0xFF,0x05,0x00,0x04,
@DCB 0xFF,0xF7,0x07,0x00,0x03,0xFF,0x05,0x00,0xFF,0x03,
@DCB 0x00,0x02,0xFF,0x05,0x00,0x02,0xFF,0xFF,0x02,0x00,
@DCB 0x02,0xFF,0x03,0x00,0x02,0xFF,0x02,0x00,0x02,0xFF,
@DCB 0x03,0x00,0x02,0xFF,0xBF,0x02,0x00,0x02,0xFF,0x06,
@DCB 0x00,0x02,0xFF,0x06,0x00,0x02,0xFF,0x00,0x03,0xFF,
@DCB 0xFB,0x05,0x00,0x02,0xFF,0x00,0x02,0xFF,0x03,0x00,
@DCB 0x02,0xFF,0x0B,0x00,0x02,0xFF,0xFF,0x07,0x00,0x02,
@DCB 0xFF,0x05,0x00,0x02,0xFF,0x02,0x00,0x02,0xFF,0x02,
@DCB 0x00,0x02,0xFF,0xFF,0x04,0x00,0x02,0xFF,0x02,0x00,
@DCB 0x02,0xFF,0x03,0x00,0x0B,0xFF,0x09,0x00,0x02,0xFF,
@DCB 0xFF,0x04,0x00,0x09,0xFF,0x03,0x00,0x02,0xFF,0x05,
@DCB 0x00,0x02,0xFF,0x04,0x00,0x02,0xFF,0xEF,0x04,0x00,
@DCB 0x03,0xFF,0x05,0x00,0x02,0xFF,0x00,0x02,0xFF,0x05,
@DCB 0x00,0x02,0xFF,0x9F,0x03,0x00,0x02,0xFF,0x05,0x00,
@DCB 0x0B,0xFF,0x03,0x00,0xFF,0x00,0x02,0xFF,0xFF,0x07,
@DCB 0x00,0x02,0xFF,0x05,0x00,0x02,0xFF,0x03,0x00,0x02,
@DCB 0xFF,0x05,0x00,0x02,0xFF,0xBF,0x02,0x00,0x02,0xFF,
@DCB 0x02,0x00,0x02,0xFF,0x03,0x00,0x09,0xFF,0x00,0x06,
@DCB 0xFF,0xEB,0x02,0x00,0x06,0xFF,0x00,0x02,0xFF,0x00,
@DCB 0x03,0xFF,0x05,0x00,0x02,0xFF,0xFE,0x00,0x02,0xFF,
@DCB 0x03,0x00,0x02,0xFF,0x0B,0x00,0x02,0xFF,0x07,0x00,
@DCB 0x02,0xFF,0xFF,0x05,0x00,0x02,0xFF,0x02,0x00,0x05,
@DCB 0xFF,0x05,0x00,0x05,0xFF,0x04,0x00,0x02,0xFF,0xFF,
@DCB 0x07,0x00,0x02,0xFF,0x09,0x00,0x02,0xFF,0x04,0x00,
@DCB 0x02,0xFF,0x0A,0x00,0x02,0xFF,0xFF,0x05,0x00,0x02,
@DCB 0xFF,0x04,0x00,0x02,0xFF,0x04,0x00,0x02,0xFF,0x05,
@DCB 0x00,0x02,0xFF,0xFF,0x02,0x00,0x02,0xFF,0x05,0x00,
@DCB 0x02,0xFF,0x03,0x00,0x02,0xFF,0x05,0x00,0x04,0xFF,
@DCB 0xFD,0x09,0x00,0xFF,0x02,0x00,0x02,0xFF,0x07,0x00,
@DCB 0x02,0xFF,0x05,0x00,0x02,0xFF,0xFF,0x03,0x00,0x02,
@DCB 0xFF,0x05,0x00,0x02,0xFF,0x02,0x00,0x05,0xFF,0x04,
@DCB 0x00,0x02,0xFF,0xAF,0x0C,0x00,0x02,0xFF,0x06,0x00,
@DCB 0x02,0xFF,0x00,0x02,0xFF,0x00,0x02,0xFF,0xFF,0x05,
@DCB 0x00,0x02,0xFF,0x02,0x00,0x02,0xFF,0x03,0x00,0x02,
@DCB 0xFF,0x0B,0x00,0x03,0xFF,0xF9,0x04,0x00,0xFF,0x00,
@DCB 0x03,0xFF,0x03,0x00,0x02,0xFF,0x03,0x00,0x02,0xFF,
@DCB 0xFF,0x02,0x00,0x02,0xFF,0x04,0x00,0x02,0xFF,0x02,
@DCB 0x00,0x02,0xFF,0x03,0x00,0x03,0xFF,0xD9,0x04,0x00,
@DCB 0xFF,0x00,0x03,0xFF,0x04,0x00,0xFF,0x03,0x00,0x02,
@DCB 0xFF,0xD9,0x02,0x00,0xFF,0x00,0x03,0xFF,0x04,0x00,
@DCB 0xFF,0x04,0x00,0x03,0xFF,0xFF,0x03,0x00,0x02,0xFF,
@DCB 0x05,0x00,0x02,0xFF,0x04,0x00,0x02,0xFF,0x04,0x00,
@DCB 0x02,0xFF,0xFF,0x03,0x00,0x03,0xFF,0x03,0x00,0x02,
@DCB 0xFF,0x04,0x00,0x03,0xFF,0x03,0x00,0x02,0xFF,0xD6,
@DCB 0x00,0x03,0xFF,0x04,0x00,0xFF,0x02,0x00,0xFF,0x03,
@DCB 0x00,0x02,0xFF,0xFF,0x07,0x00,0x03,0xFF,0x03,0x00,
@DCB 0x03,0xFF,0x03,0x00,0x03,0xFF,0x03,0x00,0x02,0xFF,
@DCB 0x7F,0x03,0x00,0x02,0xFF,0x02,0x00,0x02,0xFF,0x03,
@DCB 0x00,0x03,0xFF,0x04,0x00,0xFF,0xEE,0x00,0x02,0xFF,
@DCB 0x03,0x00,0x02,0xFF,0x00,0x02,0xFF,0x03,0x00,0x02,
@DCB 0xFF,0xFA,0x00,0x02,0xFF,0x00,0x02,0xFF,0x04,0x00,
@DCB 0x02,0xFF,0x03,0x00,0x03,0xFF,0xFD,0x03,0x00,0xFF,
@DCB 0x0C,0x00,0x07,0xFF,0x02,0x00,0x06,0xFF,0x03,0x00,
@DCB 0x02,0xFF,0xEF,0x04,0x00,0x06,0xFF,0x04,0x00,0x04,
@DCB 0xFF,0x00,0x06,0xFF,0x03,0x00,0x07,0xFF,0xFF,0x04,
@DCB 0x00,0x04,0xFF,0x02,0x00,0x06,0xFF,0x06,0x00,0x06,
@DCB 0xFF,0x06,0x00,0x02,0xFF,0xFB,0x04,0x00,0x02,0xFF,
@DCB 0x00,0x06,0xFF,0x03,0x00,0x06,0xFF,0x06,0x00,0x06,
@DCB 0xFF,0x3F,0x03,0x00,0x06,0xFF,0x04,0x00,0x07,0xFF,
@DCB 0x06,0x00,0x06,0xFF,0x00,0xFF,0xBF,0x04,0x00,0x06,
@DCB 0xFF,0x03,0x00,0x02,0xFF,0x04,0x00,0x04,0xFF,0x00,
@DCB 0x06,0xFF,0xBF,0x02,0x00,0x06,0xFF,0x02,0x00,0x06,
@DCB 0xFF,0x05,0x00,0x02,0xFF,0x00,0x07,0xFF,0xF3,0x02,
@DCB 0x00,0x04,0xFF,0x00,0xFF,0x99,0x00,0x02,0xFF,0x4E,
@DCB 0x00,0x02,0xFF,0xFF,0x03,0x00,0x02,0xFF,0x99,0x00,
@DCB 0x02,0xFF,0x4D,0x00,0x02,0xFF,0x03,0x00,0x02,0xFF,
@DCB 0xBF,0xE9,0x00,0x06,0xFF,0xFF,0x00,0x65,0x00,0x02,
@DCB 0xFF,0x21,0x00,0xFF,0xCC,0x00,0x73,0x02,0xFF,0x20,
@DCB 0x00,0xFF,0x00,0x04,0xFF,0x07,0x00,0x02,0xFF,0x00,
@DCB 0xD7,0x02,0xFF,0x08,0x00,0x02,0xFF,0x00,0x04,0xFF,
@DCB 0x00,0x03,0xFF,0x03,0x00,0x57,0x03,0xFF,0x03,0x00,
@DCB 0x04,0xFF,0x00,0x04,0xFF,0x00,0x05,0xFF,0x00,0xF5,
@DCB 0x03,0xFF,0x00,0x02,0xFF,0x00,0x03,0xFF,0x04,0x00,
@DCB 0x03,0xFF,0x44,0x00,0xFF,0x05,0xFF,0x36,0x00,0x02,
@DCB 0xFF,0x1F,0x00,0x02,0xFF,0x03,0x00,0x02,0xFF,0x05,
@DCB 0x00,0xFB,0x02,0xFF,0x04,0x00,0xFF,0x08,0x00,0x02,
@DCB 0xFF,0x02,0x00,0x03,0xFF,0x02,0x00,0xBE,0xFF,0x04,
@DCB 0x00,0x03,0xFF,0x04,0x00,0x03,0xFF,0x02,0x00,0xFF,
@DCB 0x04,0x00,0xCB,0x03,0xFF,0x03,0x00,0xFF,0x02,0x00,
@DCB 0xFF,0x00,0x04,0xFF,0x04,0x00,0xD7,0x03,0xFF,0x28,
@DCB 0x00,0x02,0xFF,0x00,0x05,0xFF,0x00,0x06,0xFF,0x04,
@DCB 0x00,0xFF,0x06,0xFF,0x08,0x00,0x04,0xFF,0x04,0x00,
@DCB 0x06,0xFF,0x05,0x00,0x02,0xFF,0x08,0x00,0x7D,0x05,
@DCB 0xFF,0x00,0x05,0xFF,0x02,0x00,0x02,0xFF,0x03,0x00,
@DCB 0x06,0xFF,0x00,0xFF,0x02,0xFF,0x04,0x00,0x02,0xFF,
@DCB 0x02,0x00,0x05,0xFF,0x11,0x00,0x03,0xFF,0x04,0x00,
@DCB 0xEE,0xFF,0x05,0x00,0x03,0xFF,0x03,0x00,0xFF,0x08,
@DCB 0x00,0x02,0xFF,0x02,0x00,0xF3,0x06,0xFF,0x03,0x00,
@DCB 0xFF,0x00,0x03,0xFF,0x03,0x00,0x03,0xFF,0x02,0x00,
@DCB 0xEE,0xFF,0x04,0x00,0x03,0xFF,0x03,0x00,0xFF,0x04,
@DCB 0x00,0x03,0xFF,0x04,0x00,0xFC,0xFF,0x00,0x03,0xFF,
@DCB 0x27,0x00,0x03,0xFF,0x03,0x00,0x04,0xFF,0x03,0x00,
@DCB 0xFF,0x03,0xFF,0x02,0x00,0x02,0xFF,0x03,0x00,0x03,
@DCB 0xFF,0x04,0x00,0x03,0xFF,0x03,0x00,0xFF,0x02,0xFF,
@DCB 0x02,0x00,0x02,0xFF,0x03,0x00,0x02,0xFF,0x05,0x00,
@DCB 0x02,0xFF,0x07,0x00,0xEF,0x02,0xFF,0x03,0x00,0x02,
@DCB 0xFF,0x02,0x00,0xFF,0x04,0x00,0x02,0xFF,0x02,0x00,
@DCB 0xEF,0x02,0xFF,0x06,0x00,0x02,0xFF,0x03,0x00,0xFF,
@DCB 0x03,0x00,0x02,0xFF,0x03,0x00,0xFF,0x02,0xFF,0x10,
@DCB 0x00,0x03,0xFF,0x0A,0x00,0x05,0xFF,0x09,0x00,0x02,
@DCB 0xFF,0x04,0x00,0x73,0x04,0xFF,0x04,0x00,0xFF,0x00,
@DCB 0x03,0xFF,0x03,0x00,0x03,0xFF,0x00,0xEF,0x02,0xFF,
@DCB 0x04,0x00,0x03,0xFF,0x03,0x00,0xFF,0x03,0x00,0x04,
@DCB 0xFF,0x04,0x00,0xFC,0xFF,0x00,0x03,0xFF,0x27,0x00,
@DCB 0x03,0xFF,0x03,0x00,0x03,0xFF,0x05,0x00,0xFD,0x02,
@DCB 0xFF,0x00,0x02,0xFF,0x05,0x00,0x02,0xFF,0x03,0x00,
@DCB 0x02,0xFF,0x05,0x00,0xFD,0x02,0xFF,0x00,0x02,0xFF,
@DCB 0x03,0x00,0x02,0xFF,0x04,0x00,0x04,0xFF,0x07,0x00,
@DCB 0xDB,0x02,0xFF,0x06,0x00,0xFF,0x05,0x00,0x02,0xFF,
@DCB 0x00,0x02,0xFF,0x07,0x00,0x7D,0x02,0xFF,0x00,0x02,
@DCB 0xFF,0x04,0x00,0x02,0xFF,0x15,0x00,0x03,0xFF,0x00,
@DCB 0xFF,0x04,0xFF,0x06,0x00,0x05,0xFF,0x08,0x00,0x02,
@DCB 0xFF,0x04,0x00,0x03,0xFF,0x05,0x00,0xFC,0xFF,0x00,
@DCB 0x03,0xFF,0x03,0x00,0x06,0xFF,0x04,0x00,0x03,0xFF,
@DCB 0x03,0x00,0xCE,0xFF,0x03,0x00,0x03,0xFF,0x05,0x00,
@DCB 0xFF,0x00,0x03,0xFF,0x27,0x00,0xDF,0x02,0xFF,0x04,
@DCB 0x00,0x03,0xFF,0x05,0x00,0x02,0xFF,0x00,0x02,0xFF,
@DCB 0x05,0x00,0xDF,0x02,0xFF,0x03,0x00,0x02,0xFF,0x05,
@DCB 0x00,0x02,0xFF,0x00,0x09,0xFF,0x02,0x00,0x7C,0xFF,
@DCB 0x00,0x02,0xFF,0x08,0x00,0x08,0xFF,0x05,0x00,0x02,
@DCB 0xFF,0x00,0xFF,0x02,0xFF,0x07,0x00,0x04,0xFF,0x06,
@DCB 0x00,0x06,0xFF,0x10,0x00,0x03,0xFF,0x02,0x00,0xFF,
@DCB 0x02,0xFF,0x08,0x00,0x05,0xFF,0x07,0x00,0x02,0xFF,
@DCB 0x05,0x00,0x03,0xFF,0x04,0x00,0xFC,0xFF,0x00,0x03,
@DCB 0xFF,0x03,0x00,0x07,0xFF,0x03,0x00,0x03,0xFF,0x03,
@DCB 0x00,0xCE,0xFF,0x03,0x00,0x03,0xFF,0x05,0x00,0xFF,
@DCB 0x00,0x03,0xFF,0x27,0x00,0xFF,0x02,0xFF,0x04,0x00,
@DCB 0x02,0xFF,0x05,0x00,0x02,0xFF,0x02,0x00,0x02,0xFF,
@DCB 0x05,0x00,0xDF,0x02,0xFF,0x03,0x00,0x02,0xFF,0x05,
@DCB 0x00,0x02,0xFF,0x00,0x02,0xFF,0x08,0x00,0x7E,0xFF,
@DCB 0x02,0x00,0x02,0xFF,0x0C,0x00,0x04,0xFF,0x04,0x00,
@DCB 0x03,0xFF,0x00,0xF7,0x02,0xFF,0x07,0x00,0x02,0xFF,
@DCB 0x00,0x02,0xFF,0x09,0x00,0x02,0xFF,0x10,0x00,0xEF,
@DCB 0x03,0xFF,0x02,0x00,0x02,0xFF,0x06,0x00,0xFF,0x04,
@DCB 0x00,0x02,0xFF,0x06,0x00,0xCF,0x02,0xFF,0x06,0x00,
@DCB 0x03,0xFF,0x03,0x00,0xFF,0x00,0x05,0xFF,0x02,0x00,
@DCB 0xBD,0x03,0xFF,0x00,0x03,0xFF,0x03,0x00,0x03,0xFF,
@DCB 0x03,0x00,0xFF,0x02,0x00,0xCB,0x03,0xFF,0x02,0x00,
@DCB 0xFF,0x02,0x00,0xFF,0x00,0x05,0xFF,0x26,0x00,0xFF,
@DCB 0x02,0xFF,0x04,0x00,0x02,0xFF,0x04,0x00,0x02,0xFF,
@DCB 0x03,0x00,0x03,0xFF,0x03,0x00,0xFF,0x02,0xFF,0x04,
@DCB 0x00,0x03,0xFF,0x03,0x00,0x02,0xFF,0x02,0x00,0x03,
@DCB 0xFF,0x04,0x00,0xF8,0xFF,0x00,0xFF,0x03,0x00,0x02,
@DCB 0xFF,0x07,0x00,0x02,0xFF,0x03,0x00,0x37,0x05,0xFF,
@DCB 0x02,0x00,0x04,0xFF,0x00,0x03,0xFF,0x04,0x00,0xFF,
@DCB 0x00,0xFF,0x02,0xFF,0x02,0x00,0x02,0xFF,0x03,0x00,
@DCB 0x02,0xFF,0x03,0x00,0x02,0xFF,0x11,0x00,0xDF,0x02,
@DCB 0xFF,0x02,0x00,0x02,0xFF,0x03,0x00,0x02,0xFF,0x00,
@DCB 0x02,0xFF,0x03,0x00,0xFF,0x02,0xFF,0x02,0x00,0x02,
@DCB 0xFF,0x02,0x00,0x02,0xFF,0x06,0x00,0x03,0xFF,0x03,
@DCB 0x00,0xDE,0xFF,0x03,0x00,0x03,0xFF,0x02,0x00,0x03,
@DCB 0xFF,0x00,0x03,0xFF,0x03,0x00,0xBB,0x03,0xFF,0x03,
@DCB 0x00,0xFF,0x02,0x00,0x03,0xFF,0x02,0x00,0xFF,0x02,
@DCB 0x00,0x7E,0xFF,0x03,0x00,0x03,0xFF,0x26,0x00,0x02,
@DCB 0xFF,0x04,0x00,0x02,0xFF,0x00,0xFF,0x06,0xFF,0x03,
@DCB 0x00,0x06,0xFF,0x06,0x00,0x06,0xFF,0x04,0x00,0x06,
@DCB 0xFF,0x03,0x00,0x7F,0x07,0xFF,0x05,0x00,0x06,0xFF,
@DCB 0x02,0x00,0x08,0xFF,0x02,0x00,0x07,0xFF,0x00,0xF7,
@DCB 0x02,0xFF,0x03,0x00,0x03,0xFF,0x00,0x06,0xFF,0x07,
@DCB 0x00,0x02,0xFF,0x02,0x00,0x73,0x02,0xFF,0x06,0x00,
@DCB 0xFF,0x00,0x02,0xFF,0x04,0x00,0x02,0xFF,0x00,0xF0,
@DCB 0xFF,0x00,0xFF,0x00,0x02,0xFF,0x03,0x00,0x02,0xFF,
@DCB 0x02,0x00,0xDF,0x02,0xFF,0x05,0x00,0x04,0xFF,0x02,
@DCB 0x00,0x02,0xFF,0x00,0x0F,0xFF,0x03,0x00,0x5D,0x02,
@DCB 0xFF,0x00,0x02,0xFF,0x02,0x00,0x03,0xFF,0x00,0x03,
@DCB 0xFF,0x00,0xBD,0x02,0xFF,0x00,0x06,0xFF,0x59,0x00,
@DCB 0x02,0xFF,0x4E,0x00,0xFF,0x0B,0x00,0xFF,0x02,0xFF,
@DCB 0x92,0x00,0x02,0xFF,0x5A,0x00,0x02,0xFF,0xFF,0x00,
@DCB 0xFF,0x00,0xFF,0x00,0x01,0x1D,0x00,