// DeformByTex.fx
//
// Based on
// VVVV DeformByTexture.fx
//

struct VS_OUTPUT
{
  float4 Position: POSITION;
  float3 Tex0:     TEXCOORD0;
  float3 Tex1:     TEXCOORD1;
};

sampler Sampler = sampler_state
{
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
};

sampler SamplerNoise = sampler_state
{
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
};


float V_Alpha : ALPHA;
float Displacement : VAR1;

float4 PS(VS_OUTPUT In) : COLOR0
{
	float2 disp   = Displacement*2*((((float4)tex2D(SamplerNoise, In.Tex1)))-0.5);
	float4 texCol = tex2D(Sampler,In.Tex0+disp);
	texCol.a*= V_Alpha;
	return texCol;
}

technique Deform
{
  pass PassDeform
  {
    PixelShader = compile ps_2_0 PS();
  }
}
