// Bloom based on version by vvrap
struct VS_OUTPUT
{
  float4 Position: POSITION;
  float3 Tex0:     TEXCOORD0;
};

sampler Sampler = sampler_state
{
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
};


float V_Alpha    : ALPHA;
float BloomScale : VAR1;
float blur       : VAR2;

// ================================================================
// Pixel Shader: 	HorizontalBlur
// Desc: 		Blurs the image horizontally
// ================================================================

float4 Bloom_xPS( float2 Tex : TEXCOORD0 ) : COLOR0
{
  static const int g_cKernelSize = 13;
  float define = blur * 100 + 100;
  float2 TexelKernel[13] =
  {
    { -6, 0 },
    { -5, 0 },
    { -4, 0 },
    { -3, 0 },
    { -2, 0 },
    { -1, 0 },
    {  0, 0 },
    {  1, 0 },
    {  2, 0 },
    {  3, 0 },
    {  4, 0 },
    {  5, 0 },
    {  6, 0 },
  };



  const float BlurWeights[13] =
  {
    0.002216,
    0.008764,
    0.026995,
    0.064759,
    0.120985,
    0.176033,
    0.199471,
    0.176033,
    0.120985,
    0.064759,
    0.026995,
    0.008764,
    0.002216,
  };

  float4 Color = 0;
  for (int i = 0; i < g_cKernelSize; i++)
  {
    Color += tex2D(Sampler, Tex + TexelKernel[i].xy/define ) * BlurWeights[i];
  }
  Color = tex2D(Sampler, Tex) + Color * BloomScale;
  Color.a = V_Alpha;
  return Color;
}


float4 Bloom_yPS( float2 Tex : TEXCOORD0 ) : COLOR0
{
  static const int g_cKernelSize = 13;
  float define = blur * 100 + 100;

  float2 TexelKernel[13] =
  {
    { -6, 0 },
    { -5, 0 },
    { -4, 0 },
    { -3, 0 },
    { -2, 0 },
    { -1, 0 },
    {  0, 0 },
    {  1, 0 },
    {  2, 0 },
    {  3, 0 },
    {  4, 0 },
    {  5, 0 },
    {  6, 0 },
  };

  const float BlurWeights[13] =
  {
    0.002216,
    0.008764,
    0.026995,
    0.064759,
    0.120985,
    0.176033,
    0.199471,
    0.176033,
    0.120985,
    0.064759,
    0.026995,
    0.008764,
    0.002216,
  };

  float4 Color = 0;
  for (int i = 0; i < g_cKernelSize; i++)
  {
    Color += tex2D(Sampler, Tex + TexelKernel[i].yx/define ) * BlurWeights[i];
  }
  //Color = Color * BloomScale * 1.5;
  Color = tex2D(Sampler, Tex) + Color * BloomScale;
  Color.a = V_Alpha;
  return Color;
}

// ================================================================
// Technique: 	PostProcess
// Desc: 		Performs post-processing effect that converts a colored 
//		image to black and white.
// ================================================================

technique Bloom_x
{
  pass p0
  {
    PixelShader = compile ps_2_0 Bloom_xPS();
    ZEnable = false;
  }
}
technique Bloom_y
{
  pass p0
  {
    PixelShader = compile ps_2_0 Bloom_yPS();
    ZEnable = false;
  }
}
