// BitmapPass.fx


struct VS_OUTPUT
{
  float4 Position: POSITION;
  float3 Tex0:     TEXCOORD0;
  float3 Tex1:     TEXCOORD1;
};

sampler Sampler = sampler_state
{
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
};

sampler SamplerNoise = sampler_state
{
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
};

float V_Alpha : ALPHA;
float Intens  : VAR1;

float4 PS(VS_OUTPUT In) : COLOR0
{
	float4 texCol = tex2D(Sampler, In.Tex0);
	float  p      = tex2D(SamplerNoise, In.Tex1).r + (Intens*2 - 1);
	texCol.a     *= V_Alpha * p;
	return texCol;
}

technique BitmapPass
{
  pass BitmapPass
  {
    PixelShader = compile ps_2_0 PS();
  }
}
