#include "main.h"
#include "engine.h"
#include "loadlwo.h"
#include "util.h"

static scene_s *scene;

static int startframe;

static void WriteText(int which, int x, int y, int fade);

int Part6Init(int frame)
{
#ifdef DEBUG
  printf("part 6 init.\n");
#endif
  startframe=frame;
  scene=new scene_s;
#ifdef DEBUG
  printf("initializing scene 6\n");
#endif
  extern char M_06bck1[], M_06msk1[], M_06msk2[], M_06msk3[];
  LoadTIM(M_06bck1);
  LoadTIM(M_06msk1);
  LoadTIM(M_06msk2);
  LoadTIM(M_06msk3);
  extern char LWO_Thing4_1[], LWO_Thing4_2[], LWO_Thing4_3[];
  object_s *n=new object_s;
  n->Initialize();
  scene->root=n;

  n->scene=scene;
  n->child=new object_s*[4];
  n->child[0]=LoadLWO(LWO_Thing4_1);
  n->child[1]=LoadLWO(LWO_Thing4_2);
  n->child[2]=LoadLWO(LWO_Thing4_3);
  n->child[3]=0;

  n->child[0]->scene=scene;
  n->child[1]->scene=scene;
  n->child[2]->scene=scene;
  n->child[0]->parent=scene->root;
  n->child[1]->parent=scene->root;
  n->child[2]->parent=scene->root;
  return 0;
}

int Part6Frame(int frame)
{
  frame-=startframe;

  int fak=4096;

  if (frame>1500)
    fak=4096-(frame-1500)*20;
  if (fak<0)
    return 1;

                                 // setup light sources
  scene->l_dir.m[0][0]=2896*fak/4096;
  scene->l_dir.m[0][1]=2896*fak/4096;
  scene->l_dir.m[0][2]=0;

  scene->l_dir.m[1][0]=0;
  scene->l_dir.m[1][1]=0;
  scene->l_dir.m[1][2]=-4096;

  scene->l_dir.m[2][0]=0;
  scene->l_dir.m[2][1]=0;
  scene->l_dir.m[2][2]=0;
                                  // setup light colors
  scene->l_color.m[0][0]=2048*fak/4096;
  scene->l_color.m[1][0]=2048*fak/4096;
  scene->l_color.m[2][0]=2048*fak/4096;

  scene->l_color.m[0][1]=2048*fak/4096;
  scene->l_color.m[1][1]=2048*fak/4096;
  scene->l_color.m[2][1]=2048*fak/4096;

  scene->l_color.m[0][2]=2048*fak/4096;
  scene->l_color.m[1][2]=2048*fak/4096;
  scene->l_color.m[2][2]=2048*fak/4096;
                                  // setup ambient
  scene->l_color.t[0]=512*fak/4096;
  scene->l_color.t[1]=512*fak/4096;
  scene->l_color.t[2]=512*fak/4096;
                                  // camera position
  scene->camera.pos.v.vx=0;
  scene->camera.pos.v.vy=0;
  scene->camera.pos.v.vz=-8192;
                                  // camera direction
  scene->camera.pos.r.vx=0;
  scene->camera.pos.r.vy=0;
  scene->camera.pos.r.vz=0;
  scene->camera.matval=0;
                                  // object position
  scene->root->matval=0;

  scene->root->pos.r.vx=-10;
  scene->root->pos.r.vy=-512;
  scene->root->pos.r.vz=-435;

  scene->root->pos.v.vx=                3000;
  scene->root->pos.v.vy=-(4096-fak)*3 - 3000;
  scene->root->pos.v.vz=0;

  scene->root->child[0]->pos.v.vx=0;
  scene->root->child[1]->pos.v.vx=rsin(frame*50)-4096;
  scene->root->child[2]->pos.v.vx=rcos(frame*50)-4096;

  scene->root->child[0]->pos.r.vx+=10;
  scene->root->child[0]->pos.r.vy=0;
  scene->root->child[0]->pos.r.vz=0;
  scene->root->child[0]->matval=0;

  scene->root->child[1]->pos.r.vz=0;
  scene->root->child[1]->pos.r.vx+=10;
  scene->root->child[1]->matval=0;

  scene->root->child[2]->pos.r.vz=0;
  scene->root->child[2]->pos.r.vx+=10;
  scene->root->child[2]->matval=0;

  int r, g, b;

  r=g=b=fak>>5;

  int rgb=r | (g<<8) | (b<<16);

  engineRender(scene);
  introShowPicture(640, 0, getClut(0, 480), 1, rgb);
  int fade=frame-300;
  if (fade>63)
    fade=63;
  if (frame>720)
    fade=63-(frame-720);
  if (fade<0)
    fade=0;
  WriteText(0, 0, 50, fade);
  fade=frame-720;
  if (fade>63)
    fade=63;
  if (fade<0)
    fade=0;
  WriteText(1, 0, 120, fade);
  fade=frame-820;
  if (fade>63)
    fade=63;
  if (fade<0)
    fade=0;
  WriteText(2, 0, 138, fade);
    
  return 0;
}

int Part6Close()
{
#ifdef DEBUG
  printf("closing Part6 ... SHOULD delete objects here.\n");
#endif
  scene->root->Free();
  delete scene->root;
  delete scene;
  return 0;
}

static void WriteText(int which, int x, int y, int fade)
{
  int u=0, v, w, h;
  if (which==0)
  {
    v=0;
    w=252;
    h=54;
  } else if (which==1)
  {
    v=53;
    w=270;
    h=36;
  } else if (which==2)
  {
    v=88;
    w=288;
    h=36;
  } else
    return;

  char *startp=_curdisplayp->wspace + _curdisplayp->wspacepos;
  POLY_FT4 *pft4=(POLY_FT4*)startp;
  u_long *ot=_curdisplayp->ot;

  int tp=0, tpage=getTPage(0, 1, 0, 256), clut=getClut(0, 481);

  while (w)
  {
    setPolyFT4(pft4);
    setSemiTrans(pft4, 1);

    while (u>=256)
    {
      u-=256;
      tp+=256/4; // 4bit
      tpage=getTPage(0, 1, tp, 256);
      
    }
    int tw=w;
    if (tw>256)
      tw=256;
    tw--;

    pft4->r0=pft4->g0=pft4->b0=fade;

    pft4->u0=u;
    pft4->v0=v;
    pft4->u1=u+tw;
    pft4->v1=v;
    pft4->u2=u;
    pft4->v2=v+h-1;
    pft4->u3=u+tw;
    pft4->v3=v+h-1;

    pft4->tpage=tpage;
    pft4->clut=clut;

    pft4->x0=x;
    pft4->y0=y;
    pft4->x1=x+tw+1;
    pft4->y1=y;
    pft4->x2=x;
    pft4->y2=y+h;
    pft4->x3=x+tw+1;
    pft4->y3=y+h;

    addPrim(ot+OTSIZE-1, pft4);
    pft4++;
    tw++;
    x+=tw;
    w-=tw;
    u+=tw;

  }
  _curdisplayp->wspacepos += (char *)pft4 - startp;
}
