#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <libetc.h>
#include <libgte.h>
#include <libgpu.h>
#include <libcd.h>
#include <kernel.h>

#include "sincos.h"
#include "padconst.h"
#include "main.h"
#include "engine.h"

int _curdisplayi;
int _hsyncs_height=1;

void InitFlares();

TIM_IMAGE dummy;

int bgr=0, bgg=0, bgb=0;

int doprof=0;

extern int logoInit(int);
extern int logoFrame(int frame);
extern int logoClose();

extern int Part1Init(int);
extern int Part1Frame(int frame);
extern int Part1Close();

extern int Part2Init(int);
extern int Part2Frame(int frame);
extern int Part2Close();

extern int Part3Init(int);
extern int Part3Frame(int frame);
extern int Part3Close();

extern int Part4Init(int);
extern int Part4Frame(int frame);
extern int Part4Close();

extern int Part5Init(int);
extern int Part5Frame(int frame);
extern int Part5Close();

extern int Part6Init(int);
extern int Part6Frame(int frame);
extern int Part6Close();

extern int Part7Init(int);
extern int Part7Frame(int frame);
extern int Part7Close();

extern int Part8Init(int);
extern int Part8Frame(int frame);
extern int Part8Close();

extern int Part9Init(int);
extern int Part9Frame(int frame);
extern int Part9Close();

extern int PartEInit(int);
extern int PartEFrame(int frame);
extern int PartEClose();

int CDInit(int)
{
  int tracks[1]={2};
  CdPlay(2, tracks, 0);
  return 0;
}

int CDMain(int)
{
  return 1;
}

int CDClose()
{
  return 1;
}

static struct part_s
{
  int (*Init)(int frame);
  int (*Frame)(int frame);
  int (*Close)();
} Part[]={   {logoInit, logoFrame, logoClose},
             {CDInit, CDMain, CDClose},
             {Part1Init, Part1Frame, Part1Close},
             {Part2Init, Part2Frame, Part2Close},
             {Part3Init, Part3Frame, Part3Close},
             {Part4Init, Part4Frame, Part4Close},
             {Part5Init, Part5Frame, Part5Close},
             {Part6Init, Part6Frame, Part6Close},
             {Part7Init, Part7Frame, Part7Close},
             {Part8Init, Part8Frame, Part8Close},
             {Part9Init, Part9Frame, Part9Close},
             {PartEInit, PartEFrame, PartEClose},
             {0, 0, 0}};
static int part=-1;
static int frame=0;

display_t _display[2], *_curdisplayp;

void SetPart(int npart, int frame);

int main()
{
  PSXInit(SCREEN_WIDTH, SCREEN_HEIGHT, 256);
  CdInit();

  SetPart(0, 0);

  for (;;)
  {
#ifdef DEBUG
    u_long PADstatus=PadRead(0);
    
    if (PADstatus & Pad1R1)
    {
      while (PadRead(0) & Pad1R1) ;
      if (Part[part].Frame)
        SetPart(part+1, frame);
    }
    

    if (PADstatus & Pad1L1)
    {
      while (PadRead(0) & Pad1L1) ;
      if (part>0)
        SetPart(part-1, frame);
    }

    if (PADstatus & Pad1Select)
    {
      int op=part;
      SetPart(-1, frame);
      while (PadRead(0) & Pad1Select);
      SetPart(part, frame);
    }

    if (PADstatus & Pad1Start)
    {
      while (PadRead(0) & Pad1Start) ;
      while (!(PadRead(0) & Pad1Start)) ;
      while (PadRead(0) & Pad1Start) ;

    }
    doprof = (PADstatus & Pad1x);
#endif DEBUG

    RenderView();
  }
  ResetGraph(3);
  return 0; 
}


void RenderView()
{
  static int draws=0;
  DrawSync(0);

  int drawt=VSync(1)-draws;

  VSync(0);

  PutDrawEnv(&_curdisplayp->draw);
  PutDispEnv(&_curdisplayp->disp);

  draws=VSync(1);

  if (frame)
    DrawOTag(_curdisplayp->ot);

  _curdisplayi^=1;
  _curdisplayp=&_display[_curdisplayi];
  _curdisplayp->wspacepos=0;
  _curdisplayp->draw.isbg=1;
  ClearOTag(_curdisplayp->ot, OTSIZE);    // ClearOTagR??

  int demos=VSync(1);
  DoDemo(frame++);
  int demot=VSync(1)-demos;


  static int linescpu=0, linesgpu=0, cntf=0;

  linescpu+=demot;
  linesgpu+=drawt;
  cntf++;
  if (cntf>=70)
  {
    if (doprof)
    {
      printf("%d(c=%d, g=%d)", part, linescpu/cntf, linesgpu/cntf);
      static int lframes=0;
      int fps=VSync(-1)-lframes;
      if ((fps/70)>1)
        printf("%d framed!!\n", fps/70);
      lframes=VSync(-1);
      printf("       \r");
    }

    cntf=linescpu=linesgpu=0;
  }
}

void PSXInit(int w, int h, int d)
{
  SetVideoMode(MODE_PAL);
  ResetGraph(0);    // kalt
  SetGraphDebug(1); // monitor illegal requests

  SetDefDrawEnv(&_display[0].draw, 0, 0, w, h); // beide screens
  SetDefDrawEnv(&_display[1].draw, w, 0, w, h); // nebeneinander
  SetDefDispEnv(&_display[0].disp, w, 0, w, h);
  SetDefDispEnv(&_display[1].disp, 0, 0, w, h);

  _display[1].disp.screen.x = _display[0].disp.screen.x = 0;
  _display[1].disp.screen.y = _display[0].disp.screen.y = 24;

  _display[1].disp.screen.h = _display[0].disp.screen.h = 240;

  SetDispMask(1); // bild AN

  _curdisplayi =0;
  _curdisplayp = &_display[0];
	_display[0].wspacepos = _display[1].wspacepos = 0;
  _display[0].draw.dtd = _display[1].draw.dtd = 1;
	_display[0].draw.isbg = _display[1].draw.isbg = 1;
  _display[0].wspace=new char[200*1024];
  _display[1].wspace=new char[200*1024];

  PutDispEnv(&_curdisplayp->disp); // das da setzen (als default, noch ist da nix.)

  InitGeom();

  SetGeomOffset(w/2, h/2);    // logischer ursprung ist MITTE
  SetGeomScreen(d);           // und abstand zur projplane halt ... 256

  if (h==240)
    _hsyncs_height=252;
	else
    _hsyncs_height=504;

  PadInit(0);
#ifdef DEBUG
  printf("init complete.\n");
#endif
}

void SetPart(int npart, int frame)
{
  if (npart!=part)
  {
#ifdef DEBUG
    char *x=new char;
    printf("switching to part %d, memory at %p\n", npart, x);
    delete x;
#endif
    if ((part!=-1) && (Part[part].Close))
      Part[part].Close();
    if ((npart!=-1) && Part[npart].Init)
      Part[npart].Init(frame);
    part=npart;
  }
}

void DoDemo(int frame)
{
  if ((part==-1) || (!Part[part].Frame)) return;
  int res=Part[part].Frame(frame);
  if (res)
    SetPart(part+res, frame+1);
}

