/*
 * Decompiled with CFR 0.152.
 */
package util;

import algebra.Color3f;
import algebra.TexCoord2f;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class Image {
    private BufferedImage image = null;

    public Image(String filename) {
        File file = new File(filename);
        System.out.println("Loading image: " + file.getName());
        try {
            this.image = ImageIO.read(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        System.out.println("Image loaded.");
    }

    public Color3f getColor(TexCoord2f texCoord) {
        int x = (int)(texCoord.x * (float)this.image.getWidth());
        int y = this.image.getHeight() - (int)(texCoord.y * (float)this.image.getHeight());
        x = Math.max(0, Math.min(this.image.getWidth() - 1, x));
        y = Math.max(0, Math.min(this.image.getHeight() - 1, y));
        return Image.fromRGB(this.image.getRGB(x, y));
    }

    private static final Color3f fromRGB(int ARGB) {
        float inv255 = 0.003921569f;
        float r = (float)((ARGB & 0xFF0000) >> 16) * 0.003921569f;
        float g = (float)((ARGB & 0xFF00) >> 8) * 0.003921569f;
        float b = (float)(ARGB & 0xFF) * 0.003921569f;
        return new Color3f(r, g, b);
    }
}

