/*
 * Decompiled with CFR 0.152.
 */
package tracer.camera;

import algebra.Algebra;
import algebra.Vector3f;
import geometry.ray.ShadingRay;
import java.util.Random;
import tracer.camera.PerspectiveCamera;

public class DOFCamera
extends PerspectiveCamera {
    private static final Random RANDOM = new Random(13354L);
    private final float blurFactor;

    public DOFCamera(Vector3f e, Vector3f d, Vector3f up, int width, int height, float scale, float focalLength, float blurFactor) {
        super(e, d, up, width, height, scale, focalLength);
        this.blurFactor = blurFactor;
    }

    @Override
    public ShadingRay ray(float x, float y) {
        float ev;
        float eu;
        float u = this.l + this.lr * (x + 0.5f) / this.width;
        float v = this.b + this.bt * (y + 0.5f) / this.height;
        Vector3f d = Algebra.sum(Algebra.scalar(this.base.w, -this.focalLength), Algebra.sum(Algebra.scalar(this.base.u, u), Algebra.scalar(this.base.v, v)));
        Vector3f s = Algebra.sum(this.e, d);
        while ((eu = RANDOM.nextFloat() * 2.0f - 1.0f) * eu + (ev = RANDOM.nextFloat() * 2.0f - 1.0f) * ev >= 1.0f) {
        }
        Vector3f ep = Algebra.sum(this.e, Algebra.sum(Algebra.scalar(this.base.u, eu * this.blurFactor), Algebra.scalar(this.base.v, ev * this.blurFactor)));
        Vector3f dp = Algebra.unit(Algebra.substract(s, ep));
        return new ShadingRay(ep, dp);
    }
}

