/*
 * Decompiled with CFR 0.152.
 */
package tracer;

import algebra.Color3f;
import scene.Scene;
import tracer.RayTracer;
import util.HaltonSequence;

public class AANTracer
extends RayTracer {
    private final int n;
    private static final HaltonSequence haltonX = new HaltonSequence(2, 20);
    private static final HaltonSequence haltonY = new HaltonSequence(17, 20);

    public AANTracer(Scene scene, int n) {
        super(scene);
        this.n = n;
    }

    @Override
    public Color3f trace(int x, int y) {
        Color3f total = new Color3f(0.0f);
        int i = 0;
        while (i < this.n) {
            float u = (float)x + haltonX.next() - 0.5f;
            float v = (float)y + haltonY.next() - 0.5f;
            total = total.sum(this.shoot(u, v));
            ++i;
        }
        return total.mult(1.0f / (float)this.n);
    }
}

