/*
 * Decompiled with CFR 0.152.
 */
package scene.model;

import algebra.Vector3f;
import geometry.Geometry;
import geometry.bounding.KDBox;
import geometry.bounding.KDNodeBox;
import geometry.ray.Ray;
import geometry.ray.RayResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import scene.material.Material;
import scene.model.Model;

public class KDModel
extends Model {
    private final KDBox box;
    private final int lowerBound;

    public KDModel(Material material, Geometry ... objects) {
        this(material, Arrays.asList(objects));
    }

    public KDModel(Material material, Collection<Geometry> objects) {
        super(material);
        System.out.println("Box start.");
        long startTime = System.currentTimeMillis();
        this.lowerBound = (int)Math.ceil(Math.log(objects.size()) / Math.log(3.0));
        System.out.println(this.lowerBound);
        this.box = new KDNodeBox(new ArrayList<Geometry>(objects), this.lowerBound);
        int seconds = (int)((float)(System.currentTimeMillis() - startTime) * 0.001f);
        float minutes = (float)seconds / 60.0f;
        System.out.println(" " + seconds + "s = " + minutes + "m");
        System.out.println(" max " + this.box.getMax());
        System.out.println(" mid " + this.box.getMid());
        System.out.println(" min " + this.box.getMin());
        System.out.println("Box stop. ");
    }

    public KDModel(Material material, KDBox box) {
        super(material);
        this.lowerBound = -1;
        this.box = box;
        System.out.println("    -> max " + box.getMax());
        System.out.println("    -> mid " + box.getMid());
        System.out.println("    -> min " + box.getMin());
    }

    @Override
    public RayResult intersect(Ray ray) {
        return this.box.searchBox(ray);
    }

    @Override
    public Vector3f getMin() {
        return this.box.getMin();
    }

    @Override
    public Vector3f getMax() {
        return this.box.getMax();
    }

    @Override
    public Vector3f getMid() {
        return this.box.getMid();
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public KDBox getBox() {
        return this.box;
    }
}

