/*
 * Decompiled with CFR 0.152.
 */
package scene.material;

import algebra.Algebra;
import algebra.Color3f;
import algebra.Vector3f;
import geometry.ray.RayResult;
import scene.Scene;
import scene.light.AmbientLight;
import scene.light.DirectionalLight;
import scene.light.Light;
import scene.light.PointLight;
import scene.material.FlatMaterial;
import scene.material.texture.Texture;

public class LambertianMaterial
extends FlatMaterial {
    public LambertianMaterial(Texture texture) {
        super(texture);
    }

    @Override
    public Color3f shade(Scene scene, RayResult rayResult) {
        Color3f resultColor = Color3f.BLACK;
        Color3f color = this.getColor(this.texture, rayResult);
        for (Light l : scene.getLights()) {
            if (!l.visibility(rayResult, scene)) continue;
            Color3f lColor = null;
            if (l instanceof AmbientLight) {
                lColor = this.light((AmbientLight)l, rayResult, color);
            } else if (l instanceof DirectionalLight) {
                lColor = this.light((DirectionalLight)l, rayResult, color);
            } else if (l instanceof PointLight) {
                lColor = this.light((PointLight)l, rayResult, color);
            }
            resultColor = resultColor.sum(lColor);
        }
        return resultColor;
    }

    private Color3f getColor(Texture texture, RayResult rayResult) {
        return texture.getColor(rayResult);
    }

    private Color3f light(AmbientLight light, RayResult rayResult, Color3f color) {
        return color.mult(light.getIntensity());
    }

    private Color3f light(DirectionalLight light, RayResult rayResult, Color3f color) {
        float cos = Math.max(0.0f, Algebra.dot(rayResult.getNormal(), light.getLightDirection()));
        return color.mult(light.getIntensity().mult(cos));
    }

    private Color3f light(PointLight light, RayResult rayResult, Color3f color) {
        Vector3f lightDirection = Algebra.unit(Algebra.substract(light.getLightPosition(), rayResult.getWorldLocation()));
        float cos = Math.max(0.0f, Algebra.dot(rayResult.getNormal(), lightDirection));
        return color.mult(light.getIntensity().mult(cos));
    }
}

