/*
 * Decompiled with CFR 0.152.
 */
package scene.light;

import algebra.Algebra;
import algebra.Color3f;
import algebra.Vector3f;
import geometry.ray.RayResult;
import scene.light.VolumeLight;
import util.RandomVectors;

public class SphereLight
extends VolumeLight {
    private final float r;
    private static final RandomVectors RANDOM_VECTORS = new RandomVectors(13354L);

    public SphereLight(Color3f intensity, Vector3f lightPosition, float r) {
        super(intensity, lightPosition);
        this.r = r;
    }

    @Override
    protected Vector3f samplePosition(RayResult from) {
        return Algebra.perturb(this.lightPosition, RANDOM_VECTORS.nextUnit3f(), this.r);
    }
}

