/*
 * Decompiled with CFR 0.152.
 */
package scene.light;

import algebra.Algebra;
import algebra.Color3f;
import algebra.Vector3f;
import geometry.ray.RayResult;
import scene.light.VolumeLight;
import util.RandomVectors;

public class GaussianLight
extends VolumeLight {
    private final float s;
    private static final RandomVectors RANDOM_VECTORS = new RandomVectors(13354L);

    public GaussianLight(Color3f intensity, Vector3f lightPosition, float s) {
        super(intensity, lightPosition);
        this.s = s;
    }

    @Override
    protected Vector3f samplePosition(RayResult from) {
        return Algebra.perturb(this.lightPosition, RANDOM_VECTORS.nextGauss3f(), this.s);
    }
}

