/*
 * Decompiled with CFR 0.152.
 */
package scene;

import geometry.ray.Ray;
import geometry.ray.RayResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import scene.Scene;
import scene.light.Light;
import scene.model.Model;
import tracer.camera.Camera;

public class SetScene
extends Scene {
    private final Collection<Model> models;

    public SetScene(Collection<Light> lights, Camera camera, Model ... models) {
        this(lights, camera, Arrays.asList(models));
    }

    public SetScene(Collection<Light> lights, Camera camera, Collection<Model> models) {
        super(lights, camera);
        this.models = new ArrayList<Model>(models);
    }

    @Override
    public RayResult intersect(Ray ray) {
        RayResult returnResult = null;
        for (Model i : this.models) {
            RayResult iResult = i.intersect(ray);
            if (returnResult != null && (iResult == null || !(returnResult.t > iResult.t))) continue;
            if (iResult != null) {
                iResult.setMaterial(i.getMaterial());
            }
            returnResult = iResult;
        }
        return returnResult;
    }
}

