/*
 * Decompiled with CFR 0.152.
 */
package geometry.bounding;

import geometry.Geometry;
import geometry.bounding.GeoSorters;
import geometry.bounding.KDBox;
import geometry.bounding.KDLeafBox;
import geometry.ray.Ray;
import geometry.ray.RayResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class KDNodeBox
extends KDBox {
    private KDBox childl;
    private KDBox childm;
    private KDBox childr;

    public KDNodeBox(ArrayList<Geometry> objects, int lowerBound) {
        this(objects, lowerBound, 0);
    }

    public KDNodeBox(ArrayList<Geometry> objects, int lowerBound, int depth) {
        super(objects, lowerBound, depth);
        Collections.sort(objects, GeoSorters.getComparator(this.getDepth()));
        Geometry mid = this.findSurfaceMid(objects);
        LinkedList<Geometry> l = new LinkedList<Geometry>();
        LinkedList<Geometry> m = new LinkedList<Geometry>();
        LinkedList<Geometry> r = new LinkedList<Geometry>();
        for (Geometry o : objects) {
            switch (GeoSorters.getSplitter(this.getDepth()).compare(o, mid)) {
                case -1: {
                    l.add(o);
                    break;
                }
                case 0: {
                    m.add(o);
                    break;
                }
                case 1: {
                    r.add(o);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        this.childl = this.buildChildren(l, objects.size(), this.getDepth());
        this.childm = this.buildChildren(m, objects.size(), this.getDepth());
        this.childr = this.buildChildren(r, objects.size(), this.getDepth());
    }

    private Geometry findMedian(List<Geometry> objects) {
        return objects.get(objects.size() / 2);
    }

    private Geometry findSurfaceMid(List<Geometry> objects) {
        float[] cumSum = new float[objects.size()];
        float sum = 0.0f;
        int i = 0;
        while (i < objects.size()) {
            cumSum[i] = sum += objects.get(i).getArea();
            ++i;
        }
        int index = Math.abs(Arrays.binarySearch(cumSum, sum * 0.5f));
        if (index < objects.size()) {
            return objects.get(index);
        }
        return this.findMedian(objects);
    }

    private KDBox buildChildren(List<Geometry> objects, int inputSize, int depth) {
        if (objects.size() <= 0) {
            return null;
        }
        ArrayList<Geometry> list = new ArrayList<Geometry>(objects);
        if (list.size() > this.lowerBound && inputSize > objects.size()) {
            return new KDNodeBox(list, this.lowerBound, depth + 1);
        }
        return new KDLeafBox(list, this.lowerBound, depth + 1);
    }

    @Override
    public RayResult searchBox(Ray ray) {
        if (!this.hitBox(ray)) {
            return null;
        }
        RayResult returnResult = null;
        if (this.childl != null) {
            returnResult = this.childl.searchBox(ray);
        }
        RayResult i = null;
        if (this.childm != null && (i = this.childm.searchBox(ray)) != null && (returnResult == null || returnResult.t > i.t)) {
            returnResult = i;
        }
        i = null;
        if (this.childr != null && (i = this.childr.searchBox(ray)) != null && (returnResult == null || returnResult.t > i.t)) {
            return i;
        }
        return returnResult;
    }
}

